# 第三章：怪物真实属性获取（getEnemyInfo）

要求：读懂脚本编辑 - 怪物真实属性（getEnemyInfo）的实现（无需理解支援）。理解如何动态修改怪物的三维，理解光环效果的实现并知晓如何新增光环效果，理解如何定义新变量并在getDamageInfo中取用。

回答如下问题：

1. 为什么要存在`getEnemyInfo`函数以获得怪物真实属性？所有东西都写在`getDamageInfo`里面不好吗？

2. 实现**仿攻（编号45）**：怪物攻击不低于勇士攻击。

3. 实现**窥血为攻（编号36）**： 战斗开始时，自身攻击力变为角色当前生命值的10%，向下取整。这种写法比第一章中在`getDamageInfo`中写法效果更好，为什么？

4. 仅修改`getEnemyInfo`，实现一个怪物`E345`满足：
    - 简单难度（flag:hard==1）下，无特殊属性。
    - 普通难度（flag:hard==2）下，拥有先攻属性。
    - 困难难度（flag:hard==3）下，拥有三连击属性。
    - 噩梦难度（flag:hard==4）下，同时拥有先攻、魔攻、二连击属性。
    - 如果玩家拥有道具`I123`，则直接无视此怪物所有属性。

5. 仅修改`getEnemyInfo`，实现一个道具`I234`：**当玩家持有此道具时，怪物的血攻防均降低10%。**

6. 仅修改`getEnemyInfo`，实现特殊属性 **「上位压制」（特殊编号46）**：玩家每低于怪物一个等级（通过`core.getStatus('lv')`获得当前玩家等级，通过`enemy.level`获得该怪物的等级），怪物三维提升10%；玩家每高于怪物一个等级，怪物三维降低5%。

7. 解释光环的缓存原理。为什么光环需要缓存？

8. `index`是什么意思？ `var cache = core.status.checkBlock.cache[index];` 是干什么的？

9. 在默认光环的实现中，`hp_buff`, `atk_buff`, `def_buff`, `usedEnemyIds` 分别是干什么的？

10. 在默认光环的实现中，怪物属性的`value`, `atkValue`和`defValue`用于控制怪物的比例增幅。将其效果修改成数值增幅（例如 `value = 50` 表示生命提升50点，而不是50%）。

11. 局部光环的实现原理是什么？十字和九宫格光环是如何区分的？

12. 实现 **「协同作战」（特殊属性47）**：同楼层/周围X格（由range和zoneSquare决定），每存在一个该属性的队友（包括自身），生命和攻防对应比例提升（提升比例由怪物value, atkValue, defValue决定，线性叠加）。并在游戏中实际验证效果。（注意这个效果和默认光环的区别）。

13. 实现 **「迅捷光环」（特殊属性28）**：同楼层/周围X格（由range和zoneSquare决定）的怪物额外先攻X回合（由此怪物的value28决定）。并在游戏中实际验证效果。

14. 实现 **「吸血光环」（特殊属性48）**：同楼层/周围X格（由range和zoneSquare决定）的怪物拥有「吸血」特殊属性，吸血比例由光环怪的`vampireValue`项决定。并在游戏中实际验证效果。
