var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。


	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作，比如切分图片等。

		// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
		// var arr = core.splitImage("assets.png", 32, 32);
		// for (var i = 0; i < arr.length; i++) {
		//     core.material.images.images["asset"+i+".png"] = arr[i];
		// }

	}
	core.control._updateDamage_damage = function (floorId, ctx) {
		core.setTextAlign(ctx, 'left');
		core.status.maps[floorId].blocks.forEach(function (block) {
			var x = block.x,
				y = block.y;
			if (!block.disable && block.event.cls.indexOf('enemy') == 0 && block.event.displayDamage !== false) {
				if (core.flags.displayEnemyDamage) {
					var damageString = core.enemys.getDamageString(block.event.id, x, y, floorId);
					var damage = damageString.damage,
						color = damageString.color;
					core.fillBoldText(ctx, damage, 32 * x + 1, 32 * (y + 1) - 1, color);
				}
				if (core.flags.displayCritical) {
					var critical = core.enemys.nextCriticals(block.event.id, 1, x, y, floorId);
					critical = core.formatBigNumber((critical[0] || [])[0], true);
					if (critical == '???') critical = '?';
					core.fillBoldText(ctx, critical, 32 * x + 1, 32 * (y + 1) - 11, '#FFFFFF');
				}
				var id = block.event.id;
				var special = core.material.enemys[id].special;
				if (core.hasSpecial(special, 23) && core.getFlag(core.status.floorId + x + "," + y + "battle", 0) > 0) {
					core.fillBoldText(ctx, core.getFlag(core.status.floorId + x + "," + y + "battle", 0), 32 * (x + 1) - 11, 32 * (y + 1) - 11, '#FFFFFF');
				}
			}
		});
	}

	this.splitText = function (text) {
		return text.split('\n');
	}


	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
},
    "heroEquip": function () {
	// 在此增加新插件
	// 1.画出10个装备栏，根据flag决定是否解锁，（已迁移入公共事件）
	// 2.装备卡不可卸载，白给
	// 3.装备的组合效果，（伤害函数）
	// 4.五行的加成
	// 5.

	this.init2 = function () {
		var shu = [0.1, [1, 2, 3], 0.3, 0.3, 1, 0.5, [0.2, 0.45, 0.8]],
			wei = [0.1, 0.5, 0.5, 0.2, 1, null, [0.15, 0.35, 0.6]],
			wu = [null, [1 / 2, 0.4], 0.5, 2, [0.5, 0.5], 0.5, [50, 100, 0.3]],
			qun = [0.3, 0.3, 2, 0.2, [0.2, 0.9], 0.2, [0.1, 1, null]];
		core.setFlag('shu', shu); //I311,[3xI312],I313,I314,I315,I316,组合
		core.setFlag('wei', wei); //I317~I322,组合
		core.setFlag('wu', wu); //I323~I328,组合
		core.setFlag('qun', qun); //I329~I334,组合
		core.material.items.I311.text = '无言：提升自己' + 100 * shu[0] + '%的攻击';
		core.material.items.I312.text = '咆哮：前3回合分别以' + 100 * shu[1][0] + '% ' + 100 * shu[1][1] + '%\n ' + 100 * shu[1][2] + '%攻击力进攻';
		core.material.items.I313.text = '涅槃：若本场战斗损失血量超过当前血量\n的一半，下战对敌伤害提升' + 100 * shu[2] + '%';
		core.material.items.I314.text = '龙胆：本场战斗额外对敌人造成 （我方攻\n击力-敌方攻击力)*' + 100 * shu[3] + '的百分比伤害';
		core.material.items.I315.text = '武圣：战斗时攻击力额外增加自己防御\n力*' + 100 * shu[4] + '%';
		core.material.items.I316.text = '看破：战斗前敌人生命力削弱' + 100 * shu[5] + '%';
		core.material.items.I317.text = '节钺：提升自己的' + 100 * wei[0] + '%的防御';
		core.material.items.I318.text = '刚烈：和模仿怪战斗时，模仿怪物的\n攻击降低' + 100 * wei[1] + '%';
		core.material.items.I319.text = '裸衣：和魔攻怪物战斗时，魔攻怪物的\n攻击降低' + wei[2] * 100 + '%';
		core.material.items.I320.text = '突袭：战斗损失超过当前血量的一半\n下场战斗伤害减免提升' + wei[3] * 100 + '%';
		core.material.items.I321.text = '遗计：战斗时防御力额外增加自己攻击\n力的' + 100 * wei[4] + '%';
		core.material.items.I322.text = '鬼才：无视敌方连击属性';
		core.material.items.I323.text = '制霸，夺走战斗先手权，即无视先攻或\n者在已先攻条件下多攻击一回合';
		core.material.items.I324.text = '苦肉：本场战斗中损失当前血量的' + wu[1][0] * 100 + '%以\n上时，下一个血瓶回复效果增加' + wu[1][1] * 100 + '%';
		core.material.items.I325.text = '谦逊：降低领域伤害' + wu[2] * 100 + '%';
		core.material.items.I326.text = '国色：降低模仿怪坚固怪' + wu[3] + '点防御';
		core.material.items.I327.text = '克己：降低' + wu[4][0] * 100 + '%金币收益(实际收益\n下整)，获得' + wu[4][1] * 100 + '%破甲';
		core.material.items.I328.text = '反间：战斗时将敌方怪物防御的' + wu[5] * 100 + '%\n加到己方攻击';
		//没做
		core.material.items.I329.text = '回春：额外获得等于能力和' + qun[0] + '倍的\n血量回复';
		core.material.items.I330.text = '闭月：地面血瓶效果增加' + qun[1] * 100 + '%';
		core.material.items.I331.text = '无双：每次攻击后回血' + qun[2] + '点，对坚固无效';
		core.material.items.I332.text = '断肠：每次敌人对你造成有效伤害时，\n敌人受到此伤害的' + qun[3] * 100 + '%';
		core.material.items.I333.text = '乱击：装备后每次战斗中，先损失' + qun[4][0] * 100 + '%\n血量，战后返还该数值的' + qun[4][1] * 100 + '%';
		core.material.items.I334.text = '蛊惑：增强商店血量效果的' + qun[5] * 100 + '%';
	}
	// ["I311", "I312", "I313", "I314", "I315", "I316", "I317", "I318", "I319", "I320", "I321", "I322", "I323", "I324", "I325", "I326", "I327", "I328", "I329", "I330", "I331", "I332", "I333", "I334"]

	this.isEquiped = function (equip) {
		for (var i in core.getFlag('currEquip', [])) {
			if (core.getFlag('currEquip', [])[i] === equip) return true;
		}
		return false;
	}

	this.areEquiped = function (equips) {
		var num = 0;
		for (var i in equips) {
			if (core.isEquiped(equips[i])) num++;
		}
		return num;
	}

	this.wuxing = function () {
		var wuxing = [0, 0, 0, 0, 0];
		for (var i in core.getFlag('currEquip', [])) {
			wuxing[core.material.items[core.getFlag('currEquip', [])[i]].equip.wuxing - 1]++;
		}
		return wuxing;
	}

	this.heroLoc = function (x, y) {
		var x1 = ["I311", "I312", "I317", "I318", "I323", "I324", "I329", "I330"],
			x2 = ["I313", "I314", "I319", "I320", "I325", "I326", "I331", "I332"],
			x3 = ["I315", "I316", "I321", "I322", "I327", "I328", "I333", "I334"],
			y1 = ["I311", "I313", "I315"],
			y2 = ["I312", "I314", "I316"],
			y3 = ["I317", "I319", "I321"],
			y4 = ["I318", "I320", "I322"],
			y5 = ["I323", "I325", "I327"],
			y6 = ["I324", "I326", "I328"],
			y7 = ["I329", "I331", "I333"],
			y8 = ["I330", "I332", "I334"],
			xn, yn;
		switch (x) {
		case 1:
			xn = x1;
			break;
		case 2:
			xn = x2;
			break;
		case 3:
			xn = x3;
			break;
		}
		switch (y) {
		case 1:
			yn = y1;
			break;
		case 2:
			yn = y2;
			break;
		case 4:
			yn = y3;
			break;
		case 5:
			yn = y4;
			break;
		case 7:
			yn = y5;
			break;
		case 8:
			yn = y6;
			break;
		case 10:
			yn = y7;
			break;
		case 11:
			yn = y8;
			break;
		}
		for (var i in xn) {
			for (var j in yn) {
				if (xn[i] === yn[j]) return xn[i];
			}
		}
	}
},
    "choEvents": function () {


	this.unlockSlot = function () {
		var cost = [30, 35, 40, 45, 50, 55, 60, 65, 70, 75];
		var index = [
			[0, 1, 2, 3, 4, 5],
			[6, 7, 8, 9]
		];
		var todo = [];
		var chos = [];
		var page = core.getFlag("f", 0);
		var use = core.getFlag('useSlot', 0);
		for (var i in index[page]) {
			var idx = parseInt(index[page][i]);
			var mask = 1 << idx;
			var alpha = ((use & mask) == 0) ? 1 : 0.5;
			var price = cost[idx];
			var tmp = {
				"text": "解锁第" + (idx + 1) + "个卡槽（" + price + "金）",
				"color": [255, 255, 0, alpha],
				"action": [{
					"type": "if",
					"condition": "(flag:useSlot&" + mask + ")!=0",
					"true": [
						"你已经解锁了",
						{ "type": "exit" },
					],
					"false": [{
						"type": "if",
						"condition": "status:money>=" + price,
						"true": [
							{ "type": "addValue", "name": "status:money", "value": "-" + price },
							{ "type": "setValue", "name": "flag:useSlot", "value": "flag:useSlot | " + mask },
							{ "type": "setBlock", "number": "E" + (359 + idx), "loc": [6, 6], "floorId": "MT1" },
							{ "type": "changeFloor", "floorId": "MT1", "loc": [6, 12], "direction": "up", "time": 500 },
						],
						"false": [
							"你的钱不够！",
							{ "type": "exit" },
						]
					}, ]
				}, ]
			};
			chos.push(tmp);
		}
		if (page == 1) {
			var tmpAlpha = 0.5;
			if ((use == 1023 && !core.hasItem("cross"))) tmpAlpha = 1;
			chos.push({
				"text": "解锁十字架（80金，需全解锁）",
				"color": [238, 255, 0, tmpAlpha],
				"action": [{
					"type": "if",
					"condition": "item:cross==1",
					"true": [
						"你已经解锁了",
						{ "type": "exit" },
					],
					"false": [{
						"type": "if",
						"condition": "flag:useSlot==1023",
						"true": [{
							"type": "if",
							"condition": "status:money>=80",
							"true": [
								{ "type": "addValue", "name": "status:money", "value": "-80" },
								{ "type": "setBlock", "number": "E369", "loc": [6, 6], "floorId": "MT1" },
								{ "type": "changeFloor", "floorId": "MT1", "loc": [6, 12], "direction": "up", "time": 500 },
							],
							"false": [
								"你的钱不够！",
								{ "type": "exit" },
							]
						}, ],
						"false": [
							"未全部解锁",
							{ "type": "exit" },
						]
					}, ]
				}, ]
			});
			chos.push({
				"text": "上一页",
				"color": [0, 255, 255, 1],
				"action": [
					{ "type": "setValue", "name": "flag:f", "value": "0" },
					{ "type": "function", "function": "function(){core.unlockSlot()}" },
				]
			});
		} else
			chos.push({
				"text": "下一页",
				"color": [0, 255, 255, 1],
				"action": [
					{ "type": "setValue", "name": "flag:f", "value": "1" },
					{ "type": "function", "function": "function(){core.unlockSlot()}" },
				]
			});
		chos.push({
			"text": "离开",
			"color": [17, 255, 0, 1],
			"action": [
				{ "type": "exit" },
			]
		});
		var todo = [
			{ "type": "choices", "text": "\t[补给站,npc0]请选择挑战项目{卡槽连带对应星级一起解锁)", "choices": chos }
		];
		core.insertAction(todo);


	}

	var cardData = {
		"蜀": {
			hero: ["徐庶", "张飞", "庞统", "赵云", "关羽", "诸葛亮"],
			st: 335,
		},
		"魏": {
			hero: ["于禁", "夏侯惇", "许褚", "张辽", "郭嘉", "司马懿"],
			st: 341,
		},
		"吴": {
			hero: ["孙策", "黄盖", "陆逊", "大乔", "吕蒙", "周瑜"],
			st: 347,
		},
		"群": {
			hero: ["华佗", "貂蝉", "吕布", "蔡文姬", "袁绍", "于吉"],
			st: 353,
		}
	};
	this.unlockCard = function () {
		var chos = [

		];
		for (var gj in cardData) {
			var flag = gj;
			var cho_hero = [];
			for (var i in cardData[gj].hero) {
				i = parseInt(i);
				var name = cardData[gj].hero[i];
				var star = i + 1;
				var idx = cardData[gj].st + i;
				var mask = 1 << i;
				var alpha = 1;
				if ((core.getFlag('useSlot', 0) & mask) == 0 || ((core.getFlag(flag) & mask) != 0)) {
					alpha = 0.5;
				}
				cho_hero.push({
					"text": name,
					"color": [255, 221, 0, alpha],
					"action": [{
						"type": "if",
						"condition": "(flag:useSlot&" + mask + ")!=0",
						"true": [{
							"type": "if",
							"condition": "flag:" + flag + "&" + mask,
							"true": [
								"已获得",
								{ "type": "exit" },
							],
							"false": [
								{ "type": "setBlock", "number": "E" + idx, "loc": [6, 6], "floorId": "MT1" },
								{ "type": "setValue", "name": "flag:" + flag, "value": "flag:" + flag + "|" + mask },
							]
						}, ],
						"false": [
							"未解锁相应星级，请去购买卡槽" + star + "。",
							{ "type": "exit" },
						]
					}, ]
				});
			}
			cho_hero.push({
				"text": "离开",
				"color": [17, 255, 0, 1],
				"action": [
					{ "type": "exit" },
				]
			});
			var tmp = {
				"text": gj,
				"color": [255, 221, 0, 1],
				"action": [
					{ "type": "choices", "text": "\t[老人,man]选择英魂", "choices": cho_hero },
				]
			};
			chos.push(tmp);
		}
		var todo = [
			{ "type": "choices", "text": "\t[老人,man]选择阵营", "choices": chos },
		]
		core.insertAction(todo);
	}


}
}