var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "initialize": function () {
	// console.log("插件编写测试");
	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。
	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作，比如切分图片等。
		// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
		// var arr = core.splitImage("assets.png", 32, 32);
		// for (var i = 0; i < arr.length; i++) {
		//     core.material.images.images["asset"+i+".png"] = arr[i];
		// }
	}
	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
	this.exportEnemys = function () { // 将怪物信息导出为csv格式，可使用Excel打开
		var s = '怪物ID,名称,手册映射ID,生命,攻击,防御,金币,经验,加点,特殊属性,不可炸,方形领域,吸血叠加,特殊数值,领域范围,连击数,退化扣攻,退化扣防,固伤值,外语名称,批量战后事件';
		for (var id in core.material.enemys) {
			var e = core.material.enemys[id];
			s += '\n"' + id + '","' + (e.name || '新敌人') + '",' + (e.displayIdInBook ? '"' + e.displayIdInBook + '"' : 'null') + ',' + e.hp + ',' + e.atk + ',' + e.def + ',' + e.money + ',' + e.exp + ',' + e.point;
			s += ',"[' + (e.special || '') + ']",' + !!e.notBomb + ',' + !!e.zoneSquare + ',' + !!e.add + ',' + (e.value || 0) + ',' + e.range + ',' + e.n + ',' + (e.atkValue || 0) + ',' + (e.defValue || 0) + ',' + (e.damage || 0);
			s += ',' + (e.displayIdInBook ? '"' + e.battleAnimate + '"' : 'null') + ',' + core.encodeBase64(JSON.stringify(e.i18nAlias)) + ',' + core.encodeBase64(JSON.stringify(e.destroyedEvent)); // 外语名称和批量战后事件是json类型，要加密存储
		}
		core.download('enemys.csv', s.replaceAll('undefined', 'null'));
	}
	this.importEnemys = function () { // 将csv格式的怪物数据导入为json格式
		core.myprompt('请将 enemys.csv 中的全部内容复制并粘贴到这里：', '', function (resources) {
			resources = resources.split(' '); // 按行拆分csv文件，要求该文件本身没有空格
			while (resources[0].charAt(0) != '"') resources.shift(); // 可能需要移除首行（表头）
			var s = 'var enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80 = {\n'; // 这行根据样板版本会有不同，请自行从project\enemys.js复制
			for (var i in resources) {
				var row = resources[i];
				var special = row.substring(row.indexOf('['), row.indexOf(']') + 1); // special数组单独处理以防逗号干扰
				var e = row.replace(',"' + special + '"', '').split(',');
				s += '\t' + e[0] + ': {"name":' + e[1]; // id和名称
				if (e[2] != 'null') s += ', "displayIdInBook":' + e[2]; // 手册映射ID
				s += ',"hp":' + e[3] + ',"atk":' + e[4] + ',"def":' + e[5] + ',"money":' + e[6] + ',"exp":' + e[7] + ',"point":' + e[8]; // 血攻防金经、加点
				s += ',"special":' + special;
				if (e[9] === 'true') s += ',"notBomb":true';
				if (e[10] === 'true') s += ',"zoneSquare":true';
				if (e[11] === 'true') s += ',"add":true';
				if (e[12] != '0') s += ',"value":' + e[12];
				if (e[13] != 'null') s += ',"range":' + e[13];
				if (e[14] != 'null') s += ',"n":' + e[14];
				if (e[15] != '0') s += ',"atkValue":' + e[15];
				if (e[16] != '0') s += ',"defValue":' + e[16];
				if (e[17] != '0') s += ',"damage":' + e[17];
				if (e[18] != 'null') s += ',"battleAnimate":' + e[18];
				if (core.decodeBase64(e[19]) != 'undefined') s += ',"i18nAlias":' + core.decodeBase64(e[19]); // 外语名称解密
				if (core.decodeBase64(e[20]) != 'undefined') s += ',"destroyedEvent":' + core.decodeBase64(e[20]); // 批量战后事件解密
				s += '},\n';
			}
			core.download('enemys.js', s + '}');
		});
	}
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
},
    "fastShop": function () {
	// 【全局商店】相关的功能
	// 
	// 打开一个全局商店
	// shopId：要打开的商店id；noRoute：是否不计入录像
	this.openShop = function (shopId, noRoute) {
		var shop = core.status.shops[shopId];
		// Step 1: 检查能否打开此商店
		if (!this.canOpenShop(shopId)) {
			core.drawTip({'简体中文': "该商店尚未开启", 'English': "This shop is not unlocked."}[core.getLocalStorage('language', '简体中文')], core.playSound('Buzzer1.m4a'));
			return false;
		}

		// Step 2: （如有必要）记录打开商店的脚本事件
		if (!noRoute) {
			core.status.route.push("shop:" + shopId);
		}

		// Step 3: 检查道具商店 or 公共事件
		if (shop.item) {
			if (core.openItemShop) {
				core.openItemShop(shopId);
			} else {
				core.drawText("\t[hero]\b[hero]道具商店插件不存在！请检查是否存在该插件！");
			}
			return;
		}
		if (shop.commonEvent) {
			core.insertCommonEvent(shop.commonEvent, shop.args);
			return;
		}

		// Step 4: 执行标准公共商店    
		core.insertAction(this._convertShop(shop));
		return true;
	}

	////// 将一个全局商店转变成可预览的公共事件 //////
	this._convertShop = function (shop) {
		return [
			{ "type": "function", "function": "function() {core.setFlag('@temp@shop', true);}" },
			{
				"type": "while",
				"condition": "true",
				"data": [
					// 检测能否访问该商店
					{
						"type": "if",
						"condition": "core.isShopVisited('" + shop.id + "')",
						"true": [
							// 可以访问，直接插入执行效果
							{ "type": "function", "function": "function() { core.plugin._convertShop_replaceChoices('" + shop.id + "', false) }" },
						],
						"false": [
							// 不能访问的情况下：检测能否预览
							{
								"type": "if",
								"condition": shop.disablePreview,
								"true": [
									// 不可预览，提示并退出
									{"type": "playSound", "name": "Buzzer1.m4a"},
									"当前无法访问该商店",
									{ "type": "break" },
								],
								"false": [
									// 可以预览：将商店全部内容进行替换
									{ "type": "tip", "text": "当前处于预览模式，不可购买" },
									{ "type": "function", "function": "function() { core.plugin._convertShop_replaceChoices('" + shop.id + "', true) }" },
								]
							}
						]
					}
				]
			},
			{ "type": "function", "function": "function() {core.removeFlag('@temp@shop');}" }
		];
	}

	this._convertShop_replaceChoices = function (shopId, previewMode) {
		var shop = core.status.shops[shopId];
		var choices = (shop.choices || []).filter(function (choice) {
			if (choice.condition == null || choice.condition == '') return true;
			try { return core.calValue(choice.condition); } catch (e) { return true; }
		}).map(function (choice) {
			var ableToBuy = core.calValue(choice.need);
			return {
				"text": choice.text,
				"icon": choice.icon,
				"color": ableToBuy && !previewMode ? choice.color : [153, 153, 153, 1],
				"action": ableToBuy && !previewMode ? choice.action : [
					{"type": "playSound", "name": "Buzzer1.m4a"},
					{ "type": "tip", "text": previewMode ? "预览模式下不可购买" : "购买条件不足" }
				]
			};
		}).concat({ "text": "离开", "action": [{ "type": "break" }] });
		core.insertAction({ "type": "choices", "text": shop.text, "choices": choices });
	}

	/// 是否访问过某个快捷商店
	this.isShopVisited = function (id) {
		if (!core.hasFlag("__shops__")) core.setFlag("__shops__", {});
		var shops = core.getFlag("__shops__");
		if (!shops[id]) shops[id] = {};
		return shops[id].visited;
	}

	/// 当前应当显示的快捷商店列表
	this.listShopIds = function () {
		return Object.keys(core.status.shops).filter(function (id) {
			return core.isShopVisited(id) || !core.status.shops[id].mustEnable;
		});
	}

	/// 是否能够打开某个商店
	this.canOpenShop = function (id) {
		if (this.isShopVisited(id)) return true;
		var shop = core.status.shops[id];
		if (shop.item || shop.commonEvent || shop.mustEnable) return false;
		return true;
	}

	/// 启用或禁用某个快捷商店
	this.setShopVisited = function (id, visited) {
		if (!core.hasFlag("__shops__")) core.setFlag("__shops__", {});
		var shops = core.getFlag("__shops__");
		if (!shops[id]) shops[id] = {};
		if (visited) shops[id].visited = true;
		else delete shops[id].visited;
	}

	/// 能否使用快捷商店
	this.canUseQuickShop = function (id) {
		// 如果返回一个字符串，表示不能，字符串为不能使用的提示
		// 返回null代表可以使用

		// 检查当前楼层的canUseQuickShop选项是否为false
		if (core.status.thisMap.canUseQuickShop === false)
			return {'简体中文': '当前地图不能使用快捷商店', 'English': "Quick shops are disabled in the current map."}[core.getLocalStorage('language', '简体中文')];
		return null;
	}

	/// 允许商店X键退出
	core.registerAction('keyUp', 'shops', function (keycode) {
		if (!core.status.lockControl || !core.hasFlag("@temp@shop") || core.status.event.id != 'action') return false;
		if (core.status.event.data.type != 'choices') return false;
		var data = core.status.event.data.current;
		var choices = data.choices;
		var topIndex = core.actions.HSIZE - parseInt((choices.length - 1) / 2) + (core.status.event.ui.offset || 0);
		if (keycode == 88 || keycode == 27) { // X, ESC
			core.actions._clickAction(core.actions.HSIZE, topIndex + choices.length - 1);
			return true;
		}
	}, 60);

},
    "itemShop": function () {
// 道具商店相关的插件
// 可在全塔属性-全局商店中使用「道具商店」事件块进行编辑（如果找不到可以在入口方块中找）

var shopId = null; // 当前商店ID
var type = 0; // 当前正在选中的类型，0买入1卖出
var selectItem = 0; // 当前正在选中的道具
var selectCount = 0; // 当前已经选中的数量
var page = 0;
var totalPage = 0;
var totalMoney = 0;
var list = [];
var shopInfo = null; // 商店信息
var choices = []; // 商店选项
var use = 'money';
var useText = '金币';

var bigFont = core.ui._buildFont(20, false),
	middleFont = core.ui._buildFont(18, false);

this._drawItemShop = function () {
	// 绘制道具商店

	// Step 1: 背景和固定的几个文字
	core.ui._createUIEvent();
	core.clearMap('uievent');
	core.ui.clearUIEventSelector();
	core.setTextAlign('uievent', 'left');
	core.setTextBaseline('uievent', 'top');
	core.fillRect('uievent', 0, 0, 416, 416, 'black');
	core.drawWindowSkin('winskin.png', 'uievent', 0, 0, 416, 56);
	core.drawWindowSkin('winskin.png', 'uievent', 0, 56, 312, 56);
	core.drawWindowSkin('winskin.png', 'uievent', 0, 112, 312, 304);
	core.drawWindowSkin('winskin.png', 'uievent', 312, 56, 104, 56);
	core.drawWindowSkin('winskin.png', 'uievent', 312, 112, 104, 304);
	core.setFillStyle('uievent', 'white');
	core.setStrokeStyle('uievent', 'white');
	core.fillText("uievent", {'简体中文': "购买", 'English': 'BUY'}[core.getLocalStorage('language', '简体中文')], 32, 74, 'white', bigFont);
	core.fillText("uievent", {'简体中文': "卖出", 'English': 'SELL'}[core.getLocalStorage('language', '简体中文')], 132, 74);
	core.fillText("uievent", {'简体中文': "离开", 'English': 'EXIT'}[core.getLocalStorage('language', '简体中文')], 232, 74);
	core.fillText("uievent", "当前" + useText, 324, 66, null, middleFont);
	core.setTextAlign("uievent", "right");
	core.fillText("uievent", core.formatBigNumber(core.status.hero[use]), 405, 89);
	core.setTextAlign("uievent", "left");
	core.ui.drawUIEventSelector(1, "winskin.png", 22 + 100 * type, 66, 60, 33);
	if (selectItem != null) {
		core.setTextAlign('uievent', 'center');
		core.fillText("uievent", type == 0 ? "买入个数" : "卖出个数", 364, 320, null, bigFont);
		core.fillText("uievent", "<   " + selectCount + "   >", 364, 350);
		core.fillText("uievent", {'简体中文': "确定", 'English': 'OK'}[core.getLocalStorage('language', '简体中文')], 364, 380);
	}

	// Step 2：获得列表并展示
	list = choices.filter(function (one) {
		if (one.condition != null && one.condition != '') {
			try { if (!core.calValue(one.condition)) return false; } catch (e) {}
		}
		return (type == 0 && one.money != null) || (type == 1 && one.sell != null);
	});
	var per_page = 6;
	totalPage = Math.ceil(list.length / per_page);
	page = Math.floor((selectItem || 0) / per_page) + 1;

	// 绘制分页
	if (totalPage > 1) {
		var half = 156;
		core.setTextAlign('uievent', 'center');
		core.fillText('uievent', page + " / " + totalPage, half, 388, null, middleFont);
		if (page > 1) core.fillText('uievent', {'简体中文': "上一页", 'English': 'PREV'}[core.getLocalStorage('language', '简体中文')], half - 80, 388);
		if (page < totalPage) core.fillText('uievent', {'简体中文': "下一页", 'English': 'NEXT'}[core.getLocalStorage('language', '简体中文')], half + 80, 388);
	}
	core.setTextAlign('uievent', 'left');

	// 绘制每一项
	var start = (page - 1) * per_page;
	for (var i = 0; i < per_page; ++i) {
		var curr = start + i;
		if (curr >= list.length) break;
		var item = list[curr];
		core.drawIcon('uievent', item.id, 10, 125 + i * 40);
		core.setTextAlign('uievent', 'left');
		core.fillText('uievent', (core.material.items[item.id].i18nAlias||{})[core.getLocalStorage('language', '简体中文')] || core.material.items[item.id].name, 50, 132 + i * 40, null, bigFont);
		core.setTextAlign('uievent', 'right');
		core.fillText('uievent', (type == 0 ? core.calValue(item.money) : core.calValue(item.sell)) + useText + "/个", 300, 133 + i * 40, null, middleFont);
		core.setTextAlign("uievent", "left");
		if (curr == selectItem) {
			// 绘制描述，文字自动放缩
			var text = (core.material.items[item.id].i18nText || {})[core.getLocalStorage('language', '简体中文')] || core.material.items[item.id].text || {'简体中文': "该道具暂无描述。", 'English': 'Lorem ipsum dolor sit amet...'}[core.getLocalStorage('language', '简体中文')];
			try { text = core.replaceText(text); } catch (e) {}
			for (var fontSize = 20; fontSize >= 8; fontSize -= 2) {
				var config = { left: 10, fontSize: fontSize, maxWidth: 403 };
				var height = core.getTextContentHeight(text, config);
				if (height <= 50) {
					config.top = (56 - height) / 2;
					core.drawTextContent("uievent", text, config);
					break;
				}
			}
			core.ui.drawUIEventSelector(2, "winskin.png", 8, 120 + i * 40, 295, 40);
			if (type == 0 && item.number != null) {
				core.fillText("uievent", "存货", 324, 132, null, bigFont);
				core.setTextAlign("uievent", "right");
				core.fillText("uievent", item.number, 406, 132, null, null, 40);
			} else if (type == 1) {
				core.fillText("uievent", "数量", 324, 132, null, bigFont);
				core.setTextAlign("uievent", "right");
				core.fillText("uievent", core.itemCount(item.id), 406, 132, null, null, 40);
			}
			core.setTextAlign("uievent", "left");
			core.fillText("uievent", "预计" + useText, 324, 250);
			core.setTextAlign("uievent", "right");
			totalMoney = selectCount * (type == 0 ? core.calValue(item.money) : core.calValue(item.sell));
			core.fillText("uievent", core.formatBigNumber(totalMoney), 405, 280);

			core.setTextAlign("uievent", "left");
			core.fillText("uievent", type == 0 ? "已购次数" : "已卖次数", 324, 170);
			core.setTextAlign("uievent", "right");
			core.fillText("uievent", (type == 0 ? item.money_count : item.sell_count) || 0, 405, 200);
		}
	}

	core.setTextAlign('uievent', 'left');
	core.setTextBaseline('uievent', 'alphabetic');
}

var _add = function (item, delta) {
	if (item == null) return;
	selectCount = core.clamp(
		selectCount + delta, 0,
		Math.min(type == 0 ? Math.floor(core.status.hero[use] / core.calValue(item.money)) : core.itemCount(item.id),
			type == 0 && item.number != null ? item.number : Number.MAX_SAFE_INTEGER)
	);
}

var _confirm = function (item) {
	if (item == null || selectCount == 0) return;
	if (type == 0) {
		core.status.hero[use] -= totalMoney;
		core.getItem(item.id, selectCount);
		if (item.number != null) item.number -= selectCount;
		item.money_count = (item.money_count || 0) + selectCount;
	} else {
		core.status.hero[use] += totalMoney;
		core.removeItem(item.id, selectCount);
		core.drawTip("成功卖出 " + selectCount + " 个" + ((core.material.items[item.id].i18nAlias||{})[core.getLocalStorage('language', '简体中文')] || core.material.items[item.id].name), item.id);
		if (item.number != null) item.number += selectCount;
		item.sell_count = (item.sell_count || 0) + selectCount;
	}
	selectCount = 0;
}

this._performItemShopKeyBoard = function (keycode) {
	var item = list[selectItem] || null;
	// 键盘操作
	switch (keycode) {
	case 38: // up
		if (selectItem == null) break;
		if (selectItem == 0) selectItem = null;
		else selectItem--;
		selectCount = 0;
		break;
	case 37: // left
		if (selectItem == null) {
			if (type > 0) type--;
			break;
		}
		_add(item, -1);
		break;
	case 39: // right
		if (selectItem == null) {
			if (type < 2) type++;
			break;
		}
		_add(item, 1);
		break;
	case 40: // down
		if (selectItem == null) {
			if (list.length > 0) selectItem = 0;
			break;
		}
		if (list.length == 0) break;
		selectItem = Math.min(selectItem + 1, list.length - 1);
		selectCount = 0;
		break;
	case 13:
	case 32: // Enter/Space
		if (selectItem == null) {
			if (type == 2)
				core.insertAction({ "type": "break" });
			else if (list.length > 0)
				selectItem = 0;
			break;
		}
		_confirm(item);
		break;
	case 27: // ESC
		if (selectItem == null) {
			core.insertAction({ "type": "break" });
			break;
		}
		selectItem = null;
		break;
	}
}

this._performItemShopClick = function (px, py) {
	var item = list[selectItem] || null;
	// 鼠标操作
	if (px >= 22 && px <= 82 && py >= 71 && py <= 102) {
		// 买
		if (type != 0) {
			type = 0;
			selectItem = null;
			selectCount = 0;
		}
		return;
	}
	if (px >= 122 && px <= 182 && py >= 71 && py <= 102) {
		// 卖
		if (type != 1) {
			type = 1;
			selectItem = null;
			selectCount = 0;
		}
		return;
	}
	if (px >= 222 && px <= 282 && py >= 71 && py <= 102) // 离开
		return core.insertAction({ "type": "break" });
	// < >
	if (px >= 318 && px <= 341 && py >= 348 && py <= 376)
		return _add(item, -1);
	if (px >= 388 && px <= 416 && py >= 348 && py <= 376)
		return _add(item, 1);
	// 确定
	if (px >= 341 && px <= 387 && py >= 380 && py <= 407)
		return _confirm(item);

	// 上一页/下一页
	if (px >= 45 && px <= 105 && py >= 388) {
		if (page > 1) {
			selectItem -= 6;
			selectCount = 0;
		}
		return;
	}
	if (px >= 208 && px <= 268 && py >= 388) {
		if (page < totalPage) {
			selectItem = Math.min(selectItem + 6, list.length - 1);
			selectCount = 0;
		}
		return;
	}

	// 实际区域
	if (px >= 9 && px <= 300 && py >= 120 && py < 360) {
		if (list.length == 0) return;
		var index = parseInt((py - 120) / 40);
		var newItem = 6 * (page - 1) + index;
		if (newItem >= list.length) newItem = list.length - 1;
		if (newItem != selectItem) {
			selectItem = newItem;
			selectCount = 0;
		}
		return;
	}
}

this._performItemShopAction = function () {
	if (flags.type == 0) return this._performItemShopKeyBoard(flags.keycode);
	else return this._performItemShopClick(flags.px, flags.py);
}

this.openItemShop = function (itemShopId) {
	shopId = itemShopId;
	type = 0;
	page = 0;
	selectItem = null;
	selectCount = 0;
	core.isShopVisited(itemShopId);
	shopInfo = flags.__shops__[shopId];
	if (shopInfo.choices == null) shopInfo.choices = core.clone(core.status.shops[shopId].choices);
	choices = shopInfo.choices;
	use = core.status.shops[shopId].use;
	if (use != 'exp') use = 'money';
	useText = use == 'money' ? '金币' : '经验';

	core.insertAction([{
			"type": "while",
			"condition": "true",
			"data": [
				{ "type": "function", "function": "function () { core.plugin._drawItemShop(); }" },
				{ "type": "wait" },
				{ "type": "function", "function": "function() { core.plugin._performItemShopAction(); }" }
			]
		},
		{
			"type": "function",
			"function": "function () { core.deleteCanvas('uievent'); core.ui.clearUIEventSelector(); }"
		}
	]);
}

},
    "砍层插件": function () {
	// 高层塔砍层插件，删除后不会存入存档，不可浏览地图也不可飞到。
	// 推荐用法：
	// 对于超高层或分区域塔，当在1区时将2区以后的地图删除；1区结束时恢复2区，进二区时删除1区地图，以此类推
	// 这样可以大幅减少存档空间，以及加快存读档速度

	// 删除楼层
	// core.removeMaps("MT1", "MT300") 删除MT1~MT300之间的全部层
	// core.removeMaps("MT10") 只删除MT10层
	this.removeMaps = function (fromId, toId) {
		toId = toId || fromId;
		var fromIndex = core.floorIds.indexOf(fromId),
			toIndex = core.floorIds.indexOf(toId);
		if (toIndex < 0) toIndex = core.floorIds.length - 1;
		flags.__visited__ = flags.__visited__ || {};
		flags.__removed__ = flags.__removed__ || [];
		flags.__disabled__ = flags.__disabled__ || {};
		for (var i = fromIndex; i <= toIndex; ++i) {
			var floorId = core.floorIds[i];
			if (core.status.maps[floorId].deleted) continue;
			delete flags.__visited__[floorId];
			flags.__removed__.push(floorId);
			delete flags.__disabled__[floorId];
			core.status.maps[floorId].deleted = true;
			core.status.maps[floorId].canFlyTo = false;
			core.status.maps[floorId].cannotViewMap = true;
		}
	}

	// 恢复楼层
	// core.resumeMaps("MT1", "MT300") 恢复MT1~MT300之间的全部层
	// core.resumeMaps("MT10") 只恢复MT10层
	this.resumeMaps = function (fromId, toId) {
		toId = toId || fromId;
		var fromIndex = core.floorIds.indexOf(fromId),
			toIndex = core.floorIds.indexOf(toId);
		if (toIndex < 0) toIndex = core.floorIds.length - 1;
		flags.__removed__ = flags.__removed__ || [];
		for (var i = fromIndex; i <= toIndex; ++i) {
			var floorId = core.floorIds[i];
			if (!core.status.maps[floorId].deleted) continue;
			flags.__removed__ = flags.__removed__.filter(function (f) { return f != floorId; });
			core.status.maps[floorId] = core.loadFloor(floorId);
		}
	}

	// 分区砍层相关
	var inAnyPartition = function (floorId) {
		var inPartition = false;
		(core.floorPartitions || []).forEach(function (floor) {
			var fromIndex = core.floorIds.indexOf(floor[0]);
			var toIndex = core.floorIds.indexOf(floor[1]);
			var index = core.floorIds.indexOf(floorId);
			if (fromIndex < 0 || index < 0) return;
			if (toIndex < 0) toIndex = core.floorIds.length - 1;
			if (index >= fromIndex && index <= toIndex) inPartition = true;
		});
		return inPartition;
	}

	// 分区砍层
	this.autoRemoveMaps = function (floorId) {
		if (main.mode != 'play' || !inAnyPartition(floorId)) return;
		// 根据分区信息自动砍层与恢复
		(core.floorPartitions || []).forEach(function (floor) {
			var fromIndex = core.floorIds.indexOf(floor[0]);
			var toIndex = core.floorIds.indexOf(floor[1]);
			var index = core.floorIds.indexOf(floorId);
			if (fromIndex < 0 || index < 0) return;
			if (toIndex < 0) toIndex = core.floorIds.length - 1;
			if (index >= fromIndex && index <= toIndex) {
				core.resumeMaps(core.floorIds[fromIndex], core.floorIds[toIndex]);
			} else {
				core.removeMaps(core.floorIds[fromIndex], core.floorIds[toIndex]);
			}
		});
	}
},
    "fiveLayers": function () {
	// 是否启用五图层（增加背景2层和前景2层） 将__enable置为true即会启用；启用后请保存后刷新编辑器
	// 背景层2将会覆盖背景层 被事件层覆盖 前景层2将会覆盖前景层
	// 另外 请注意加入两个新图层 会让大地图的性能降低一些
	// 插件作者：ad
	var __enable = false;
	if (!__enable) return;

	// 创建新图层
	function createCanvas(name, zIndex) {
		if (!name) return;
		var canvas = document.createElement('canvas');
		canvas.id = name;
		canvas.className = 'gameCanvas';
		canvas.width = canvas.height = core.__PIXELS__;
		// 编辑器模式下设置zIndex会导致加入的图层覆盖优先级过高
		if (main.mode != "editor") canvas.style.zIndex = zIndex || 0;
		// 将图层插入进游戏内容
		document.getElementById('gameDraw').appendChild(canvas);
		var ctx = canvas.getContext('2d');
		core.canvas[name] = ctx;
		return canvas;
	}

	var bg2Canvas = createCanvas('bg2', 20);
	var fg2Canvas = createCanvas('fg2', 63);
	// 大地图适配
	core.bigmap.canvas = ["bg2", "fg2", "bg", "event", "event2", "fg", "damage"];
	core.initStatus.bg2maps = {};
	core.initStatus.fg2maps = {};

	if (main.mode == 'editor') {
		/*插入编辑器的图层 不做此步新增图层无法在编辑器显示*/
		// 编辑器图层覆盖优先级 eui > efg > fg(前景层) > event2(48*32图块的事件层) > event(事件层) > bg(背景层)
		// 背景层2(bg2) 插入事件层(event)之前(即bg与event之间)
		document.getElementById('mapEdit').insertBefore(bg2Canvas, document.getElementById('event'));
		// 前景层2(fg2) 插入编辑器前景(efg)之前(即fg之后)
		document.getElementById('mapEdit').insertBefore(fg2Canvas, document.getElementById('ebm'));
		// 原本有三个图层 从4开始添加
		var num = 4;
		// 新增图层存入editor.dom中
		editor.dom.bg2c = core.canvas.bg2.canvas;
		editor.dom.bg2Ctx = core.canvas.bg2;
		editor.dom.fg2c = core.canvas.fg2.canvas;
		editor.dom.fg2Ctx = core.canvas.fg2;
		editor.dom.maps.push('bg2map', 'fg2map');
		editor.dom.canvas.push('bg2', 'fg2');

		// 创建编辑器上的按钮
		var createCanvasBtn = function (name) {
			// 电脑端创建按钮
			var input = document.createElement('input');
			// layerMod4/layerMod5
			var id = 'layerMod' + num++;
			// bg2map/fg2map
			var value = name + 'map';
			input.type = 'radio';
			input.name = 'layerMod';
			input.id = id;
			input.value = value;
			editor.dom[id] = input;
			input.onchange = function () {
				editor.uifunctions.setLayerMod(value);
			}
			return input;
		};

		var createCanvasBtn_mobile = function (name) {
			// 手机端往选择列表中添加子选项
			var input = document.createElement('option');
			var id = 'layerMod' + num++;
			var value = name + 'map';
			input.name = 'layerMod';
			input.value = value;
			editor.dom[id] = input;
			return input;
		};
		if (!editor.isMobile) {
			var input = createCanvasBtn('bg2');
			var input2 = createCanvasBtn('fg2');
			// 获取事件层及其父节点
			var child = document.getElementById('layerMod'),
				parent = child.parentNode;
			// 背景层2插入事件层前
			parent.insertBefore(input, child);
			// 不能直接更改背景层2的innerText 所以创建文本节点
			var txt = document.createTextNode('背景层2');
			// 插入事件层前(即新插入的背景层2前)
			parent.insertBefore(txt, child);
			// 向最后插入前景层2(即插入前景层后)
			parent.appendChild(input2);
			var txt2 = document.createTextNode('前景层2');
			parent.appendChild(txt2);
		} else {
			var input = createCanvasBtn_mobile('bg2');
			var input2 = createCanvasBtn_mobile('fg2');
			// 手机端因为是选项 所以可以直接改innerText
			input.innerText = '背景层2';
			input2.innerText = '前景层2';
			var parent = document.getElementById('layerMod');
			parent.insertBefore(input, parent.children[1]);
			parent.appendChild(input2);
		}
	}
	core.maps._loadFloor_doNotCopy = function () {
		return [
			"firstArrive", "eachArrive", "blocks", "parallel", "map", "bgmap", "fgmap", "bg2map", "fg2map",
			"events", "changeFloor", "afterBattle", "afterGetItem", "afterOpenDoor", "cannotMove"
		];
	}
	////// 绘制背景和前景层 //////
	core.maps._drawBg_draw = function (floorId, toDrawCtx, cacheCtx, config) {
		config.ctx = cacheCtx;
		core.maps._drawBg_drawBackground(floorId, config);
		// ------ 调整这两行的顺序来控制是先绘制贴图还是先绘制背景图块；后绘制的覆盖先绘制的。
		core.maps._drawFloorImages(floorId, config.ctx, 'bg', null, null, config.onMap);
		core.maps._drawBgFgMap(floorId, 'bg', config);
		if (config.onMap) {
			core.drawImage(toDrawCtx, cacheCtx.canvas, core.bigmap.v2 ? -32 : 0, core.bigmap.v2 ? -32 : 0);
			core.clearMap('bg2');
			core.clearMap(cacheCtx);
		}
		core.maps._drawBgFgMap(floorId, 'bg2', config);
		if (config.onMap) core.drawImage('bg2', cacheCtx.canvas, core.bigmap.v2 ? -32 : 0, core.bigmap.v2 ? -32 : 0);
		config.ctx = toDrawCtx;
	}
	core.maps._drawFg_draw = function (floorId, toDrawCtx, cacheCtx, config) {
		config.ctx = cacheCtx;
		// ------ 调整这两行的顺序来控制是先绘制贴图还是先绘制前景图块；后绘制的覆盖先绘制的。
		core.maps._drawFloorImages(floorId, config.ctx, 'fg', null, null, config.onMap);
		core.maps._drawBgFgMap(floorId, 'fg', config);
		if (config.onMap) {
			core.drawImage(toDrawCtx, cacheCtx.canvas, core.bigmap.v2 ? -32 : 0, core.bigmap.v2 ? -32 : 0);
			core.clearMap('fg2');
			core.clearMap(cacheCtx);
		}
		core.maps._drawBgFgMap(floorId, 'fg2', config);
		if (config.onMap) core.drawImage('fg2', cacheCtx.canvas, core.bigmap.v2 ? -32 : 0, core.bigmap.v2 ? -32 : 0);
		config.ctx = toDrawCtx;
	}
	////// 移动判定 //////
	core.maps._generateMovableArray_arrays = function (floorId) {
		return {
			bgArray: this.getBgMapArray(floorId),
			fgArray: this.getFgMapArray(floorId),
			eventArray: this.getMapArray(floorId),
			bg2Array: this._getBgFgMapArray('bg2', floorId),
			fg2Array: this._getBgFgMapArray('fg2', floorId)
		};
	}
},
    "怪物称号": function () {
	// 此插件将提供怪物手册中的怪物境界显示
	// 使用此插件需要先给每个怪物定义境界，方法如下：
	// 点击怪物的【配置表格】，找到“【怪物】相关的表格配置”，然后在【名称】仿照增加境界定义：
	/*
	 "level": {
	 	"_leaf": true,
	 	"_type": "textarea",
	 	"_string": true,
	 	"_data": "境界"
	 },
	 */
	// 然后保存刷新，可以看到怪物的属性定义中出现了【境界】。再开启本插件即可。

	// 是否开启本插件，默认禁用；将此改成 true 将启用本插件。
	var __enable = false;
	if (!__enable) return;

	// 这里定义每个境界的显示颜色；可以写'red', '#RRGGBB' 或者[r,g,b,a]四元数组
	var levelToColors = {
		"倔强青铜": "red",
		"不屈白银": "#FF0000",
		"尊贵黄金": [255, 0, 0, 1],
	};

	// 复写 _drawBook_drawName
	var originDrawBook = core.ui._drawBook_drawName;
	core.ui._drawBook_drawName = function (index, enemy, top, left, width) {
		// 如果没有境界，则直接调用原始代码绘制
		if (!enemy.level) return originDrawBook.call(core.ui, index, enemy, top, left, width);
		// 存在境界，则额外进行绘制
		core.setTextAlign('ui', 'center');
		if (enemy.specialText.length == 0) {
			core.fillText('ui', enemy.name, left + width / 2,
				top + 27, '#DDDDDD', this._buildFont(17, true));
			core.fillText('ui', enemy.level, left + width / 2,
				top + 51, core.arrayToRGBA(levelToColors[enemy.level] || '#DDDDDD'), this._buildFont(14, true));
		} else {
			core.fillText('ui', enemy.name, left + width / 2,
				top + 20, '#DDDDDD', this._buildFont(17, true), width);
			switch (enemy.specialText.length) {
			case 1:
				core.fillText('ui', enemy.specialText[0], left + width / 2,
					top + 38, core.arrayToRGBA((enemy.specialColor || [])[0] || '#FF6A6A'),
					this._buildFont(14, true), width);
				break;
			case 2:
				if (core.getLocalStorage('language', '简体中文') != '简体中文') // 仅CJK支持双属性
                    return core.fillText('ui', {'简体中文': "多属性...", 'English': 'Details...'}[core.getLocalStorage('language', '简体中文')], left + width / 2, top + 50, '#FF6A6A', this._buildFont(15, true), width);
                // Step 1: 计算字体
                var text = enemy.specialText[0] + ' ' + enemy.specialText[1];
                core.setFontForMaxWidth('ui', text, width, this._buildFont(15, true));
                // Step 2: 计算总宽度
                var totalWidth = core.calWidth('ui', text);
                var leftWidth = core.calWidth('ui', enemy.specialText[0]);
                var rightWidth = core.calWidth('ui', enemy.specialText[1]);
                // Step 3: 绘制
                core.fillText('ui', enemy.specialText[0], left + (width + leftWidth - totalWidth) / 2,
                    top+50, core.arrayToRGBA((enemy.specialColor || [])[0] || '#FF6A6A'));
                core.fillText('ui', enemy.specialText[1], left + (width + totalWidth - rightWidth) / 2,
                    top+50, core.arrayToRGBA((enemy.specialColor || [])[1] || '#FF6A6A'));
                break;
            default:
                core.fillText('ui', {'简体中文': "多属性...", 'English': 'Details...'}[core.getLocalStorage('language', '简体中文')], left + width / 2, top + 50, '#FF6A6A', this._buildFont(15, true), width);
			}
			core.fillText('ui', enemy.level, left + width / 2,
				top + 56, core.arrayToRGBA(levelToColors[enemy.level] || '#DDDDDD'), this._buildFont(14, true));
		}
	}

	// 也可以复写其他的属性颜色如怪物攻防等，具体参见下面的例子的注释部分
	core.ui._drawBook_drawRow1 = function (index, enemy, top, left, width, position) {
		// 绘制第一行
		core.setTextAlign('ui', 'left');
		var b13 = this._buildFont(13, true), f13 = this._buildFont(13, false);
		var col1 = left, col2 = col1 + width / 3 - 5, col3 = col1 + width * 2 / 3 - 10;
		core.fillText('ui', core.getStatusLabel('hp') || '生命', col1, position, '#DDDDDD', f13);
		core.fillText('ui', core.formatBigNumber(enemy.hp || 0), col1 + 30, position, /*'red' */ null, b13);
		core.fillText('ui', core.getStatusLabel('atk') || '攻击', col2, position, null, f13);
		core.fillText('ui', core.formatBigNumber(enemy.atk || 0), col2 + 30, position, /* '#FF0000' */ null, b13);
		core.fillText('ui', core.getStatusLabel('def') || '防御', col3, position, null, f13);
		core.fillText('ui', core.formatBigNumber(enemy.def || 0), col3 + 30, position, /* [255, 0, 0, 1] */ null, b13);
	}
},
    "血量跳动": function () {
	// 此插件允许人物血量动态进行变化
	// 原作：Fux2（老黄鸡）

	// 是否开启本插件，默认禁用；将此改成 true 将启用本插件。
	var __enable = false;
	if (!__enable) return;

	var speed = 0.05; // 动态血量变化速度，越大越快。

	var _currentHp = null;
	var _lastStatus = null;
	var _check = function () {
		if (_lastStatus != core.status.hero) {
			_lastStatus = core.status.hero;
			_currentHp = core.status.hero.hp;
		}
	}

	core.registerAnimationFrame('dynamicHp', true, function () {
		_check();
		if (core.status.hero.hp != _currentHp) {
			var dis = (_currentHp - core.status.hero.hp) * speed;
			if (Math.abs(dis) < 2) {
				_currentHp = core.status.hero.hp;
			} else {
				_currentHp -= dis;
			}
			core.setStatusBarInnerHTML('hp', _currentHp);
		}
	});
},
    "multiHero": function () {
	// 多角色插件
	// Step 1: 启用本插件
	// Step 2: 定义每个新的角色各项初始数据（参见下方注释）
	// Step 3: 在游戏中的任何地方都可以调用 `core.changeHero()` 进行切换；也可以 `core.changeHero(1)` 来切换到某个具体的角色上

	// 是否开启本插件，默认禁用；将此改成 true 将启用本插件。
	var __enable = false;
	if (!__enable) return;

	// 在这里定义全部的新角色属性
	// 请注意，在这里定义的内容不会多角色共用，在切换时会进行恢复。
	// 你也可以自行新增或删除，比如不共用金币则可以加上"money"的初始化，不共用道具则可以加上"items"的初始化，
	// 多角色共用hp的话则删除hp，等等。总之，不共用的属性都在这里进行定义就好。
	var hero1 = {
		"floorId": "MT0", // 该角色初始楼层ID；如果共用楼层可以注释此项
		"image": "brave.png", // 角色的行走图名称；此项必填不然会报错
		"name": "1号角色",
		"lv": 1,
		"hp": 10000, // 如果HP共用可注释此项
		"atk": 1000,
		"def": 1000,
		"mdef": 0,
		// "money": 0, // 如果要不共用金币则取消此项注释
		// "exp": 0, // 如果要不共用经验则取消此项注释
		"loc": { "x": 0, "y": 0, "direction": "up" }, // 该角色初始位置；如果共用位置可注释此项
		"items": {
			"tools": {}, // 如果共用消耗道具（含钥匙）则可注释此项
			// "constants": {}, // 如果不共用永久道具（如手册）可取消注释此项
			"equips": {}, // 如果共用在背包的装备可注释此项
		},
		"equipment": [], // 如果共用装备可注释此项；此项和上面的「共用在背包的装备」需要拥有相同状态，不然可能出现问题
	};
	// 也可以类似新增其他角色
	// 新增的角色，各项属性共用与不共用的选择必须和上面完全相同，否则可能出现问题。
	// var hero2 = { ...

	var heroCount = 2; // 包含默认角色在内总共多少个角色，该值需手动修改。

	this.initHeros = function () {
		core.setFlag("hero1", core.clone(hero1)); // 将属性值存到变量中
		// core.setFlag("hero2", core.clone(hero2)); // 更多的角色也存入变量中；每个定义的角色都需要新增一行

		// 检测是否存在装备
		if (hero1.equipment) {
			if (!hero1.items || !hero1.items.equips) {
				alert('多角色插件的equipment和道具中的equips必须拥有相同状态！');
			}
			// 存99号套装为全空
			var saveEquips = core.getFlag("saveEquips", []);
			saveEquips[99] = [];
			core.setFlag("saveEquips", saveEquips);
		} else {
			if (hero1.items && hero1.items.equips) {
				alert('多角色插件的equipment和道具中的equips必须拥有相同状态！');
			}
		}
	}

	// 在游戏开始注入initHeros
	var _startGame_setHard = core.events._startGame_setHard;
	core.events._startGame_setHard = function () {
		_startGame_setHard.call(core.events);
		core.initHeros();
	}

	// 切换角色
	// 可以使用 core.changeHero() 来切换到下一个角色
	// 也可以 core.changeHero(1) 来切换到某个角色（默认角色为0）
	this.changeHero = function (toHeroId) {
		var currHeroId = core.getFlag("heroId", 0); // 获得当前角色ID
		if (toHeroId == null) {
			toHeroId = (currHeroId + 1) % heroCount;
		}
		if (currHeroId == toHeroId) return;

		var saveList = Object.keys(hero1);

		// 保存当前内容
		var toSave = {};
		// 暂时干掉 drawTip 和 音效，避免切装时的提示
		var _drawTip = core.ui.drawTip;
		core.ui.drawTip = function () {};
		var _playSound = core.control.playSound;
		core.control.playSound = function () {}
		// 记录当前录像，因为可能存在换装问题
		core.clearRouteFolding();
		var routeLength = core.status.route.length;
		// 优先判定装备
		if (hero1.equipment) {
			core.items.quickSaveEquip(100 + currHeroId);
			core.items.quickLoadEquip(99);
		}

		saveList.forEach(function (name) {
			if (name == 'floorId') toSave[name] = core.status.floorId; // 楼层单独设置
			else if (name == 'items') {
				toSave.items = core.clone(core.status.hero.items);
				Object.keys(toSave.items).forEach(function (one) {
					if (!hero1.items[one]) delete toSave.items[one];
				});
			} else toSave[name] = core.clone(core.status.hero[name]); // 使用core.clone()来创建新对象
		});

		core.setFlag("hero" + currHeroId, toSave); // 将当前角色信息进行保存
		var data = core.getFlag("hero" + toHeroId); // 获得要切换的角色保存内容

		// 设置角色的属性值
		saveList.forEach(function (name) {
			if (name == "floorId");
			else if (name == "items") {
				Object.keys(core.status.hero.items).forEach(function (one) {
					if (data.items[one]) core.status.hero.items[one] = core.clone(data.items[one]);
				});
			} else {
				core.status.hero[name] = core.clone(data[name]);
			}
		});
		// 最后装上装备
		if (hero1.equipment) {
			core.items.quickLoadEquip(100 + toHeroId);
		}

		core.ui.drawTip = _drawTip;
		core.control.playSound = _playSound;
		core.status.route = core.status.route.slice(0, routeLength);

		// 插入事件：改变角色行走图并进行楼层切换
		var toFloorId = data.floorId || core.status.floorId;
		var toLoc = data.loc || core.status.hero.loc;
		core.insertAction([
			{ "type": "setHeroIcon", "name": data.image || "hero.png" }, // 改变行走图
			// 同层则用changePos，不同层则用changeFloor；这是为了避免共用楼层造成触发eachArrive
			toFloorId != core.status.floorId ? {
				"type": "changeFloor",
				"floorId": toFloorId,
				"loc": [toLoc.x, toLoc.y],
				"direction": toLoc.direction,
				"time": 0 // 可以在这里设置切换时间
			} : { "type": "changePos", "loc": [toLoc.x, toLoc.y], "direction": toLoc.direction }
			// 你还可以在这里执行其他事件，比如增加或取消跟随效果
		]);
		core.setFlag("heroId", toHeroId); // 保存切换到的角色ID
	}
},
    "楼传过滤": function () {
	// 此插件可以让用户在楼传页面手动隐藏某些楼层	
	// 原作：一桶天下

	// 是否开启本插件，默认禁用；将此改成 true 将启用本插件。
	var __enable = true;
	if (!__enable) return;

	var _drawFly = core.ui.drawFly;
	core.ui.drawFly = function (page) {
		_drawFly.call(core.ui, page);
		// 绘制「显示本层」和「显示全部」
		var __hideFloors__ = core.getFlag('__hideFloors__', {});
		var __showAllFloor__ = core.getFlag('__showAllFloor__', false);
		var floorId = core.floorIds[page];
		core.fillText('ui', {'简体中文': '显示该层', 'English': 'Current Only'}[core.getLocalStorage('language', '简体中文')], this.HPIXEL - 120, 60, __hideFloors__[floorId] ? '#FFFFFF' : 'yellow', this._buildFont(20, false));
		core.fillText('ui', {'简体中文': '显示全部', 'English': 'Show All'}[core.getLocalStorage('language', '简体中文')], this.HPIXEL + 120, 60, !__showAllFloor__ ? '#FFFFFF' : 'yellow', this._buildFont(20, false));
	}

	var _clickFly = core.actions._clickFly;
	core.actions._clickFly = function (x, y) {
		_clickFly.call(core.actions, x, y);

		var __hideFloors__ = core.getFlag('__hideFloors__', {})
		var __showAllFloor__ = core.getFlag('__showAllFloor__', false)
		var _floorId = core.floorIds[core.status.event.data]

		if (y == 1 && x >= this.HSIZE - 5 && x <= this.HSIZE - 2) {
			__hideFloors__[_floorId] = !__hideFloors__[_floorId]
			core.setFlag('__hideFloors__', __hideFloors__)
			core.ui.drawFly(this._getNextFlyFloor(0))
		}
		if (y == 1 && x >= this.HSIZE + 2 && x <= this.HSIZE + 5) {
			core.setFlag('__showAllFloor__', !__showAllFloor__)
			core.ui.drawFly(this._getNextFlyFloor(0))
		}
	}

	var _keyUpFly = core.actions._keyUpFly;
	core.actions._keyUpFly = function (keycode) {
		_keyUpFly.call(core.actions, keycode);

		var __hideFloors__ = core.getFlag('__hideFloors__', {})
		var __showAllFloor__ = core.getFlag('__showAllFloor__', false)
		var _floorId = core.floorIds[core.status.event.data]

		// Q
		if (keycode == 81) {
			__hideFloors__[_floorId] = !__hideFloors__[_floorId]
			core.setFlag('__hideFloors__', __hideFloors__)
			core.ui.drawFly(this._getNextFlyFloor(0));
		} else if (keycode == 69) {
			// E			
			core.setFlag('__showAllFloor__', !__showAllFloor__)
			core.ui.drawFly(this._getNextFlyFloor(0))
		}
	}

	core.actions._getNextFlyFloor = function (delta, index) {
		var __hideFloors__ = core.getFlag('__hideFloors__', {})
		var __showAllFloor__ = core.getFlag('__showAllFloor__', false)
		if (index == null) index = core.status.event.data;
		if (delta == 0) return index;
		var sign = Math.sign(delta);
		delta = Math.abs(delta);
		var ans = index;
		while (true) {
			index += sign;
			if (index < 0 || index >= core.floorIds.length) break;
			var floorId = core.floorIds[index];
			if (core.status.maps[floorId].canFlyTo && core.hasVisitedFloor(floorId) && (__showAllFloor__ || !__hideFloors__[floorId])) {
				delta--;
				ans = index;
			}
			if (delta == 0) break;
		}
		return ans;
	}
},
    "道具分类": function () {
	// 物品分类插件。此插件允许你对消耗道具和永久道具进行分类，比如标记「宝物类」「剧情道具」「药品」等等。
	// 使用方法：
	// 1. 启用本插件
	// 2. 在下方数组中定义全部的物品分类类型
	// 3. 点击道具的【配置表格】，找到“【道具】相关的表格配置”，然后在【道具描述】之后仿照增加道具的分类：
	/*
	 "category": {
	 	"_leaf": true,
	 	"_type": "textarea",
	 	"_string": true,
	 	"_data": "道具分类"
	 },
	 */
	// （你也可以选择使用下拉框的方式定义每个道具的分类，写法参见上面的cls）
	// 然后刷新编辑器，就可以对每个物品进行分类了

	// 是否开启本插件，默认禁用；将此改成 true 将启用本插件。
	var __enable = false;
	if (!__enable) return;

	// 在这里定义所有的道具分类类型，一行一个
	var categories = [
		"宝物类",
		"辅助类",
		"技能类",
		"剧情道具",
		"增益道具",
	];
	// 当前选中的道具类别
	var currentCategory = null;

	// 重写 core.ui._drawToolbox 以绘制分类类别
	var _drawToolbox = core.ui._drawToolbox;
	core.ui._drawToolbox = function (index) {
		_drawToolbox.call(this, index);
		core.setTextAlign('ui', 'left');
		core.fillText('ui', '类别[E]：' + (currentCategory || "全部"), 15, this.PIXEL - 13);
	}

	// 获得所有应该在道具栏显示的某个类型道具
	core.ui.getToolboxItems = function (cls) {
		// 检查类别
		return Object.keys(core.status.hero.items[cls])
			.filter(function (id) {
				return !core.material.items[id].hideInToolbox &&
					(currentCategory == null || core.material.items[id].category == currentCategory);
			}).sort();
	}

	// 注入道具栏的点击事件（点击类别）
	var _clickToolbox = core.actions._clickToolbox;
	core.actions._clickToolbox = function (x, y) {
		if (x >= 0 && x <= this.HSIZE - 4 && y == this.LAST) {
			drawToolboxCategory();
			return;
		}
		return _clickToolbox.call(core.actions, x, y);
	}

	// 注入道具栏的按键事件（E键）
	var _keyUpToolbox = core.actions._keyUpToolbox;
	core.actions._keyUpToolbox = function (keyCode) {
		if (keyCode == 69) {
			// 按E键则打开分类类别选择
			drawToolboxCategory();
			return;
		}
		return _keyUpToolbox.call(core.actions, keyCode);
	}

	// ------ 以下为选择道具分类的相关代码 ------ //

	// 关闭窗口时清除分类选择项
	var _closePanel = core.ui.closePanel;
	core.ui.closePanel = function () {
		currentCategory = null;
		_closePanel.call(core.ui);
	}

	// 弹出菜单以选择具体哪个分类
	// 直接使用 core.drawChoices 进行绘制
	var drawToolboxCategory = function () {
		if (core.status.event.id != 'toolbox') return;
		var selection = categories.indexOf(currentCategory) + 1;
		core.ui.closePanel();
		core.status.event.id = 'toolbox-category';
		core.status.event.selection = selection;
		core.lockControl();
		// 给第一项插入「全部」
		core.drawChoices('\t[请选择道具类别,hero] ', ["全部"].concat(categories));
	}

	// 选择某一项
	var _selectCategory = function (index) {
		core.ui.closePanel();
		if (index <= 0 || index > categories.length) currentCategory = null;
		else currentCategory = categories[index - 1];
		core.openToolbox();
	}

	var _clickToolBoxCategory = function (x, y) {
		if (!core.status.lockControl || core.status.event.id != 'toolbox-category') return false;

		if (x < core.actions.CHOICES_LEFT || x > core.actions.CHOICES_RIGHT) return false;
		var choices = core.status.event.ui.choices;
		var topIndex = core.actions.HSIZE - parseInt((choices.length - 1) / 2) + (core.status.event.ui.offset || 0);
		if (y >= topIndex && y < topIndex + choices.length) {
			_selectCategory(y - topIndex);
		}
		return true;
	}

	// 注入点击事件
	core.registerAction('onclick', 'toolbox-category', _clickToolBoxCategory, 100);

	// 注入光标跟随事件
	core.registerAction('onmove', 'toolbox-category', function (x, y) {
		if (!core.status.lockControl || core.status.event.id != 'toolbox-category') return false;
		core.actions._onMoveChoices(x, y);
		return true;
	}, 100);

	// 注入键盘光标事件
	core.registerAction('keyDown', 'toolbox-category', function (keyCode) {
		if (!core.status.lockControl || core.status.event.id != 'toolbox-category') return false;
		core.actions._keyDownChoices(keyCode);
		return true;
	}, 100);

	// 注入键盘按键事件
	core.registerAction('keyUp', 'toolbox-category', function (keyCode) {
		if (!core.status.lockControl || core.status.event.id != 'toolbox-category') return false;
		core.actions._selectChoices(core.status.event.ui.choices.length, keyCode, _clickToolBoxCategory);
		return true;
	}, 100);

},
    "自动拾取": function () {
	var enable = false; // 改为true来启用此插件
	if (!enable) return;
	/*
		作者：君浪 上传时间：2020-07-11 17:44:32 审核：未审核
		简介：在能到达的范围内，每走一步（moveOnestep）自动吸取物品，适合没有吸血和血限的爽塔。
		也可以在别的地方（如moveDirectly）加入core.autoGetItem();触发
		PS： 最好在脚本编辑的loadData中加一句 core.stopAttractAnimate(); 以防在读档后动画不消失。
		使用样例：《龙之传奇》
	*/

	// var noUpdate = false;
	////// 更新状态栏 ////// 不建议状态栏刷新后触发 容易导致录像不一致的问题
	//control.prototype.updateStatusBar = function (doNotCheckAutoEvents) {
	//	if (!core.isPlaying()) return;
	//	if (noUpdate) return;
	//	noUpdate = true;
	//	core.autoGetItem();
	//	noUpdate = false;
	//	this.controldata.updateStatusBar();
	//	if (!doNotCheckAutoEvents) core.checkAutoEvents();
	//	this._updateStatusBar_setToolboxIcon();
	//	core.clearRouteFolding();
	//}

	////// 每移动一格后执行的事件 //////
	control.prototype.moveOneStep = function (callback) {
		core.autoGetItem();
		return this.controldata.moveOneStep(callback);
	}

	function bfsFlood(sx, sy, blockfn) {
		var canMoveArray = core.generateMovableArray();
		var blocksObj = core.getMapBlocksObj();
		var bgMap = core.getBgMapArray();

		var visited = [],
			queue = [];
		visited[sx + "," + sy] = 0;
		queue.push(sx + "," + sy);

		while (queue.length > 0) {
			var now = queue.shift().split(","),
				x = ~~now[0],
				y = ~~now[1];
			for (var direction in core.utils.scan) {
				if (!core.inArray(canMoveArray[x][y], direction)) continue;
				var nx = x + core.utils.scan[direction].x,
					ny = y + core.utils.scan[direction].y,
					nindex = nx + "," + ny;
				if (visited[nindex]) continue;
				if (core.onSki(bgMap[ny][nx])) continue;
				if (blockfn && !blockfn(blocksObj, nx, ny)) continue;
				visited[nindex] = visited[now] + 1;
				queue.push(nindex);
			}
		}
	}

	function attractAnimate() {
		var name = 'attractAnimate';
		var isPlaying = false;
		this.nodes = [];

		this.add = function (id, x, y, callback) {
			this.nodes.push({ id: id, x: x, y: y, callback: callback });
		}
		this.start = function () {
			if (isPlaying) return;
			isPlaying = true;
			core.registerAnimationFrame(name, true, this.update);
			this.ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 120);
		}
		this.remove = function () {
			core.unregisterAnimationFrame(name);
			core.deleteCanvas(name);
			isPlaying = false;
		}
		this.clear = function () {
			this.nodes = [];
			this.remove();
		}
		var lastTime = -1;
		var self = this;
		this.update = function (timeStamp) {
			if (lastTime < 0) lastTime = timeStamp;
			if (timeStamp - lastTime < 20) return;
			lastTime = timeStamp;
			core.clearMap(name);
			var cx = core.status.heroCenter.px - 16,
				cy = core.status.heroCenter.py - 16;
			var thr = 5; //缓动比例倒数 越大移动越慢
			self.nodes.forEach(function (n) {
				var dx = cx - n.x,
					dy = cy - n.y;
				if (Math.abs(dx) <= thr && Math.abs(dy) <= thr) {
					n.dead = true;
				} else {
					n.x += ~~(dx / thr);
					n.y += ~~(dy / thr);
				}
				core.drawIcon(name, n.id, n.x, n.y, 32, 32);
			});
			self.nodes = self.nodes.filter(function (n) {
				if (n.dead && n.callback) {
					n.callback();
				}
				return !n.dead;
			});
			if (self.nodes.length == 0)
				self.remove();
		}
	}


	var animateHwnd = new attractAnimate();

	this.stopAttractAnimate = function () {
		animateHwnd.clear();
	}

	this.autoGetItem = function () {
		var canGetItems = {};
		if (!core.status.floorId || !core.status.checkBlock.damage || core.status.event.id == 'action' || core.status.lockControl) return;

		bfsFlood(core.getHeroLoc('x'), core.getHeroLoc('y'), function (blockMap, x, y) {
			var idx = x + ',' + y;
			if (idx in canGetItems) return false;
			var blk = blockMap[idx];
			if (blk && !blk.disable && blk.event.cls == 'items' && !core.isMapBlockDisabled(core.status.floorId, blk.x, blk.y) && blk.event.trigger == 'getItem') {
				canGetItems[idx] = { x: x, y: y, id: blk.event.id };
				return !core.status.checkBlock.damage[idx] && !core.status.checkBlock.ambush[idx];
			}
			return core.maps._canMoveDirectly_checkNextPoint(blockMap, x, y);
		});
		for (var k in canGetItems) {
			var x = canGetItems[k].x,
				y = canGetItems[k].y,
				id = canGetItems[k].id;
			core.trigger(x, y);
			animateHwnd.add(id, x * 32, y * 32);
		}
		animateHwnd.start();
	}
},
    "造塔显伤": function () {
	/////// 用户设置 ///////
	// 将__enable置为true将开启插件
	var __enable = false;
	// 魔防攻速之类的属性可以在这里加 ['atk', 'def', 'mdef']
	var heroStatus = ['atk', 'def', 'mdef', 'hp'];
	// saveHero为true 将会把每次造塔测试时的角色数据存下来 否则会读取初始属性
	// 用不着可以关了 节约缓存空间 (虽然根本没多少 还没一个存档大
	// 也可以手动清理 控制台输入core.removeLocalStorage('editorHero')即可
	var saveHero = true;
	// 下面那些parseInt疑似会在超过九千万亿后失效，必要时请改为parseFloat
	// 下为具体实现 懒得写注释了 大概就是写HTML然后注册交互
	if (!__enable || main.mode != 'editor') return;
	core.plugin.initEditorDamage = false;
	if (heroStatus.length >= 4 && !editor.isMobile) editor.dom.mid2.style.top = 650 + 30 * (heroStatus.length - 3) + 'px';
	editor.statusRatio = core.getLocalStorage('statusRatio', 1);
	editor.saveHero = saveHero;
	editor._heroStatus = heroStatus;
	editor.dom.mapEdit.appendChild(core.canvas.damage.canvas)
	var HTML = "<input type='button' value='←'/><input type='button' value='↑'/><input type='button' value='↓'/><input type='button' value='→'/><input type='button' id='bigmapBtn' value='大地图'' style='margin-left: '5px'/>";

	//if (heroStatus.length >= 4 && !editor.isMobile) editor.dom.mid2.style.top = 650 + 30 * (heroStatus.length - 3) + 'px';
	heroStatus.forEach(function (status) {
		var id = status + 'set',
			id2 = status + 'add',
			id3 = status + 'rec',
			id4 = status + 'help';
		HTML += "<br/><input type='text' size='15' id='" + id + "'><input type='button' id='" + id2 + "' value = '+'><input type='button' id='" + id3 + "' value = '-'><input type='button' value='?' id = '" + id4 + "'>"
	});
	document.getElementById('viewportButtons').innerHTML = HTML;
	['set', 'add', 'rec', 'help'].forEach(function (e) {
		heroStatus.forEach(function (status) {
			editor.dom[status + e] = document.getElementById(status + e);
		});
	});
	var _hasItem = core.items.hasItem;
	core.items.hasItem = function (itemId) {
		if (itemId == 'book' && main.mode == 'editor') return true;
		return _hasItem.call(core.items, itemId);
	}
	core.control.updateDamage = function (floorId, ctx) {
		floorId = floorId || core.status.floorId;
		if (!floorId || core.status.gameOver) return;
		var onMap = ctx == null;
		if (main.mode == 'editor') {
			ctx = core.canvas.damage;
			core.updateCheckBlock();
		}

		// 没有怪物手册
		if (!core.hasItem('book')) return;
		core.status.damage.posX = core.bigmap.posX;
		core.status.damage.posY = core.bigmap.posY;
		if (!onMap) {
			var width = core.floors[floorId].width,
				height = core.floors[floorId].height;
			// 地图过大的缩略图不绘制显伤
			if (width * height > core.bigmap.threshold) return;
		}
		this._updateDamage_damage(floorId, onMap);
		this._updateDamage_extraDamage(floorId, onMap);
		this.drawDamage(ctx);
	}
	core.control._updateDamage_damage = function (floorId, onMap) {
		core.status.damage.data = [];
		if (!core.flags.displayEnemyDamage && !core.flags.displayExtraDamage) return;

		core.extractBlocks(floorId);
		core.status.maps[floorId].blocks.forEach(function (block) {
			var x = block.x,
				y = block.y;

			// v2优化，只绘制范围内的部分
			if (onMap && core.bigmap.v2) {
				if (x < core.bigmap.posX - core.bigmap.extend || x > core.bigmap.posX + core.__SIZE__ + core.bigmap.extend ||
					y < core.bigmap.posY - core.bigmap.extend || y > core.bigmap.posY + core.__SIZE__ + core.bigmap.extend) {
					return;
				}
			}

			if (!block.disable && block.event.cls.indexOf('enemy') == 0 && block.event.displayDamage !== false) {
				if (core.flags.displayEnemyDamage) {
					var damageString = core.enemys.getDamageString(main.mode == 'editor' ? core.enemys.enemys[block.event.id] : block.event.id, x, y, floorId);
					core.status.damage.data.push({
						fromLoc: [x, y],
						text: damageString.damage,
						px: 32 * x + 1,
						py: 32 * (y + 1) - 1,
						color: damageString.color
					});
				}
				if (core.flags.displayCritical) {
					var critical = core.enemys.nextCriticals(main.mode == 'editor' ? core.enemys.enemys[block.event.id] : block.event.id, 1, x, y, floorId);
					critical = core.formatBigNumber((critical[0] || [])[0], true);
					if (critical == '???') critical = '?';
					core.status.damage.data.push({
						fromLoc: [x, y],
						text: critical,
						px: 32 * x + 1,
						py: 32 * (y + 1) - 11,
						color: '#FFFFFF'
					});
				}
			}
		});
	}
	////// 重绘地图显伤 //////
	core.control.drawDamage = function (ctx) {
		if (core.status.gameOver || !core.status.damage) return;
		var onMap = false;
		if (ctx == null) {
			ctx = core.canvas.damage;
			core.clearMap('damage');
			onMap = true;
		}

		if (onMap && core.bigmap.v2) {
			// 检查是否需要重算...
			if (Math.abs(core.bigmap.posX - core.status.damage.posX) >= core.bigmap.extend - 1 ||
				Math.abs(core.bigmap.posY - core.status.damage.posY) >= core.bigmap.extend - 1) {
				return this.updateDamage();
			}
		}
		return this._drawDamage_draw(ctx, onMap);
	}
	core.control._drawDamage_draw = function (ctx, onMap) {
		if (!core.hasItem('book')) return;
		// 双缓冲
		var cacheCtx = core.bigmap.cacheCanvas;
		cacheCtx.canvas.width = ctx.canvas.width;
		cacheCtx.canvas.height = ctx.canvas.height;
		cacheCtx.clearRect(0, 0, cacheCtx.canvas.width, cacheCtx.canvas.height);
		if (onMap && core.bigmap.v2) cacheCtx.translate(32, 32);

		core.setFont(cacheCtx, "bold 11px Consolas");
		core.setTextAlign(cacheCtx, 'left');
		core.status.damage.data.forEach(function (one) {
			var px = one.px,
				py = one.py;
			if (onMap && core.bigmap.v2) {
				px -= core.bigmap.posX * 32;
				py -= core.bigmap.posY * 32;
				if (px < -32 * 2 || px > core.__PIXELS__ + 32 || py < -32 || py > core.__PIXELS__ + 32)
					return;
			}
			core.fillBoldText(cacheCtx, one.text, px, py, one.color);
		});

		core.setTextAlign(cacheCtx, 'center');
		core.status.damage.extraData.forEach(function (one) {
			var px = one.px,
				py = one.py;
			if (onMap && core.bigmap.v2) {
				px -= core.bigmap.posX * 32;
				py -= core.bigmap.posY * 32;
				if (px < -32 || px > core.__PIXELS__ + 32 || py < -32 || py > core.__PIXELS__ + 32)
					return;
			}
			core.fillBoldText(cacheCtx, one.text, px, py, one.color);
		});
		cacheCtx.translate(0, 0);

		if (main.mode == 'editor') {
			core.clearMap(ctx);
			if (editor.uivalues.bigmap) return;
		}
		core.drawImage(ctx, cacheCtx.canvas, onMap && core.bigmap.v2 ? -32 : 0, onMap && core.bigmap.v2 ? -32 : 0);
	}
	////// 以x,y的形式返回每个点的事件 //////
	core.maps.getMapBlocksObj = function (floorId, noCache) {
		floorId = floorId || core.status.floorId;
		if (core.status.mapBlockObjs[floorId] && !noCache && main.mode != 'editor')
			return core.status.mapBlockObjs[floorId];

		var obj = {};
		core.extractBlocks(floorId);
		core.status.maps[floorId].blocks.forEach(function (block) {
			obj[block.x + "," + block.y] = block;
		});
		return core.status.mapBlockObjs[floorId] = obj;
	}

	this.bignum = function (num, defaultValue) {
		if (num == null || num == "") return defaultValue;
		num = num + "";
		var list = {
			'w': 1e4,
			'e': 1e8,
			'z': 1e12,
			'j': 1e16,
			'g': 1e20
		};
		// 浮点数问题
		function checkFloat(num) {
			if (parseInt(num) != parseInt(num)) return 0;
			num = num + "";
			var index = num.indexOf(".");
			if (index < 0) return 0;
			else return num.slice(index + 1).length;
		}
		var index = num.search(/w|e|z|j|g/);
		if (index <= 0) {
			num = parseInt(num);
			if (num != num) return num;
			else {
				alert('不正确的输入');
				return defaultValue;
			}
		}
		for (; index > 0; index = num.search(/w|e|z|j|g/)) {
			var p = num[index],
				q = list[p],
				n = num.slice(0, index),
				m = Math.pow(10, checkFloat(n));
			num = n * m * q / m + num.slice(index + 1);
		}
		return parseInt(num);
	}

	this.updateEditorDamage = function (noSave) {
		core.updateDamage();
		heroStatus.forEach(function (status) {
			editor.dom[status + 'set'].value = core.status.hero[status];
		});
		if (!noSave && editor.saveHero) core.setLocalStorage('editorHero', core.status.hero);
	}
	////// 更新视野范围 //////
	core.control.updateViewport = function () {
		// 当前是否应该重绘？
		if (core.bigmap.v2) {
			if (core.bigmap.offsetX >= core.bigmap.posX * 32 + 32 ||
				core.bigmap.offsetX <= core.bigmap.posX * 32 - 32 ||
				core.bigmap.offsetY >= core.bigmap.posY * 32 + 32 ||
				core.bigmap.offsetY <= core.bigmap.posY * 32 - 32) {
				core.bigmap.posX = parseInt(core.bigmap.offsetX / 32);
				core.bigmap.posY = parseInt(core.bigmap.offsetY / 32);
				core.redrawMap();
			}
		} else {
			core.bigmap.posX = core.bigmap.posY = 0;
		}
		var offsetX = core.bigmap.v2 ? -(core.bigmap.offsetX - 32 * core.bigmap.posX) - 32 : -core.bigmap.offsetX;
		var offsetY = core.bigmap.v2 ? -(core.bigmap.offsetY - 32 * core.bigmap.posY) - 32 : -core.bigmap.offsetY;

		core.bigmap.canvas.forEach(function (cn) {
			core.control.setGameCanvasTranslate(cn, offsetX, offsetY);
		});
		// ------ 路线
		core.relocateCanvas('route', core.status.automaticRoute.offsetX - core.bigmap.offsetX, core.status.automaticRoute.offsetY - core.bigmap.offsetY);
	}

	var _resizeMap = core.maps.resizeMap;
	core.maps.resizeMap = function (floorId) {
		_resizeMap.call(core.maps, floorId);
		if (!core.plugin.initEditorDamage && main.mode == 'editor') {
			core.plugin.initEditorDamage = true;
			var editorHero = core.getLocalStorage('editorHero');
			if (editorHero && saveHero) core.status.hero = editorHero;
			else core.removeLocalStorage('editorHero');
			editor._heroStatus.forEach(function (e) {
				editor.dom[e + 'set'].onchange = function () {
					var status = this.id.slice(0, -3);
					core.status.hero[status] = core.bignum(this.value, core.status.hero[status]);
					core.updateEditorDamage();
				}
				editor.dom[e + 'add'].onclick = function () {
					var status = this.id.slice(0, -3);
					core.status.hero[status] += editor.statusRatio;
					core.updateEditorDamage();
				}
				editor.dom[e + 'rec'].onclick = function () {
					var status = this.id.slice(0, -3);
					core.status.hero[status] -= editor.statusRatio;
					core.updateEditorDamage();
				}
				editor.dom[e + 'help'].onclick = function () {
					var status = this.id.slice(0, -4),
						name = core.getStatusLabel(status);
					var ratio = parseInt(prompt("当前属性：" + name + "\n现在的点击按钮变化值：" + editor.statusRatio + ",请输入按下一次+/-按钮的属性变化量,可以写4w 10.2e这种字母缩写"));
					if (!core.isset(ratio)) {
						printe('不合法的输入');
						return;
					}
					editor.statusRatio = ratio;
					core.setLocalStorage('statusRatio', ratio);
				}
			});
			var _updateMap = editor.updateMap;
			editor.updateMap = function () {
				_updateMap.call(editor);
				core.updateEditorDamage(true);
			}
			editor.mode.onmode = function (mode, callback) {
				if (editor_mode.mode != mode) {
					if (mode === 'save') {
						editor_mode.doActionList(editor_mode.mode, editor_mode.actionList, function () {
							if (callback) callback();
							core.updateEditorDamage();
						});
					}
					if (editor_mode.mode === 'nextChange' && mode) editor_mode.showMode(mode);
					if (mode !== 'save') editor_mode.mode = mode;
					editor_mode.actionList = [];
				}
			}
		}
	}
},
    "天赋系统": function () {
	var enable = false; // 改为true来启用此插件
	if (!enable) return;
	// 本插件由道具商店改编而来
	// 可在全塔属性-全局商店中使用「道具商店」事件块进行编辑（如果找不到可以在入口方块中找）
	// 也可以使用core.openItemShop()来调用
	var selectItem = 0; // 用于区分天赋的变量
	// 此处定义一个用于显示所有天赋的数组，将你自己的内容写在里面，下面只给出样例
	var tf = [{
			// name表示该天赋的名称
			name: "力量强化",
			// max表示该天赋的最大等级
			max: 10,
			// tnow表示当前等级的天赋效果描述(此处变量为当前的天赋等级加上暂存的技能等级，根据需要自行修改)
			tnow: "角色基础物理攻击提升 ${flag:llqh + flag:zac[0]} %",
			// tnext表示下一等级的天赋效果描述
			tnext: "角色基础物理攻击提升 ${flag:llqh + flag:zac[0] + 1} %",
			// need表示该天赋的要求(比如前置天赋，等级要求等，可使用自己的逻辑方法定义)
			need: [6, 0],
			// dsp表示该天赋的说明
			dsp: "有了攻击，你就有了整个世界！"
			// 可在此处继续定义你需要的一些其他东西，注意格式
			// ……
		},
		// 在此处继续定义下一个天赋的有关内容({},{},……,{})
		{}
	];
	// 此处定义两个常用的字号，也可以不定义直接写
	var bigFont = core.ui._buildFont(20, false),
		middleFont = core.ui._buildFont(18, false);
	// 此处为ui绘制部分
	this.drawItemShop = function () {
		core.ui._createUIEvent();
		core.clearMap('uievent');
		core.ui._uievent_drawSelector({ "code": 2 });
		core.setTextAlign('uievent', 'left');
		core.setTextBaseline('uievent', 'top');
		core.strokeRect("uievent", 0, 64, 320, 352, 'white', 3);
		core.drawLine("uievent", 320, 0, 320, 480, 'white', 3);
		core.setFillStyle('uievent', 'white');
		core.setStrokeStyle('uievent', 'white');
		core.setTextAlign('uievent', 'center');
		// 标题名字，根据需要自行修改
		core.fillText("uievent", "天赋系统 3.0", 160, 22, null, bigFont);
		core.setTextAlign('uievent', 'left');
		// 剩余点数显示以及操作按钮
		core.fillText("uievent", "剩余天赋点：" + core.getFlag('tfd', 0), 10, 438, null, bigFont);
		core.fillText("uievent", "【确认】", 160, 438, null, bigFont);
		core.fillText("uievent", "【离开】", 240, 438, null, bigFont);
		// 绘制天赋图标的位置，注意每个变量的含义
		core.drawArrow("uievent", 36, 80, 36, 400, 'red', 2);
		core.drawImage("uievent", '请在此处插入你自己的图标文件名', 20, 80, 32, 32);
		// 此处绘制右侧天赋说明
		if (selectItem === 0) { // 此处的selectItem获取你当前的光标位置，用于判断显示哪个天赋
			core.drawImage("uievent", '请在此处插入你自己的图标文件名', 340, 20, 32, 32);
			core.strokeRect("uievent", 17, 77, 38, 38, 'yellow', 3);
			core.setTextAlign('uievent', 'center');
			// 下面这句显示的效果为(当前天赋等级，最大天赋等级)[暂存天赋等级]
			core.fillText("uievent", '[' + core.getFlag('llqh', 0) + '/10]' + '(' + flags.zac[0] + ')', 400, 80, null, 'bold 16px Consolas');
			// 这句用于判定当前加暂存不超过最大等级
			if (core.getFlag('llqh', 0) + flags.zac[0] < 10) {
				// 这里显示对应天赋的信息
				core.setTextAlign('uievent', 'left');
				core.fillText("uievent", core.replaceText(tf[selectItem].name), 388, 25, 'white', 'bold 18px Consolas');
				core.fillText("uievent", '<', 330, 80, 'white', 'bold 18px Consolas');
				core.fillText("uievent", '>', 455, 80, 'white', 'bold 18px Consolas');
				core.fillText("uievent", '当前效果：', 340, 110, 'white', 'bold 16px Consolas');
				core.drawTextContent("uievent", core.replaceText(tf[selectItem].tnow), {
					left: 340,
					top: 140,
					maxWidth: 125,
					color: 'lightgreen',
					align: 'left',
					fontSize: 12,
					lineHeight: 20,
					bold: true,
					font: 'Consolas'
				});
				core.fillText("uievent", '下一级效果：', 340, 230, 'white', 'bold 16px Consolas');
				core.fillText("uievent", '下一级要求：', 340, 350, 'white', 'bold 16px Consolas');
				// 天赋描述
				core.drawTextContent("uievent", core.replaceText(tf[selectItem].dsp), {
					left: 340,
					top: 430,
					maxWidth: 125,
					color: 'yellow',
					align: 'left',
					fontSize: 12,
					lineHeight: 20,
					bold: true,
					font: 'Consolas'
				});
				core.drawTextContent("uievent", core.replaceText(tf[0].tnext), {
					left: 340,
					top: 260,
					maxWidth: 125,
					color: 'lightgreen',
					align: 'left',
					fontSize: 12,
					lineHeight: 20,
					bold: true,
					font: 'Consolas'
				});
				core.setTextAlign('uievent', 'left');
				core.fillText("uievent", '等级达到：' + flags.xzs[core.getFlag('llqh', 0) + flags.zac[0]], 340, 380, 'red', 'bold 12px Consolas');
				core.fillText("uievent", '智力强化为 0 级', 340, 400, 'red', 'bold 12px Consolas');
			} else {
				core.fillText("uievent", '已满级', 340, 260, 'red', 'bold 12px Consolas');
				core.fillText("uievent", '已满级', 340, 380, 'red', 'bold 12px Consolas');
			}
		}
		// 在此处可继续添加其他天赋的显示信息
		// ……
	}
	// 鼠标点击操作(主要是控制px和py的范围制定一个点击生效的矩形区域)
	this._performItemShopClick = function (px, py) {
		var item = list[selectItem] || null;

		if (px >= 240 && px <= 300 && py >= 426 && py <= 470) // 离开
			return core.insertAction({ "type": "break" });

		// <,减少点数(从暂存点数中扣除1点，不影响已分配的点数，此处的加减点数都是在暂存点数中进行操作)
		if (px >= 330 && px <= 350 && py >= 80 && py <= 100) {
			if (flags.zac[selectItem] > 0) {
				flags.zac[selectItem] -= 1;
				core.addFlag('tfd', 1);
			}
		}
		// >,增加点数(符合每个天赋的加点条件后，使其暂存区点数+1，样例如下)
		if (px >= 455 && px <= 475 && py >= 80 && py <= 100) {
			if (selectItem === 0) {
				if (core.getFlag('llqh', 0) + flags.zac[0] < 10 &&
					core.getFlag('tfd', 0) > 0 &&
					core.status.hero.lv >= flags.xzs[core.getFlag('llqh', 0) + flags.zac[0]] &&
					core.getFlag('zlqh', 0) === 0) {
					flags.zac[0] += 1;
					core.addFlag('tfd', -1);
				}
			}
			// 在此处添加其他天赋的条件判定
			// ……
		}
		// 确定(即将暂存区的点数加到当前点数中，暂存区清空)
		if (px >= 160 && px <= 220 && py >= 426 && py <= 470) {
			core.addFlag('llqh', flags.zac[0]);

			for (var i = 0; i <= 1; i += 1) {
				flags.zac[i] = 0;
			}
		}
		// 实际区域(点击对应天赋的图标，获取该天赋的序号，即获取selectItem)
		if (px >= 20 && px <= 52 && py >= 80 && py < 112) {
			selectItem = 0;
		}
		// 在此处添加其他天赋
		// ……
	}
	this.performItemShopAction = function () {
		if (flags.type == 1) {
			return this._performItemShopClick(flags.px, flags.py);
		}
	}
	this.openItemShop = function (itemShopId) {
		selectItem = 0;
		core.createCanvas("uieventbg", 0, 0, 480, 480, 130);
		core.insertAction([{
				"type": "while",
				"condition": "true",
				"data": [
					{ "type": "function", "function": "function () { core.drawItemShop(); }" },
					{ "type": "wait" },
					{ "type": "function", "function": "function() { core.performItemShopAction(); }" }
				]
			},
			{
				"type": "function",
				"function": "function () { " +
					"core.deleteCanvas('uievent'); core.deleteCanvas('uieventbg');" +
					"core.ui._uievent_drawSelector({ \"code\": 1 }); " +
					"core.ui._uievent_drawSelector({ \"code\": 2 }); " +
					"}"
			}
		]);
	}
	// 此处为动态背景的制作方法
	var uieventbgOffsetx = 0;
	var uieventbgOffsety = 0;
	this.drawItemShopBg = function () {
		core.clearMap('uieventbg');
		core.drawImage("uieventbg", '请在此输入你的背景图文件名', uieventbgOffsetx - 480, uieventbgOffsety);
		core.drawImage("uieventbg", '请在此输入你的背景图文件名', uieventbgOffsetx, uieventbgOffsety);
		core.drawImage("uieventbg", '请在此输入你的背景图文件名', uieventbgOffsetx, uieventbgOffsety - 480);
		core.drawImage("uieventbg", '请在此输入你的背景图文件名', uieventbgOffsetx - 480, uieventbgOffsety - 480);
	}
	core.registerAnimationFrame("uieventbg", true, function () {
		if (!core.dymCanvas.uieventbg) return;
		core.drawItemShopBg();
		// 在这里修改横向与纵向的移动速度
		uieventbgOffsetx += 4;
		uieventbgOffsety += 4;
		if (uieventbgOffsetx >= 480) uieventbgOffsetx -= 480;
		if (uieventbgOffsety >= 480) uieventbgOffsety -= 480;
	})
},
    "DRAW": function () {
	this.shuffle = function (v) {
		for (var j, x, i = v.length; i; j = parseInt(core.rand(i)), x = v[--i], v[i] = v[j], v[j] = x);
		return v;
	}
	this.DRAW = function () {
		if (flags.mode == 2 && core.status.hero.mdef >= 180000) core.insertAction([{ "type": "win", "reason": "3-min", "norank": true }, { "type": "wait", "time": 200 }, { "type": "restart" }]);
		if (flags.b){
		flags.b[-1] = [];
		flags.b[-2] = [];
		flags.b[-3] = [];
		flags.b[-4] = [];
		flags.b[-5] = [];
		flags.b[10] = [];
		flags.b[11] = [];
		flags.b[12] = [];
		flags.b[13] = [];
		flags.b[14] = [];
		}
		if(!flags.k)flags.k=0;
		if(!flags.Z)flags.Z=0;
		if(!flags.X)flags.X=0;
		if(!flags.Y)flags.Y=0;
		for (var i = 0; i < 10; i++)
			for (var j = 2; j < 22; j++)
				core.setBlock(flags.b[i][j], i + 5, j - 2);
		if (flags.next.length < 7) {
			var _ = [1, 2, 3, 4, 5, 6, 7];
			_ = core.shuffle(_);
			for (var i = 0; i < 7; i++) flags.next.push(_[i]);
		}
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					flags.b[k + flags.X][j + flags.Y] = 0;
				}
		var y = flags.Y,
			t = 1;
		while (t) {
			y += 1;
			if (y > 30) break;
			for (var j = 0; j < 4; j++)
				for (var k = 0; k < 4; k++)
					if (main.t[flags.k][flags.Z][j][k]) {
						if (flags.b[k + flags.X][j + y] != 0) t = 0;
					}
		}
		y -= 1;
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					flags.b[k + flags.X][j + flags.Y] = main.t[flags.k][flags.Z][j][k];
				}
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					if (flags.b[k + flags.X][j + y] == 0) core.setBlock(flags.k + 10, k + flags.X + 5, j + y - 2);
				}
		for (var i = 0; i <= 4; i++) {
			for (var j = 0; j < 2; j++)
				for (var k = 0; k < 4; k++) core.setBlock(main.t[flags.next[i]][0][j][k], k + 16, 3 * i + j + 1);
		}
		if (flags.hold)
			for (var j = 0; j < 2; j++)
				for (var k = 0; k < 4; k++) core.setBlock(main.t[flags.hold][0][j][k], k, j + 2);
	}
	this.craft = function (hold) {
		if (hold && flags.holded) return;
		flags.holded = hold;
		if (hold)
			for (var j = 0; j < 4; j++)
				for (var k = 0; k < 4; k++)
					if (main.t[flags.k][flags.Z][j][k]) {
						flags.b[k + flags.X][j + flags.Y] = 0;
					}
		flags.X = 3;
		flags.Y = 1;
		flags.Z = 0;
		var t = 0;
		if (hold) {
			if (flags.hold) {
				t = flags.hold;
				flags.hold = flags.k;
				flags.k = t;
			} else {
				flags.hold = flags.k;
				flags.k = flags.next.splice(0, 1)[0];
			}

		} else { flags.k = flags.next.splice(0, 1)[0]; }
		t = 0;
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					if (flags.b[k + flags.X][j + flags.Y] != 0) t = 1;
					flags.b[k + flags.X][j + flags.Y] = main.t[flags.k][flags.Z][j][k];
				}
		if (flags.mode == 3) core.down_();
		core.DRAW();
		if (t)
			if (flags.mode == 1) core.insertAction([{ "type": "lose", "reason": "" }, { "type": "wait", "time": 200 }, { "type": "restart" }]);
			else core.insertAction([{ "type": "win", "reason": ['common','40-Line','3-min','20G'][flags.mode], "norank": true }, { "type": "wait", "time": 200 }, { "type": "restart" }]);

	}
	this.line = function () {
		if (!flags.ren) flags.ren = 0;
		var clear = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
		var tspin = flags.k == 3;
		var mini = false;
		var xiao = 0;
		var perfect = true;
		for (var i = 0; i < 22; i++)
			for (var j = 0; j < 10; j++) clear[i] += flags.b[j][i] == 0 ? 0 : 1;
		for (var i = 0; i < 22; i++)
			if (clear[i] == 10) xiao += 1, clear[i] = 1;
			else if (clear[i] > 0) perfect = false, clear[i] = 0;
		else clear[i] = 0;
		var cnt = 0;
		if (flags.b[flags.X][flags.Y] == 0) cnt += 1;
		if (flags.b[flags.X][flags.Y + 2] == 0) cnt += 1;
		if (flags.b[flags.X + 2][flags.Y] == 0) cnt += 1;
		if (flags.b[flags.X + 2][flags.Y + 2] == 0) cnt += 1;
		if (cnt >= 2) tspin = false;
		if (flags.b[flags.X][flags.Y + 1] == 0 || flags.b[flags.X + 2][flags.Y + 1] == 0 || flags.b[flags.X + 1][flags.Y] == 0 || flags.b[flags.X + 1][flags.Y + 2] == 0) mini = true;
		if (flags.Z == 0 && (flags.b[flags.X][flags.Y] == 0 || flags.b[flags.X + 2][flags.Y] == 0)) mini = true;
		if (flags.Z == 1 && (flags.b[flags.X + 2][flags.Y] == 0 || flags.b[flags.X + 2][flags.Y + 2] == 0)) mini = true;
		if (flags.Z == 2 && (flags.b[flags.X + 2][flags.Y + 2] == 0 || flags.b[flags.X][flags.Y + 2] == 0)) mini = true;
		if (flags.Z == 3 && (flags.b[flags.X][flags.Y + 2] == 0 || flags.b[flags.X][flags.Y] == 0)) mini = true;
		var score = 0;
		var str = "";
		if (xiao == 1) str = "Single";
		if (xiao == 2) str = "Double";
		if (xiao == 3) str = "Triple";
		if (xiao == 4) str = "Tetris";
		if (tspin) str = "T-spin " + str;
		if (tspin && mini) str = str + " Mini";
		if (flags.b2b && (xiao >= 4 || xiao >= 2 && tspin || xiao >= 1 && tspin && !mini)) str = "Back-to-back" + str;
		if (tspin) {
			if (mini) {
				score += [100, 200, 1200, 1600][xiao];
				if (flags.b2b) score += [0, 0, 600, 800][xiao];
				if (xiao >= 1) flags.b2b = true;
			} else {
				score += [400, 800, 1200, 1600][xiao];
				if (flags.b2b) score += [0, 400, 600, 800][xiao];
				if (xiao >= 1) flags.b2b = true;
			}
		} else {
			score += [0, 100, 300, 500, 800][xiao];
			if (flags.b2b) score += [0, 0, 0, 0, 400][xiao];
			if (xiao >= 4) flags.b2b = true;
			else if (xiao >= 1) flags.b2b = false;
		}
		if (score > 0) flags.ren += 1;
		else flags.ren = 0;
		if (score) core.drawTip("出现" + str + ",得分+" + score + (flags.ren > 1 ? ";" + flags.ren + "连击,奖励" + (flags.ren * 50 - 50) + "分" : "") + (perfect ? ";完美消除,奖励2221分" : ""));
		core.status.hero.hp += score + (flags.ren > 1 ? 50 * flags.ren - 50 : 0) + (perfect ? 2221 : 0);
		core.status.hero.mana += xiao;
		if (flags.mode == 1 && core.status.hero.mana >= 40) core.status.hero.hp = 1000000 - core.status.hero.mdef, core.insertAction([{ "type": "win", "reason": "40-Line", "norank": true }, { "type": "wait", "time": 200 }, { "type": "restart" }]);
		core.drawStatusBar();
		if (score >= 2400) core.status.hero.lv = 3;
		else if (score >= 1600 && core.status.hero.lv < 2) core.status.hero.lv = 2;
		for (var i = 21; i >= 0; i--)
			if (clear[i])
				for (var j = 0; j < 10; j++) flags.b[j].splice(i, 1);
		for (var j = 0; j < 10; j++)
			while (flags.b[j].length < 22) flags.b[j].splice(0, 0, 0);
		flags.k = 0;
		core.DRAW();
	}
	this.down = function (hard) {
		t = 0;
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					flags.b[k + flags.X][j + flags.Y] = 0;
				}
		flags.Y = flags.Y + 1;
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					if (flags.b[k + flags.X][j + flags.Y] != 0) t = 1;
				}
		if (t == 1) flags.Y = flags.Y - 1;
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					flags.b[k + flags.X][j + flags.Y] = main.t[flags.k][flags.Z][j][k];
				}
		if (!t) core.setValue('status:hp', '+=', hard ? 2 : 1);
		if (t) core.line(), core.craft();
		else if (!hard) core.DRAW();
		else core.down(hard);
	}
	this.down_ = function () {
		t = 0;
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					flags.b[k + flags.X][j + flags.Y] = 0;
				}
		flags.Y = flags.Y + 1;
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					if (flags.b[k + flags.X][j + flags.Y] != 0) t = 1;
				}
		if (t == 1) flags.Y = flags.Y - 1;
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					flags.b[k + flags.X][j + flags.Y] = main.t[flags.k][flags.Z][j][k];
				}
		if (t) core.DRAW();
		else core.down_();
	}
	this.left = function () {
		t = 0;
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					flags.b[k + flags.X][j + flags.Y] = 0;
				}
		flags.X = flags.X - 1;
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					if (flags.b[k + flags.X][j + flags.Y] != 0) t = 1;
				}
		if (t == 1) flags.X = flags.X + 1, core.drawTip('移动失败。', flags.k);
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					flags.b[k + flags.X][j + flags.Y] = main.t[flags.k][flags.Z][j][k];
				}
		if (flags.mode == 3) core.down_();
		core.DRAW();
	}
	this.right = function () {
		t = 0;
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					flags.b[k + flags.X][j + flags.Y] = 0;
				}
		flags.X = flags.X + 1;
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					if (flags.b[k + flags.X][j + flags.Y] != 0) t = 1;
				}
		if (t == 1) flags.X = flags.X - 1, core.drawTip('移动失败。', flags.k);
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					flags.b[k + flags.X][j + flags.Y] = main.t[flags.k][flags.Z][j][k];
				}
		if (flags.mode == 3) core.down_();
		core.DRAW();
	}
	this.rotate = function (ni) {
		if (flags.k == 2) { core.drawTip('旋转失败。', flags.k); return; }
		tiqiang = [
			[{ x: 0, y: 0 }, { x: -1, y: 0 }, { x: -1, y: -1 }, { x: 0, y: +2 }, { x: -1, y: +2 }],
			[{ x: 0, y: 0 }, { x: +1, y: 0 }, { x: +1, y: +1 }, { x: 0, y: -2 }, { x: +1, y: -2 }],
			[{ x: 0, y: 0 }, { x: +1, y: 0 }, { x: +1, y: -1 }, { x: 0, y: +2 }, { x: +1, y: +2 }],
			[{ x: 0, y: 0 }, { x: -1, y: 0 }, { x: -1, y: +1 }, { x: 0, y: -2 }, { x: -1, y: -2 }],
			[{ x: 0, y: 0 }, { x: +1, y: 0 }, { x: +1, y: -1 }, { x: 0, y: +2 }, { x: +1, y: +2 }],
			[{ x: 0, y: 0 }, { x: +1, y: 0 }, { x: +1, y: +1 }, { x: 0, y: -2 }, { x: +1, y: -2 }],
			[{ x: 0, y: 0 }, { x: -1, y: 0 }, { x: -1, y: -1 }, { x: 0, y: +2 }, { x: -1, y: +2 }],
			[{ x: 0, y: 0 }, { x: -1, y: 0 }, { x: -1, y: +1 }, { x: 0, y: -2 }, { x: -1, y: -2 }]
		];
		if (flags.k == 1) tiqiang = [
			[{ x: 0, y: 0 }, { x: -2, y: 0 }, { x: +1, y: 0 }, { x: -2, y: +1 }, { x: +1, y: -2 }],
			[{ x: 0, y: 0 }, { x: -1, y: 0 }, { x: +2, y: 0 }, { x: -1, y: -2 }, { x: +2, y: +1 }],
			[{ x: 0, y: 0 }, { x: +2, y: 0 }, { x: -1, y: 0 }, { x: +2, y: -1 }, { x: -1, y: +2 }],
			[{ x: 0, y: 0 }, { x: +1, y: 0 }, { x: -2, y: 0 }, { x: +1, y: +2 }, { x: -2, y: -1 }],
			[{ x: 0, y: 0 }, { x: -1, y: 0 }, { x: +2, y: 0 }, { x: -1, y: -2 }, { x: +2, y: +1 }],
			[{ x: 0, y: 0 }, { x: +2, y: 0 }, { x: -1, y: 0 }, { x: +2, y: -1 }, { x: -1, y: +2 }],
			[{ x: 0, y: 0 }, { x: +1, y: 0 }, { x: -2, y: 0 }, { x: +1, y: +2 }, { x: -2, y: -1 }],
			[{ x: 0, y: 0 }, { x: -2, y: 0 }, { x: +1, y: 0 }, { x: -2, y: +1 }, { x: +1, y: -2 }]
		]
		var x = flags.X,
			y = flags.Y,
			z = flags.Z;
		tiqiang = tiqiang[z + (ni ? 4 : 0)];
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					flags.b[k + flags.X][j + flags.Y] = 0;
				}
		if (ni) flags.Z += 3;
		else flags.Z += 1;
		if (flags.Z > 3) flags.Z -= 4;
		var able = false;
		for (var i = 0; i < 5; i++) {
			able = true;
			flags.X += tiqiang[i].x, flags.Y += tiqiang[i].y;
			for (var j = 0; j < 4; j++)
				for (var k = 0; k < 4; k++)
					if (main.t[flags.k][flags.Z][j][k]) {
						if (flags.b[k + flags.X][j + flags.Y] != 0) able = false;
					}
			if (able) break;
			else flags.X -= tiqiang[i].x, flags.Y -= tiqiang[i].y;
		}
		if (!able) flags.X = x, flags.Y = y, flags.Z = z, core.drawTip('旋转失败。', flags.k);
		for (var j = 0; j < 4; j++)
			for (var k = 0; k < 4; k++)
				if (main.t[flags.k][flags.Z][j][k]) {
					flags.b[k + flags.X][j + flags.Y] = main.t[flags.k][flags.Z][j][k];
				}
		if (flags.mode == 3) core.down_();
		core.DRAW();
	}
}
}