import { Animation as Animation_2 } from 'mutate-animate';
import { ComponentInternalInstance } from 'vue';
import { ComponentOptionsMixin } from 'vue';
import { CreateAppFunction } from 'vue';
import { default as default_2 } from 'eventemitter3';
import { DefineComponent } from 'vue';
import { DefineSetupFnComponent } from 'vue';
import { ElementNamespace } from 'vue';
import { EventEmitter } from 'eventemitter3';
import { JSX } from 'vue/jsx-runtime';
import { mat3 } from 'gl-matrix';
import { mat4 } from 'gl-matrix';
import { ReservedProps } from 'vue';
import { RootRenderFunction } from 'vue';
import { Ticker } from 'mutate-animate';
import { TickerFn } from 'mutate-animate';
import { TimingFn } from 'mutate-animate';
import { Transition } from 'mutate-animate';
import { vec3 } from 'gl-matrix';
import { VNodeProps } from 'vue';

declare type _A<T> = [data: T];

export declare interface ActionEventMap {
    [ActionType.Click]: IActionEvent;
    [ActionType.Down]: IActionEvent;
    [ActionType.Enter]: IActionEvent;
    [ActionType.Leave]: IActionEvent;
    [ActionType.Move]: IActionEvent;
    [ActionType.Up]: IActionEvent;
    [ActionType.Wheel]: IWheelEvent;
}

export declare const enum ActionType {
    /** 点击事件，即按下与抬起都在该元素上时触发 */
    Click = 0,
    /** 鼠标或手指按下事件 */
    Down = 1,
    /** 鼠标或手指移动事件 */
    Move = 2,
    /** 鼠标或手指抬起事件 */
    Up = 3,
    /** 鼠标或手指移动入该元素时触发的事件 */
    Enter = 4,
    /** 鼠标或手指移出该元素时触发的事件 */
    Leave = 5,
    /** 鼠标在该元素上滚轮时触发的事件 */
    Wheel = 6
}

declare type AdapterFunction<T> = (item: T, ...params: any[]) => Promise<any>;

/**
 * 将两个缓动函数做加法
 */
export declare function addTiming(timing1: TimingFn, timing2: TimingFn): TimingFn;

declare type AnimationUsing = [Animation_2];

declare interface AttribSetFn {
    [AttribType.Attrib1f]: _U1;
    [AttribType.Attrib1fv]: _A<Float32List>;
    [AttribType.Attrib2f]: _U2;
    [AttribType.Attrib2fv]: _A<Float32List>;
    [AttribType.Attrib3f]: _U3;
    [AttribType.Attrib3fv]: _A<Float32List>;
    [AttribType.Attrib4f]: _U4;
    [AttribType.Attrib4fv]: _A<Float32List>;
    [AttribType.AttribI4i]: _U4;
    [AttribType.AttribI4iv]: _A<Int32List>;
    [AttribType.AttribI4ui]: _U4;
    [AttribType.AttribI4uiv]: _A<Uint32List>;
}

export declare const enum AttribType {
    Attrib1f = 0,
    Attrib1fv = 1,
    Attrib2f = 2,
    Attrib2fv = 3,
    Attrib3f = 4,
    Attrib3fv = 5,
    Attrib4f = 6,
    Attrib4fv = 7,
    AttribI4i = 8,
    AttribI4iv = 9,
    AttribI4ui = 10,
    AttribI4uiv = 11
}

export declare interface BaseProps {
    /** 元素的横坐标 */
    x?: number;
    /** 元素的纵坐标 */
    y?: number;
    /** 元素的横向锚点位置 */
    anchorX?: number;
    /** 元素的纵向锚点位置 */
    anchorY?: number;
    /** 元素的纵深，值越大越靠上 */
    zIndex?: number;
    /** 元素的宽度 */
    width?: number;
    /** 元素的高度 */
    height?: number;
    /** 元素的滤镜 */
    filter?: string;
    /** 是否启用高清画布 */
    hd?: boolean;
    /** 是否启用抗锯齿 */
    anti?: boolean;
    /** 是否不启用抗锯齿，优先级大于 anti，主要用于像素图片渲染 */
    noanti?: boolean;
    /** 元素是否隐藏，可以用于一些画面效果，也可以用于调试 */
    hidden?: boolean;
    /** 元素的变换矩阵 */
    transform?: Transform;
    /** 元素的定位模式，static 表示常规定位，absolute 定位模式下元素位置始终处于左上角 */
    type?: RenderItemPosition;
    /** 是否启用缓存，用处较少，主要用于一些默认不启用缓存的元素的特殊优化 */
    cache?: boolean;
    /** 是否不启用缓存，优先级大于 cache，用处较少，主要用于一些特殊优化 */
    nocache?: boolean;
    /** 是否启用变换矩阵下穿，下穿模式下，当前元素会使用由父元素传递过来的变换矩阵，而非元素自身的 */
    fall?: boolean;
    /** 这个元素的唯一标识符，不可重复 */
    id?: string;
    /** 这个元素的不透明度 */
    alpha?: number;
    /** 这个元素与已渲染内容的混合模式，默认为 source-over */
    composite?: GlobalCompositeOperation;
    /** 鼠标放在这个元素上时的光标样式 */
    cursor?: string;
    /**
     * 定位属性，可以填 `[横坐标，纵坐标，宽度，高度，x锚点，y锚点]`，
     * 对于横坐标与纵坐标、宽度与高度、x锚点与y锚点，两两一组要么都填，要么都不填
     * 是 x, y, width, height, anchorX, anchorY 的简写属性
     */
    loc?: ElementLocator;
    /** 锚点属性，可以填 `[x锚点，y锚点]`，是 anchorX, anchorY 的简写属性 */
    anc?: ElementAnchor;
    /** 放缩属性，可以填 `[x比例，y比例]`，是 transform 的简写属性之一 */
    scale?: ElementScale;
    /** 旋转属性，单位弧度，是 transform 的简写属性之一 */
    rotate?: number;
    /** 这个元素是否不会触发任何交互事件（cursor 属性也会无效），当执行到此元素时，会下穿至下一个元素 */
    noevent?: boolean;
}

export declare class BezierCurve extends GraphicItemBase {
    sx: number;
    sy: number;
    cp1x: number;
    cp1y: number;
    cp2x: number;
    cp2y: number;
    ex: number;
    ey: number;
    mode: GraphicMode;
    getPath(): Path2D;
    /**
     * 设置起始点坐标
     */
    setStart(x: number, y: number): void;
    /**
     * 设置控制点1坐标
     */
    setControl1(x: number, y: number): void;
    /**
     * 设置控制点2坐标
     */
    setControl2(x: number, y: number): void;
    /**
     * 设置终点坐标
     */
    setEnd(x: number, y: number): void;
    protected isActionInElement(x: number, y: number): boolean;
    private fitRect;
    protected handleProps(key: string, prevValue: any, nextValue: any): boolean;
}

export declare type BezierParams = [
sx: number,
sy: number,
cp1x: number,
cp1y: number,
cp2x: number,
cp2y: number,
ex: number,
ey: number
];

export declare interface BezierProps extends GraphicPropsBase {
    sx?: number;
    sy?: number;
    cp1x?: number;
    cp1y?: number;
    cp2x?: number;
    cp2y?: number;
    ex?: number;
    ey?: number;
    /** 三次贝塞尔曲线参数，可以填 `[sx, sy, cp1x, cp1y, cp2x, cp2y, ex, ey]`，都是必填 */
    curve?: BezierParams;
}

declare type CanvasStyle_2 = string | CanvasGradient | CanvasPattern;
export { CanvasStyle_2 as CanvasStyle }

declare type CanvasStyle_3 = string | CanvasGradient | CanvasPattern;

export declare class Circle extends GraphicItemBase {
    radius: number;
    start: number;
    end: number;
    anchorX: number;
    anchorY: number;
    getPath(): Path2D;
    /**
     * 设置圆的半径
     * @param radius 半径
     */
    setRadius(radius: number): void;
    /**
     * 设置圆的起始与终止角度
     * @param start 起始角度
     * @param end 终止角度
     */
    setAngle(start: number, end: number): void;
    protected handleProps(key: string, prevValue: any, nextValue: any): boolean;
}

export declare type CircleParams = [
cx?: number,
cy?: number,
radius?: number,
start?: number,
end?: number
];

export declare interface CirclesProps extends GraphicPropsBase {
    radius?: number;
    start?: number;
    end?: number;
    /**
     * 圆属性参数，可以填 `[圆心 x 坐标，圆心 y 坐标，半径，起始角度，终止角度]`，是 x, y, radius, start, end 的简写，
     * 其中半径可选，后两项要么都填，要么都不填
     */
    circle?: CircleParams;
}

declare class Comment_2 extends RenderItem {
    text: string;
    readonly isComment: boolean;
    constructor(text?: string);
    getBoundingRect(): DOMRectReadOnly;
    protected render(_canvas: MotaOffscreenCanvas2D, _transform: Transform): void;
    protected handleProps(): boolean;
}
export { Comment_2 as Comment }

export declare interface CommentProps extends BaseProps {
    text?: string;
}

export declare interface ConatinerCustomProps extends ContainerProps {
    /** 自定义容器渲染函数 */
    render?: CustomContainerRenderFn;
    /** 自定义容器事件传递函数 */
    propagate?: CustomContainerPropagateFn;
}

export declare class Container<E extends EContainerEvent = EContainerEvent> extends RenderItem<E | EContainerEvent> implements IRenderChildable {
    sortedChildren: RenderItem[];
    private needSort;
    /**
     * 创建一个容器，容器中可以包含其他渲染对象
     * @param type 渲染模式，absolute表示绝对位置，static表示跟随摄像机移动
     * @param cache 是否启用缓存机制
     */
    constructor(type?: RenderItemPosition, cache?: boolean, fall?: boolean);
    protected render(canvas: MotaOffscreenCanvas2D, transform: Transform): void;
    onResize(scale: number): void;
    requestSort(): void;
    /**
     * 添加子元素到这个容器上，然后在下一个tick执行更新
     * @param children 要添加的子元素
     */
    appendChild(...children: RenderItem<any>[]): void;
    removeChild(...child: RenderItem<any>[]): void;
    appendTo(parent: RenderItem): void;
    /**
     * 遍历这个元素中的每个子元素，并执行传入的函数
     * @param fn 对每个元素执行的函数
     */
    forEachChild(fn: (ele: RenderItem) => void): void;
    private sortChildren;
    protected propagateEvent<T extends ActionType>(type: T, progress: EventProgress, event: ActionEventMap[T]): void;
    destroy(): void;
}

export declare class ContainerCustom extends Container {
    private renderFn?;
    private propagateFn?;
    protected render(canvas: MotaOffscreenCanvas2D, transform: Transform): void;
    protected propagateEvent<T extends ActionType>(type: T, progress: EventProgress, event: ActionEventMap[T]): void;
    /**
     * 设置这个自定义容器的渲染函数
     * @param render 渲染函数
     */
    setRenderFn(render?: CustomContainerRenderFn): void;
    /**
     * 设置这个自定义容器的事件传递函数
     * @param propagate 事件传递函数
     */
    setPropagateFn(propagate: CustomContainerPropagateFn): void;
    protected handleProps(key: string, prevValue: any, nextValue: any): boolean;
}

export declare interface ContainerProps extends BaseProps {
}

export declare const createApp: CreateAppFunction<RenderItem<ERenderItemEvent>>;

export declare type CustomContainerPropagateFn = <T extends ActionType>(type: T, progress: EventProgress, event: ActionEventMap[T], container: ContainerCustom, origin: CustomContainerPropagateOrigin) => void;

export declare type CustomContainerPropagateOrigin = <T extends ActionType>(type: T, progress: EventProgress, event: ActionEventMap[T]) => void;

export declare type CustomContainerRenderFn = (canvas: MotaOffscreenCanvas2D, children: RenderItem[], transform: Transform) => void;

export declare interface CustomProps {
    _item: (props: BaseProps) => RenderItem;
}

export declare type DefaultProps<P extends BaseProps = BaseProps, E extends ERenderItemEvent = ERenderItemEvent> = TagDefine<P, E>;

declare type _Define<P extends BaseProps, E extends ERenderItemEvent> = DefineComponent<P, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, WrapEventEmitterEvents<E>, Exclude<keyof WrapEventEmitterEvents<E>, number | symbol>, VNodeProps, Readonly<P & MappingEvent<E>>>;

declare interface DrawArraysInstancedParam {
    mode: GLenum;
    first: number;
    count: number;
    instanceCount: number;
}

declare interface DrawArraysParam {
    mode: GLenum;
    first: number;
    count: number;
}

declare interface DrawElementsInstancedParam {
    mode: GLenum;
    count: number;
    type: GLenum;
    offset: GLintptr;
    instanceCount: number;
}

declare interface DrawElementsParam {
    mode: GLenum;
    count: number;
    type: GLenum;
    offset: GLintptr;
}

export declare interface DrawParamsMap {
    [RenderMode.Arrays]: DrawArraysParam;
    [RenderMode.ArraysInstanced]: DrawArraysInstancedParam;
    [RenderMode.Elements]: DrawElementsParam;
    [RenderMode.ElementsInstanced]: DrawElementsInstancedParam;
}

export declare interface EContainerEvent extends ERenderItemEvent {
}

export declare interface EGL2Event extends ERenderItemEvent {
}

export declare interface EGraphicItemEvent extends ERenderItemEvent {
}

export declare interface EImageEvent extends ERenderItemEvent {
}

export declare type ElementAnchor = [x: number, y: number];

export declare type ElementLocator = [
x?: number,
y?: number,
width?: number,
height?: number,
anchorX?: number,
anchorY?: number
];

export declare type ElementScale = [x: number, y: number];

export declare class Ellipse extends GraphicItemBase {
    radiusX: number;
    radiusY: number;
    start: number;
    end: number;
    anchorX: number;
    anchorY: number;
    getPath(): Path2D;
    /**
     * 设置椭圆的横纵轴长度
     * @param x 横轴长度
     * @param y 纵轴长度
     */
    setRadius(x: number, y: number): void;
    /**
     * 设置椭圆的起始与终止角度
     * @param start 起始角度
     * @param end 终止角度
     */
    setAngle(start: number, end: number): void;
    protected handleProps(key: string, prevValue: any, nextValue: any): boolean;
}

export declare type EllipseParams = [
cx?: number,
cy?: number,
radiusX?: number,
radiusY?: number,
start?: number,
end?: number
];

export declare interface EllipseProps extends GraphicPropsBase {
    radiusX?: number;
    radiusY?: number;
    start?: number;
    end?: number;
    /**
     * 椭圆属性参数，可以填 `[圆心 x 坐标，圆心 y 坐标，x半径，y半径，起始角度，终止角度]`，是 x, y, radiusX, radiusY, start, end 的简写，
     * 其中每两项要么都填，要么都不填
     */
    ellipse?: EllipseParams;
}

export declare interface ERenderItemActionEvent {
    /** 当这个元素被点击时的捕获阶段触发 */
    clickCapture: [ev: Readonly<IActionEvent>];
    /** 当这个元素被点击时的冒泡阶段触发 */
    click: [ev: Readonly<IActionEvent>];
    /** 当鼠标或手指在该元素上按下的捕获阶段触发 */
    downCapture: [ev: Readonly<IActionEvent>];
    /** 当鼠标或手指在该元素上按下的冒泡阶段触发 */
    down: [ev: Readonly<IActionEvent>];
    /** 当鼠标或手指在该元素上移动的捕获阶段触发 */
    moveCapture: [ev: Readonly<IActionEvent>];
    /** 当鼠标或手指在该元素上移动的冒泡阶段触发 */
    move: [ev: Readonly<IActionEvent>];
    /** 当鼠标或手指在该元素上抬起的捕获阶段触发 */
    upCapture: [ev: Readonly<IActionEvent>];
    /** 当鼠标或手指在该元素上抬起的冒泡阶段触发 */
    up: [ev: Readonly<IActionEvent>];
    /** 当鼠标或手指进入该元素时触发 */
    enter: [ev: Readonly<IActionEventBase>];
    /** 当鼠标或手指离开该元素时触发 */
    leave: [ev: Readonly<IActionEventBase>];
    /** 当鼠标滚轮时的捕获阶段触发 */
    wheelCapture: [ev: Readonly<IWheelEvent>];
    /** 当鼠标滚轮时的冒泡阶段触发 */
    wheel: [ev: Readonly<IWheelEvent>];
}

export declare interface ERenderItemEvent extends ERenderItemActionEvent {
    beforeRender: [transform: Transform];
    afterRender: [transform: Transform];
    destroy: [];
    transform: [item: RenderItem, transform: Transform];
}

export declare interface EShaderEvent extends EGL2Event {
}

export declare interface ESpriteEvent extends ERenderItemEvent {
}

export declare interface ETextEvent extends ERenderItemEvent {
    setText: [text: string, width: number, height: number];
}

export declare const eventNameMap: Record<ActionType, keyof ERenderItemActionEvent>;

export declare const enum EventProgress {
    /** 捕获阶段 */
    Capture = 0,
    /** 冒泡阶段 */
    Bubble = 1
}

export declare class Font implements IFontConfig {
    readonly family: string;
    readonly size: number;
    readonly sizeUnit: string;
    readonly weight: number;
    readonly italic: boolean;
    static defaultFamily: string;
    static defaultSize: number;
    static defaultSizeUnit: string;
    static defaultWeight: number;
    static defaultItalic: boolean;
    private readonly fallbacks;
    private fontString;
    constructor(family?: string, size?: number, sizeUnit?: string, weight?: number, italic?: boolean);
    /**
     * 添加后备字体，若当前字体不可用，那么会使用后备字体，后备字体也可以添加后备字体，但是请避免递归添加
     * @param fallback 后备字体
     */
    addFallback(...fallback: Font[]): void;
    private build;
    private getFallbackFont;
    private getFont;
    /**
     * 获取字体的 CSS 字符串
     */
    string(): string;
    private static parseOne;
    /**
     * 从 CSS 字体字符串解析出 Font 实例，不支持的属性将被忽略
     */
    static parse(str: string): void;
    /**
     * 设置默认字体
     */
    static setDefaults(font: Font): void;
    /**
     * 获取默认字体
     */
    static defaults(): Font;
    /**
     * 复制一个字体，同时修改字体的一部分属性
     * @param font 要复制的字体
     */
    static clone(font: Font, { family, size, sizeUnit, weight, italic }: Partial<IFontConfig>): Font;
}

export declare const enum FontWeight {
    Light = 300,
    Normal = 400,
    Bold = 700
}

export declare abstract class GL2<E extends EGL2Event = EGL2Event> extends RenderItem<EGL2Event | E> {
    /** 是否支持此组件 */
    static readonly support: boolean;
    readonly UNIFORM_1f: UniformType.Uniform1f;
    readonly UNIFORM_1fv: UniformType.Uniform1fv;
    readonly UNIFORM_1i: UniformType.Uniform1i;
    readonly UNIFORM_1iv: UniformType.Uniform1iv;
    readonly UNIFORM_1ui: UniformType.Uniform1ui;
    readonly UNIFORM_1uiv: UniformType.Uniform1uiv;
    readonly UNIFORM_2f: UniformType.Uniform2f;
    readonly UNIFORM_2fv: UniformType.Uniform2fv;
    readonly UNIFORM_2i: UniformType.Uniform2i;
    readonly UNIFORM_2iv: UniformType.Uniform2iv;
    readonly UNIFORM_2ui: UniformType.Uniform2ui;
    readonly UNIFORM_2uiv: UniformType.Uniform2uiv;
    readonly UNIFORM_3f: UniformType.Uniform3f;
    readonly UNIFORM_3fv: UniformType.Uniform3fv;
    readonly UNIFORM_3i: UniformType.Uniform3i;
    readonly UNIFORM_3iv: UniformType.Uniform3iv;
    readonly UNIFORM_3ui: UniformType.Uniform3ui;
    readonly UNIFORM_3uiv: UniformType.Uniform3uiv;
    readonly UNIFORM_4f: UniformType.Uniform4f;
    readonly UNIFORM_4fv: UniformType.Uniform4fv;
    readonly UNIFORM_4i: UniformType.Uniform4i;
    readonly UNIFORM_4iv: UniformType.Uniform4iv;
    readonly UNIFORM_4ui: UniformType.Uniform4ui;
    readonly UNIFORM_4uiv: UniformType.Uniform4uiv;
    readonly U_MATRIX_2x2: UniformMatrix.UMatrix2x2;
    readonly U_MATRIX_2x3: UniformMatrix.UMatrix2x3;
    readonly U_MATRIX_2x4: UniformMatrix.UMatrix2x4;
    readonly U_MATRIX_3x2: UniformMatrix.UMatrix3x2;
    readonly U_MATRIX_3x3: UniformMatrix.UMatrix3x3;
    readonly U_MATRIX_3x4: UniformMatrix.UMatrix3x4;
    readonly U_MATRIX_4x2: UniformMatrix.UMatrix4x2;
    readonly U_MATRIX_4x3: UniformMatrix.UMatrix4x3;
    readonly U_MATRIX_4x4: UniformMatrix.UMatrix4x4;
    readonly ATTRIB_1f: AttribType.Attrib1f;
    readonly ATTRIB_1fv: AttribType.Attrib1fv;
    readonly ATTRIB_2f: AttribType.Attrib2f;
    readonly ATTRIB_2fv: AttribType.Attrib2fv;
    readonly ATTRIB_3f: AttribType.Attrib3f;
    readonly ATTRIB_3fv: AttribType.Attrib3fv;
    readonly ATTRIB_4f: AttribType.Attrib4f;
    readonly ATTRIB_4fv: AttribType.Attrib4fv;
    readonly ATTRIB_I4i: AttribType.AttribI4i;
    readonly ATTRIB_I4iv: AttribType.AttribI4iv;
    readonly ATTRIB_I4ui: AttribType.AttribI4ui;
    readonly ATTRIB_I4uiv: AttribType.AttribI4uiv;
    readonly DRAW_ARRAYS = RenderMode.Arrays;
    readonly DRAW_ELEMENTS = RenderMode.Elements;
    readonly DRAW_ARRAYS_INSTANCED = RenderMode.ArraysInstanced;
    readonly DRAW_ELEMENTS_INSTANCED = RenderMode.ElementsInstanced;
    readonly MAX_TEXTURE_COUNT: number;
    canvas: HTMLCanvasElement;
    gl: WebGL2RenderingContext;
    /** webgl使用的程序 */
    protected program: GL2Program | null;
    /** 当前渲染实例的所有着色器程序 */
    protected programs: Set<GL2Program>;
    /** framebuffer 映射 */
    protected framebufferMap: Map<string, WebGLFramebuffer>;
    constructor(type?: RenderItemPosition);
    onResize(scale: number): void;
    setHD(hd: boolean): void;
    size(width: number, height: number): void;
    private sizeGL;
    protected render(canvas: MotaOffscreenCanvas2D, transform: Transform): void;
    /**
     * 渲染当前 gl2 画布
     * @param canvas 渲染至的目标画布，注意系统会自动将 gl2 画布渲染至目标画布，不需要手动画到该画布上
     * @param gl 当前正在渲染的 gl2 画布
     * @param program 当前元素正在使用的着色器程序
     * @param transform 当前元素相对父元素的变换矩阵
     */
    protected abstract drawScene(canvas: MotaOffscreenCanvas2D, gl: WebGL2RenderingContext, program: GL2Program, transform: Transform): void;
    /**
     * 执行顶点绘制
     * @param gl 当前正在渲染的 gl2 画布
     * @param program 当前元素正在使用的着色器程序
     */
    draw(gl: WebGL2RenderingContext, program: GL2Program): void;
    /**
     * 将画面渲染至帧缓冲
     * @param name 帧缓冲名称
     * @param texture 渲染至的纹理
     * @param clear 是否先清空画布再渲染
     */
    framebuffer(name: string, texture: IShaderTexture2D, clear?: boolean): void;
    /**
     * 创建一个帧缓冲对象
     * @param name 帧缓冲名称
     * @returns 是否创建成功
     */
    createFramebuffer(name: string): boolean;
    /**
     * 删除一个帧缓冲对象
     * @param name 帧缓冲名称
     * @returns 是否删除成功
     */
    deleteFramebuffer(name: string): boolean;
    /**
     * 切换着色器程序
     * @param program 着色器程序
     */
    useProgram(program: GL2Program): void;
    /**
     * 创建一个着色器程序
     * @param vs 顶点着色器，可选
     * @param fs 片元着色器，可选
     */
    createProgram<T extends GL2Program>(Program: ProgramConstructor<T>, vs?: string, fs?: string): T;
    /**
     * 删除一个着色器程序
     * @param program 要删除的着色器程序
     */
    deleteProgram(program: GL2Program): void;
    destroy(): void;
    private init;
}

export declare class GL2Program extends default_2<ShaderProgramEvent> {
    /** 顶点着色器 */
    private vertex;
    /** 片元着色器 */
    private fragment;
    /** webgl2上下文 */
    gl: WebGL2RenderingContext;
    /** 当前着色器程序的着色器渲染元素 */
    element: GL2;
    /** uniform存放地址 */
    private uniform;
    /** attribute存放地址，300版本里面叫做in */
    private attribute;
    /** attribute array 存放地址 */
    private attribArray;
    /** 顶点索引存放地址 */
    private indices;
    /** uniform矩阵存放地址 */
    private matrix;
    /** uniform block 存放地址 */
    private block;
    /** 纹理存放地址 */
    private texture;
    /** 当前编译完成的shader程序 */
    private shader;
    /** 当前的webgl程序 */
    program: WebGLProgram | null;
    /** 当前正在使用的顶点索引数组 */
    usingIndices: IShaderIndices | null;
    /** 着色器内容是否是默认内容，可以用于优化空着色器 */
    modified: boolean;
    /** 渲染模式 */
    renderMode: RenderMode;
    private arraysParams;
    private elementsParams;
    private arraysInstancedParams;
    private elementsInstancedParams;
    /** 是否需要重新编译着色器 */
    protected shaderDirty: boolean;
    /** 着色器代码的前缀，会在设置时自动添加至代码前 */
    protected readonly prefix: IGL2ProgramPrefix;
    constructor(shader: GL2, vs?: string, fs?: string);
    /**
     * 渲染前准备
     */
    ready(): boolean;
    /**
     * 设置渲染模式，目前可选 {@link Shader.DRAW_ARRAYS} 至 {@link Shader.DRAW_INSTANCED}
     */
    mode(mode: RenderMode): void;
    /**
     * 获取指定渲染模式的渲染参数
     * @param param 渲染模式
     */
    getDrawParams<T extends RenderMode>(param: T): DrawParamsMap[T] | null;
    /**
     * 设置 DRAW_ARRAYS 模式下的渲染参数
     * 参考 https://developer.mozilla.org/zh-CN/docs/Web/API/WebGLRenderingContext/drawArrays
     * @param mode 渲染模式
     * @param first 第一个元素的位置
     * @param count 渲染多少个元素
     */
    paramArrays(mode: GLenum, first: number, count: number): void;
    /**
     * 设置 DRAW_ARRAYS_INSTANCED 模式下的渲染参数
     * 参考 https://developer.mozilla.org/en-US/docs/Web/API/WebGL2RenderingContext/drawArraysInstanced
     * @param mode 渲染模式
     * @param first 第一个元素的位置
     * @param count 渲染多少个元素
     * @param instanceCount 渲染实例数量
     */
    paramArraysInstanced(mode: GLenum, first: number, count: number, instanceCount: number): void;
    /**
     * 设置 DRAW_ELEMENTS 模式下的渲染参数
     * 参考 https://developer.mozilla.org/zh-CN/docs/Web/API/WebGLRenderingContext/drawElements
     * @param mode 渲染模式
     * @param count 渲染元素数量
     * @param type 数据类型
     * @param offset 偏移量
     */
    paramElements(mode: GLenum, count: number, type: GLenum, offset: number): void;
    /**
     * 设置 DRAW_ELEMENTS 模式下的渲染参数
     * 参考 https://developer.mozilla.org/en-US/docs/Web/API/WebGL2RenderingContext/drawElementsInstanced
     * @param mode 渲染模式
     * @param count 渲染元素数量
     * @param type 数据类型
     * @param offset 偏移量
     * @param instanceCount 渲染实例数量
     */
    paramElementsInstanced(mode: GLenum, count: number, type: GLenum, offset: number, instanceCount: number): void;
    /**
     * 切换渲染时使用的顶点索引
     * @param name 要使用的顶点索引名称
     */
    useIndices(name: string | IShaderIndices): void;
    /**
     * 检查当前是否需要重新编译着色器，如果需要，则重新编译
     * @param force 是否强制重新编译
     */
    requestCompile(force?: boolean): boolean;
    /**
     * 设置顶点着色器内容
     * @param vs 顶点着色器
     */
    vs(vs: string): void;
    /**
     * 设置片元着色器内容
     * @param fs 片元着色器
     */
    fs(fs: string): void;
    /**
     * 当这个程序被卸载时执行的函数
     */
    unload(): void;
    /**
     * 当这个程序被加载（使用）时执行的函数
     */
    load(): void;
    /**
     * 获取一个uniform，需要事先定义，否则返回null
     * @param uniform uniform名称
     */
    getUniform<T extends UniformType = UniformType>(uniform: string): IShaderUniform<T> | null;
    /**
     * 获取一个attribute，需要事先定义，否则返回null
     * @param attrib attribute名称
     */
    getAttribute<T extends AttribType = AttribType>(attrib: string): IShaderAttrib<T> | null;
    /**
     * 获取一个attribute array，需要事先定义，否则返回null
     * @param name attribute array名称
     */
    getAttribArray(name: string): IShaderAttribArray | null;
    /**
     * 获取一个顶点索引数组，需要提前定义，否则返回null
     * @param name 顶点索引数组的名称
     */
    getIndices(name: string): IShaderIndices | null;
    /**
     * 获取一个 uniform matrix，需要事先定义，否则返回null
     * @param matrix uniform matrix 的名称
     */
    getMatrix(matrix: string): IShaderUniformMatrix | null;
    /**
     * 获取一个 uniform block，例如 UBO，需要事先定义，否则返回null
     * @param block uniform block 的名称
     */
    getUniformBlock(block: string): IShaderUniformBlock | null;
    /**
     * 获取一个 texture，需要事先定义，否则返回null
     * @param name texture 的名称
     */
    getTexture(name: string): IShaderTexture2D | null;
    /**
     * 定义一个 uniform 变量，并存入本着色器程序的 uniform 变量映射
     * @param uniform uniform 变量名
     * @param type uniform 类型，可选 {@link GL2.UNIFORM_1f} 至 {@link GL2.UNIFORM_4uiv}
     * @returns uniform 变量的操作对象，可用于设置其值
     */
    defineUniform<T extends UniformType>(uniform: string, type: T): IShaderUniform<T> | null;
    /**
     * 定义一个 uniform 矩阵变量，并存入本着色器程序的 uniform 矩阵变量映射
     * @param uniform uniform 矩阵变量名
     * @param type uniform 矩阵类型，可选 {@link GL2.U_MATRIX_2x2} 至 {@link GL2.U_MATRIX_4x4}
     * @returns uniform 矩阵变量的操作对象，可用于设置其值
     */
    defineUniformMatrix(uniform: string, type: UniformMatrix): IShaderUniformMatrix | null;
    /**
     * 定义一个 attribute 常量，并存入本着色器程序的 attribute 常量映射，在 es 300 版本中叫做 in
     * @param attrib attribute 常量名
     * @param type attribute 类型，可选 {@link GL2.ATTRIB_1f} 至 {@link GL2.ATTRIB_I4uiv}
     * @returns attribute 常量的操作对象，可用于设置其值
     */
    defineAttribute<T extends AttribType>(attrib: string, type: T): IShaderAttrib<T> | null;
    /**
     * 定义一个顶点数组
     * @param name 顶点数组名称
     */
    defineAttribArray(name: string): IShaderAttribArray | null;
    /**
     * 定义一个顶点索引数组
     * @param name 顶点索引数组的名称
     */
    defineIndices(name: string): IShaderIndices | null;
    /**
     * 定义一个 uniform block，例如 UBO，并存入本着色器程序的 uniform block 映射
     * 用于一次性向着色器传输大量数据
     * @param block uniform block 名称
     * @param size 数据量，即数据长度，例如一个vec4就是4个长度
     * @param usage 缓冲区用途，例如 gl.STATIC_DRAW 是指会频繁读取但不会频繁写入
     *              参考 https://developer.mozilla.org/zh-CN/docs/Web/API/WebGLRenderingContext/bufferData
     *              的 `usage` 参数
     * @param binding uniform block 的索引，例如这是你设置的第一个uniform block，就可以填0，第二个填1，以此类推
     * @returns uniform block 的操作对象，可用于设置其值
     */
    defineUniformBlock(block: string, size: number, usage: number, binding: number): IShaderUniformBlock | null;
    /**
     * 定义一个材质
     * @param name 纹理名称
     * @param index 纹理索引，根据不同浏览器，其最大数量不一定相等，根据标准其数量应该大于等于 8 个，
     *              因此考虑到兼容性，不建议纹理数量超过 8 个。
     * @param w 纹理的宽度
     * @param h 纹理的高度
     * @returns 这个 texture 的操作对象，可以用于设置其内容
     */
    defineTexture(name: string, index: number, w?: number, h?: number): IShaderTexture2D | null;
    /**
     * 摧毁这个着色器程序，不要直接调用，请使用 {@link GL2.deleteProgram} 来删除一个着色器程序
     */
    destroy(): void;
    private clearProgram;
    protected compile(): boolean;
    private compileShader;
}

export declare interface GL2Props extends BaseProps {
}

declare type GlobalAdapterFunction = (...params: any[]) => Promise<any>;

export declare abstract class GraphicItemBase extends RenderItem<EGraphicItemEvent> implements Required<ILineProperty> {
    mode: GraphicMode;
    fill: CanvasStyle_2;
    stroke: CanvasStyle_2;
    lineWidth: number;
    lineDash: number[];
    lineDashOffset: number;
    lineJoin: CanvasLineJoin;
    lineCap: CanvasLineCap;
    miterLimit: number;
    fillRule: CanvasFillRule;
    enableCache: boolean;
    private propFill;
    private propStroke;
    private strokeAndFill;
    private propFillSet;
    private actionStroke;
    private cachePath?;
    protected pathDirty: boolean;
    /**
     * 获取这个元素的绘制路径
     */
    abstract getPath(): Path2D;
    protected render(canvas: MotaOffscreenCanvas2D, _transform: Transform): void;
    protected isActionInElement(x: number, y: number): boolean;
    /**
     * 设置描边绘制的信息
     * @param options 线的信息
     */
    setLineOption(options: Partial<ILineProperty>): void;
    /**
     * 设置填充样式
     * @param style 绘制样式
     */
    setFillStyle(style: CanvasStyle_2): void;
    /**
     * 设置描边样式
     * @param style 绘制样式
     */
    setStrokeStyle(style: CanvasStyle_2): void;
    /**
     * 设置填充原则
     * @param rule 填充原则
     */
    setFillRule(rule: CanvasFillRule): void;
    /**
     * 设置绘制模式，是描边还是填充
     * @param mode 绘制模式
     */
    setMode(mode: GraphicMode): void;
    /**
     * 检查渲染模式，参考 {@link GraphicPropsBase} 中的 fill stroke strokeAndFill 属性
     */
    private checkMode;
    /**
     * 设置画布的渲染状态，在实际渲染前调用
     * @param canvas 要设置的画布
     */
    protected setCanvasState(canvas: MotaOffscreenCanvas2D): void;
    protected handleProps(key: string, _prevValue: any, nextValue: any): boolean;
}

export declare const enum GraphicMode {
    /** 仅填充 */
    Fill = 0,
    /** 仅描边 */
    Stroke = 1,
    /** 先填充，然后描边 */
    FillAndStroke = 2,
    /** 先描边，然后填充 */
    StrokeAndFill = 3
}

export declare interface GraphicPropsBase extends BaseProps, Partial<ILineProperty> {
    /** 是否填充，若填写 {@link stroke}，那么表现为先填充后描边 */
    fill?: boolean;
    /** 是否描边，若填写 {@link fill}，那么表现为先填充后描边 */
    stroke?: boolean;
    /** 是否先描边后填充，优先级最高，若设置，则 {@link fill} 与 {@link stroke} 无效。 */
    strokeAndFill?: boolean;
    /** 填充原则，比如 `nonzero` 表示非零环绕原则，默认为奇偶环绕原则 `evenodd` */
    fillRule?: CanvasFillRule;
    /** 填充样式 */
    fillStyle?: CanvasStyle_2;
    /** 描边样式 */
    strokeStyle?: CanvasStyle_2;
    /** 在交互时，是否只检查交互位置只在描边上，对 fill, stroke, strokeAndFill 均有效 */
    actionStroke?: boolean;
}

export declare interface IActionEvent extends IActionEventBase {
    /** 相对于触发元素左上角的横坐标 */
    offsetX: number;
    /** 相对于触发元素左上角的纵坐标 */
    offsetY: number;
    /** 相对于整个画布左上角的横坐标 */
    absoluteX: number;
    /** 相对于整个画布左上角的纵坐标 */
    absoluteY: number;
    /**
     * 调用后将停止事件的继续传播。
     * 在捕获阶段，将会阻止捕获的进一步进行，在冒泡阶段，将会阻止冒泡的进一步进行。
     * 如果当前元素有很多监听器，该方法并不会阻止其他监听器的执行。
     */
    stopPropagation(): void;
}

export declare interface IActionEventBase {
    /** 当前事件是监听的哪个元素 */
    target: RenderItem;
    /** 是触摸操作还是鼠标操作 */
    touch: boolean;
    /**
     * 触发的按键种类，会出现在点击、按下、抬起三个事件中，而其他的如移动等该值只会是 {@link MouseType.None}，
     * 电脑端可以有左键、中键、右键等，手机只会触发左键，每一项的值参考 {@link MouseType}
     */
    type: MouseType;
    /**
     * 当前按下了哪些按键。该值是一个数字，可以通过位运算判断是否按下了某个按键。
     * 例如通过 `buttons & MouseType.Left` 来判断是否按下了左键。
     * 注意在鼠标抬起或鼠标点击事件中，并不会包含触发的那个按键
     */
    buttons: number;
    /** 触发时是否按下了 alt 键 */
    altKey: boolean;
    /** 触发时是否按下了 shift 键 */
    shiftKey: boolean;
    /** 触发时是否按下了 ctrl 键 */
    ctrlKey: boolean;
    /** 触发时是否按下了 Windows(Windows) / Command(Mac) 键 */
    metaKey: boolean;
    /** 这次操作的标识符，在按下、移动、抬起阶段中保持不变 */
    identifier: number;
}

export declare interface IFontConfig {
    /** 字体类型 */
    readonly family: string;
    /** 字体大小的值 */
    readonly size: number;
    /** 字体大小单位，推荐使用 px */
    readonly sizeUnit: string;
    /** 字体粗细，范围 0-1000 */
    readonly weight: number;
    /** 是否斜体 */
    readonly italic: boolean;
}

export declare interface IGL2ProgramPrefix {
    readonly VERTEX: string;
    readonly FRAGMENT: string;
}

export declare interface IGraphicProperty extends ILineProperty {
    /** 渲染模式，参考 {@link GraphicMode} */
    mode: GraphicMode;
    /** 填充样式 */
    fill: CanvasStyle_2;
    /** 描边样式 */
    stroke: CanvasStyle_2;
    /** 填充算法 */
    fillRule: CanvasFillRule;
}

export declare interface ILineProperty {
    /** 线宽 */
    lineWidth: number;
    /** 线的虚线设置 */
    lineDash?: number[];
    /** 虚线偏移量 */
    lineDashOffset?: number;
    /** 线的连接样式 */
    lineJoin: CanvasLineJoin;
    /** 线的顶端样式 */
    lineCap: CanvasLineCap;
    /** 线的斜接限制，当连接为miter类型时可填，默认为10 */
    miterLimit: number;
}

declare class Image_2 extends RenderItem<EImageEvent> {
    image: CanvasImageSource;
    constructor(image: CanvasImageSource, type?: RenderItemPosition);
    protected render(canvas: MotaOffscreenCanvas2D, _transform: Transform): void;
    /**
     * 设置图片资源
     * @param image 图片资源
     */
    setImage(image: CanvasImageSource): void;
    protected handleProps(key: string, _prevValue: any, nextValue: any): boolean;
}
export { Image_2 as Image }

export declare interface ImageProps extends BaseProps {
    /** 图片对象 */
    image: CanvasImageSource;
}

export declare interface InstancedElementProp {
    item: RenderItem;
}

export declare interface IRenderAnchor {
    /** 锚点横坐标，0表示最左端，1表示最右端 */
    anchorX: number;
    /** 锚点纵坐标，0表示最上端，1表示最下端 */
    anchorY: number;
    /**
     * 设置渲染元素的位置锚点
     * @param x 锚点的横坐标，小数，0表示最左边，1表示最右边
     * @param y 锚点的纵坐标，小数，0表示最上边，1表示最下边
     */
    setAnchor(x: number, y: number): void;
}

export declare interface IRenderChildable {
    /** 当前元素的子元素 */
    children: Set<RenderItem>;
    /**
     * 向这个元素添加子元素
     * @param child 添加的元素
     */
    appendChild(...child: RenderItem<any>[]): void;
    /**
     * 移除这个元素中的某个子元素
     * @param child 要移除的元素
     */
    removeChild(...child: RenderItem<any>[]): void;
    /**
     * 在下一个tick的渲染前对子元素进行排序
     */
    requestSort(): void;
}

export declare interface IRenderConfig {
    /** 是否是高清画布 */
    highResolution: boolean;
    /** 是否启用抗锯齿 */
    antiAliasing: boolean;
    /**
     * 设置当前渲染元素是否使用高清画布
     * @param hd 是否高清
     */
    setHD(hd: boolean): void;
    /**
     * 设置当前渲染元素是否启用抗锯齿
     * @param anti 是否抗锯齿
     */
    setAntiAliasing(anti: boolean): void;
}

export declare interface IRenderEvent {
    /**
     * 当触发缩放事件时，此函数执行的内容
     * @param scale 缩放至的缩放比
     */
    onResize(scale: number): void;
}

export declare interface IRenderFrame {
    /**
     * 在下一帧渲染之前执行函数，常用于渲染前数据更新，理论上不应当用于渲染，不保证运行顺序
     * @param fn 执行的函数
     */
    requestBeforeFrame(fn: () => void): void;
    /**
     * 在下一帧渲染之后执行函数，理论上不应当用于渲染，不保证运行顺序
     * @param fn 执行的函数
     */
    requestAfterFrame(fn: () => void): void;
    /**
     * 在下一帧渲染时执行函数，理论上应当只用于渲染（即{@link RenderItem.update}方法），且不保证运行顺序
     * @param fn 执行的函数
     */
    requestRenderFrame(fn: () => void): void;
}

export declare interface IRenderTickerSupport {
    /**
     * 委托ticker，让其在指定时间范围内每帧执行对应函数，超过时间后自动删除
     * @param fn 每帧执行的函数
     * @param time 函数持续时间，不填代表不会自动删除，需要手动删除
     * @param end 持续时间结束后执行的函数
     * @returns 委托id，可用于删除
     */
    delegateTicker(fn: TickerFn, time?: number, end?: () => void): number;
    /**
     * 移除ticker函数
     * @param id 函数id，也就是{@link IRenderTickerSupport.delegateTicker}的返回值
     * @param callEnd 是否调用结束函数，即{@link IRenderTickerSupport.delegateTicker}的end参数，默认调用
     * @returns 是否删除成功，比如对应ticker不存在，就是删除失败
     */
    removeTicker(id: number, callEnd?: boolean): boolean;
    /**
     * 检查是否包含一个委托函数
     * @param id 函数id
     */
    hasTicker(id: number): boolean;
}

export declare interface IRenderTreeRoot {
    readonly isRoot: true;
    /**
     * 将一个渲染元素连接到此根元素
     * @param item 要连接到此根元素的渲染元素
     */
    connect(item: RenderItem): void;
    /**
     * 将已连接的渲染元素从此根元素中去掉
     * @param item 要取消连接的渲染元素
     */
    disconnect(item: RenderItem): void;
    /**
     * 修改已连接的元素的 id
     * @param item 修改了 id 的元素
     * @param previous 先前的元素 id
     * @param current 现在的元素 id
     */
    modifyId(item: RenderItem, previous: string, current: string): void;
    /**
     * 获取渲染至的目标画布，即显示在画面上的画布
     */
    getCanvas(): HTMLCanvasElement;
    /**
     * 当鼠标覆盖在某个元素上时执行
     * @param element 鼠标覆盖的元素
     */
    hoverElement(element: RenderItem): void;
}

export declare interface IRenderUpdater {
    /**
     * 更新这个渲染元素
     * @param item 触发更新事件的元素，不填默认为元素自身触发
     */
    update(item?: RenderItem): void;
}

export declare interface IRenderVueSupport {
    /**
     * 在 jsx, vue 中当属性改变后触发此函数，用于处理响应式等情况
     * @param key 属性键名
     * @param prevValue 该属性先前的数值
     * @param nextValue 该属性当前的数值
     * @param namespace 元素命名空间
     * @param parentComponent 元素的父组件
     */
    patchProp(key: string, prevValue: any, nextValue: any, namespace?: ElementNamespace, parentComponent?: ComponentInternalInstance | null): void;
}

export declare interface IShaderAttrib<T extends AttribType> {
    /** 这个 attribute 常量的内存位置 */
    readonly location: number;
    /** 这个 attribute 常量的类型 */
    readonly type: T;
    /** 这个量所处的着色器程序 */
    readonly program: GL2Program;
    /**
     * 设置这个 attribute 常量的值，
     * 浮点数参考 https://developer.mozilla.org/zh-CN/docs/Web/API/WebGLRenderingContext/vertexAttrib
     * 整数参考 https://developer.mozilla.org/en-US/docs/Web/API/WebGL2RenderingContext/vertexAttribI
     * @param params 要传递的参数
     */
    set(...params: AttribSetFn[T]): void;
}

export declare interface IShaderAttribArray {
    /** 这个 attribute 常量的内存位置 */
    readonly location: number;
    /** 这个 attribute 所用的缓冲区信息 */
    readonly data: WebGLBuffer;
    /** 这个量所处的着色器程序 */
    readonly program: GL2Program;
    /**
     * 修改缓冲区数据，会更改数据大小，重新分配内存，不更改数据大小的情况下建议使用 {@link sub} 代替。
     * 参考 https://developer.mozilla.org/zh-CN/docs/Web/API/WebGLRenderingContext/bufferData
     * @param data 数据
     * @param usage 用途
     */
    buffer(data: AllowSharedBufferSource | null, usage: GLenum): void;
    /**
     * 修改缓冲区数据，会更改数据大小，重新分配内存，不更改数据大小的情况下建议使用 {@link sub} 代替。
     * 参考 https://developer.mozilla.org/zh-CN/docs/Web/API/WebGLRenderingContext/bufferData
     * @param data 数据
     * @param usage 用途
     * @param srcOffset 数据偏移量
     * @param length 数据长度
     */
    buffer(data: ArrayBufferView, usage: GLenum, srcOffset: number, length?: number): void;
    /**
     * 修改缓冲区数据，但是不修改数据大小，不重新分配内存。
     * 参考 https://developer.mozilla.org/en-US/docs/Web/API/WebGLRenderingContext/bufferSubData
     * @param dstByteOffset 数据修改的起始位置
     * @param srcData 数据
     */
    sub(dstByteOffset: GLintptr, srcData: AllowSharedBufferSource): void;
    /**
     * 修改缓冲区数据，但是不修改数据大小，不重新分配内存。
     * 参考 https://developer.mozilla.org/en-US/docs/Web/API/WebGLRenderingContext/bufferSubData
     * @param dstByteOffset 数据修改的起始位置
     * @param srcData 数据
     * @param srcOffset 数据偏移量
     * @param length 数据长度
     */
    sub(dstByteOffset: GLintptr, srcData: ArrayBufferView, srcOffset: number, length?: GLuint): void;
    /**
     * 告诉 gpu 将读取此 attribute 数据
     * 参考 https://developer.mozilla.org/zh-CN/docs/Web/API/WebGLRenderingContext/vertexAttribPointer
     * @param size 单个数据大小
     * @param type 数据类型
     * @param normalized 是否要经过归一化处理
     * @param stride 每一部分字节偏移量
     * @param offset 第一部分字节偏移量
     */
    pointer(size: GLint, type: GLenum, normalized: GLboolean, stride: GLsizei, offset: GLintptr): void;
    /**
     * 告诉 gpu 将由整数类型读取此 attribute 数据
     * 参考 https://developer.mozilla.org/en-US/docs/Web/API/WebGL2RenderingContext/vertexAttribIPointer
     * @param size 单个数据大小
     * @param type 数据类型
     * @param stride 每一部分字节偏移量
     * @param offset 第一部分字节偏移量
     */
    pointerI(size: GLint, type: GLenum, stride: GLsizei, offset: GLintptr): void;
    /**
     * 设置顶点指针更新时刻。
     * 参考 https://developer.mozilla.org/en-US/docs/Web/API/WebGL2RenderingContext/vertexAttribDivisor
     * @param divisor 每多少个实例更新一次，0表示每个顶点都更新
     */
    divisor(divisor: number): void;
    /**
     * 启用这个顶点数据
     */
    enable(): void;
    /**
     * 禁用这个顶点数据
     */
    disable(): void;
}

export declare interface IShaderIndices {
    /** 这个顶点索引所用的缓冲区信息 */
    readonly data: WebGLBuffer;
    /** 这个量所处的着色器程序 */
    readonly program: GL2Program;
    /**
     * 修改缓冲区数据，会更改数据大小，重新分配内存，不更改数据大小的情况下建议使用 {@link sub} 代替。
     * 参考 https://developer.mozilla.org/zh-CN/docs/Web/API/WebGLRenderingContext/bufferData
     * @param data 数据
     * @param usage 用途
     */
    buffer(data: AllowSharedBufferSource | null, usage: GLenum): void;
    /**
     * 修改缓冲区数据，会更改数据大小，重新分配内存，不更改数据大小的情况下建议使用 {@link sub} 代替。
     * 参考 https://developer.mozilla.org/zh-CN/docs/Web/API/WebGLRenderingContext/bufferData
     * @param data 数据
     * @param usage 用途
     * @param srcOffset 数据偏移量
     * @param length 数据长度
     */
    buffer(data: ArrayBufferView, usage: GLenum, srcOffset: number, length?: number): void;
    /**
     * 修改缓冲区数据，但是不修改数据大小，不重新分配内存。
     * 参考 https://developer.mozilla.org/en-US/docs/Web/API/WebGLRenderingContext/bufferSubData
     * @param dstByteOffset 数据修改的起始位置
     * @param srcData 数据
     */
    sub(dstByteOffset: GLintptr, srcData: AllowSharedBufferSource): void;
    /**
     * 修改缓冲区数据，但是不修改数据大小，不重新分配内存。
     * 参考 https://developer.mozilla.org/en-US/docs/Web/API/WebGLRenderingContext/bufferSubData
     * @param dstByteOffset 数据修改的起始位置
     * @param srcData 数据
     * @param srcOffset 数据偏移量
     * @param length 数据长度
     */
    sub(dstByteOffset: GLintptr, srcData: ArrayBufferView, srcOffset: number, length?: GLuint): void;
}

export declare interface IShaderTexture2D {
    /** 纹理对象 */
    readonly texture: WebGLTexture;
    /** 宽度 */
    readonly width: number;
    /** 高度 */
    readonly height: number;
    /** 纹理所属索引 */
    readonly index: number;
    /** 这个量所处的着色器程序 */
    readonly program: GL2Program;
    /**
     * 设置这个纹理的图像，不建议使用，会修改宽高
     * @param source 要设置成的图像源
     */
    set(source: TexImageSource): void;
    /**
     * 设置纹理的一部分信息，不会修改宽高
     * @param source 要设置的图像源
     * @param x 要设置到的起始点横坐标
     * @param y 要设置到的起始点纵坐标
     * @param width 宽度
     * @param height 高度
     */
    sub(source: TexImageSource, x: number, y: number, width: number, height: number): void;
}

export declare interface IShaderUniform<T extends UniformType> {
    /** 这个 uniform 变量的内存位置 */
    readonly location: WebGLUniformLocation;
    /** 这个 uniform 变量的类型 */
    readonly type: T;
    /** 这个量所处的着色器程序 */
    readonly program: GL2Program;
    /**
     * 设置这个 uniform 变量的值，
     * 参考 https://developer.mozilla.org/zh-CN/docs/Web/API/WebGL2RenderingContext/uniform
     * @param params 要传递的参数，例如 uniform2f 就要传递 x0 x1 两个参数等，可以参考 mdn 文档
     */
    set(...params: UniformSetFn[T]): void;
}

export declare interface IShaderUniformBlock {
    /** 这个 uniform block 的内存地址 */
    readonly location: GLuint;
    /** 与这个 uniform block 所绑定的缓冲区 */
    readonly buffer: WebGLBuffer;
    /** 这个 uniform block 的大小 */
    readonly size: number;
    /** 这个量所处的着色器程序 */
    readonly program: GL2Program;
    /**
     * 参考 https://developer.mozilla.org/zh-CN/docs/Web/API/WebGL2RenderingContext/bindBufferBase
     * @param srcData 要设置为的值
     */
    set(srcData: AllowSharedBufferSource | null): void;
    /**
     * 参考 https://developer.mozilla.org/zh-CN/docs/Web/API/WebGL2RenderingContext/bindBufferBase
     * @param srcData 要设置为的值
     * @param srcOffset 数据偏移量
     * @param length 数据长度
     */
    set(srcData: ArrayBufferView, srcOffset: number, length?: number): void;
}

export declare interface IShaderUniformMatrix {
    /** 矩阵的内存位置 */
    readonly location: WebGLUniformLocation;
    /** 矩阵类型 */
    readonly type: UniformMatrix;
    /** 这个量所处的着色器程序 */
    readonly program: GL2Program;
    /**
     * 设置矩阵的值，参考 https://developer.mozilla.org/zh-CN/docs/Web/API/WebGL2RenderingContext/uniformMatrix
     * @param transpose 是否转置矩阵
     * @param data 矩阵数据，列主序
     * @param srcOffset 数据偏移量
     * @param srcLength 数据长度
     */
    set(transpose: GLboolean, data: Float32List, srcOffset?: number, srcLength?: number): void;
}

/**
 * 判断两个集合是否相等
 */
export declare function isSetEqual<T>(set1: Set<T>, set2: Set<T>): boolean;

export declare function isWebGL2Supported(): boolean;

export declare function isWebGLSupported(): boolean;

export declare interface ITransformUpdatable {
    updateTransform?(): void;
}

export declare interface IWheelEvent extends IActionEvent {
    /** 滚轮事件的鼠标横向滚动量 */
    wheelX: number;
    /** 滚轮事件的鼠标纵向滚动量 */
    wheelY: number;
    /** 滚轮事件的鼠标垂直屏幕的滚动量 */
    wheelZ: number;
    /** 滚轮事件的滚轮类型，表示了对应值的单位 */
    wheelType: WheelType;
}

export declare class Line extends GraphicItemBase {
    x1: number;
    y1: number;
    x2: number;
    y2: number;
    mode: GraphicMode;
    getPath(): Path2D;
    /**
     * 设置第一个点的横纵坐标
     */
    setPoint1(x: number, y: number): void;
    /**
     * 设置第二个点的横纵坐标
     */
    setPoint2(x: number, y: number): void;
    private fitRect;
    protected handleProps(key: string, prevValue: any, nextValue: any): boolean;
}

export declare type LineParams = [x1: number, y1: number, x2: number, y2: number];

export declare interface LineProps extends GraphicPropsBase {
    x1?: number;
    y1?: number;
    x2?: number;
    y2?: number;
    /** 直线属性参数，可以填 `[x1, y1, x2, y2]`，都是必填 */
    line?: LineParams;
}

declare type MappingEvent<E extends ERenderItemEvent> = {
    [P in keyof WrapEventEmitterEvents<E> as P extends string ? `on${Capitalize<P>}` : never]?: WrapEventEmitterEvents<E>[P];
};

export declare class MotaOffscreenCanvas2D extends EventEmitter<OffscreenCanvasEvent> {
    canvas: HTMLCanvasElement;
    ctx: CanvasRenderingContext2D;
    width: number;
    height: number;
    /** 是否是高清画布 */
    highResolution: boolean;
    /** 是否启用抗锯齿 */
    antiAliasing: boolean;
    scale: number;
    /** 更新标识符，如果发生变化则说明画布被动清空 */
    symbol: number;
    /**
     * 创建一个新的离屏画布\
     * **注意**：如果你在自定义渲染元素中使用，请避免使用此构造函数，而应该使用 `RenderItem.requireCanvas`
     * @param alpha 是否启用透明度通道
     * @param canvas 指定画布，不指定时会自动创建一个新画布
     */
    constructor(alpha?: boolean, canvas?: HTMLCanvasElement);
    /**
     * 设置画布的缩放比
     * @param scale 缩放比
     */
    setScale(scale: number): void;
    /**
     * 设置画布的大小
     */
    size(width: number, height: number): void;
    /**
     * 设置当前画布是否为高清画布
     */
    setHD(hd: boolean): void;
    /**
     * 设置当前画布的抗锯齿设置
     */
    setAntiAliasing(anti: boolean): void;
    /**
     * 清空画布
     */
    clear(): void;
    /**
     * 复制一个离屏Canvas2D对象，一般用于缓存等操作
     * @param canvas 被复制的MotaOffscreenCanvas2D对象
     */
    static clone(canvas: MotaOffscreenCanvas2D): MotaOffscreenCanvas2D;
}

export declare class MotaRenderer extends Container implements IRenderTreeRoot {
    static list: Map<string, MotaRenderer>;
    /** 所有连接到此根元素的渲染元素的 id 到元素自身的映射 */
    protected idMap: Map<string, RenderItem>;
    /** 最后一次按下的鼠标按键，用于处理鼠标移动 */
    private lastMouse;
    /** 每个触点的信息 */
    private touchInfo;
    /** 触点列表 */
    private touchList;
    /** 每个鼠标按键的信息 */
    private mouseInfo;
    /** 操作的标识符 */
    private actionIdentifier;
    /** 用于终止 document 上的监听 */
    private abort?;
    /** 根据捕获行为判断光标样式 */
    private targetCursor;
    /** 当前鼠标覆盖的元素 */
    private hoveredElement;
    /** 本次交互前鼠标覆盖的元素 */
    private beforeHovered;
    target: MotaOffscreenCanvas2D;
    readonly isRoot = true;
    constructor(config: MotaRendererConfig);
    /**
     * 设置这个渲染器的缩放比
     * @param scale 缩放比
     */
    setScale(scale: number): void;
    onResize(scale: number): void;
    private getMountCanvas;
    size(width: number, height: number): void;
    private listen;
    private isTouchInCanvas;
    private getMouseType;
    private getActiveMouseIdentifier;
    private getMouseIdentifier;
    private getMouseButtons;
    private createMouseActionBase;
    private createTouchActionBase;
    private createMouseAction;
    private createWheelAction;
    private getTouchIdentifier;
    private createTouch;
    private createTouchAction;
    private checkMouseEnterLeave;
    private checkTouchEnterLeave;
    update(_item?: RenderItem): void;
    protected refresh(): void;
    /**
     * 根据渲染元素的id获取一个渲染元素
     * @param id 要获取的渲染元素id
     * @returns
     */
    getElementById(id: string): RenderItem | null;
    private searchElement;
    connect(item: RenderItem): void;
    disconnect(item: RenderItem): void;
    modifyId(item: RenderItem, previous: string, current: string): void;
    getCanvas(): HTMLCanvasElement;
    hoverElement(element: RenderItem): void;
    destroy(): void;
    private toTagString;
    /**
     * 调试功能，将渲染树输出为 XML 标签形式，只包含渲染元素类名，以及元素 id 等基础属性，不包含属性值等
     * @param space 缩进空格数
     */
    toTagTree(space?: number): string;
    static get(id: string): MotaRenderer | undefined;
}

export declare interface MotaRendererConfig {
    /** 要挂载到哪个画布上，可以填 css 选择器或画布元素本身 */
    canvas: string | HTMLCanvasElement;
    /** 画布的宽度，所有渲染操作会自行适配缩放 */
    width: number;
    /** 画布的高度，所有渲染操作会自行适配缩放 */
    height: number;
    /** 是否启用不透明度通道，默认启用 */
    alpha?: boolean;
}

export declare const enum MouseType {
    /** 没有按键按下 */
    None = 0,
    /** 左键 */
    Left = 1,
    /** 中键，即按下滚轮 */
    Middle = 2,
    /** 右键 */
    Right = 4,
    /** 侧键后退 */
    Back = 8,
    /** 侧键前进 */
    Forward = 16
}

/**
 * 将两个缓动函数做乘法
 */
export declare function multiplyTiming(timing1: TimingFn, timing2: TimingFn): TimingFn;

declare interface OffscreenCanvasEvent {
    /** 当被动触发resize时（例如窗口大小变化）时触发，使用size函数并不会触发 */
    resize: [];
}

export declare function onEvent<T extends ERenderItemEvent, K extends default_2.EventNames<T>>(item: RenderItem<T>, key: K, listener: default_2.EventListener<T, K>): void;

declare type OnItemCreate<E extends ERenderItemEvent = ERenderItemEvent, T extends RenderItem<E> = RenderItem<E>> = (namespace?: ElementNamespace, isCustomizedBuiltIn?: string, vnodeProps?: (VNodeProps & {
    [key: string]: any;
}) | null) => T;

/**
 * 在组件中每帧执行一次函数
 * @param fn 每帧执行的函数
 */
export declare function onTick(fn: (time: number) => void): void;

export declare class Path extends GraphicItemBase {
    /** 路径 */
    path: Path2D;
    /**
     * 获取当前路径
     */
    getPath(): Path2D;
    /**
     * 为路径添加路径
     * @param path 要添加的路径
     */
    addPath(path: Path2D): void;
    protected isActionInElement(x: number, y: number): boolean;
    protected handleProps(key: string, prevValue: any, nextValue: any): boolean;
}

export declare interface PathProps extends GraphicPropsBase {
    path?: Path2D;
}

export declare type ProgramConstructor<T extends GL2Program> = new (gl2: GL2, vs?: string, fs?: string) => T;

export declare type Props<T extends keyof JSX.IntrinsicElements | DefineSetupFnComponent<any> | DefineComponent> = T extends keyof JSX.IntrinsicElements ? JSX.IntrinsicElements[T] : T extends DefineSetupFnComponent<any> ? InstanceType<T>['$props'] & InstanceType<T>['$emits'] : T extends DefineComponent ? InstanceType<T>['$props'] & InstanceType<T>['$emits'] : unknown;

export declare type QuadParams = [
sx: number,
sy: number,
cpx: number,
cpy: number,
ex: number,
ey: number
];

export declare class QuadraticCurve extends GraphicItemBase {
    sx: number;
    sy: number;
    cpx: number;
    cpy: number;
    ex: number;
    ey: number;
    mode: GraphicMode;
    getPath(): Path2D;
    protected render(canvas: MotaOffscreenCanvas2D, _transform: Transform): void;
    /**
     * 设置起始点坐标
     */
    setStart(x: number, y: number): void;
    /**
     * 设置控制点坐标
     */
    setControl(x: number, y: number): void;
    /**
     * 设置终点坐标
     */
    setEnd(x: number, y: number): void;
    private fitRect;
    protected isActionInElement(x: number, y: number): boolean;
    protected handleProps(key: string, prevValue: any, nextValue: any): boolean;
}

export declare interface QuadraticProps extends GraphicPropsBase {
    sx?: number;
    sy?: number;
    cpx?: number;
    cpy?: number;
    ex?: number;
    ey?: number;
    /** 二次贝塞尔曲线参数，可以填 `[sx, sy, cpx, cpy, ex, ey]`，都是必填 */
    curve?: QuadParams;
}

export declare class Rect extends GraphicItemBase {
    pos(x: number, y: number): void;
    size(width: number, height: number): void;
    getPath(): Path2D;
}

export declare interface RectProps extends GraphicPropsBase {
}

export declare class RectR extends GraphicItemBase {
    /** 圆角属性，四元素数组，每个元素是一个二元素数组，表示这个角的半径，顺序为 左上，右上，右下，左下 */
    readonly corner: [radiusX: number, radiusY: number][];
    getPath(): Path2D;
    /**
     * 设置圆角半径
     * @param x 横向半径
     * @param y 纵向半径
     */
    setRadius(x: number, y: number, corner: RectRCorner): void;
    /**
     * 设置圆形圆角参数
     * @param circle 圆形圆角参数
     */
    setCircle(circle: RectRCircleParams): void;
    /**
     * 设置椭圆圆角参数
     * @param ellipse 椭圆圆角参数
     */
    setEllipse(ellipse: RectREllipseParams): void;
    protected handleProps(key: string, prevValue: any, nextValue: any): boolean;
}

export declare type RectRCircleParams = [
r1: number,
r2?: number,
r3?: number,
r4?: number
];

export declare const enum RectRCorner {
    TopLeft = 0,
    TopRight = 1,
    BottomRight = 2,
    BottomLeft = 3
}

export declare type RectREllipseParams = [
rx1: number,
ry1: number,
rx2?: number,
ry2?: number,
rx3?: number,
ry3?: number,
rx4?: number,
ry4?: number
];

export declare interface RectRProps extends GraphicPropsBase {
    /**
     * 圆形圆角参数，可以填 `[r1, r2, r3, r4]`，后三项可选。填写不同数量下的表现：
     * - 1个：每个角都是 `r1` 半径的圆
     * - 2个：左上和右下是 `r1` 半径的圆，右上和左下是 `r2` 半径的圆
     * - 3个：左上是 `r1` 半径的圆，右上和左下是 `r2` 半径的圆，右下是 `r3` 半径的圆
     * - 4个：左上、右上、左下、右下 分别是 `r1, r2, r3, r4` 半径的圆
     */
    circle?: RectRCircleParams;
    /**
     * 椭圆圆角参数，可以填 `[rx1, ry1, rx2, ry2, rx3, ry3, rx4, ry4]`，
     * 两两一组，后三组可选，填写不同数量下的表现：
     * - 1组：每个角都是 `[rx1, ry1]` 半径的椭圆
     * - 2组：左上和右下是 `[rx1, ry1]` 半径的椭圆，右上和左下是 `[rx2, ry2]` 半径的椭圆
     * - 3组：左上是 `[rx1, ry1]` 半径的椭圆，右上和左下是 `[rx2, ey2]` 半径的椭圆，右下是 `[rx3, ry3]` 半径的椭圆
     * - 4组：左上、右上、左下、右下 分别是 `[rx1, ry1], [rx2, ry2], [rx3, ry3], [rx4, ry4]` 半径的椭圆
     */
    ellipse?: RectREllipseParams;
}

export declare const render: RootRenderFunction<RenderItem<ERenderItemEvent>>;

/**
 * 渲染适配器，用作渲染层与数据层沟通的桥梁，用于在数据层等待渲染层执行，常用与动画等。
 * 例如移动图块，移动图块操作先由数据层执行，删除原有图块，然后通知渲染层进行移动动画，
 * 而移动动画是耗时的，因此需要通过本类进行适配，实现等待移动动画执行完毕，然后进行后续操作
 */
export declare class RenderAdapter<T> {
    static adapters: Map<string, RenderAdapter<any>>;
    /** 所有元素的集合 */
    items: Set<T>;
    /** 适配器的id */
    id: string;
    private execute;
    private syncExecutes;
    private globalExecutes;
    constructor(id: string);
    /**
     * 添加一个元素
     */
    add(item: T): void;
    /**
     * 移除一个元素
     */
    remove(item: T): void;
    /**
     * 定义一个类似于静态函数的函数，只会调用一次，不会对每个元素执行
     * @param id 函数名称
     * @param fn 执行的函数
     */
    receiveGlobal(id: string, fn: GlobalAdapterFunction): void;
    /**
     * 设置执行函数
     * @param fn 对于每个元素执行的函数
     */
    receive(id: string, fn: AdapterFunction<T>): void;
    /**
     * 设置同步执行函数
     * @param fn 对于每个元素执行的函数
     */
    receiveSync(id: string, fn: SyncAdapterFunction<T>): void;
    /**
     * 对所有元素执行函数，当所有元素都运行完毕后兑现，类似于Promise.all
     * @returns 包含每个元素运行结果的数组
     */
    all<R = any>(fn: string, ...params: any[]): Promise<R[]>;
    /**
     * 对所有元素执行函数，当任意一个元素运行完毕后兑现，类似于Promise.any
     * @returns 最先运行完毕的元素的结果
     */
    any<R = any>(fn: string, ...params: any[]): Promise<R>;
    /**
     * 对所有元素执行同步函数
     * @returns 包含每个元素运行结果的数组
     */
    sync<R = any>(fn: string, ...params: any[]): R[];
    /**
     * 调用一个全局函数
     */
    global<R = any>(id: string, ...params: any[]): Promise<R>;
    /**
     * 销毁这个adapter
     */
    destroy(): void;
    /**
     * 获取适配器
     */
    static get<T>(id: string): RenderAdapter<T> | undefined;
}

export declare type RenderFunction = (canvas: MotaOffscreenCanvas2D, transform: Transform) => void;

export declare abstract class RenderItem<E extends ERenderItemEvent = ERenderItemEvent> extends EventEmitter<ERenderItemEvent | E> implements IRenderUpdater, IRenderAnchor, IRenderConfig, IRenderFrame, IRenderTickerSupport, IRenderChildable, IRenderVueSupport, ITransformUpdatable, IRenderEvent {
    /** 渲染的全局ticker */
    static ticker: Ticker;
    /** 包括但不限于怪物、npc、自动元件的动画帧数 */
    static animatedFrame: number;
    /** ticker委托映射 */
    static tickerMap: Map<number, TickerDelegation>;
    /** ticker委托id */
    static tickerId: number;
    readonly uid: number;
    /** 是否是注释元素 */
    readonly isComment: boolean;
    private _id;
    /**
     * 元素的 id，原则上不可重复
     */
    get id(): string;
    set id(v: string);
    /** 元素纵深，表示了遮挡关系 */
    zIndex: number;
    width: number;
    height: number;
    /** 渲染锚点，(0,0)表示左上角，(1,1)表示右下角 */
    anchorX: number;
    /** 渲染锚点，(0,0)表示左上角，(1,1)表示右下角 */
    anchorY: number;
    /** 渲染模式，absolute表示绝对位置，static表示跟随摄像机移动 */
    type: RenderItemPosition;
    /** 是否是高清画布 */
    highResolution: boolean;
    /** 是否抗锯齿 */
    antiAliasing: boolean;
    /** 是否被隐藏 */
    hidden: boolean;
    /** 滤镜 */
    filter: string;
    /** 混合方式 */
    composite: GlobalCompositeOperation;
    /** 不透明度 */
    alpha: number;
    /** 缩放比 */
    protected scale: number;
    /** 鼠标覆盖在此元素上时的光标样式 */
    cursor: string;
    /** 该元素是否忽略交互事件 */
    noEvent: boolean;
    get x(): number;
    get y(): number;
    /** 该元素的变换矩阵 */
    private _transform;
    set transform(value: Transform);
    get transform(): Transform;
    private _parent?;
    /** 当前元素的父元素 */
    get parent(): RenderItem<ERenderItemEvent> | undefined;
    /** 当前元素是否为根元素，如果是根元素，那么必须实现 `IRenderTreeRoot` 接口 */
    readonly isRoot: boolean;
    private _root?;
    get root(): (RenderItem<ERenderItemEvent> & IRenderTreeRoot) | undefined;
    /** 当前元素是否已经连接至任意根元素 */
    get connected(): boolean;
    /** 该渲染元素的子元素 */
    children: Set<RenderItem<ERenderItemEvent>>;
    /** 渲染缓存信息 */
    protected cache: MotaOffscreenCanvas2D;
    /** 是否需要更新缓存 */
    protected cacheDirty: boolean;
    /** 是否启用缓存机制 */
    readonly enableCache: boolean;
    /** 是否启用transform下穿机制，即画布的变换是否会继续作用到下一层画布 */
    readonly transformFallThrough: boolean;
    /** 这个渲染元素使用到的所有画布 */
    protected readonly canvases: Set<MotaOffscreenCanvas2D>;
    /** 这个渲染元素每个画布的配置信息 */
    private readonly canvasMap;
    /** 是否调用了 `ev.stopPropagation` */
    protected propagationStoped: Map<ActionType, boolean>;
    /** 捕获阶段缓存的事件对象 */
    private cachedEvent;
    /** 下穿模式下当前下穿过来的变换矩阵 */
    private fallTransform?;
    /** 是否在元素内 */
    private inElement;
    /** 鼠标标识符映射，键为按下的鼠标按键类型，值表示本次操作的唯一标识符，在按下、移动、抬起过程中保持一致 */
    protected mouseId: Map<MouseType, number>;
    /** 当前所有的触摸标识符 */
    readonly touchId: Set<number>;
    /** 是否需要禁用更新，如果出现更新，那么发出警告并停止更新操作 */
    private forbidUpdate;
    constructor(type: RenderItemPosition, enableCache?: boolean, transformFallThrough?: boolean);
    /**
     * 渲染函数
     * @param canvas 渲染至的画布
     * @param transform 当前变换矩阵的，渲染时已经进行变换处理，不需要对画布再次进行变换处理。
     *                  此参数可用于自己对元素进行变换处理，也会用于对子元素的处理。
     *                  例如对于`absolute`类型的元素，同时有对视角改变的需求，就可以通过此参数进行变换。
     *                  样板内置的`Layer`及`Damage`元素就是通过此方式实现的
     */
    protected abstract render(canvas: MotaOffscreenCanvas2D, transform: Transform): void;
    /**
     * 渲染当前对象
     * @param canvas 渲染至的画布
     * @param transform 由父元素传递过来的变换矩阵
     */
    renderContent(canvas: MotaOffscreenCanvas2D, transform: Transform): void;
    /**
     * 申请一个 `MotaOffscreenCanvas2D`，即申请一个画布
     * @param alpha 是否启用画布的 alpha 通道
     * @param autoScale 是否自动跟随缩放
     */
    requireCanvas(alpha?: boolean, autoScale?: boolean): MotaOffscreenCanvas2D;
    /**
     * 删除由 `requireCanvas` 申请的画布，当画布不再使用时，可以用该方法删除画布
     * @param canvas 要删除的画布
     */
    deleteCanvas(canvas: MotaOffscreenCanvas2D): void;
    onResize(scale: number): void;
    /**
     * 获取当前元素的缩放比，它与根元素应当保持一致
     */
    getScale(): number;
    /**
     * 修改这个对象的大小
     */
    size(width: number, height: number): void;
    /**
     * 设置这个元素的位置，等效于`transform.setTranslate(x, y)`
     * @param x 横坐标
     * @param y 纵坐标
     */
    pos(x: number, y: number): void;
    /**
     * 设置本元素的滤镜
     * @param filter 滤镜
     */
    setFilter(filter: string): void;
    /**
     * 设置本元素渲染时的混合方式
     * @param composite 混合方式
     */
    setComposite(composite: GlobalCompositeOperation): void;
    /**
     * 设置本元素的不透明度
     * @param alpha 不透明度
     */
    setAlpha(alpha: number): void;
    setHD(hd: boolean): void;
    setAntiAliasing(anti: boolean): void;
    setZIndex(zIndex: number): void;
    setAnchor(x: number, y: number): void;
    /**
     * 隐藏这个元素
     */
    hide(): void;
    /**
     * 显示这个元素
     */
    show(): void;
    /**
     * 获取当前元素的绝对位置（不建议使用，因为应当很少会有获取绝对位置的需求）
     */
    getAbsolutePosition(x?: number, y?: number): [number, number];
    /**
     * 获取到可以包围这个元素的最小矩形，相对于父元素
     */
    getBoundingRect(): DOMRectReadOnly;
    update(item?: RenderItem<any>): void;
    updateTransform(): void;
    requestBeforeFrame(fn: () => void): void;
    requestAfterFrame(fn: () => void): void;
    requestRenderFrame(fn: () => void): void;
    delegateTicker(fn: TickerFn, time?: number, end?: () => void): number;
    removeTicker(id: number, callEnd?: boolean): boolean;
    hasTicker(id: number): boolean;
    setRoot(item: RenderItem & IRenderTreeRoot): void;
    checkRoot(): RenderItem | null;
    /**
     * 刷新所有子元素
     */
    refreshAllChildren(): void;
    /**
     * 将这个渲染元素添加到其他父元素上
     * @param parent 父元素
     */
    appendTo(parent: RenderItem): void;
    /**
     * 从渲染树中移除这个节点
     * @returns 是否移除成功
     */
    remove(): boolean;
    /**
     * 添加子元素，默认没有任何行为且会抛出警告，你需要在自己的RenderItem继承类中复写它，才可以使用
     * @param child 子元素
     */
    appendChild(..._child: RenderItem<any>[]): void;
    /**
     * 移除子元素，默认没有任何行为且会抛出警告，你需要在自己的RenderItem继承类中复写它，才可以使用
     * @param child 子元素
     */
    removeChild(..._child: RenderItem<any>[]): void;
    /**
     * 申请对元素进行排序，默认没有任何行为且会抛出警告，你需要在自己的RenderItem继承类中复写它，才可以使用
     */
    requestSort(): void;
    /**
     * 根据事件类型和事件阶段获取事件名称
     * @param type 事件类型
     * @param progress 事件阶段
     */
    getEventName(type: ActionType, progress: EventProgress): keyof ERenderItemActionEvent;
    /**
     * 传递事件，即将事件传递给父元素或子元素等，可以通过 override 来实现自己的事件传递，
     * 例如 Container 元素就需要在捕获阶段将事件传递给所有子元素，
     * 默认行为是，捕获阶段触发自身冒泡，冒泡阶段触发父元素冒泡，适用于大部分不包含子元素的元素
     * @param type 事件类型
     * @param progress 事件阶段，捕获阶段或冒泡阶段
     * @param event 正在处理的事件对象
     */
    protected propagateEvent<T extends ActionType>(type: T, progress: EventProgress, event: ActionEventMap[T]): void;
    private handleEvent;
    /**
     * 捕获事件
     * @param type 事件类型
     * @param event 由父元素传递来的事件
     */
    captureEvent<T extends ActionType>(type: T, event: ActionEventMap[T]): ActionEventMap[T] | null;
    /**
     * 冒泡事件
     * @param type 事件类型
     * @param event 由子元素传递来的事件
     */
    bubbleEvent<T extends ActionType>(type: T, event: ActionEventMap[T]): ActionEventMap[T] | null;
    /**
     * 处理事件，用于根据上一级传递的事件内容生成新的事件内容，并执行一些事件的默认行为
     * @param type 事件类型
     * @param progress 事件阶段，捕获阶段还是冒泡阶段
     * @param event 由上一级（捕获阶段的父元素，冒泡阶段的子元素）传递来的事件内容
     */
    protected processEvent<T extends ActionType>(type: T, progress: EventProgress, event: ActionEventMap[T]): ActionEventMap[T] | null;
    /**
     * 处理捕获阶段的事件，可以通过 override 来添加新内容，注意调用 `super.processCapture` 来执行默认行为
     * @param type 事件类型
     * @param event 正在处理的事件对象
     * @param inElement 当前鼠标是否在元素内
     * @returns 是否继续传递事件
     */
    protected processCapture<T extends ActionType>(type: T, event: ActionEventMap[T], inElement: boolean): boolean;
    /**
     * 处理冒泡阶段的事件，可以通过 override 来添加新内容，注意调用 `super.processBubble` 来执行默认行为
     * @param type 事件类型
     * @param event 正在处理的事件对象
     * @param inElement 当前鼠标是否在元素内
     * @returns 是否继续传递事件
     */
    protected processBubble<T extends ActionType>(type: T, _event: ActionEventMap[T], inElement: boolean): boolean;
    /**
     * 计算一个点击事件在该元素上的位置
     * @param event 触发的事件
     * @param transform 当前的变换矩阵
     */
    protected calActionPosition(event: IActionEvent, transform: Transform): vec3;
    /**
     * 判断一个点击事件是否在元素内，可以通过 override 来修改其行为
     * @param x 横坐标
     * @param y 纵坐标
     */
    protected isActionInElement(x: number, y: number): boolean;
    actionClick(): void;
    actionDown(): void;
    actionUp(): void;
    actionMove(): void;
    actionEnter(): void;
    actionLeave(): void;
    actionWheel(): void;
    /**
     * 判断一个prop是否是期望类型
     * @param value 实际值
     * @param expected 期望类型
     * @param key 键名
     */
    protected assertType(value: any, expected: string, key: string): boolean;
    /**
     * 判断一个prop是否是期望类型
     * @param value 实际值
     * @param expected 期望类型
     * @param key 键名
     */
    protected assertType<T>(value: any, expected: new (...params: any[]) => T, key: string): value is T;
    /**
     * 解析事件key
     * @param key 键名
     * @returns 返回字符串表示解析后的键名，返回布尔值表示不是事件
     */
    protected parseEvent(key: string): string | false;
    /**
     * 自定义处理 props，自定义元素需要 override 此函数来处理 props
     * @param key 传入的 props 的键名
     * @param prevValue 这个 props 之前的值
     * @param nextValue 这个 props 传入的值
     * @returns 是否处理成功
     */
    protected handleProps(_key: string, _prevValue: any, _nextValue: any): boolean;
    patchProp(key: string, prevValue: any, nextValue: any, _namespace?: ElementNamespace, _parentComponent?: ComponentInternalInstance | null): void;
    /**
     * 摧毁这个渲染元素，摧毁后不应继续使用
     */
    destroy(): void;
}

export declare type RenderItemPosition = 'absolute' | 'static';

declare const enum RenderMode {
    Arrays = 0,
    Elements = 1,
    ArraysInstanced = 2,
    ElementsInstanced = 3
}

declare class RenderTagMap {
    private map;
    /**
     * 注册一个标签，每个标签对应一类元素，重复注册会覆盖之前的
     * @param tag 标签名称
     * @param ele 对应的元素类或其构造器
     */
    register<E extends ERenderItemEvent, T extends RenderItem<E>>(tag: string, onCreate: OnItemCreate<E, T>): void;
    /**
     * 获取一个标签对应的元素构造器
     * @param tag 标签名
     */
    get<E extends ERenderItemEvent, T extends RenderItem<E>>(tag: string): OnItemCreate<E, T> | undefined;
}

export declare class Shader<E extends EShaderEvent = EShaderEvent> extends GL2<EShaderEvent | E> {
    protected drawScene(canvas: MotaOffscreenCanvas2D, gl: WebGL2RenderingContext, program: GL2Program): void;
}

export declare class ShaderProgram extends GL2Program {
    protected readonly prefix: IGL2ProgramPrefix;
    constructor(gl2: GL2, vs?: string, fs?: string);
    ready(): boolean;
    protected compile(): boolean;
}

declare interface ShaderProgramEvent {
    load: [];
    unload: [];
}

export declare interface ShaderProps extends BaseProps {
}

export declare type SizedCanvasImageSource = Exclude<CanvasImageSource, VideoFrame | SVGElement>;

export declare class Sprite<E extends ESpriteEvent = ESpriteEvent> extends RenderItem<E> {
    renderFn: RenderFunction;
    /**
     * 创建一个精灵，可以自由在上面渲染内容
     * @param type 渲染模式，absolute表示绝对位置，不会跟随自身的Transform改变
     * @param cache 是否启用缓存机制
     */
    constructor(type?: RenderItemPosition, cache?: boolean, fall?: boolean);
    protected render(canvas: MotaOffscreenCanvas2D, transform: Transform): void;
    setRenderFn(fn: RenderFunction): void;
    protected handleProps(key: string, _prevValue: any, nextValue: any): boolean;
}

export declare interface SpriteProps extends BaseProps {
    /** 自定义的渲染函数 */
    render?: RenderFunction;
}

export declare const standardElement: (Item: new (type: RenderItemPosition, cache?: boolean, fall?: boolean) => RenderItem) => (_0: any, _1: any, props?: any) => RenderItem<ERenderItemEvent>;

export declare const standardElementNoCache: (Item: new (type: RenderItemPosition, cache?: boolean, fall?: boolean) => RenderItem) => (_0: any, _1: any, props?: any) => RenderItem<ERenderItemEvent>;

declare type SyncAdapterFunction<T> = (item: T, ...params: any[]) => any;

export declare type TagDefine<T extends object, E extends ERenderItemEvent> = T & MappingEvent<E> & ReservedProps;

export declare const tagMap: RenderTagMap;

declare class Text_2 extends RenderItem<ETextEvent> {
    text: string;
    fillStyle?: CanvasStyle_3;
    strokeStyle?: CanvasStyle_3;
    font: Font;
    strokeWidth: number;
    private length;
    private descent;
    private static measureCanvas;
    constructor(text?: string, type?: RenderItemPosition);
    protected render(canvas: MotaOffscreenCanvas2D, _transform: Transform): void;
    /**
     * 获取文字的长度
     */
    measure(): TextMetrics;
    /**
     * 设置显示文字
     * @param text 显示的文字
     */
    setText(text: string): void;
    /**
     * 设置使用的字体
     * @param font 字体
     */
    setFont(font: Font): void;
    /**
     * 设置字体样式
     * @param fill 填充样式
     * @param stroke 描边样式
     */
    setStyle(fill?: CanvasStyle_3, stroke?: CanvasStyle_3): void;
    /**
     * 设置描边宽度
     * @param width 宽度
     */
    setStrokeWidth(width: number): void;
    /**
     * 计算字体所占空间，从而确定这个元素的大小
     */
    calBox(): void;
    protected handleProps(key: string, _prevValue: any, nextValue: any): boolean;
}
export { Text_2 as Text }

export declare interface TextProps extends BaseProps {
    /** 要渲染的文字 */
    text?: string;
    /** 文字的填充样式 */
    fillStyle?: CanvasStyle_2;
    /** 文字的描边样式 */
    strokeStyle?: CanvasStyle_2;
    /** 文字的字体 */
    font?: Font;
    /** 文字的描边粗细 */
    strokeWidth?: number;
}

declare interface TickerDelegation {
    fn: TickerFn;
    timeout?: number;
    endFn?: () => void;
}

export declare class Transform {
    mat: mat3;
    x: number;
    y: number;
    scaleX: number;
    scaleY: number;
    rad: number;
    /** 有没有对这个Transform进行过修改，用于优化常规表现 */
    private modified;
    /** 绑定的可更新元素 */
    bindedObject?: ITransformUpdatable;
    /**
     * 对这个变换实例添加绑定对象，当矩阵变换时，自动调用其 update 函数
     * @param obj 要绑定的对象
     */
    bind(obj?: ITransformUpdatable): void;
    /**
     * 重设所有参数
     */
    reset(): void;
    /**
     * 修改缩放，叠加关系
     */
    scale(x: number, y?: number): this;
    /**
     * 移动，叠加关系
     */
    translate(x: number, y: number): this;
    /**
     * 旋转，叠加关系
     */
    rotate(rad: number): this;
    /**
     * 设置缩放，非叠加关系
     */
    setScale(x: number, y?: number): this;
    /**
     * 设置位置，非叠加关系
     */
    setTranslate(x: number, y: number): this;
    /**
     * 设置旋转，非叠加关系
     */
    setRotate(rad: number): this;
    /**
     * 设置变换矩阵，叠加模式
     * @param a 水平缩放
     * @param b 垂直倾斜
     * @param c 水平倾斜
     * @param d 垂直缩放
     * @param e 水平移动
     * @param f 垂直移动
     */
    transform(a: number, b: number, c: number, d: number, e: number, f: number): this;
    /**
     * 设置变换矩阵，非叠加模式
     * @param a 水平缩放
     * @param b 垂直倾斜
     * @param c 水平倾斜
     * @param d 垂直缩放
     * @param e 水平移动
     * @param f 垂直移动
     */
    setTransform(a: number, b: number, c: number, d: number, e: number, f: number): this;
    /**
     * 重新计算 translation scaling rotation
     */
    calAttributes(): void;
    /**
     * 与一个矩阵相乘，返回其计算结果（不改变原矩阵）
     * @param transform 变换矩阵
     */
    multiply(transform: Transform): Transform;
    /**
     * 复制这个变换矩阵
     */
    clone(): Transform;
    /**
     * 根据变换矩阵的信息，将一个点转换为计算后的位置
     * @param x 横坐标
     * @param y 纵坐标
     */
    transformed(x: number, y: number): vec3;
    /**
     * 根据变换矩阵的信息，将一个计算后的位置逆转换为原位置
     * @param x 横坐标
     * @param y 纵坐标
     */
    untransformed(x: number, y: number): vec3;
    /**
     * 根据变换矩阵的信息，将一个点转换为计算后的位置
     * @param transform 变换矩阵
     * @param x 横坐标
     * @param y 纵坐标
     */
    static transformed(transform: Transform, x: number, y: number): vec3;
    /**
     * 根据变换矩阵的信息，将一个计算后的位置逆转换为原位置
     * @param transform 变换矩阵
     * @param x 横坐标
     * @param y 纵坐标
     */
    static untransformed(transform: Transform, x: number, y: number): vec3;
    /** 单位矩阵 */
    static get identity(): Transform;
}

export declare class Transform3D {
    mat: mat4;
    /** 绑定的可更新元素 */
    bindedObject?: ITransformUpdatable;
    /**
     * 绑定可更新对象
     * @param obj 要绑定的对象
     */
    bind(obj?: ITransformUpdatable): void;
    /**
     * 重置为单位矩阵
     */
    reset(): this;
    /**
     * 应用缩放变换
     * @param x X轴缩放
     * @param y Y轴缩放
     * @param z Z轴缩放
     */
    scale(x: number, y: number, z: number): this;
    /**
     * 应用平移变换
     * @param x X轴平移
     * @param y Y轴平移
     * @param z Z轴平移
     */
    translate(x: number, y: number, z: number): this;
    /**
     * 应用旋转变换
     * @param rad 旋转角度（弧度）
     * @param axis 旋转轴
     */
    rotate(rad: number, axis: vec3): this;
    /**
     * 应用绕X轴旋转
     * @param rad 旋转角度（弧度）
     */
    rotateX(rad: number): this;
    /**
     * 应用绕Y轴旋转
     * @param rad 旋转角度（弧度）
     */
    rotateY(rad: number): this;
    /**
     * 应用绕Z轴旋转
     * @param rad 旋转角度（弧度）
     */
    rotateZ(rad: number): this;
    /**
     * 设置视图矩阵
     * @param eye 摄像机位置
     * @param center 目标位置
     * @param up 上方向量
     */
    lookAt(eye: vec3, center: vec3, up: vec3): this;
    /**
     * 设置透视投影矩阵
     * @param fovy 垂直视野角度（弧度）
     * @param aspect 宽高比
     * @param near 近平面
     * @param far 远平面
     */
    perspective(fovy: number, aspect: number, near: number, far: number): this;
    /**
     * 设置正交投影矩阵
     * @param left 左平面
     * @param right 右平面
     * @param bottom 底平面
     * @param top 顶平面
     * @param near 近平面
     * @param far 远平面
     */
    ortho(left: number, right: number, bottom: number, top: number, near: number, far: number): this;
    /**
     * 与另一个变换矩阵相乘
     * @param transform 另一个变换矩阵
     */
    multiply(transform: Transform3D): Transform3D;
    /**
     * 克隆当前变换矩阵
     */
    clone(): Transform3D;
    /**
     * 将点应用变换
     * @param point 要变换的点
     */
    transformed(point: vec3): vec3;
    /**
     * 将点应用逆变换
     * @param point 要逆变换的点
     */
    untransformed(point: vec3): vec3;
    /**
     * 静态方法：单位矩阵
     */
    static get identity(): Transform3D;
}

export declare function transformCanvas(canvas: MotaOffscreenCanvas2D, transform: Transform): void;

declare type TransitionUsing = [Transition];

declare type _U1 = [x0: number];

declare type _U2 = [x0: number, x1: number];

declare type _U3 = [x0: number, x1: number, x2: number];

declare type _U4 = [x0: number, x1: number, x2: number, x3: number];

export declare const enum UniformMatrix {
    UMatrix2x2 = 0,
    UMatrix2x3 = 1,
    UMatrix2x4 = 2,
    UMatrix3x2 = 3,
    UMatrix3x3 = 4,
    UMatrix3x4 = 5,
    UMatrix4x2 = 6,
    UMatrix4x3 = 7,
    UMatrix4x4 = 8
}

declare interface UniformSetFn {
    [UniformType.Uniform1f]: _U1;
    [UniformType.Uniform1fv]: _UV<Float32List>;
    [UniformType.Uniform1i]: _U1;
    [UniformType.Uniform1iv]: _UV<Int32List>;
    [UniformType.Uniform1ui]: _U1;
    [UniformType.Uniform1uiv]: _UV<Uint32List>;
    [UniformType.Uniform2f]: _U2;
    [UniformType.Uniform2fv]: _UV<Float32List>;
    [UniformType.Uniform2i]: _U2;
    [UniformType.Uniform2iv]: _UV<Int32List>;
    [UniformType.Uniform2ui]: _U2;
    [UniformType.Uniform2uiv]: _UV<Uint32List>;
    [UniformType.Uniform3f]: _U3;
    [UniformType.Uniform3fv]: _UV<Float32List>;
    [UniformType.Uniform3i]: _U3;
    [UniformType.Uniform3iv]: _UV<Int32List>;
    [UniformType.Uniform3ui]: _U3;
    [UniformType.Uniform3uiv]: _UV<Uint32List>;
    [UniformType.Uniform4f]: _U4;
    [UniformType.Uniform4fv]: _UV<Float32List>;
    [UniformType.Uniform4i]: _U4;
    [UniformType.Uniform4iv]: _UV<Int32List>;
    [UniformType.Uniform4ui]: _U4;
    [UniformType.Uniform4uiv]: _UV<Uint32List>;
}

export declare const enum UniformType {
    Uniform1f = 0,
    Uniform1fv = 1,
    Uniform1i = 2,
    Uniform1iv = 3,
    Uniform1ui = 4,
    Uniform1uiv = 5,
    Uniform2f = 6,
    Uniform2fv = 7,
    Uniform2i = 8,
    Uniform2iv = 9,
    Uniform2ui = 10,
    Uniform2uiv = 11,
    Uniform3f = 12,
    Uniform3fv = 13,
    Uniform3i = 14,
    Uniform3iv = 15,
    Uniform3ui = 16,
    Uniform3uiv = 17,
    Uniform4f = 18,
    Uniform4fv = 19,
    Uniform4i = 20,
    Uniform4iv = 21,
    Uniform4ui = 22,
    Uniform4uiv = 23
}

/**
 * 在组件中创建一个动画实例
 */
export declare function useAnimation(): AnimationUsing;

/**
 * 在组件中创建一个渐变实例
 */
export declare function useTransition(): TransitionUsing;

declare type _UV<T> = [data: T, srcOffset?: number, srcLength?: number];

export declare const enum WheelType {
    None = 0,
    /** 以像素为单位 */
    Pixel = 1,
    /** 以行为单位，每行长度视浏览器设置而定，约为 1rem */
    Line = 2,
    /** 以页为单位，一般为一个屏幕高度 */
    Page = 3
}

export declare type WrapEventEmitterEvents<T extends default_2.ValidEventTypes> = T extends string | symbol ? T : {
    [P in keyof T]: T[P] extends any[] ? (...args: T[P]) => void : (...args: any[]) => void;
};

export declare function wrapInstancedComponent<P extends BaseProps = BaseProps, E extends ERenderItemEvent = ERenderItemEvent, C extends RenderItem = RenderItem>(onCreate: (props: P) => C): _Define<P, E>;

export { }


declare module 'vue/jsx-runtime' {
    namespace JSX {
        interface IntrinsicElements {
            sprite: TagDefine<SpriteProps, ESpriteEvent>;
            container: TagDefine<ContainerProps, EContainerEvent>;
            'container-custom': TagDefine<ConatinerCustomProps, EContainerEvent>;
            shader: TagDefine<ShaderProps, EShaderEvent>;
            text: TagDefine<TextProps, ETextEvent>;
            image: TagDefine<ImageProps, EImageEvent>;
            comment: TagDefine<CommentProps, ERenderItemEvent>;
            custom: TagDefine<CustomProps, ERenderItemEvent>;
            'g-rect': TagDefine<RectProps, EGraphicItemEvent>;
            'g-circle': TagDefine<CirclesProps, EGraphicItemEvent>;
            'g-ellipse': TagDefine<EllipseProps, EGraphicItemEvent>;
            'g-line': TagDefine<LineProps, EGraphicItemEvent>;
            'g-bezier': TagDefine<BezierProps, EGraphicItemEvent>;
            'g-quad': TagDefine<QuadraticProps, EGraphicItemEvent>;
            'g-path': TagDefine<PathProps, EGraphicItemEvent>;
            'g-rectr': TagDefine<RectRProps, EGraphicItemEvent>;
        }
    }
}
