import { MessageApi } from 'ant-design-vue/lib/message';
import { TimingFn } from 'mutate-animate';
import { KeyCode } from './keyCodes';
import { KeyboardEmits } from '@/core/main/custom/keyboard';
type CanParseCss = keyof {
    [P in keyof CSSStyleDeclaration as CSSStyleDeclaration[P] extends string ? P extends string ? P : never : never]: CSSStyleDeclaration[P];
};
export default function init(): {
    has: typeof has;
    getDamageColor: typeof getDamageColor;
    parseCss: typeof parseCss;
    tip: typeof tip;
    changeLocalStorage: typeof changeLocalStorage;
};
/**
 * 判定一个值是否不是undefined或null
 * @param value 要判断的值
 */
export declare function has<T>(value: T): value is NonNullable<T>;
/**
 * 根据伤害大小获取颜色
 * @param damage 伤害大小
 */
export declare function getDamageColor(damage: number): Color;
/**
 * 设置画布的长宽
 * @param canvas 画布
 * @param w 宽度
 * @param h 高度
 */
export declare function setCanvasSize(canvas: HTMLCanvasElement, w: number, h: number): void;
/**
 * 获取事件中的keycode对应的键
 * @param key 要获取的键
 */
export declare function keycode(key: number): KeyCode;
/**
 * 解析css字符串为CSSStyleDeclaration对象
 * @param css 要解析的css字符串
 */
export declare function parseCss(css: string): Partial<Record<CanParseCss, string>>;
/**
 * 使用打字机效果显示一段文字
 * @param str 要打出的字符串
 * @param time 打出总用时，默认1秒，当第四个参数是true时，该项为每个字的平均时间
 * @param timing 打出时的速率曲线，默认为线性变化
 * @param avr 是否将第二个参数视为每个字的平均时间
 * @returns 文字的响应式变量
 */
export declare function type(str: string, time?: number, timing?: TimingFn, avr?: boolean): Ref<string>;
export declare function tip(type: Exclude<keyof MessageApi, 'open' | 'config' | 'destroy'>, text: string): void;
/**
 * 设置文字分段换行等
 * @param str 文字
 */
export declare function splitText(str: string[]): string;
/**
 * 在下一帧执行某个函数
 * @param cb 执行的函数
 */
export declare function nextFrame(cb: (time: number) => void): void;
/**
 * 下载一个画布对应的图片
 * @param canvas 画布
 * @param name 图片名称
 */
export declare function downloadCanvasImage(canvas: HTMLCanvasElement, name: string): void;
/**
 * 下载一个文件
 * @param content 下载的内容
 * @param name 文件名称
 */
export declare function download(content: string, name: string): void;
/**
 * 间隔一段时间调用一个函数
 * @param funcs 函数列表
 * @param interval 调用间隔
 */
export declare function doByInterval(funcs: (() => void)[], interval: number, awaitFirst?: boolean): Promise<void>;
/**
 * 更改一个本地存储
 * @deprecated
 * @param name 要更改的信息
 * @param fn 更改时执行的函数
 * @param defaultValue 如果不存在时获取的默认值
 */
export declare function changeLocalStorage<T>(name: string, fn: (data: T) => T, defaultValue?: T): void;
export declare function ensureArray<T>(arr: T): T extends any[] ? T : T[];
export declare function pColor(color: string): Color;
/**
 * 删除数组内的某个项，返回删除后的数组
 * @param arr 要操作的数组
 * @param ele 要删除的项
 */
export declare function deleteWith<T>(arr: T[], ele: T): T[];
export declare function spliceBy<T>(arr: T[], from: T): T[];
export declare function triggerFullscreen(full: boolean): Promise<void>;
/**
 * 根据布尔值数组转换成一个二进制数
 * @param arr 要转换的布尔值数组
 */
export declare function generateBinary(arr: boolean[]): number;
/**
 * 获得某个状态的中文名
 * @param name 要获取的属性名
 */
export declare function getStatusLabel(name: string): string;
export declare function flipBinary(num: number, col: number): number;
/**
 * 唤起虚拟键盘，并获取到一次按键操作
 * @param emitAssist 是否可以获取辅助按键，为true时，如果按下辅助按键，那么会立刻返回该按键，
 *                   否则会视为开关辅助按键
 * @param assist 初始化的辅助按键
 */
export declare function getVitualKeyOnce(emitAssist?: boolean, assist?: number, emittable?: KeyCode[]): Promise<KeyboardEmits>;
export {};
