interface ClsMap {
    tools: '消耗道具';
    constants: '永久道具';
    all: '全部道具';
}
interface AllItem {
    tools: [ItemIdOf<'tools'>, number][];
    constants: [ItemIdOf<'constants'>, number][];
}
/**
 * 根据道具的cls获取中文类型
 * @param cls 道具的cls
 */
export declare function getClsName<T extends keyof ClsMap | 'all'>(cls: T): ClsMap[T];
/**
 * 获取某个类型的所有道具
 * @param cls 道具类型
 */
export declare function getItems(cls: 'all'): AllItem;
export declare function getItems(cls: keyof ClsMap): [string, number][];
export {};
