type BFSFromString = `${FloorIds},${number},${number},${Dir}`;
type BFSToString = `${FloorIds},${number},${number}`;
interface MapBFSResult {
    maps: FloorIds[];
    link: Record<BFSFromString, BFSToString>;
}
interface MapDrawData {
    locs: Partial<Record<FloorIds, LocArr>>;
    line: [number, number, number, number][];
    width: number;
    height: number;
}
/**
 * 切分地图区域
 */
export declare function splitArea(): void;
export declare function getArea(): Record<string, FloorIds[]>;
/**
 * 获取地图绘制信息
 * @param floorId 中心楼层
 * @param interval 地图间距
 * @param border 边框宽度
 * @param noCache 是否不使用缓存
 */
export declare function getMapDrawData(floorId: FloorIds, interval?: number, border?: number, noCache?: boolean): MapDrawData;
/**
 * 广度优先搜索地图信息
 * @param floorId 中心楼层id
 * @param noCache 是否不使用缓存
 */
export declare function getMapData(floorId: FloorIds, noCache?: boolean): MapBFSResult;
export {};
