import type { DamageEnemy } from '../game/enemy/damage';
import { Ref } from 'vue';
export interface MarkInfo<T extends EnemyIds> {
    id: T;
    enemy: DamageEnemy<T>;
    /**
     * 提示模式，从低到高位数分别为：
     * 1. 踩临界时
     * 2. 能打过怪物时
     * 3. 小于勇士生命值的2/3时
     * 4. 小于勇士生命值的1/3时
     * 5. 零伤时
     * 6. 小于指定伤害时
     */
    mode: number;
    /** 当前提示状态，提示模式的 2-6 */
    status: number;
    lastAtk: number;
    lastDamage: number;
    markDamage?: number;
    /** 数据更新用，取反更新标记信息 */
    update: Ref<boolean>;
}
/**
 * 标记一个怪物，标记后的怪物会在勇士刚好能打过怪物时、伤害刚好小于勇士生命值的2/3和1/3时、踩到临界时提示
 * @param id 标记的怪物id
 */
export declare function markEnemy(id: EnemyIds): void;
export declare function unmarkEnemy(id: EnemyIds): void;
export declare function checkMarkedEnemy(): void;
export declare function hasMarkedEnemy(id: EnemyIds): boolean;
