import { Layout } from './layout';
export declare class LayoutGame extends Layout {
    /** 画布id */
    id: string;
    constructor(id: string, x: number, y: number, w: number, h: number, z: number);
    image2(layout: Layout | CanvasImageSource | Path2D | ImageIds, type: number): LayoutGame;
    image2(layout: Layout | CanvasImageSource | Path2D | ImageIds, type: number, x: number, y: number): LayoutGame;
    image2(layout: Layout | CanvasImageSource | Path2D | ImageIds, type: number, x: number, y: number, w: number, h: number): LayoutGame;
    image2(layout: Layout | CanvasImageSource | Path2D | ImageIds, type: number, sx: number, sy: number, sw: number, sh: number, dx: number, dy: number, dw: number, dh: number): LayoutGame;
    /**
     * 绘制一个图标
     * @param id 图标id
     * @param x 横坐标
     * @param y 纵坐标
     * @param w 宽度
     * @param h 高度
     * @param frame 绘制第几帧
     */
    icon(id: AllIds, x: number, y: number, w?: number, h?: number, frame?: number): this;
    /**
     * 绘制WindowSkin
     * @param direction 指向箭头的方向
     */
    winskin(background: any, x: number, y: number, w: number, h: number, direction?: 'up' | 'down', px?: number, py?: number): this;
    /**
     * 绘制一个箭头
     * @param x1 起始点横坐标
     * @param y1 起始点纵坐标
     * @param x2 终止点横坐标
     * @param y2 终止点纵坐标
     */
    arrow(x1: number, y1: number, x2: number, y2: number): this;
    /**
     * 绘制线段
     */
    line(x1: number, y1: number, x2: number, y2: number): this;
    /**
     * 绘制圆弧或扇形
     * @param type 绘制类型
     * @param start 起始弧度
     * @param end 终止弧度
     * @param anticlockwise 是否逆时针
     */
    arc(type: number, x: number, y: number, r: number, start: number, end: number, anticlockwise?: boolean): this;
    /**
     * 绘制一个圆
     * @param type 绘制类型
     */
    circle(type: number, x: number, y: number, r: number): this;
    /**
     * 绘制椭圆
     */
    ellipse(type: number, x: number, y: number, a: number, b: number, rotation?: number, start?: number, end?: number, anticlockwise?: boolean): this;
    /**
     * 绘制多边形
     * @param type 绘制类型
     * @param nodes 多边形节点
     * @param close 是否闭合路径
     */
    polygon(type: number, nodes: LocArr[], close?: boolean): this;
    /**
     * 绘制矩形
     */
    rect(type: number, x: number, y: number, w: number, h: number): this;
    /**
     * 绘制圆角矩形
     */
    roundRect(type: number, x: number, y: number, w: number, h: number, r: number): void;
    /**
     * 删除这个布局
     */
    destroy(): void;
    private draw;
}
