export default function init(): {
    createGaussNoise: typeof createGaussNoise;
};
interface GaussNoiseConfig {
    /** 分辨率，最小为1，最大为画布长宽的最大值，默认为画布长宽最大值的一半，过大可能会卡顿 */
    resolution?: number;
    /** 画布宽度 */
    width?: number;
    /** 画布高度 */
    height?: number;
    /** 噪声灰度的均值，范围 0 ~ 255 */
    expectation: number;
    /** 噪声灰度方差 */
    deviation: number;
    /** 目标画布，如果不指定会创建一个新的 */
    canvas?: HTMLCanvasElement;
}
/**
 * 创建一个高斯噪声
 * @param config 噪声选项
 * @returns 噪声画布
 */
export declare function createGaussNoise(config: GaussNoiseConfig): HTMLCanvasElement;
export {};
