/**
 * 获取勇士在某一点的属性
 * @param name 要获取的勇士属性
 * @param floorId 勇士所在楼层
 */
export declare function getHeroStatusOn(name: 'all', floorId?: FloorIds): HeroStatus;
export declare function getHeroStatusOn(name: (keyof HeroStatus)[], floorId?: FloorIds): Partial<HeroStatus>;
export declare function getHeroStatusOn<K extends keyof HeroStatus>(name: K, floorId?: FloorIds): HeroStatus[K];
/**
 * 获取一定状态下的勇士在某一点的属性
 * @param status 勇士的状态
 * @param name 要获取的勇士属性
 * @param floorId 勇士所在楼层
 */
export declare function getHeroStatusOf(status: Partial<HeroStatus>, name: 'all', floorId?: FloorIds): HeroStatus;
export declare function getHeroStatusOf(status: Partial<HeroStatus>, name: (keyof HeroStatus)[], floorId?: FloorIds): Partial<HeroStatus>;
export declare function getHeroStatusOf<K extends keyof HeroStatus>(status: Partial<HeroStatus>, name: K, floorId?: FloorIds): HeroStatus[K];
