import { Range, RangeCollection } from '@/plugin/game/range';
interface HaloType {
    square: {
        x: number;
        y: number;
        d: number;
    };
    manhattan: {
        x: number;
        y: number;
        d: number;
    };
}
interface EnemyInfo extends Partial<Enemy> {
    atk: number;
    def: number;
    hp: number;
    special: number[];
    atkBuff_: number;
    defBuff_: number;
    hpBuff_: number;
    enemy: Enemy;
    guard?: DamageEnemy[];
    x?: number;
    y?: number;
    floorId?: FloorIds;
}
interface DamageInfo {
    damage: number;
}
interface MapDamage {
    damage: number;
    type: Set<string>;
    repulse?: LocArr[];
    ambush?: DamageEnemy[];
}
interface HaloData<T extends keyof HaloType = keyof HaloType> {
    type: T;
    data: HaloType[T];
    special: number;
    from?: DamageEnemy;
}
interface DamageDelta {
    /** 跟最小伤害值的减伤 */
    delta: number;
    damage: number;
    info: DamageInfo;
}
interface CriticalDamageDelta extends Omit<DamageDelta, 'info'> {
    /** 勇士的攻击增量 */
    atkDelta: number;
}
type HaloFn = (info: EnemyInfo, enemy: EnemyInfo) => void;
export declare class EnemyCollection implements RangeCollection<DamageEnemy> {
    floorId: FloorIds;
    list: DamageEnemy[];
    range: Range<DamageEnemy>;
    mapDamage: Record<string, MapDamage>;
    haloList: HaloData[];
    constructor(floorId: FloorIds);
    get(x: number, y: number): DamageEnemy<"greenSlime" | "redSlime" | "blackSlime" | "slimelord" | "bat" | "bigBat" | "redBat" | "vampire" | "skeleton" | "skeletonWarrior" | "skeletonCaptain" | "ghostSoldier" | "zombie" | "zombieKnight" | "rock" | "slimeman" | "bluePriest" | "redPriest" | "brownWizard" | "redWizard" | "yellowGateKeeper" | "blueGateKeeper" | "redGateKeeper" | "swordsman" | "soldier" | "yellowKnight" | "redKnight" | "darkKnight" | "blackKing" | "yellowKing" | "greenKing" | "blueKnight" | "goldSlime" | "poisonSkeleton" | "poisonBat" | "ironRock" | "skeletonPriest" | "skeletonKing" | "skeletonPresbyter" | "skeletonKnight" | "evilHero" | "devilWarrior" | "demonPriest" | "goldHornSlime" | "redKing" | "blueKing" | "magicMaster" | "silverSlime" | "blademaster" | "whiteHornSlime" | "evilPrincess" | "evilFairy" | "yellowPriest" | "redSwordsman" | "whiteSlimeman" | "poisonZombie" | "dragon" | "octopus" | "fairyEnemy" | "princessEnemy" | "angel" | "elemental" | "steelGuard" | "evilBat" | "silverSlimelord" | "goldSlimelord" | "grayRock" | "greenKnight" | "bowman" | "purpleBowman" | "watcherSlime" | "frostBat" | "devilKnight" | "grayPriest" | "greenGateKeeper" | "keiskeiFairy" | "tulipFairy" | "bearDown" | "bearLeft" | "bearRight" | "bearUp"> | undefined;
    /**
     * 解析本地图的怪物信息
     */
    extract(): void;
    /**
     * 计算怪物真实属性
     */
    calRealAttribute(): void;
    /**
     * @deprecated
     * 计算怪物伤害
     * @param noCache 是否不使用缓存
     */
    calDamage(noCache?: boolean): void;
    /**
     * 计算地图伤害
     */
    calMapDamage(): void;
    /**
     * 向怪物施加光环
     * @param type 光环的范围类型
     * @param data 光环范围信息
     * @param halo 光环效果函数
     * @param recursion 是否递归施加，只有在光环预平衡阶段会使用到
     */
    applyHalo<K extends keyof HaloType>(type: K, data: HaloType[K], enemy: DamageEnemy, halo: HaloFn | HaloFn[], recursion?: boolean): void;
    /**
     * 预平衡光环
     */
    preBalanceHalo(): void;
    render(onMap?: boolean, cal?: boolean): void;
}
export declare class DamageEnemy<T extends EnemyIds = EnemyIds> {
    id: T;
    x?: number;
    y?: number;
    floorId?: FloorIds;
    enemy: Enemy<T>;
    col?: EnemyCollection;
    /**
     * 怪物属性。
     * 属性计算流程：预平衡光环(即计算加光环的光环怪的光环) -> 计算怪物在没有光环下的属性
     * -> provide inject 光环 -> 计算怪物的光环加成 -> 计算完毕
     */
    info: EnemyInfo;
    /** 向其他怪提供过的光环 */
    providedHalo: Set<number>;
    /**
     * 伤害计算进度，0 -> 预平衡光环 -> 1 -> 计算没有光环的属性 -> 2 -> provide inject 光环
     * -> 3 -> 计算光环加成 -> 4 -> 计算完毕
     */
    private progress;
    constructor(enemy: Enemy<T>, x?: number, y?: number, floorId?: FloorIds, col?: EnemyCollection);
    reset(): void;
    /**
     * 计算怪物在不计光环下的属性，在inject光环之前，预平衡光环之后执行
     */
    calAttribute(): void;
    /**
     * 获取怪物的真实属性信息，在inject光环后执行
     */
    getRealInfo(): EnemyInfo;
    getHaloSpecials(): number[];
    /**
     * 光环预提供，用于平衡所有怪的光环属性，避免出现不同情况下光环效果不一致的现象
     */
    preProvideHalo(): void;
    /**
     * 向其他怪提供光环
     */
    provideHalo(): void;
    /**
     * 接受其他怪的光环
     */
    injectHalo(halo: HaloFn, enemy: EnemyInfo): void;
    /**
     * 计算怪物伤害
     */
    calDamage(hero?: Partial<HeroStatus>): {
        damage: number;
    };
    /**
     * 计算地图伤害
     * @param damage 存入的对象
     */
    calMapDamage(damage?: Record<string, MapDamage>, hero?: Partial<HeroStatus>): Record<string, MapDamage>;
    setMapDamage(damage: Record<string, MapDamage>, loc: string, dam: number, type?: string): void;
    private calEnemyDamageOf;
    /**
     * 计算怪物临界
     * @param num 要计算多少个临界
     * @param hero 勇士属性，最终结果将会与由此属性计算出的伤害相减计算减伤
     */
    calCritical(num?: number, hero?: Partial<HeroStatus>): CriticalDamageDelta[];
    /**
     * 二分计算怪物临界
     * @param num 计算的临界数量
     * @param min 当前怪物伤害最小值
     * @param seckill 秒杀怪物时的攻击
     * @param hero 勇士真实属性
     */
    private calCriticalWith;
    /**
     * 计算n防减伤
     * @param num 要加多少防御
     * @param hero 勇士属性，最终结果将会与由此属性计算出的伤害相减计算减伤
     */
    calDefDamage(num?: number, hero?: Partial<HeroStatus>): DamageDelta;
    /**
     * 获取怪物秒杀时所需的攻击
     */
    getSeckillAtk(): number;
}
export declare namespace Damage {
    /** 光环属性 */
    const haloSpecials: Set<number>;
    /** 会被第一类光环修改的怪物特殊属性数值 */
    const changeableHaloValue: Map<number, SelectKey<Enemy, number | undefined>[]>;
    /**
     * 计算伤害时会用到的勇士属性，攻击防御，其余的不会有buff加成，直接从core.status.hero取
     */
    let realStatus: (keyof HeroStatus)[];
    /**
     * 计算怪物伤害
     * @param info 怪物信息
     * @param hero 勇士信息
     */
    function calDamageWith(info: DeepReadonly<EnemyInfo>, hero: DeepReadonly<Partial<HeroStatus>>): number | null;
    function ensureFloorDamage(floorId: FloorIds): void;
    function getSingleEnemy(id: EnemyIds): DamageEnemy<"greenSlime" | "redSlime" | "blackSlime" | "slimelord" | "bat" | "bigBat" | "redBat" | "vampire" | "skeleton" | "skeletonWarrior" | "skeletonCaptain" | "ghostSoldier" | "zombie" | "zombieKnight" | "rock" | "slimeman" | "bluePriest" | "redPriest" | "brownWizard" | "redWizard" | "yellowGateKeeper" | "blueGateKeeper" | "redGateKeeper" | "swordsman" | "soldier" | "yellowKnight" | "redKnight" | "darkKnight" | "blackKing" | "yellowKing" | "greenKing" | "blueKnight" | "goldSlime" | "poisonSkeleton" | "poisonBat" | "ironRock" | "skeletonPriest" | "skeletonKing" | "skeletonPresbyter" | "skeletonKnight" | "evilHero" | "devilWarrior" | "demonPriest" | "goldHornSlime" | "redKing" | "blueKing" | "magicMaster" | "silverSlime" | "blademaster" | "whiteHornSlime" | "evilPrincess" | "evilFairy" | "yellowPriest" | "redSwordsman" | "whiteSlimeman" | "poisonZombie" | "dragon" | "octopus" | "fairyEnemy" | "princessEnemy" | "angel" | "elemental" | "steelGuard" | "evilBat" | "silverSlimelord" | "goldSlimelord" | "grayRock" | "greenKnight" | "bowman" | "purpleBowman" | "watcherSlime" | "frostBat" | "devilKnight" | "grayPriest" | "greenGateKeeper" | "keiskeiFairy" | "tulipFairy" | "bearDown" | "bearLeft" | "bearRight" | "bearUp">;
}
declare global {
    interface Floor {
        enemy: EnemyCollection;
    }
}
export {};
