var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。


	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作，比如切分图片等。

		// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
		// var arr = core.splitImage("assets.png", 32, 32);
		// for (var i = 0; i < arr.length; i++) {
		//     core.material.images.images["asset"+i+".png"] = arr[i];
		// }
		core.setOpacity("fg", 0.5);

	}

	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
},
    "itemShop": function () {
	// 道具商店相关的插件
	// 可在全塔属性-全局商店中使用「道具商店」事件块进行编辑（如果找不到可以在入口方块中找）

	var shopId = null; // 当前商店ID
	var type = 0; // 当前正在选中的类型，0买入1卖出
	var selectItem = 0; // 当前正在选中的道具
	var selectCount = 0; // 当前已经选中的数量
	var page = 0;
	var totalPage = 0;
	var totalMoney = 0;
	var list = [];

	var bigFont = core.ui._buildFont(20, false),
		middleFont = core.ui._buildFont(18, false);

	this.drawItemShop = function () {
		// 绘制道具商店

		// Step 1: 背景和固定的几个文字
		core.ui._createUIEvent();
		core.clearMap('uievent');
		core.ui._uievent_drawSelector({ "code": 1 });
		core.ui._uievent_drawSelector({ "code": 2 });
		core.setTextAlign('uievent', 'left');
		core.setTextBaseline('uievent', 'top');
		core.fillRect('uievent', 0, 0, 416, 416, 'black');
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 0, y: 0, width: 416, height: 56 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 0, y: 56, width: 312, height: 56 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 0, y: 112, width: 312, height: 304 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 312, y: 56, width: 104, height: 56 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 312, y: 112, width: 104, height: 304 });
		core.setFillStyle('uievent', 'white');
		core.setStrokeStyle('uievent', 'white');
		core.fillText("uievent", "购买", 32, 74, 'white', bigFont);
		core.fillText("uievent", "卖出", 132, 74);
		core.fillText("uievent", "离开", 232, 74);
		core.fillText("uievent", "当前金币", 324, 66, null, middleFont);
		core.setTextAlign("uievent", "right");
		core.fillText("uievent", core.formatBigNumber(core.status.hero.money), 405, 89);
		core.setTextAlign("uievent", "left");
		core.ui._uievent_drawSelector({
			"type": "drawSelector",
			"image": "winskin.png",
			"code": 2,
			"x": 22 + 100 * type,
			"y": 66,
			"width": 60,
			"height": 33
		});
		if (selectItem != null) {
			core.setTextAlign('uievent', 'center');
			core.fillText("uievent", type == 0 ? "买入个数" : "卖出个数", 364, 320, null, bigFont);
			core.fillText("uievent", "◀   " + selectCount + "   ▶", 364, 350);
			core.fillText("uievent", "确定", 364, 380);
		}

		// Step 2：获得列表并展示
		var choices = core.status.shops[shopId].choices;
		list = choices.filter(function (one) {
			if (one.condition != null) {
				try { if (!core.calValue(one.condition)) return false; } catch (e) {}
			}
			return (type == 0 && one.money != null) || (type == 1 && one.sell != null);
		});
		var per_page = 6;
		totalPage = Math.ceil(list.length / per_page);
		page = Math.floor((selectItem || 0) / per_page) + 1;

		// 绘制分页
		if (totalPage > 1) {
			var half = 156;
			core.setTextAlign('uievent', 'center');
			core.fillText('uievent', page + " / " + totalPage, half, 388, null, middleFont);
			if (page > 1) core.fillText('uievent', '上一页', half - 80, 388);
			if (page < totalPage) core.fillText('uievent', '下一页', half + 80, 388);
		}
		core.setTextAlign('uievent', 'left');

		// 绘制每一项
		var start = (page - 1) * per_page;
		for (var i = 0; i < per_page; ++i) {
			var curr = start + i;
			if (curr >= list.length) break;
			var item = list[curr];
			core.drawIcon('uievent', item.id, 10, 125 + i * 40);
			core.setTextAlign('uievent', 'left');
			core.fillText('uievent', core.material.items[item.id].name, 50, 132 + i * 40, null, bigFont);
			core.setTextAlign('uievent', 'right');
			core.fillText('uievent', (type == 0 ? core.calValue(item.money) : core.calValue(item.sell)) + "金币/个", 300, 133 + i * 40, null, middleFont);
			core.setTextAlign("uievent", "left");
			if (curr == selectItem) {
				// 绘制描述，文字自动放缩
				var text = core.material.items[item.id].text || "该道具暂无描述";
				try { text = core.replaceText(text); } catch (e) {}
				for (var fontSize = 20; fontSize >= 8; fontSize -= 2) {
					var config = { left: 10, fontSize: fontSize, maxWidth: 403, lineHeight: 1.4 };
					var height = core.getTextContentHeight(text, config);
					if (height <= 50) {
						config.top = (56 - height) / 2;
						core.drawTextContent("uievent", text, config);
						break;
					}
				}
				core.ui._uievent_drawSelector({ "type": "drawSelector", "image": "winskin.png", "code": 1, "x": 8, "y": 120 + i * 40, "width": 295, "height": 40 });
				if (type == 0 && item.number != null) {
					core.fillText("uievent", "存货", 324, 132, null, bigFont);
					core.setTextAlign("uievent", "right");
					core.fillText("uievent", item.number, 406, 132, null, null, 40);
				} else if (type == 1) {
					core.fillText("uievent", "数量", 324, 132, null, bigFont);
					core.setTextAlign("uievent", "right");
					core.fillText("uievent", core.itemCount(item.id), 406, 132, null, null, 40);
				}
				core.setTextAlign("uievent", "left");
				core.fillText("uievent", "预计金额", 324, 250);
				core.setTextAlign("uievent", "right");
				totalMoney = selectCount * (type == 0 ? core.calValue(item.money) : core.calValue(item.sell));
				core.fillText("uievent", core.formatBigNumber(totalMoney), 405, 280);

				core.setTextAlign("uievent", "left");
				core.fillText("uievent", type == 0 ? "已购次数" : "已卖次数", 324, 170);
				core.setTextAlign("uievent", "right");
				core.fillText("uievent", (type == 0 ? item.money_count : item.sell_count) || 0, 405, 200);
			}
		}

		core.setTextAlign('uievent', 'left');
		core.setTextBaseline('uievent', 'alphabetic');
	}

	var _add = function (item, delta) {
		if (item == null) return;
		selectCount = core.clamp(
			selectCount + delta, 0,
			Math.min(type == 0 ? Math.floor(core.status.hero.money / core.calValue(item.money)) : core.itemCount(item.id),
				type == 0 && item.number != null ? item.number : Number.MAX_SAFE_INTEGER)
		);
	}

	var _confirm = function (item) {
		if (item == null || selectCount == 0) return;
		if (type == 0) {
			core.status.hero.money -= totalMoney;
			core.getItem(item.id, selectCount);
			if (item.number != null) item.number -= selectCount;
			item.money_count = (item.money_count || 0) + selectCount;
		} else {
			core.status.hero.money += totalMoney;
			core.removeItem(item.id, selectCount);
			core.drawTip("成功卖出" + selectCount + "个" + core.material.items[item.id].name, item.id);
			if (item.number != null) item.number += selectCount;
			item.sell_count = (item.sell_count || 0) + selectCount;
		}
		selectCount = 0;
	}

	this._performItemShopKeyBoard = function (keycode) {
		var item = list[selectItem] || null;
		// 键盘操作
		switch (keycode) {
		case 38: // up
			if (selectItem == null) break;
			if (selectItem == 0) selectItem = null;
			else selectItem--;
			selectCount = 0;
			break;
		case 37: // left
			if (selectItem == null) {
				if (type > 0) type--;
				break;
			}
			_add(item, -1);
			break;
		case 39: // right
			if (selectItem == null) {
				if (type < 2) type++;
				break;
			}
			_add(item, 1);
			break;
		case 40: // down
			if (selectItem == null) {
				if (list.length > 0) selectItem = 0;
				break;
			}
			if (list.length == 0) break;
			selectItem = Math.min(selectItem + 1, list.length - 1);
			selectCount = 0;
			break;
		case 13:
		case 32: // Enter/Space
			if (selectItem == null) {
				if (type == 2)
					core.insertAction({ "type": "break" });
				else if (list.length > 0)
					selectItem = 0;
				break;
			}
			_confirm(item);
			break;
		case 27: // ESC
			if (selectItem == null) {
				core.insertAction({ "type": "break" });
				break;
			}
			selectItem = null;
			break;
		}
	}

	this._performItemShopClick = function (px, py) {
		var item = list[selectItem] || null;
		// 鼠标操作
		if (px >= 22 && px <= 82 && py >= 71 && py <= 102) {
			// 买
			if (type != 0) {
				type = 0;
				selectItem = null;
				selectCount = 0;
			}
			return;
		}
		if (px >= 122 && px <= 182 && py >= 71 && py <= 102) {
			// 卖
			if (type != 1) {
				type = 1;
				selectItem = null;
				selectCount = 0;
			}
			return;
		}
		if (px >= 222 && px <= 282 && py >= 71 && py <= 102) // 离开
			return core.insertAction({ "type": "break" });
		// ◀，▶
		if (px >= 318 && px <= 341 && py >= 348 && py <= 376)
			return _add(item, -1);
		if (px >= 388 && px <= 416 && py >= 348 && py <= 376)
			return _add(item, 1);
		// 确定
		if (px >= 341 && px <= 387 && py >= 380 && py <= 407)
			return _confirm(item);

		// 上一页/下一页
		if (px >= 45 && px <= 105 && py >= 388) {
			if (page > 1) selectItem -= 6;
			return;
		}
		if (px >= 208 && px <= 268 && py >= 388) {
			if (page < totalPage) selectItem = Math.min(selectItem + 6, list.length - 1);
			return;
		}

		// 实际区域
		if (px >= 9 && px <= 300 && py >= 120 && py < 360) {
			if (list.length == 0) return;
			var index = parseInt((py - 120) / 40);
			var newItem = 6 * (page - 1) + index;
			if (newItem >= list.length) newItem = list.length - 1;
			if (newItem != selectItem) {
				selectItem = newItem;
				selectCount = 0;
			}
			return;
		}
	}

	this.performItemShopAction = function () {
		if (flags.type == 0) return this._performItemShopKeyBoard(flags.keycode);
		else return this._performItemShopClick(flags.px, flags.py);
	}

	this.openItemShop = function (itemShopId) {
		shopId = itemShopId;
		type = 0;
		page = 0;
		selectItem = null;
		selectCount = 0;
		core.insertAction([{
				"type": "while",
				"condition": "true",
				"data": [
					{ "type": "function", "function": "function () { core.drawItemShop(); }" },
					{ "type": "wait" },
					{ "type": "function", "function": "function() { core.performItemShopAction(); }" }
				]
			},
			{ "type": "function", "function": "function () { " +
					"core.deleteCanvas('uievent'); " +
					"core.ui._uievent_drawSelector({ \"code\": 1 }); " +
					"core.ui._uievent_drawSelector({ \"code\": 2 }); " +
					"}" }
		]);
	}

	// Write item number to save
	core.control.saveData = function () {
		var data = this.controldata.saveData();
		for (var shopId in core.status.shops) {
			if (core.status.shops[shopId].item) {
				data.shops[shopId].choices = core.status.shops[shopId].choices.map(function (t) {
					return {
						number: t.number,
						money_count: t.money_count || 0,
						sell_count: t.sell_count || 0
					}
				});
			}
		}
		return data;
	}

	core.control.loadData = function (data, callback) {
		this.controldata.loadData(data, callback);
		for (var shopId in data.shops) {
			if (data.shops[shopId].choices) {
				for (var i = 0; i < data.shops[shopId].choices.length; ++i) {
					core.status.shops[shopId].choices[i].number = data.shops[shopId].choices[i].number;
					core.status.shops[shopId].choices[i].money_count = data.shops[shopId].choices[i].money_count;
					core.status.shops[shopId].choices[i].sell_count = data.shops[shopId].choices[i].sell_count;
				}
			}
		}
	}

},
    "smoothCamera": function () {

    // 是否启用本插件，默认不启用
	this.__enableSmoothCamera = false;
	if (!this.__enableSmoothCamera) return;

	this.Camera = function () {

		// 下面这个变量决定本插件的开关
		// 你可以在游戏中使用core.setFlag('smoothCamera',false)来关闭本插件的功能
		// 同时也可以core.setFlag('smoothCamera',true)重新开启
		// 此项默认为true
		// 
		this.__switchName = 'smoothCamera';

		// 初始化成员变量
		this._cameraNeedRefresh = true;
		this._nowOffsetX = 0;
		this._nowOffsetY = 0;
		this._targetOffsetX = 0;
		this._targetOffsetY = 0;
		this._currentFloorId = null;

		// 重置镜头，在楼层变更时使用
		this.resetCamera = function () {
			this._targetOffsetX = core.bigmap.offsetX;
			this._targetOffsetY = core.bigmap.offsetY;
			this._nowOffsetX = this._targetOffsetX;
			this._nowOffsetY = this._targetOffsetY;
			this._cameraNeedRefresh = true;
		};

		// 设置焦点坐标，目前没有用
		this.setTarget = function (x, y) {
			this._targetOffsetX = x;
			this._targetOffsetY = y;
		};

		// 请求镜头更新
		this.requestCameraUpdate = function () {
			this._cameraNeedRefresh = true;
		};

		// 更新焦点坐标，目前仅根据大地图偏移决定
		this.updateTargetPosition = function () {
			this._targetOffsetX = core.bigmap.offsetX;
			this._targetOffsetY = core.bigmap.offsetY;
		};

		// 更新额外的刷新条件，即镜头未指向焦点时
		this.updateRefreshFlag = function () {
			if (this._nowOffsetX != this._targetOffsetX || this._nowOffsetY != this._targetOffsetY) {
				this._cameraNeedRefresh = true;
			}
		};

		// 判断是否禁止了弹性滚动
		this.canDirectMove = function () {
			return !core.getFlag(this.__switchName, true);
		};

		// 更新镜头坐标
		this.updateCameraPosition = function () {
			if (this._cameraNeedRefresh) {
				this._cameraNeedRefresh = false;
				var disX = this._targetOffsetX - this._nowOffsetX;
				var disY = this._targetOffsetY - this._nowOffsetY;
				if (Math.abs(disX) <= 2 && Math.abs(disY) <= 2 || this.canDirectMove()) {
					this._nowOffsetX = this._targetOffsetX;
					this._nowOffsetY = this._targetOffsetY;
				} else {
					this._nowOffsetX += disX / 10;
					this._nowOffsetY += disY / 10;
				}
				var x = -Math.floor(this._nowOffsetX);
				var y = -Math.floor(this._nowOffsetY);
				core.bigmap.canvas.forEach(function (cn) {
					core.control.setGameCanvasTranslate(cn, x, y);
				});
				core.relocateCanvas('route', core.status.automaticRoute.offsetX + x, core.status.automaticRoute.offsetY + y);
				core.setGameCanvasTranslate('hero', x + this._targetOffsetX, y + this._targetOffsetY);
			}
		};

		// 更新逻辑主体
		this.update = function () {
			this.updateTargetPosition();
			this.updateRefreshFlag();
			this.updateCameraPosition();
		};
	};

	// 其实只注释了最后一行，只能这样了
	control.drawHero = function (status, offset) {
		if (!core.isPlaying() || !core.status.floorId || core.status.gameOver) return;
		var x = core.getHeroLoc('x'),
			y = core.getHeroLoc('y'),
			direction = core.getHeroLoc('direction');
		status = status || 'stop';
		offset = offset || 0;
		var way = core.utils.scan[direction];
		var dx = way.x,
			dy = way.y,
			offsetX = dx * offset,
			offsetY = dy * offset;
		core.bigmap.offsetX = core.clamp((x - core.__HALF_SIZE__) * 32 + offsetX, 0, 32 * core.bigmap.width - core.__PIXELS__);
		core.bigmap.offsetY = core.clamp((y - core.__HALF_SIZE__) * 32 + offsetY, 0, 32 * core.bigmap.height - core.__PIXELS__);
		core.clearAutomaticRouteNode(x + dx, y + dy);
		core.clearMap('hero');

		if (!core.hasFlag('hideHero')) {
			this._drawHero_getDrawObjs(direction, x, y, status, offset).forEach(function (block) {
				core.drawImage('hero', block.img, block.heroIcon[block.status] * block.width,
					block.heroIcon.loc * block.height, block.width, block.height,
					block.posx + (32 - block.width) / 2, block.posy + 32 - block.height, block.width, block.height);
			});
		}

		core.control.updateViewport();
		//core.setGameCanvasTranslate('hero', 0, 0);
	};

	// 复写转发
	core.drawHero = function (status, offset) {
		return core.control.drawHero(status, offset);
	};

	// 创建摄像机对象
	this.camera = new this.Camera();

	// 帧事件 更新摄像机
	this.updateCameraEx = function () {
		this.camera.update();
	};

	// 代理原本的镜头事件
	control.updateViewport = function () {
		core.plugin.camera.requestCameraUpdate();
	};

	// 更变楼层的行为追加，重置镜头
	events.prototype.changingFloor = function (floorId, heroLoc, fromLoad) {
		this.eventdata.changingFloor(floorId, heroLoc, fromLoad);
		core.plugin.camera.resetCamera();
	};

	// 注册帧事件
	core.registerAnimationFrame('smoothCameraFlash', true, this.updateCameraEx.bind(this));
},
    "qiehuan": function () {
	// 在此增加新插件
	this.qiehuan = function () {
		if (flags.keqiehuan == 1) {
			var shangxian = 18 * (core.status.hero.atk + core.status.hero.def),
				shikongshang = (flags.shikongshang || 0) + 41 + 5 * ((core.status.hero.items.keys.yellowKey || 0) + (core.status.hero.items.keys.blueKeyKey || 0)) + (core.status.hero.items.tools.pickaxe || 0) * 18 + (core.status.hero.items.tools.centerFly || 0) * 414 + (core.status.hero.items.tools.bomb || 0) * 23 + 41 * (core.status.hero.items.keys.purpleKey || 0);
			if (shikongshang <= shangxian) {
				flags.shikongshang = shikongshang;
				core.insertAction([{ "type": "insert", "name": "切换流向" }]);


			} else {
				core.drawTip("警告：时空连续体张力过大，无法实行此功能");
			}



		}
	};
},
    "beijing": function () {
	// 在此增加新插件
	////// 实际的背景/前景图块的绘制 //////
	/*core.maps._drawBgFgMap = function (floorId, ctx, name, onMap) {
		floorId = floorId || core.status.floorId;
		if (!floorId) return;
		var width = core.floors[floorId].width;
		var height = core.floors[floorId].height;

		if (!core.status[name + "maps"])
			core.status[name + "maps"] = {};

		var arr = this._getBgFgMapArray(name, floorId, true);
		var eventArr = null;
		if (name == 'fg' && onMap && this._drawBgFgMap_shouldBlurFg()) {
			eventArr = this.getMapArray(floorId);
		}

		for (var x = 0; x < width; x++) {
			for (var y = 0; y < height; y++) {
				var block = this.initBlock(x, y, arr[y][x], true);
				block.name = name;
				var blockInfo = this.getBlockInfo(block);
				if (!blockInfo) continue;
				// --- 背景虚化
				var blur = false,
					alpha;
				if (eventArr != null && eventArr[y][x] == 0) {
					blur = true;
					alpha = ctx.globalAlpha;
					ctx.globalAlpha = 0.5;
				}
				this._drawMap_drawBlockInfo(ctx, block, blockInfo, arr, onMap);
				if (blur) ctx.globalAlpha = alpha;
			}
		}
		if (onMap)
			core.status.autotileAnimateObjs[name + "map"] = core.clone(arr);
	}*/
},
    "tiaozi": function () {
	// 在此增加新插件
	this.tiaozi = function (neirong, yanse) { //跳字红
		if (!core.status.replay.replaying) {

			core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) + 1);
			var tiaozihao = core.getFlag("tiaozizhong");
			var shangsheng = 1;
			var gaodu = 0,
				shijian = -4;
			var herox = core.status.hero.loc.x,
				heroy = core.status.hero.loc.y;
			var fade = setInterval(function () {
				core.clearMap('tiaozi', 0, 0, 416, 416);
				shijian += 1;
				gaodu = -1 * shijian * shijian + 8 * shijian;

				if (shijian == 14 || core.getFlag("tiaozizhong") > tiaozihao) {
					core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) - 1);
					core.clearMap('tiaozi', 0, 0, 416, 416);
					clearInterval(fade);
				} else core.fillBoldText('tiaozi', neirong, herox * 32 + 16, heroy * 32 - gaodu, yanse, "bold 22px Verdana");
			}, 54);

		}
	}
},
    "chushihua": function () {
	// 在此增加新插件
	this.chushihua = function () {
		//跳字图层
		flags.shikongshang = 0;
		core.createCanvas('tiaozi', 0, 0, 416, 416, 74);
		core.setTextAlign("tiaozi", 'center');
		flags.liuxiang = 0;
		flags.chengji = 100000;

	}
},
    "guoguanpanding": function () {
	// 在此增加新插件
	this.guoguanpanding = function () {
		if (flags.guoguanle != 1) {
			flags.guoguanle = 1;
			var loc = 0;
			switch (core.status.floorId) {
			case "fux25":
				loc = [6, 11];
				break;
			case "fux31":
				loc = [7, 6];
				break;
			case "fux32":
				loc = [10, 6];
				break;
			case "fux33":
				loc = [6, 10];
				break;
			case "fux34":
				loc = [6, 7];
				break;
			case "fux35":
				loc = [9, 6];
				break;
			case "fux36":
				loc = [6, 11];
				break;
			case "fux37":
				loc = [6, 10];
				break;
			case "fux38":
				loc = [6, 10];
				break;
			case "fux39":
				loc = [6, 10];
				break;
			case "fux13":
				loc = [6, 8];
				break;
			case "fux12":
				loc = [6, 8];
				break;
			case "fux17":
				loc = [6, 11];
				break;
			case "fux15":
				loc = [6, 12];
				break;
			case "fux24":
				loc = [6, 12];
				break;
			case "fux19":
				loc = [6, 11];
				break;
			case "fux26":
				loc = [6, 11];
				break;
			case "fux21":
				loc = [6, 11];
				break;
			case "fux20":
				loc = [6, 6];
				break;
			case "fux22":
				loc = [6, 11];
				break;
			case "fux23":
				loc = [6, 11];
				break;
			case "fux27":
				loc = [6, 11];
				break;
			case "fux28":
				loc = [6, 11];
				break;
			case "fux41":
				loc = [6, 11];
				break;
			}

			if (core.status.hero.loc.x == loc[0] && core.status.hero.loc.y == loc[1]) {
				var a = true;
				var fgMapArray = core.getFgMapArray(),
					mapArray = core.getMapArray();
				if (core.status.floorId == "fux12") {
					for (var x = 0; x <= 12; x++) {
						for (var y = 0; y <= 12; y++) {
							if (mapArray[y][x] != 0 && x == 4 && y == 5) a = false;
							if (mapArray[y][x] != 0 && x == 4 && y == 6) a = false;
							if (mapArray[y][x] != 0 && x == 6 && y == 6) a = false;
							if (mapArray[y][x] != 0 && x == 8 && y == 5) a = false;
							if (mapArray[y][x] != 0 && x == 8 && y == 6) a = false;
							if (fgMapArray[y][x] != 0 && mapArray[y][x] == 0 && x != 4 && x != 8 && y != 6) a = false;



						}
					}
				} else {
					for (var x = 0; x <= 12; x++) {
						for (var y = 0; y <= 12; y++) {
							if (fgMapArray[y][x] != 0 && mapArray[y][x] == 0) {
								a = false;
							}
						}
					}
				}
				flags.guoguanle = 0;
				return a;
			}
			flags.guoguanle = 0;
			return false;
		}
	}
},
    "daojutishi": function () {
	// 在此增加新插件
	this.daojutishi = function (itemId) { //统一跳字
		switch (itemId) {
		case "redJewel":
			var neirong = "攻击+1",
				yanse = "red";
			break;
		case "blueJewel":
			var neirong = "防御+1",
				yanse = "blue";
			break;
		case "I373":
			var neirong = "攻击+3",
				yanse = "red";
			break;
		case "I374":
			var neirong = "防御+3",
				yanse = "blue";
			break;
		case "I404":
			var neirong = "防御+25",
				yanse = "blue";
			break;
		case "I405":
			var neirong = "防御+25",
				yanse = "blue";
			break;
		case "I375":
			var neirong = "攻击+30",
				yanse = "red";
			break;
		case "yellowKey":
			var neirong = "黄钥匙+1",
				yanse = "yellow";
			break;
		case "blueKey":
			var neirong = "蓝钥匙+1",
				yanse = "blue";
			break;
		case "redKey":
			var neirong = "黑钥匙+1",
				yanse = "black";
			break;
		case "purpleKey":
			var neirong = "紫钥匙+1",
				yanse = "purple";
			break;
		case "greenKey":
			var neirong = "绿钥匙+1",
				yanse = "green";
			break;
		case "bomb":
			var neirong = "炸弹+1",
				yanse = "white";
			break;
		case "centerFly":
			var neirong = "中心对称飞行器+1",
				yanse = "white";
			break;
		case "redPotion":
			var neirong = "HP+400",
				yanse = "green";
			break;
		case "bluePotion":
			var neirong = "HP+1000",
				yanse = "green";
			break;
		case "I403":
			var neirong = "时间箭头逆向装置+1",
				yanse = "white";
			break;


		}
		if (itemId != "I371" && itemId != "I372") core.plugin.tiaozi(neirong, yanse);
	}
},
    "chufa": function () {
	// 在此增加新插件
	this.chufa = function () {
		if (flags.liuxiang == 0) {
			var x = core.getHeroLoc('x') - core.utils.scan[core.getHeroLoc('direction')].x,
				y = core.getHeroLoc('y') - core.utils.scan[core.getHeroLoc('direction')].y;
			var fgMapArray = core.getFgMapArray(),
				mapArray = core.getMapArray();
			if (fgMapArray[y][x] != 0 && mapArray[y][x] == 0) {
				if (core.floors[core.status.floorId].events[x + "," + y] != null) {
					core.insertAction([{ "type": "trigger", "loc": [x, y], "keep": true }]);
				} else {
					if (core.getBlockInfo(fgMapArray[y][x]).cls == "enemys") {
						var enemy1 = core.getEnemyInfo(core.getBlockInfo(fgMapArray[y][x]).id, core.floors[core.status.floorId].events[x + "," + y])
						if (core.status.hero.atk > enemy1.def && core.status.hero.money >= enemy1.money && core.status.hero.experience >= enemy1.experience) {

							if (core.hasSpecial(enemy1.special, 12)) {
								var turn = (core.getDamageInfo(enemy1, null, x, y, core.status.floorId).turn || 0) - 1;
								if (!core.hasFlag("poison")) flags.poison = 0;
								if (flags.poison >= turn) {
									core.autosave(false);
									core.setBlock(fgMapArray[y][x], x, y);
									core.insertAction([{ "type": "trigger", "loc": [x, y], "keep": true },
										{
											"type": "setBlock",
											"number": fgMapArray[y][x],
											"loc": [
												[x, y]
											]
										},
									]);
								} else {
									core.insertAction("不符合该单位的触发条件");
								}
							} else {
								core.autosave(false);
								core.setBlock(fgMapArray[y][x], x, y);
								core.insertAction([{ "type": "trigger", "loc": [x, y], "keep": true },
									{
										"type": "setBlock",
										"number": fgMapArray[y][x],
										"loc": [
											[x, y]
										]
									},
								]);
							}
							//core.setBlock(fgMapArray[y][x], x, y);
						} else {
							core.insertAction("不符合该单位的触发条件");
						}
					}
					if (core.getBlockInfo(fgMapArray[y][x]).cls == "items") {
						var itemId = core.getBlockInfo(fgMapArray[y][x]).id,
							atk = core.status.hero.atk,
							def = core.status.hero.def,
							hp = core.status.hero.hp;
						var a = false;
						switch (itemId) {
						case "redJewel":
							if (atk >= 1) {
								a = true;
								core.status.hero.atk -= 1;
							}
							break;
						case "blueJewel":
							if (def >= 1) {
								a = true;
								core.status.hero.def -= 1;
							}
							break;
						case "I373":
							if (atk >= 3) {
								a = true;
								core.status.hero.atk -= 3;
							}
							break;
						case "I374":
							if (def >= 3) {
								a = true;
								core.status.hero.def -= 3;
							}
							break;
						case "I404":
							if (def >= 25) {
								a = true;
								core.status.hero.def -= 25;
							}
							break;
						case "I405":
							if (def >= 25) {
								a = true;
								core.status.hero.def -= 25;
							}
							break;
						case "I375":
							if (atk >= 30) {
								a = true;
								core.status.hero.atk -= 30;
							}
							break;
						case "yellowKey":
						case "blueKey":
						case "redKey":
						case "purpleKey":
						case "greenKey":
						case "bomb":
						case "centerFly":
							if (core.hasItem(itemId)) {
								a = true;
								core.addItem(itemId, -1);
							}
							break;
						case "redPotion":
							if (hp > 400) {
								a = true;
								core.status.hero.hp -= 400;
							}
							break;
						case "bluePotion":
							if (hp > 1000) {
								a = true;
								core.status.hero.hp -= 1000;
							}
							break;
						}
						if (a) {
							core.setBlock(fgMapArray[y][x], x, y);
							core.plugin.daojutishi(itemId);
						} else core.insertAction("不符合该单位的触发条件");

					}
					if (core.getBlockInfo(fgMapArray[y][x]).cls == "terrains") {
						core.autosave(false);
						var id = core.getBlockInfo(fgMapArray[y][x]).id;
						var id2 = id.substr(0, id.length - 4) + "Key";
						core.insertAction({ "type": "closeDoor", "id": id, "loc": [x, y] });
						if (id != "steelDoor" && id != "purplesteelDoor" && id != "specialDoor") core.addItem(id2);
					}
					if (core.getBlockInfo(fgMapArray[y][x]).cls == "npcs") {
						core.setBlock(fgMapArray[y][x], x, y);
						core.insertAction([{ "type": "trigger", "loc": [x, y] }]);
					}
				}
			} else if (fgMapArray[y][x] != 0) {
				if (core.getBlockInfo(fgMapArray[y][x]).cls == "npcs") core.insertAction({ "type": "trigger", "loc": [x, y] });
			} else if (mapArray[y][x] == 23 || mapArray[y][x] == 83) {
				core.insertAction({ "type": "trigger", "loc": [x, y] });
			}
		}
	}
},
    "louchuan": function () {
	// 在此增加新插件
	// 重写events.js的useFly函数，即点击楼传按钮时的事件
	core.events.useFly = function (fromUserAction) {
		if (core.isMoving()) {
			core.drawTip("请先停止勇士行动");
			return;
		}
		if (core.status.lockControl || core.status.event.id != null) return;

		if (core.canUseItem('fly')) core.useItem('fly');
		else core.drawTip("当前无法使用" + core.material.items.fly.name);
	}
	core.events.openQuickShop = function (fromUserAction) {
		if (core.isMoving()) {
			core.drawTip("请先停止勇士行动");
			return;
		}
		if (core.status.lockControl || core.status.event.id != null) return;

		if (core.canUseItem('I403')) core.useItem('I403');
		else core.drawTip("当前无法切换时间流向");
	}
},
    "setblock": function () {
	// 在此增加新插件
	this.setblock1 = function () {
		var fgMapArray = core.getFgMapArray();
		if (flags.liuxiang != 1) {
			var x = core.getHeroLoc('x') - core.utils.scan[core.getHeroLoc('direction')].x,
				y = core.getHeroLoc('y') - core.utils.scan[core.getHeroLoc('direction')].y;
		} else {
			var x = core.nextX(),
				y = core.nextY();
		}
		core.setBlock(fgMapArray[y][x], x, y);
	};
},
    "cangguai": function () {
	// 在此增加新插件
	////// 获得当前楼层的怪物列表 //////
	core.enemys.getCurrentEnemys = function (floorId) {
		floorId = floorId || core.status.floorId;
		if (floorId == "fux25") {
			return core.getCurrentEnemys("X1");
		}
		if (floorId == "fux31" || floorId == "fux32" || floorId == "fux33") {
			return core.getCurrentEnemys("X2");
		}
		if (floorId == "fux34") {
			return core.getCurrentEnemys("X3");
		}
		if (floorId == "fux35") {
			return core.getCurrentEnemys("X4");
		}
		if (floorId == "fux36") {
			return core.getCurrentEnemys("X5");
		}
		if (floorId == "fux38") {
			return core.getCurrentEnemys("X6");
		}
		if (floorId == "fux39") {
			return core.getCurrentEnemys("X7");
		}
		if (floorId == "fux13") {
			return core.getCurrentEnemys("X8");
		}
		if (floorId == "fux12") {
			return core.getCurrentEnemys("X9");
		}
		if (floorId == "fux15" || floorId == "fux24") {
			return core.getCurrentEnemys("X10");
		}
		if (floorId == "fux21") {
			return core.getCurrentEnemys("X11");
		}
		if (floorId == "fux20") {
			return core.getCurrentEnemys("X12");
		}
		if (floorId == "fux22") {
			return core.getCurrentEnemys("X13");
		}
		if (floorId == "fux27") {
			return core.getCurrentEnemys("X14");
		}
		var enemys = [],
			used = {};
		var mapBlocks = core.status.maps[floorId].blocks;
		for (var b = 0; b < mapBlocks.length; b++) {
			if (!mapBlocks[b].disable && mapBlocks[b].event.cls.indexOf('enemy') == 0) {
				this._getCurrentEnemys_addEnemy(mapBlocks[b].event.id, enemys, used, floorId);
			}
		}
		return this._getCurrentEnemys_sort(enemys);
	}
},
    "chufaqi": function () {
	// 在此增加新插件

	////// 触发(x,y)点的事件 //////
	core.events._trigger = function (x, y) {

		if (core.status.gameOver) return;
		if (core.status.event.id == 'action') {
			core.insertAction({ "type": "trigger", "loc": [x, y] }, x, y, null, true);
			return;
		}

		if (core.status.event.id) return;

		var block = core.getBlock(x, y);

		if (block == null) return;
		block = block.block;
		/*var fgMapArray = core.getFgMapArray();
		if (flags.liuxiang != 1 && fgMapArray[y][x] == 0) {
			core.insertAction({ "type": "trigger", "loc": [x, y] });
			return;
		}*/
		if (flags.liuxiang != 1) return;
		// 执行该点的脚本
		try {
			eval(block.event.script);
		} catch (e) { main.log(e); }

		if (block.event.trigger) {
			var noPass = block.event.noPass,
				trigger = block.event.trigger;
			if (noPass) core.clearAutomaticRouteNode(x, y);

			// 转换楼层能否穿透
			if (trigger == 'changeFloor' && !noPass && this._trigger_ignoreChangeFloor(block))
				return;
			core.status.automaticRoute.moveDirectly = false;
			this.doSystemEvent(trigger, block);
		}
	}
},
    "nopass": function () {
	// 在此增加新插件
	////// 某个点是否不可通行 //////
	core.maps.noPass = function (x, y, floorId) {
		var block = core.getBlock(x, y, floorId);
		if (block == null) return false;
		if (block.block.id == 87 || block.block.id == 88 || block.block.id == 389 || block.block.id == 10003) return false;
		if (flags.liuxiang != 1 && core.getBlockId(x, y) == "greenKey") return true;
		if (flags.liuxiang != 1 && block.block.event.trigger != 'action') return true;
		return block.block.event.noPass;
	}
},
    "closeDoor": function () {
	// 在此增加新插件
	core.events.closeDoor = function (x, y, id, callback) {
		id = id || "";
		if (!(id.endsWith("Door") || id.endsWith("Wall")) ||
			core.material.icons.animates[id] == null || (core.getBlockId(x, y) != null && core.getBlockId(x, y) != "none")) {
			if (callback) callback();
			return;
		}
		// 关门动画
		core.playSound('door.mp3');
		var door = core.material.icons.animates[id];
		var speed = id.endsWith("Door") ? 30 : 70,
			state = 0;
		var animate = window.setInterval(function () {
			state++;
			if (state == 4) {
				clearInterval(animate);
				delete core.animateFrame.asyncId[animate];
				core.setBlock(core.getNumberById(id), x, y);
				if (callback) callback();
				return;
			}
			core.clearMap('event', 32 * x, 32 * y, 32, 32);
			core.drawImage('event', core.material.images.animates, 32 * (4 - state), 32 * door, 32, 32, 32 * x, 32 * y, 32, 32);
		}, core.status.replay.speed == 24 ? 1 : speed / Math.max(core.status.replay.speed, 1));
		core.animateFrame.asyncId[animate] = true;
	}
},
    "openDoor": function () {
	// 在此增加新插件
	core.events._openDoor_animate = function (id, x, y, callback) {
		var door = core.material.icons.animates[id];
		var speed = id.endsWith("Door") ? 30 : 70;

		var locked = core.status.lockControl;
		core.lockControl();
		core.status.replay.animate = true;
		//core.hideBlock(x, y);
		//core.insertAction({ "type": "hide", "loc": [[x, y]], "time": 0 });
		core.setBlock(0, x, y);
		core.removeBlock(x, y);
		core.drawImage('event', core.material.images.animates, 0, 32 * door, 32, 32, 32 * x, 32 * y, 32, 32);
		var state = 0;
		var animate = window.setInterval(function () {
			core.clearMap('event', 32 * x, 32 * y, 32, 32);
			state++;
			if (state == 4) {
				clearInterval(animate);
				delete core.animateFrame.asyncId[animate];
				if (!locked) core.unLockControl();
				core.status.replay.animate = false;
				core.events.afterOpenDoor(id, x, y, callback);
				return;
			}
			core.drawImage('event', core.material.images.animates, 32 * state, 32 * door, 32, 32, 32 * x, 32 * y, 32, 32);
		}, core.status.replay.speed == 24 ? 1 : speed / Math.max(core.status.replay.speed, 1));
		core.animateFrame.asyncId[animate] = true;
	}
},
    "qingan": function () {
	// 在此增加新插件
	////// 获得面前的物品（轻按） //////
	core.events.getNextItem = function (noRoute) {
		if (core.isMoving() || !core.flags.enableGentleClick) return false;
		if (flags.liuxiang == 0) return false;
		if (this._canGetNextItem()) return this._getNextItem(null, noRoute);

		var directions = ["up", "down", "left", "right"].filter(function (dir) {
			return core.events._canGetNextItem(dir);
		});
		return directions.length == 1 ? this._getNextItem(directions[0]) : false;
	}
},
    "shunyi": function () {
	// 在此增加新插件
	core.control._replayAction_moveDirectly = function (action) {
		if (action.indexOf("move:") != 0) return false;
		// 忽略连续的瞬移事件
		/*while (core.status.replay.toReplay.length>0 &&
		    core.status.replay.toReplay[0].indexOf('move:')==0) {
		        core.status.route.push(action);
		        action = core.status.replay.toReplay.shift();
		}*/

		var pos = action.substring(5).split(":");
		var x = parseInt(pos[0]),
			y = parseInt(pos[1]);
		var nowx = core.getHeroLoc('x'),
			nowy = core.getHeroLoc('y');
		if (!core.moveDirectly(x, y)) return false;
		core.ui.drawArrow('ui', 32 * nowx + 16 - core.bigmap.offsetX, 32 * nowy + 16 - core.bigmap.offsetY,
			32 * x + 16 - core.bigmap.offsetX, 32 * y + 16 - core.bigmap.offsetY, '#FF0000', 3);
		setTimeout(function () {
			core.clearMap('ui');
			core.replay();
		}, core.control.__replay_getTimeout());
		return true;
	}
}
}