/**
 * 创建一个以webgl为绘制上下文的画布
 * @param id 画布id
 * @param x 横坐标
 * @param y 纵坐标
 * @param w 宽度
 * @param h 高度
 * @param z 纵深
 */
export declare function createWebGLCanvas(id: string, x: number, y: number, w: number, h: number, z: number): WebGLRenderingContext;
/**
 * 删除一个webgl画布
 * @param id 画布id
 */
export declare function deleteWebGLCanvas(id: string): void;
/**
 * 获取webgl画布上下文
 * @param id 画布id
 */
export declare function getWebGLCanvas(id: string): WebGLRenderingContext | null;
/**
 * 创建webgl程序对象
 * @param gl 画布webgl上下文
 * @param vshader 顶点着色器
 * @param fshader 片元着色器
 */
export declare function createProgram(gl: WebGLRenderingContext, vshader: string, fshader: string): WebGLProgram;
/**
 * 加载着色器
 * @param gl 画布的webgl上下文
 * @param type 着色器类型，顶点着色器还是片元着色器
 * @param source 着色器源码
 */
export declare function loadShader(gl: WebGLRenderingContext, type: number, source: string): WebGLShader;
