///<reference path="./types/core.d.ts" />
import { AllowedComponentProps } from 'vue';
import { Animation as Animation_2 } from 'mutate-animate';
import { axios } from 'axios';
import type { default as BoxAnimate_2 } from '../components/boxAnimate.vue.vue';
import { chartJs } from 'chart.js';
import type Colomn from '../components/colomn.vue.vue';
import { Component } from 'vue';
import { ComponentCustomProps } from 'vue';
import { ComponentOptionsMixin } from 'vue';
import { DefineComponent } from 'vue';
import type EnemyOne from '../components/enemyOne.vue.vue';
import type EnemySpecial from '../panel/enemySpecial.vue.vue';
import type EnemyTarget from '../panel/enemyTarget.vue.vue';
import { ExtractPropTypes } from 'vue';
import { FunctionalComponent } from 'vue';
import { jszip } from 'jszip';
import type KeyboardPanel from '../panel/keyboard.vue.vue';
import { lodashEs } from 'lodash-es';
import { lzString } from 'lz-string';
import { MessageApi } from 'ant-design-vue/lib/message';
import { mutateAnimate } from 'mutate-animate';
import { PathFn } from 'mutate-animate';
import { PropType } from 'vue';
import { Ref as Ref_2 } from 'vue';
import { RendererElement } from 'vue';
import { RendererNode } from 'vue';
import { RenderFunction } from 'vue';
import type Scroll from '../components/scroll.vue.vue';
import { SetupContext } from 'vue';
import { TimingFn } from 'mutate-animate';
import { VNode } from 'vue';
import { VNodeChild } from 'vue';
import { VNodeProps } from 'vue';
import { vue } from 'vue';

declare type __VLS_NonUndefinedable<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_10<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_11<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_12<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_13<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_14<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_15<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_16<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_17<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_18<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_2<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_3<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_4<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_5<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_6<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_7<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_8<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_9<T> = T extends undefined ? never : T;

declare type __VLS_TypePropsToRuntimeProps<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_10<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_10<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_11<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_11<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_12<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_12<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_13<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_13<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_14<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_14<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_15<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_15<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_16<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_16<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_17<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_17<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_18<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_18<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_2<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_2<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_3<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_3<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_4<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_4<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_5<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_5<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_6<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_6<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_7<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_7<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_8<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_8<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_9<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_9<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_WithTemplateSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};

/**
 * 添加一个动画
 * @param fn 要添加的函数
 */
declare function addAnimate(fn: (time: number) => void): void;

/**
 * 添加一个光源
 * @param info 光源信息
 */
declare function addLight(info: Light): void;

/**
 * 根据坐标数组添加物体节点
 * @param polygons 坐标数组
 */
declare function addPolygon(...polygons: LocArr[][]): void;

/**
 * 根据多边形数组添加物体节点
 * @param polygons 多边形数组
 */
declare function addPolygon(...polygons: Polygon[]): void;

/**
 * 添加弹出文字
 * @param px 弹出的横坐标
 * @param py 弹出的纵坐标
 * @param value 弹出的文字
 */
declare function addPop(px: number, py: number, value: string): void;

declare interface AllItem {
    tools: [ItemIdOf<'tools'>, number][];
    constants: [ItemIdOf<'constants'>, number][];
}

/**
 * 动画改变一个属性的值
 * @param id 灯光id
 * @param key 动画属性，x,y,r,decay，颜色请使用animateLightColor（下个版本会加）
 * @param n 目标值
 * @param time 动画时间
 * @param mode 动画方式，渐变函数，高级动画提供了大量内置的渐变函数
 * @param relative 相对方式，是绝对还是相对
 */
declare function animateLight<K extends Exclude<keyof Light, 'id'>>(id: string, key: K, n: Light[K], time?: number, mode?: TimingFn, relative?: boolean): void;

declare function animateLightColor(id: string, target: Color, time?: number, mode?: TimingFn): void;

declare function applyFragWith(canvas: HTMLCanvasElement, length?: number, time?: number, config?: any): {
    animation: Animation_2;
    onEnd: Promise<void>;
    canvas: HTMLCanvasElement;
};

declare interface AssistHoykey {
    ctrl: boolean;
    shift: boolean;
    alt: boolean;
}

declare interface AssistKeyToolbarItem extends ToolbarItemBase<'assistKey'> {
    assist: KeyCode.Ctrl | KeyCode.Shift | KeyCode.Alt;
}

declare type AudioParamOf<T> = Record<SelectKey<T, AudioParam>, number>;

declare class AudioPlayer extends EventEmitter<AudioPlayerEvent> {
    static ac: AudioContext;
    static index: number;
    /** 音频的索引，这样的话可以复用来提高性能表现 */
    index: number;
    data: ArrayBuffer;
    buffer: AudioBuffer | null;
    source?: AudioBufferSourceNode;
    baseNode: BaseNode[];
    constructor(data: ArrayBuffer);
    /**
     * 更新音频数据
     * @param data 音频的ArrayBuffer数据
     */
    update(data: ArrayBuffer): Promise<void>;
    /**
     * 获取音频源数据节点
     */
    getSource(): AudioBufferSourceNode;
    /**
     * 播放音频
     */
    play(when?: number, offset?: number, duration?: number): AudioBufferSourceNode | undefined;
    /**
     * 准备音频资源连接
     */
    ready(): void;
    /**
     * 获取音频输出destination
     */
    getDestination(): AudioDestinationNode;
}

declare interface AudioPlayerEvent extends EmitableEvent {
    play: (node: AudioBufferSourceNode) => void;
    update: (audio: AudioBuffer) => void;
    end: (node: AudioBufferSourceNode) => void;
}

declare function autoRemoveMaps(floorId: FloorIds): void;

declare function backDir(dir: Dir): Dir;

declare const backgroundInfo: Partial<Record<FloorIds, Color>>;

declare interface BaseNode {
    node: AudioNode;
    channel?: number;
}

declare namespace battle {
    export {
        getEnemy,
        CurrentEnemy
    }
}

declare type BFSFromString = `${FloorIds},${number},${number},${Dir}`;

declare type BFSToString = `${FloorIds},${number},${number}`;

declare class BgmController extends ResourceController<HTMLAudioElement> implements Undoable<BgmIds> {
    /** Bgm播放栈，可以undo，最多存放10个 */
    stack: BgmIds[];
    /** Bgm的redo栈，最多存放10个 */
    redoStack: BgmIds[];
    /** 当前播放的bgm */
    now?: BgmIds;
    /** 渐变切歌时长 */
    transitionTime: number;
    /** 渐变切歌的音量曲线 */
    transitionCurve: TimingFn;
    /** 音量 */
    volume: number;
    /** 是否关闭了bgm */
    disable: boolean;
    /** 是否正在播放bgm */
    playing: boolean;
    private transitionData;
    /**
     * 添加一个bgm
     * @param uri bgm的`uri`，由于bgm是一类资源，因此`uri`为`bgms.xxx`的形式
     * @param data bgm音频元素
     */
    add(uri: string, data: HTMLAudioElement): void;
    /**
     * 加载一个bgm
     * @param id 要加载的bgm
     */
    load(id: BgmIds): void;
    /**
     * 切换bgm，具有渐变效果，可以通过监听切换事件，同时调用preventDefault来阻止渐变，
     * 并使用自己的切歌程序。阻止后，不会将切换的歌曲加入播放栈，也不会进行切歌，
     * 所有的切歌操作均由你自己的程序执行
     * @param id 要切换至的bgm
     * @param when 切换至的歌从什么时候开始播放，默认-1，表示不改变，整数表示设置为目标值
     */
    changeTo(id: BgmIds, when?: number, noStack?: boolean): void;
    /**
     * 暂停当前bgm的播放，继续播放时将会延续暂停的时刻，同样可以使用preventDefault使用自己的暂停程序
     * @param transition 是否使用渐变效果，默认使用
     */
    pause(transition?: boolean): void;
    /**
     * 继续当前bgm的播放，从上一次暂停的时刻开始播放，同样可以使用preventDefault使用自己的播放程序
     * @param transition 是否使用渐变效果，默认使用
     */
    resume(transition?: boolean): void;
    /**
     * 播放bgm，不进行渐变操作，效果为没有渐变的切歌，也会触发changeBgm事件，可以被preventDefault
     * @param id 要播放的bgm
     * @param when 从bgm的何时开始播放
     */
    play(id: BgmIds, when?: number, noStack?: boolean): void;
    /**
     * 撤销当前播放，改为播放前一个bgm
     */
    undo(transition?: boolean, when?: number): BgmIds | undefined;
    /**
     * 取消上一次的撤销，改为播放上一次撤销的bgm
     */
    redo(transition?: boolean, when?: number): BgmIds | undefined;
    /**
     * 设置渐变切歌信息
     * @param time 渐变时长
     * @param curve 渐变的音量曲线
     */
    setTransition(time?: number, curve?: TimingFn): void;
    /**
     * 根据id获取bgm
     * @param id 要获取的bgm的id
     */
    get(id: BgmIds): HTMLAudioElement;
    private setTransitionAnimate;
}

declare const blurInfo: Partial<Record<FloorIds, number>>;

declare interface BookDetailInfo {
    /** 怪物手册详细信息展示的怪物 */
    enemy?: ToShowEnemy;
    /** 怪物手册的怪物详细信息的初始位置 */
    pos?: number;
}

declare namespace bookTools {
    export {
        getSpecialHint,
        getDefDamage,
        getCriticalDamage,
        ToShowEnemy,
        detailInfo
    }
}

/**
 * 获得一个数组的数值的最大值和最小值
 * @param arr 要获得的数组
 */
declare function boundary(arr: number[]): [number, number];

/**
 * 获得一个数组的元素的某个属性的数值的最大值和最小值
 * @param arr 要获得的数组
 * @param key 要获得的属性名
 */
declare function boundary<T>(arr: T[], key: keyof T): [number, number];

/**
 * 去除一个全局拖拽函数
 * @param fn 要去除的函数
 */
declare function cancelGlobalDrag(fn: DragFn_2): void;

declare function canOpenShop(id: string): boolean;

declare type CanParseCss_2 = keyof {
    [P in keyof CSSStyleDeclaration as CSSStyleDeclaration[P] extends string ? P extends string ? P : never : never]: CSSStyleDeclaration[P];
};

declare function canUseQuickShop(): "当前楼层不能使用快捷商店。" | null;

declare interface ChangableValue<T> {
    change: Ref_2<boolean>;
    value: Ref_2<T>;
    stop: () => void;
}

/**
 * 更改一个本地存储
 * @deprecated
 * @param name 要更改的信息
 * @param fn 更改时执行的函数
 * @param defaultValue 如果不存在时获取的默认值
 */
declare function changeLocalStorage<T>(name: string, fn: (data: T) => T, defaultValue?: T): void;

declare function checkAssist(bin: number, key: KeyCode): boolean;

declare function checkMarkedEnemy(): void;

/**
 * 检查漏怪
 */
declare function checkRemainEnemy(floorIds: FloorIds[]): Partial<Record<FloorIds, {
    loc: LocArr;
    id: EnemyIds;
}[]>>;

/**
 * 检查一个点是否在当前超大地图 v2 优化范围内
 */
declare function checkV2(x?: number, y?: number): boolean;

export declare interface ClassInterface {
    EventEmitter: typeof EventEmitter;
    IndexedEventEmitter: typeof IndexedEventEmitter;
    Disposable: typeof Disposable_2;
    GameStorage: typeof GameStorage;
    MotaSetting: typeof MotaSetting;
    SettingDisplayer: typeof SettingDisplayer;
    Focus: typeof Focus;
    GameUi: typeof GameUi;
    UiController: typeof UiController;
    Hotkey: typeof Hotkey;
    Keyboard: typeof Keyboard;
    CustomToolbar: typeof CustomToolbar;
    AudioPlayer: typeof AudioPlayer;
    SoundEffect: typeof SoundEffect;
    SoundController: typeof SoundController;
    BgmController: typeof BgmController;
    MComponent: typeof MComponent;
    ResourceController: typeof ResourceController;
    Range: typeof Range_2;
    EnemyCollection: typeof EnemyCollection;
    DamageEnemy: typeof DamageEnemy;
}

/**
 * 清除某一层的墙壁缓存
 * @param floorId 楼层id
 */
declare function clearShadowCache(floorId: FloorIds): void;

declare function clip(...replace: string[]): void;

declare interface ClsMap {
    tools: '消耗道具';
    constants: '永久道具';
    all: '全部道具';
}

declare namespace commonTools {
    export {
        createChangable
    }
}

declare interface Components {
    Default: SettingComponent;
    Boolean: SettingComponent;
    Number: SettingComponent;
    HotkeySetting: SettingComponent;
    ToolbarEditor: SettingComponent;
    Radio: (items: string[]) => SettingComponent;
    Performance: SettingComponent;
}

declare interface Components_2 {
    DefaultTool: CustomToolbarComponent;
    KeyTool: CustomToolbarComponent<'hotkey'>;
    ItemTool: CustomToolbarComponent<'item'>;
    AssistKeyTool: CustomToolbarComponent<'assistKey'>;
}

declare function _convertShop_replaceChoices(shopId: string, previewMode: boolean): void;

/**
 * 创建一个监听响应式变量更改的，可以用于Changable的监听器
 * @param value 要监听的值
 */
declare function createChangable<T>(value: Ref_2<T>, key?: keyof T): ChangableValue<T>;

declare function createSettingComponents(): Components;

declare function createToolbarComponents(): Components_2;

declare function createToolbarEditorComponents(): Components_2;

declare interface CriticalDamageDelta extends Omit<DamageDelta, 'info'> {
    /** 勇士的攻击增量 */
    atkDelta: number;
}

declare interface CurrentEnemy {
    enemy: DamageEnemy;
    onMapEnemy: DamageEnemy[];
}

declare class CustomToolbar extends EventEmitter<CustomToolbarEvent> {
    static num: number;
    static list: CustomToolbar[];
    static info: Record<string, RegisteredCustomToolInfo>;
    items: ValueOf<ToolbarItemMap>[];
    num: number;
    id: string;
    x: number;
    y: number;
    width: number;
    height: number;
    assistKey: number;
    showIds: number[];
    constructor(id: string);
    /**
     * 添加一个自定义项
     * @param item 要添加的自定义工具栏项
     */
    add<K extends ToolbarItemType>(item: ToolbarItemMap[K]): this;
    /**
     * 删除一个自定义项
     * @param id 要删除的项的id
     */
    delete(id: string): this | undefined;
    /**
     * 设置一个项
     * @param id 要设置的项的id
     * @param item 要设置的属性内容
     */
    set<T extends ToolbarItemType>(id: string, item: Partial<SettableItemData<T>>): this | undefined;
    /**
     * 触发一个自定义工具
     * @param id 要触发的自定义工具的id
     */
    emitTool(id: string): this;
    /**
     * 强制刷新这个自定义工具栏的所有显示
     */
    refresh(reopen?: boolean): this;
    setPos(x?: number, y?: number): void;
    setSize(width?: number, height?: number): void;
    /**
     * 显示这个自定义工具栏，可以显示多个，且内容互通
     */
    show(): number;
    /**
     * 关闭一个以此实例为基础显示的自定义工具栏
     * @param id 要关闭的id
     */
    close(id: number): void;
    /**
     * 关闭这个自定义工具栏的所有显示
     */
    closeAll(): void;
    static get(id: string): CustomToolbar | undefined;
    /**
     * 注册一类自定义工具
     * @param type 要注册的自定义工具类型
     * @param name 该类型的中文名
     * @param onEmit 当触发这个自定义工具的时候执行的函数
     * @param show 这个自定义工具在自定义工具栏的显示组件
     * @param editor 这个自定义工具在编辑时编辑组件
     * @param onCreate 当这个自定义工具在编辑器中被添加时，执行的初始化脚本
     */
    static register<K extends ToolbarItemType>(type: K, name: string, onEmit: ToolItemEmitFn<K>, show: CustomToolbarComponent<K>, editor: CustomToolbarComponent<K>, onCreate: (item: any) => ToolbarItemMap[K]): void;
    static save(): void;
    static load(): void;
    static refreshAll(reopen?: boolean): void;
    static showAll(): number[];
    static closeAll(): void;
}

declare type CustomToolbarComponent<T extends ToolbarItemType = ToolbarItemType> = FunctionalComponent<CustomToolbarProps<T>>;

declare interface CustomToolbarEvent extends EmitableEvent {
    add: (item: ValueOf<ToolbarItemMap>) => void;
    delete: (item: ValueOf<ToolbarItemMap>) => void;
    set: (id: string, data: Partial<SettableItemData>) => void;
    emit: (id: string, item: ValueOf<ToolbarItemMap>) => void;
    posChange: (bar: CustomToolbar) => void;
}

declare interface CustomToolbarProps<T extends ToolbarItemType = ToolbarItemType> {
    item: ToolbarItemMap[T];
    toolbar: CustomToolbar;
}

declare namespace Damage {
    /** 光环属性 */
    const haloSpecials: Set<number>;
    /** 会被第一类光环修改的怪物特殊属性数值 */
    const changeableHaloValue: Map<number, SelectKey<Enemy, number | undefined>[]>;
    /**
     * 计算伤害时会用到的勇士属性，攻击防御，其余的不会有buff加成，直接从core.status.hero取
     */
    let realStatus: (keyof HeroStatus)[];
    /**
     * 计算怪物伤害
     * @param info 怪物信息
     * @param hero 勇士信息
     */
    function calDamageWith(info: DeepReadonly<EnemyInfo_2>, hero: DeepReadonly<Partial<HeroStatus>>): number | null;
    function ensureFloorDamage(floorId: FloorIds): void;
    function getSingleEnemy(id: EnemyIds): DamageEnemy<"greenSlime" | "redSlime" | "blackSlime" | "slimelord" | "bat" | "bigBat" | "redBat" | "vampire" | "skeleton" | "skeletonWarrior" | "skeletonCaptain" | "ghostSoldier" | "zombie" | "zombieKnight" | "rock" | "slimeman" | "bluePriest" | "redPriest" | "brownWizard" | "redWizard" | "yellowGateKeeper" | "blueGateKeeper" | "redGateKeeper" | "swordsman" | "soldier" | "yellowKnight" | "redKnight" | "darkKnight" | "blackKing" | "yellowKing" | "greenKing" | "blueKnight" | "goldSlime" | "poisonSkeleton" | "poisonBat" | "ironRock" | "skeletonPriest" | "skeletonKing" | "skeletonPresbyter" | "skeletonKnight" | "evilHero" | "devilWarrior" | "demonPriest" | "goldHornSlime" | "redKing" | "blueKing" | "magicMaster" | "silverSlime" | "blademaster" | "whiteHornSlime" | "evilPrincess" | "evilFairy" | "yellowPriest" | "redSwordsman" | "whiteSlimeman" | "poisonZombie" | "dragon" | "octopus" | "fairyEnemy" | "princessEnemy" | "angel" | "elemental" | "steelGuard" | "evilBat" | "silverSlimelord" | "goldSlimelord" | "grayRock" | "greenKnight" | "bowman" | "purpleBowman" | "watcherSlime" | "frostBat" | "devilKnight" | "grayPriest" | "greenGateKeeper" | "keiskeiFairy" | "tulipFairy" | "bearDown" | "bearLeft" | "bearRight" | "bearUp">;
}

declare interface DamageDelta {
    /** 跟最小伤害值的减伤 */
    delta: number;
    damage: number;
    info: DamageInfo_2;
}

declare class DamageEnemy<T extends EnemyIds = EnemyIds> {
    id: T;
    x?: number;
    y?: number;
    floorId?: FloorIds;
    enemy: Enemy<T>;
    col?: EnemyCollection;
    /**
     * 怪物属性。
     * 属性计算流程：预平衡光环(即计算加光环的光环怪的光环) -> 计算怪物在没有光环下的属性
     * -> provide inject 光环 -> 计算怪物的光环加成 -> 计算完毕
     */
    info: EnemyInfo_2;
    /** 向其他怪提供过的光环 */
    providedHalo: Set<number>;
    /**
     * 伤害计算进度，0 -> 预平衡光环 -> 1 -> 计算没有光环的属性 -> 2 -> provide inject 光环
     * -> 3 -> 计算光环加成 -> 4 -> 计算完毕
     */
    private progress;
    constructor(enemy: Enemy<T>, x?: number, y?: number, floorId?: FloorIds, col?: EnemyCollection);
    reset(): void;
    /**
     * 计算怪物在不计光环下的属性，在inject光环之前，预平衡光环之后执行
     */
    calAttribute(): void;
    /**
     * 获取怪物的真实属性信息，在inject光环后执行
     */
    getRealInfo(): EnemyInfo_2;
    getHaloSpecials(): number[];
    /**
     * 光环预提供，用于平衡所有怪的光环属性，避免出现不同情况下光环效果不一致的现象
     */
    preProvideHalo(): void;
    /**
     * 向其他怪提供光环
     */
    provideHalo(): void;
    /**
     * 接受其他怪的光环
     */
    injectHalo(halo: HaloFn, enemy: EnemyInfo_2): void;
    /**
     * 计算怪物伤害
     */
    calDamage(hero?: Partial<HeroStatus>): {
        damage: number;
    };
    /**
     * 计算地图伤害
     * @param damage 存入的对象
     */
    calMapDamage(damage?: Record<string, MapDamage>, hero?: Partial<HeroStatus>): Record<string, MapDamage>;
    setMapDamage(damage: Record<string, MapDamage>, loc: string, dam: number, type?: string): void;
    private calEnemyDamageOf;
    /**
     * 计算怪物临界
     * @param num 要计算多少个临界
     * @param hero 勇士属性，最终结果将会与由此属性计算出的伤害相减计算减伤
     */
    calCritical(num?: number, hero?: Partial<HeroStatus>): CriticalDamageDelta[];
    /**
     * 二分计算怪物临界
     * @param num 计算的临界数量
     * @param min 当前怪物伤害最小值
     * @param seckill 秒杀怪物时的攻击
     * @param hero 勇士真实属性
     */
    private calCriticalWith;
    /**
     * 计算n防减伤
     * @param num 要加多少防御
     * @param hero 勇士属性，最终结果将会与由此属性计算出的伤害相减计算减伤
     */
    calDefDamage(num?: number, hero?: Partial<HeroStatus>): DamageDelta;
    /**
     * 获取怪物秒杀时所需的攻击
     */
    getSeckillAtk(): number;
}

declare interface DamageInfo_2 {
    damage: number;
}

declare const _default: DefineComponent<__VLS_TypePropsToRuntimeProps<{
    num: number;
    ui: GameUi;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps<{
    num: number;
    ui: GameUi;
}>>>, {}, {}>;

declare const _default_10: DefineComponent<__VLS_TypePropsToRuntimeProps_10<{
    num: number;
    ui: GameUi;
    shopId: string;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_10<{
    num: number;
    ui: GameUi;
    shopId: string;
}>>>, {}, {}>;

declare const _default_11: DefineComponent<__VLS_TypePropsToRuntimeProps_11<{
    num: number;
    ui: GameUi;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_11<{
    num: number;
    ui: GameUi;
}>>>, {}, {}>;

declare const _default_12: DefineComponent<{}, {}, {}, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<{}>>, {}, {}>;

declare const _default_13: DefineComponent<__VLS_TypePropsToRuntimeProps_12<{
    num: number;
    ui: GameUi;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_12<{
    num: number;
    ui: GameUi;
}>>>, {}, {}>;

declare const _default_14: DefineComponent<__VLS_TypePropsToRuntimeProps_13<{
    num: number;
    ui: GameUi;
    hotkey: Hotkey;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_13<{
    num: number;
    ui: GameUi;
    hotkey: Hotkey;
}>>>, {}, {}>;

declare const _default_15: DefineComponent<__VLS_TypePropsToRuntimeProps_14<{
    num: number;
    ui: GameUi;
    bar: CustomToolbar;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_14<{
    num: number;
    ui: GameUi;
    bar: CustomToolbar;
}>>>, {}, {}>;

declare const _default_16: DefineComponent<__VLS_TypePropsToRuntimeProps_15<{
    ui: GameUi;
    num: number;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_15<{
    ui: GameUi;
    num: number;
}>>>, {}, {}>;

declare const _default_17: DefineComponent<__VLS_TypePropsToRuntimeProps_16<{
    ui: GameUi;
    num: number;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_16<{
    ui: GameUi;
    num: number;
}>>>, {}, {}>;

declare const _default_18: __VLS_WithTemplateSlots<DefineComponent<__VLS_TypePropsToRuntimeProps_17<{
    dragable?: boolean | undefined;
    resizable?: boolean | undefined;
    left?: number | undefined;
    top?: number | undefined;
    width?: number | undefined;
    height?: number | undefined;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {
    "update:left": (data: number) => void;
    "update:top": (data: number) => void;
    "update:width": (data: number) => void;
    "update:height": (data: number) => void;
}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_17<{
    dragable?: boolean | undefined;
    resizable?: boolean | undefined;
    left?: number | undefined;
    top?: number | undefined;
    width?: number | undefined;
    height?: number | undefined;
}>>> & {
    "onUpdate:left"?: ((data: number) => any) | undefined;
    "onUpdate:top"?: ((data: number) => any) | undefined;
    "onUpdate:width"?: ((data: number) => any) | undefined;
    "onUpdate:height"?: ((data: number) => any) | undefined;
}, {}, {}>, {
    default?(_: {}): any;
}>;

declare const _default_19: DefineComponent<__VLS_TypePropsToRuntimeProps_18<{
    fromBook?: boolean | undefined;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_18<{
    fromBook?: boolean | undefined;
}>>>, {}, {}>;

declare const _default_2: DefineComponent<__VLS_TypePropsToRuntimeProps_2<{
    fromBook?: boolean | undefined;
    defaultPanel?: "special" | "target" | "critical" | undefined;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {
    close: () => void;
}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_2<{
    fromBook?: boolean | undefined;
    defaultPanel?: "special" | "target" | "critical" | undefined;
}>>> & {
    onClose?: (() => any) | undefined;
}, {}, {}>;

declare const _default_3: DefineComponent<__VLS_TypePropsToRuntimeProps_3<{
    num: number;
    ui: GameUi;
    chapter: string;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_3<{
    num: number;
    ui: GameUi;
    chapter: string;
}>>>, {}, {}>;

declare const _default_4: DefineComponent<__VLS_TypePropsToRuntimeProps_4<{
    num: number;
    ui: GameUi;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_4<{
    num: number;
    ui: GameUi;
}>>>, {}, {}>;

declare const _default_5: DefineComponent<__VLS_TypePropsToRuntimeProps_5<{
    num: number;
    ui: GameUi;
    enemy: DamageEnemy;
    close: Ref<boolean>;
    loc: [x: number, y: number];
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {
    close: () => void;
}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_5<{
    num: number;
    ui: GameUi;
    enemy: DamageEnemy;
    close: Ref<boolean>;
    loc: [x: number, y: number];
}>>> & {
    onClose?: (() => any) | undefined;
}, {}, {}>;

declare const _default_6: DefineComponent<__VLS_TypePropsToRuntimeProps_6<{
    num: number;
    ui: GameUi;
    panel?: "special" | "target" | "critical" | undefined;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_6<{
    num: number;
    ui: GameUi;
    panel?: "special" | "target" | "critical" | undefined;
}>>>, {}, {}>;

declare const _default_7: DefineComponent<__VLS_TypePropsToRuntimeProps_7<{
    num: number;
    ui: GameUi;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_7<{
    num: number;
    ui: GameUi;
}>>>, {}, {}>;

declare const _default_8: DefineComponent<__VLS_TypePropsToRuntimeProps_8<{
    num: number;
    ui: GameUi;
    enemy: MarkInfo<EnemyIds>;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_8<{
    num: number;
    ui: GameUi;
    enemy: MarkInfo<EnemyIds>;
}>>>, {}, {}>;

declare const _default_9: DefineComponent<__VLS_TypePropsToRuntimeProps_9<{
    info?: MotaSetting | undefined;
    num: number;
    ui: GameUi;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_9<{
    info?: MotaSetting | undefined;
    num: number;
    ui: GameUi;
}>>>, {}, {}>;

declare function deleteFlags(floorId: FloorIds): void;

/**
 * 删除数组内的某个项，返回删除后的数组
 * @param arr 要操作的数组
 * @param ele 要删除的项
 */
declare function deleteWith<T>(arr: T[], ele: T): T[];

declare const detailInfo: BookDetailInfo;

declare class Disposable_2<T> extends EventEmitter<DisposableEvent<T>> {
    protected _data?: T;
    set data(value: T | null);
    get data(): T | null;
    protected activated: boolean;
    protected destroyed: boolean;
    constructor(data: T);
    active(): void;
    dispose(): void;
    destroy(): void;
}

declare interface DisposableEvent<T> extends EmitableEvent {
    active: (value: T) => void;
    dispose: (value: T) => void;
    destroy: () => void;
}

/**
 * 间隔一段时间调用一个函数
 * @param funcs 函数列表
 * @param interval 调用间隔
 */
declare function doByInterval(funcs: (() => void)[], interval: number, awaitFirst?: boolean): Promise<void>;

/**
 * 下载一个文件
 * @param content 下载的内容
 * @param name 文件名称
 */
declare function download(content: string, name: string): void;

/**
 * 下载一个画布对应的图片
 * @param canvas 画布
 * @param name 图片名称
 */
declare function downloadCanvasImage(canvas: HTMLCanvasElement, name: string): void;

declare type DragFn_2 = (x: number, y: number, e: MouseEvent | TouchEvent) => void;

/**
 * 绘制阴影
 */
declare function drawShadow(): void;

declare interface EmitableEvent {
    [event: string]: (...params: any) => any;
}

declare type EmitFn<F extends (...params: any) => any> = (events: Listener<F>[], ...params: Parameters<F>) => any;

declare class EnemyCollection implements RangeCollection<DamageEnemy> {
    floorId: FloorIds;
    list: DamageEnemy[];
    range: Range_2<DamageEnemy>;
    mapDamage: Record<string, MapDamage>;
    haloList: HaloData[];
    constructor(floorId: FloorIds);
    get(x: number, y: number): DamageEnemy<"greenSlime" | "redSlime" | "blackSlime" | "slimelord" | "bat" | "bigBat" | "redBat" | "vampire" | "skeleton" | "skeletonWarrior" | "skeletonCaptain" | "ghostSoldier" | "zombie" | "zombieKnight" | "rock" | "slimeman" | "bluePriest" | "redPriest" | "brownWizard" | "redWizard" | "yellowGateKeeper" | "blueGateKeeper" | "redGateKeeper" | "swordsman" | "soldier" | "yellowKnight" | "redKnight" | "darkKnight" | "blackKing" | "yellowKing" | "greenKing" | "blueKnight" | "goldSlime" | "poisonSkeleton" | "poisonBat" | "ironRock" | "skeletonPriest" | "skeletonKing" | "skeletonPresbyter" | "skeletonKnight" | "evilHero" | "devilWarrior" | "demonPriest" | "goldHornSlime" | "redKing" | "blueKing" | "magicMaster" | "silverSlime" | "blademaster" | "whiteHornSlime" | "evilPrincess" | "evilFairy" | "yellowPriest" | "redSwordsman" | "whiteSlimeman" | "poisonZombie" | "dragon" | "octopus" | "fairyEnemy" | "princessEnemy" | "angel" | "elemental" | "steelGuard" | "evilBat" | "silverSlimelord" | "goldSlimelord" | "grayRock" | "greenKnight" | "bowman" | "purpleBowman" | "watcherSlime" | "frostBat" | "devilKnight" | "grayPriest" | "greenGateKeeper" | "keiskeiFairy" | "tulipFairy" | "bearDown" | "bearLeft" | "bearRight" | "bearUp"> | undefined;
    /**
     * 解析本地图的怪物信息
     */
    extract(): void;
    /**
     * 计算怪物真实属性
     */
    calRealAttribute(): void;
    /**
     * @deprecated
     * 计算怪物伤害
     * @param noCache 是否不使用缓存
     */
    calDamage(noCache?: boolean): void;
    /**
     * 计算地图伤害
     */
    calMapDamage(): void;
    /**
     * 向怪物施加光环
     * @param type 光环的范围类型
     * @param data 光环范围信息
     * @param halo 光环效果函数
     * @param recursion 是否递归施加，只有在光环预平衡阶段会使用到
     */
    applyHalo<K extends keyof HaloType>(type: K, data: HaloType[K], enemy: DamageEnemy, halo: HaloFn | HaloFn[], recursion?: boolean): void;
    /**
     * 预平衡光环
     */
    preBalanceHalo(): void;
    render(onMap?: boolean, cal?: boolean): void;
}

declare interface EnemyInfo_2 extends Partial<Enemy> {
    atk: number;
    def: number;
    hp: number;
    special: number[];
    atkBuff_: number;
    defBuff_: number;
    hpBuff_: number;
    enemy: Enemy;
    guard?: DamageEnemy[];
    x?: number;
    y?: number;
    floorId?: FloorIds;
}

declare function ensureArray<T>(arr: T): T extends any[] ? T : T[];

declare function ensureArray_2<T>(arr: T): T extends any[] ? T : T[];

/**
 * 判断一个数组的数值是否全部相等
 * @param arr 要判断的数组
 */
declare function equal(arr: number[]): boolean;

/**
 * 判断一个数组的元素的某个属性的数值是否全部相等
 * @param arr 要判断的数组
 * @param key 要判断的属性名
 */
declare function equal<T>(arr: T[], key: keyof T): boolean;

declare namespace equipboxTools {
    export {
        getEquips,
        getAddStatus,
        getNowStatus
    }
}

declare const EVENT_KEY_CODE_MAP: {
    [keyCode: number]: KeyCode;
};

declare class EventEmitter<T extends EmitableEvent = {}> {
    protected events: {
        [P in keyof T]?: Listener<T[P]>[];
    };
    private emitted;
    protected emitter: {
        [P in keyof T]?: EmitFn<T[P]>;
    };
    /**
     * 监听某个事件
     * @param event 要监听的事件类型
     * @param fn 触发事件时执行的函数
     * @param options 监听选项
     */
    on<K extends keyof T>(event: K, fn: T[K], options?: Partial<ListenerOptions>): void;
    /**
     * 取消监听某个事件
     * @param event 要取消监听的事件类型
     * @param fn 要取消监听的函数
     */
    off<K extends keyof T>(event: K, fn: T[K]): void;
    /**
     * 监听事件，并只触发一次
     * @param event 要监听的事件
     * @param fn 监听函数
     */
    once<K extends keyof T>(event: K, fn: T[K]): void;
    /**
     * 触发某个事件
     * @param event 要触发的事件类型
     * @param params 传入的参数
     */
    emit<K extends keyof T>(event: K, ...params: Parameters<T[K]>): ReturnType<T[K]>[];
    emit<K extends keyof T, R>(event: K, ...params: Parameters<T[K]>): R;
    /**
     * 设置一个事件的执行器(emitter)
     * @param event 要设置的事件
     * @param fn 事件执行器，留空以清除触发器
     */
    setEmitter<K extends keyof T>(event: K, fn?: EmitFn<T[K]>): void;
    /**
     * 取消监听所有的事件，删除所有监听函数
     */
    removeAllListeners(): void;
    /**
     * 取消监听一个事件的所有函数
     * @param event 要取消监听的事件
     */
    removeAllListeners(event: keyof T): void;
}

declare type _F<F> = F extends (...params: infer P) => infer R ? [P, R] : never;

declare const filterMap: [FloorIds[], string][];

/**
 * 获取两个坐标的相对方向
 * @param from 初始坐标
 * @param to 指向坐标
 */
declare function findDir(from: Loc, to: Loc): Dir2 | 'none';

declare namespace fixedTools {
    export {
        getLocFromMouseLoc,
        getDetailedEnemy
    }
}

declare function flipBinary(num: number, col: number): number;

declare namespace flyTools {
    export {
        splitArea,
        getArea,
        getMapDrawData,
        getMapData
    }
}

declare class Focus<T = any> extends EventEmitter<FocusEvent_2<T>> {
    /** 显示列表 */
    stack: T[];
    focused: T | null;
    /** 聚焦目标是否平等，在平等时，关闭聚焦目标不再会将其之后的目标全部删除，而是保留 */
    readonly equal: boolean;
    constructor(react?: boolean, equal?: boolean);
    /**
     * 聚焦于一个目标
     * @param target 聚焦目标
     * @param add 如果聚焦目标不在显示列表里面，是否自动追加
     */
    focus(target: T, add?: boolean): void;
    /**
     * 取消聚焦
     */
    unfocus(): void;
    /**
     * 向显示列表中添加物品
     * @param item 添加的物品
     */
    add(item: T): void;
    /**
     * 弹出显示列表中的最后一个物品
     */
    pop(): NonNullable<T> | null;
    /**
     * 从一个位置开始删除显示列表，如果平等，则只会删除一个，否则会将其之后的所有的目标全部删除
     * @param item 从哪开始删除，包括此项
     */
    splice(item: T): void;
    /**
     * 根据索引在显示列表中删除一项
     * @param index 要删除的项的索引
     */
    spliceIndex(index: number): void;
}

declare interface FocusEvent_2<T> extends EmitableEvent {
    focus: (before: T | null, after: T) => void;
    unfocus: (before: T | null) => void;
    add: (item: T) => void;
    pop: (item: T | null) => void;
    splice: (spliced: T[]) => void;
}

declare const fontSize: Ref_2<number>;

declare function formatDamage(damage: number): DamageString;

declare namespace frag_r {
    export {
        init_8 as init,
        applyFragWith,
        withImage
    }
}

declare type _Func = (...params: any) => any;

export declare interface FunctionInterface extends _IBattle, _IHero {
    m: typeof m;
    unwrapBinary: typeof unwarpBinary;
    checkAssist: typeof checkAssist;
    isAssist: typeof isAssist;
    generateKeyboardEvent: typeof generateKeyboardEvent;
    addAnimate: typeof addAnimate;
    removeAnimate: typeof removeAnimate;
}

declare namespace gameCanvas_r {
    export {
        init_6 as default,
        setGameCanvasFilter,
        getCanvasFilterByFloorId,
        setCanvasFilterByFloorId,
        filterMap
    }
}

declare interface GameEvent extends EmitableEvent {
    /** Emitted in events.prototype.resetGame. */
    reset: () => void;
    /** Emitted in src/App.vue setup. */
    mounted: () => void;
    /** Emitted in plugin/ui.js */
    statusBarUpdate: () => void;
    /** Emitted in core/index.ts */
    renderLoaded: () => void;
}

declare class GameListener extends EventEmitter<ListenerEvent> {
    static num: number;
    num: number;
    constructor();
    private init;
}

declare const gameListener: GameListener;

declare interface GameLoadEvent extends EmitableEvent {
    coreLoaded: () => void;
    autotileLoaded: () => void;
    coreInit: () => void;
    materialLoaded: () => void;
}

declare class GameLoading extends EventEmitter<GameLoadEvent> {
    private autotileLoaded;
    private autotileNum?;
    private autotileListened;
    private materialsNum;
    private materialsLoaded;
    constructor();
    addMaterialLoaded(): void;
    addAutotileLoaded(): void;
    /**
     * 当自动原件加载完毕时
     * @param autotiles 自动原件数组
     */
    onAutotileLoaded(autotiles: Partial<Record<AllIdsOf<'autotile'>, HTMLImageElement>>): void;
}

declare namespace gameShadow_r {
    export {
        init_5 as init,
        updateShadow,
        clearShadowCache,
        setCalShadow,
        shadowInfo,
        backgroundInfo,
        blurInfo,
        immersionInfo
    }
}

declare class GameStorage<T extends object = any> {
    static list: GameStorage<any>[];
    key: string;
    data: T;
    constructor(key: string);
    /**
     * 从本地存储读取
     */
    read(): T;
    /**
     * 写入本地存储
     */
    write(): void;
    /**
     * 设置存储的值
     * @param key 存储的名称
     * @param value 存储的值
     */
    setValue<K extends keyof T>(key: K, value: T[K]): void;
    setValue(key: string, value: any): void;
    getValue<K extends keyof T>(key: K): T[K] | null;
    getValue<K extends keyof T>(key: K, defaults: T[K]): T[K];
    getValue<T>(key: string, defaults?: T): T;
    toJSON(): string;
    clear(): void;
    keys(): string[];
    values(): any[];
    entries(): [string, any][];
    /**
     * 获取本游戏的存储键
     * @param key 存储名称
     */
    static fromGame(key: string): string;
    /**
     * 获取与作者相关联的存储键
     * @param _ 填充参数，无用
     * @param key 存储名称
     */
    static fromAuthor(_: any, key: string): string;
    /**
     * 根据存储键获取对应的存储实例
     * @param key 存储键
     * @example Storage.get(Storage.fromAuthor('AncTe', 'setting'));
     */
    static get(key: string): GameStorage<any> | undefined;
}

declare class GameUi extends EventEmitter<GameUiEvent> {
    static uiList: GameUi[];
    component: Component;
    hotkey?: Hotkey;
    id: string;
    symbol: symbol;
    constructor(id: string, component: Component, hotkey?: Hotkey);
    /**
     * 根据 v-on 和 v-bind 创建可以显示的 ui 组件
     * @param vOn 监听的事件
     * @param vBind 绑定的数据
     */
    with(vBind?: UiVBind, vOn?: UiVOn): ShowableGameUi;
}

declare interface GameUiEvent extends EmitableEvent {
    close: () => void;
    open: () => void;
}

/**
 * 根据布尔值数组转换成一个二进制数
 * @param arr 要转换的布尔值数组
 */
declare function generateBinary(arr: boolean[]): number;

declare function generateKeyboardEvent(key: KeyCode, assist: number): KeyboardEvent;

/**
 * 获取装备增加的属性
 * @param equip 装备
 */
declare function getAddStatus(equip: Equip): JSX.Element;

/**
 * 获取所有灯光
 */
declare function getAllLights(): Light[];

declare function getArea(): Record<string, FloorIds[]>;

declare function getCanvasFilterByFloorId(floorId?: FloorIds): string;

/**
 * 根据道具的cls获取中文类型
 * @param cls 道具的cls
 */
declare function getClsName<T extends keyof ClsMap | 'all'>(cls: T): ClsMap[T];

/**
 * 获取怪物的临界信息
 * @param enemy 怪物实例
 */
declare function getCriticalDamage(enemy: ToShowEnemy, addAtk?: number, addDef?: number): [number, number][];

/**
 * 根据伤害大小获取颜色
 * @param damage 伤害大小
 */
declare function getDamageColor(damage: number): Color;

/**
 * 获得怪物的最近100个加防减伤
 * @param enemy 怪物实例
 */
declare function getDefDamage(enemy: ToShowEnemy, addDef?: number, addAtk?: number): [number, number][];

declare function getDetailedEnemy(enemy: DamageEnemy, floorId?: FloorIds): ToShowEnemy;

declare function getEnemy(x: number, y: number, floorId?: FloorIds): DamageEnemy<"greenSlime" | "redSlime" | "blackSlime" | "slimelord" | "bat" | "bigBat" | "redBat" | "vampire" | "skeleton" | "skeletonWarrior" | "skeletonCaptain" | "ghostSoldier" | "zombie" | "zombieKnight" | "rock" | "slimeman" | "bluePriest" | "redPriest" | "brownWizard" | "redWizard" | "yellowGateKeeper" | "blueGateKeeper" | "redGateKeeper" | "swordsman" | "soldier" | "yellowKnight" | "redKnight" | "darkKnight" | "blackKing" | "yellowKing" | "greenKing" | "blueKnight" | "goldSlime" | "poisonSkeleton" | "poisonBat" | "ironRock" | "skeletonPriest" | "skeletonKing" | "skeletonPresbyter" | "skeletonKnight" | "evilHero" | "devilWarrior" | "demonPriest" | "goldHornSlime" | "redKing" | "blueKing" | "magicMaster" | "silverSlime" | "blademaster" | "whiteHornSlime" | "evilPrincess" | "evilFairy" | "yellowPriest" | "redSwordsman" | "whiteSlimeman" | "poisonZombie" | "dragon" | "octopus" | "fairyEnemy" | "princessEnemy" | "angel" | "elemental" | "steelGuard" | "evilBat" | "silverSlimelord" | "goldSlimelord" | "grayRock" | "greenKnight" | "bowman" | "purpleBowman" | "watcherSlime" | "frostBat" | "devilKnight" | "grayPriest" | "greenGateKeeper" | "keiskeiFairy" | "tulipFairy" | "bearDown" | "bearLeft" | "bearRight" | "bearUp"> | null;

/**
 * 获取所有装备
 */
declare function getEquips(): [ItemIdOf<'equips'>, number][];

/**
 * 获取一定状态下的勇士在某一点的属性
 * @param status 勇士的状态
 * @param name 要获取的勇士属性
 * @param floorId 勇士所在楼层
 */
declare function getHeroStatusOf(status: Partial<HeroStatus>, name: 'all', floorId?: FloorIds): HeroStatus;

declare function getHeroStatusOf(status: Partial<HeroStatus>, name: (keyof HeroStatus)[], floorId?: FloorIds): Partial<HeroStatus>;

declare function getHeroStatusOf<K extends keyof HeroStatus>(status: Partial<HeroStatus>, name: K, floorId?: FloorIds): HeroStatus[K];

/**
 * 获取勇士在某一点的属性
 * @param name 要获取的勇士属性
 * @param floorId 勇士所在楼层
 */
declare function getHeroStatusOn(name: 'all', floorId?: FloorIds): HeroStatus;

declare function getHeroStatusOn(name: (keyof HeroStatus)[], floorId?: FloorIds): Partial<HeroStatus>;

declare function getHeroStatusOn<K extends keyof HeroStatus>(name: K, floorId?: FloorIds): HeroStatus[K];

/**
 * 获取某个类型的所有道具
 * @param cls 道具类型
 */
declare function getItems(cls: 'all'): AllItem;

declare function getItems(cls: keyof ClsMap): [string, number][];

/**
 * 获取一个灯光
 * @param id 灯光id
 */
declare function getLight(id: string): Light | undefined;

declare function getLocFromMouseLoc(x: number, y: number): LocArr;

/**
 * 广度优先搜索地图信息
 * @param floorId 中心楼层id
 * @param noCache 是否不使用缓存
 */
declare function getMapData(floorId: FloorIds, noCache?: boolean): MapBFSResult;

/**
 * 获取地图绘制信息
 * @param floorId 中心楼层
 * @param interval 地图间距
 * @param border 边框宽度
 * @param noCache 是否不使用缓存
 */
declare function getMapDrawData(floorId: FloorIds, interval?: number, border?: number, noCache?: boolean): MapDrawData;

/**
 * 获取当前勇士属性，如果有选中的装备，会在后面追加显示增加量
 * @param nowEquip 当前选中的装备
 */
declare function getNowStatus(nowEquip?: Equip, onCol?: boolean): JSX.Element;

/**
 * 获取剩余怪物字符串
 */
declare function getRemainEnemyString(floorIds: FloorIds[]): string[];

/**
 * 获取怪物的特殊技能描述
 * @param enemy 怪物实例
 */
declare function getSpecialHint(enemy: ToShowEnemy): JSX.Element;

/**
 * 获得某个状态的中文名
 * @param name 要获取的属性名
 */
declare function getStatusLabel(name: string): string;

/**
 * 唤起虚拟键盘，并获取到一次按键操作
 * @param emitAssist 是否可以获取辅助按键，为true时，如果按下辅助按键，那么会立刻返回该按键，
 *                   否则会视为开关辅助按键
 * @param assist 初始化的辅助按键
 */
declare function getVitualKeyOnce(emitAssist?: boolean, assist?: number, emittable?: KeyCode[]): Promise<KeyboardEmits>;

declare interface HaloData<T extends keyof HaloType = keyof HaloType> {
    type: T;
    data: HaloType[T];
    special: number;
    from?: DamageEnemy;
}

declare type HaloFn = (info: EnemyInfo_2, enemy: EnemyInfo_2) => void;

declare interface HaloType {
    square: {
        x: number;
        y: number;
        d: number;
    };
    manhattan: {
        x: number;
        y: number;
        d: number;
    };
}

/**
 * 判定一个值是否不是undefined或null
 * @param value 要判断的值
 */
declare function has<T>(value: T): value is NonNullable<T>;

declare function has_2<T>(v: T): v is NonNullable<T>;

declare function hasMarkedEnemy(id: EnemyIds): boolean;

declare namespace hero_2 {
    export {
        getHeroStatusOn,
        getHeroStatusOf
    }
}

declare namespace heroFourFrames_g {
    export {
        init_10 as init
    }
}

declare interface HoldOnController {
    end(noClosePanel?: boolean): void;
}

declare const hook: EventEmitter<GameEvent>;

declare class Hotkey extends EventEmitter<HotkeyEvent> {
    static list: Hotkey[];
    id: string;
    name: string;
    data: Record<string, HotkeyData>;
    keyMap: Map<KeyCode, HotkeyData[]>;
    /** id to name */
    groupName: Record<string, string>;
    /** id to keys */
    groups: Record<string, string[]>;
    enabled: boolean;
    conditionMap: Map<symbol, () => boolean>;
    private scope;
    private scopeStack;
    private grouping;
    constructor(id: string, name: string);
    /**
     * 注册一个按键，id可以包含数字后缀，可以显示为同一个按键操作拥有多个按键可以触发
     * @param data 要注册的按键信息
     */
    register(data: RegisterHotkeyData): this;
    /**
     * 实现一个按键按下时的操作
     * @param id 要实现的按键id，可以不包含数字后缀
     * @param func 按键按下时执行的函数
     */
    realize(id: string, func: HotkeyFunc): this;
    /**
     * 使用一个symbol作为当前作用域，之后调用{@link realize}所实现的按键功能将会添加至此作用域
     * @param symbol 当前作用域的symbol
     */
    use(symbol: symbol): void;
    /**
     * 释放一个作用域，释放后作用域将退回至删除的作用域的上一级
     * @param symbol 要释放的作用域的symbol
     */
    dispose(symbol?: symbol): void;
    /**
     * 设置一个按键信息
     * @param id 要设置的按键的id
     * @param key 要设置成的按键
     * @param assist 辅助按键，三位二进制数据，从低到高依次为`ctrl` `shift` `alt`
     * @param emit 是否触发set事件，当且仅当从fromJSON方法调用时为false
     */
    set(id: string, key: KeyCode, assist: number, emit?: boolean): void;
    /**
     * 触发一个按键
     * @param key 要触发的按键
     * @param assist 辅助按键，三位二进制数据，从低到高依次为`ctrl` `shift` `alt`
     */
    emitKey(key: KeyCode, assist: number, type: KeyEmitType, ev: KeyboardEvent): boolean;
    /**
     * 按键分组，执行后 register 的按键将会加入此分组
     * @param id 组的id
     * @param name 组的名称
     */
    group(id: string, name: string): this;
    /**
     * 启用这个按键控制器
     */
    enable(): void;
    /**
     * 禁用这个按键控制器
     */
    disable(): void;
    /**
     * 在当前作用域下，满足什么条件时触发按键
     * @param fn 条件函数
     */
    when(fn: () => boolean): this;
    toJSON(): string;
    fromJSON(data: string): void;
    private ensureMap;
    /**
     * 根据id获取hotkey实例
     * @param id 要获取的hotkey实例的id
     */
    static get(id: string): Hotkey | undefined;
}

declare interface HotkeyData extends Required<RegisterHotkeyData> {
    key: KeyCode;
    func: Map<symbol, HotkeyFunc>;
    group?: string;
}

declare interface HotkeyEvent extends EmitableEvent {
    set: (id: string, key: KeyCode, assist: number) => void;
    emit: (key: KeyCode, assist: number, type: KeyEmitType) => void;
}

/**
 * @param id 此处的id包含数字后缀
 */
declare type HotkeyFunc = (id: string, code: KeyCode, ev: KeyboardEvent) => void;

declare interface HotkeyToolbarItem extends ToolbarItemBase<'hotkey'> {
    key: KeyCode;
    assist: number;
}

declare type _IBattle = typeof battle;

declare type _IHero = typeof hero_2;

declare const immersionInfo: Partial<Record<FloorIds, number>>;

/**
 * -1 if a ScanCode => KeyCode mapping depends on kb layout.
 */
declare const IMMUTABLE_CODE_TO_KEY_CODE: KeyCode[];

/**
 * -1 if a KeyCode => ScanCode mapping depends on kb layout.
 */
declare const IMMUTABLE_KEY_CODE_TO_CODE: ScanCode[];

export declare interface IMota {
    rewrite: typeof rewrite;
    r: typeof r;
    rf: typeof rf;
    /** 样板插件接口 */
    Plugin: IPlugin;
    /**
     * 样板使用的第三方库接口，可以直接获取到库的原有接口。
     * 接口在渲染进程中引入，在游戏进程中不会polyfill，因此在游戏进程中使用时，
     * 应先使用main.replayChecking进行检查，保证该值不存在时才进行使用，否则会引起录像出错
     */
    Package: IPackage;
    /**
     * 获取一个样板接口
     * @param type 要获取的接口类型
     * @param key 接口名称
     */
    require<T extends InterfaceType, K extends keyof SystemInterfaceMap[T]>(type: T, key: K): SystemInterfaceMap[T][K];
    /**
     * 获取一个样板接口
     * @param type 要获取的接口类型
     * @param key 接口名称
     */
    require(type: InterfaceType, key: string): any;
    /**
     * 获取一种接口的所有内容
     * @param type 要获取的接口类型
     */
    requireAll<T extends InterfaceType>(type: T): SystemInterfaceMap[T];
    /**
     * 注册一个样板接口
     * @param type 要注册的接口类型
     * @param key 接口名称
     * @param data 接口内容
     */
    register<T extends InterfaceType, K extends keyof SystemInterfaceMap[T]>(type: T, key: K, data: SystemInterfaceMap[T][K]): void;
    /**
     * 注册一个样板接口
     * @param type 要注册的接口类型
     * @param key 接口名称
     * @param data 接口内容
     */
    register(type: InterfaceType, key: string, data: any): void;
}

declare class IndexedEventEmitter<T extends EmitableEvent> extends EventEmitter<T> {
    private fnMap;
    /**
     * 监听事件，并将函数与唯一标识符绑定
     * @param event 事件类型
     * @param symbol 监听函数的唯一标识符
     * @param fn 监听函数
     * @param options 监听配置
     */
    onIndex<K extends keyof T>(event: K, symbol: IndexedSymbol, fn: T[K], options?: Partial<ListenerOptions>): void;
    /**
     * 监听事件，绑定唯一标识符，但监听函数只会执行一次
     * @param event 要监听的事件
     * @param symbol 监听函数的唯一标识符
     * @param fn 监听函数
     */
    onceIndex<K extends keyof T>(event: K, symbol: IndexedSymbol, fn: T[K]): void;
    /**
     * 取消监听一个事件
     * @param event 要取消监听的事件
     * @param symbol 取消监听的函数的唯一标识符
     */
    offIndex<K extends keyof T>(event: K, symbol: IndexedSymbol): void;
    private ensureMap;
}

declare interface IndexedGameUi extends ShowableGameUi {
    num: number;
    vBind?: MountedVBind;
}

declare type IndexedSymbol = number | string | symbol;

declare function init(): {
    useDrag: typeof useDrag;
    useWheel: typeof useWheel;
    useUp: typeof useUp;
    isMobile: boolean;
};

declare function init_10(): void;

declare function init_11(): void;

declare function init_12(): void;

declare function init_2(): {
    has: typeof has;
    getDamageColor: typeof getDamageColor;
    parseCss: typeof parseCss;
    tip: typeof tip;
    changeLocalStorage: typeof changeLocalStorage;
};

declare function init_3(): void;

declare function init_4(): void;

declare function init_5(): void;

declare function init_6(): {
    setGameCanvasFilter: typeof setGameCanvasFilter;
    getCanvasFilterByFloorId: typeof getCanvasFilterByFloorId;
    setCanvasFilterByFloorId: typeof setCanvasFilterByFloorId;
};

declare function init_7(): void;

declare function init_8(): void;

declare function init_9(): void;

/**
 * 初始化阴影画布
 */
declare function initShadowCanvas(): void;

declare type InRangeFn<C extends Partial<Loc>> = (collection: Range_2<C>, data: any, item: Partial<Loc>) => boolean;

declare type InterfaceType = keyof SystemInterfaceMap;

export declare interface IPackage {
    /**
     * 获取样板使用的第三方库
     * @param name 要获取的第三方库
     */
    require<K extends keyof PackageInterface>(name: K): PackageInterface[K];
    /**
     * 获取样板使用的所有第三方库
     */
    requireAll(): PackageInterface;
    register<K extends keyof PackageInterface>(name: K, data: PackageInterface[K]): void;
}

export declare interface IPlugin {
    inited: boolean;
    /**
     * 初始化所有插件
     */
    init(): void;
    /**
     * 获取到一个插件的内容
     * @param plugin 要获取的插件
     */
    require<K extends keyof PluginInterface>(plugin: K): PluginInterface[K];
    /**
     * 获取到一个插件的内容
     * @param plugin 要获取的插件
     */
    require(plugin: string): any;
    /**
     * 获取所有插件
     */
    requireAll(): PluginInterface & {
        [x: string]: any;
    };
    /**
     * 注册一个插件
     * @param plugin 要注册的插件名
     * @param data 插件内容
     * @param init 插件的初始化函数，可选，初始化函数接受两个参数，分别是plugin和data，表示插件名称和内容
     */
    register<K extends keyof PluginInterface>(plugin: K, data: PluginInterface[K], init?: (plugin: K, data: PluginInterface[K]) => void): void;
    /**
     * 注册一个插件
     * @param plugin 要注册的插件名
     * @param init 插件的初始化函数，初始化函数接受一个参数，表示插件名称，要求返回插件内容
     */
    register<K extends keyof PluginInterface>(plugin: K, init: (plugin: K) => PluginInterface[K]): void;
    /**
     * 注册一个插件
     * @param plugin 要注册的插件名
     * @param data 插件内容
     * @param init 插件的初始化函数，可选，初始化函数接受两个参数，分别是plugin和data，表示插件名称和内容
     */
    register<K extends string, D>(plugin: K, data: D, init?: (plugin: K, data: D) => void): void;
    /**
     * 注册一个插件
     * @param plugin 要注册的插件名
     * @param init 插件的初始化函数，初始化函数接受一个参数，表示插件名称，要求返回插件内容
     */
    register<K extends string>(plugin: K, init: (plugin: K) => any): void;
}

declare function isAssist(key: KeyCode): boolean;

/**
 * 是否是移动设备
 */
declare let isMobile: boolean;

declare function isShopVisited(id: string): any;

declare namespace itemDetail_g {
    export {
        init_12 as init
    }
}

declare interface ItemToolbarItem extends ToolbarItemBase<'item'> {
    item: ItemIdOf<'tools' | 'constants'>;
}

/**
 * 虚拟按键，同一个虚拟按键实例应当只能同时操作一个，但可以显示多个
 */
declare class Keyboard extends EventEmitter<VirtualKeyboardEvent> {
    static list: Keyboard[];
    id: string;
    keys: KeyboardItem[];
    assist: number;
    fontSize: number;
    scope: symbol;
    private scopeStack;
    private onEmitKey;
    private scopeAssist;
    constructor(id: string);
    /**
     * 给虚拟键盘添加一个按键
     * @param item 按键信息
     */
    add(item: KeyboardItem): this;
    /**
     * 移除一个按键
     * @param item 按键信息
     */
    remove(item: KeyboardItem): this;
    /**
     * 创造一个在某些辅助按键已经按下的情况下的作用域，这些被按下的辅助按键还可以被玩家手动取消
     * @param assist 辅助按键
     */
    withAssist(assist: number): symbol;
    /**
     * 创造一个虚拟按键作用域，所有监听的事件与其他作用域不冲突
     * @returns 作用域的唯一标识符
     */
    createScope(): symbol;
    /**
     * 释放一个作用域，同时删除其中的所有监听器
     */
    disposeScope(): void;
    /**
     * 继承一个按键的按键信息
     * @param keyboard 要被继承的按键
     * @param offsetX 被继承的按键的横坐标偏移量
     * @param offsetY 被继承的按键的纵坐标偏移量
     */
    extend(keyboard: Keyboard, offsetX?: number, offsetY?: number): this;
    /**
     * 触发按键
     * @param key 要触发的按键
     */
    emitKey(key: KeyboardItem, index: number): void;
    static get(id: string): Keyboard | undefined;
}

declare interface KeyboardEmits {
    key: KeyCode;
    assist: number;
}

declare interface KeyboardItem {
    key: KeyCode;
    text?: string;
    x: number;
    y: number;
    width: number;
    height: number;
}

declare function KeyChord(firstPart: number, secondPart: number): number;

/**
 * Virtual Key Codes, the value does not hold any inherent meaning.
 * Inspired somewhat from https://msdn.microsoft.com/en-us/library/windows/desktop/dd375731(v=vs.85).aspx
 * But these are "more general", as they should work across browsers & OS`s.
 */
declare enum KeyCode {
    DependsOnKbLayout = -1,
    /**
     * Placed first to cover the 0 value of the enum.
     */
    Unknown = 0,
    Backspace = 1,
    Tab = 2,
    Enter = 3,
    Shift = 4,
    Ctrl = 5,
    Alt = 6,
    PauseBreak = 7,
    CapsLock = 8,
    Escape = 9,
    Space = 10,
    PageUp = 11,
    PageDown = 12,
    End = 13,
    Home = 14,
    LeftArrow = 15,
    UpArrow = 16,
    RightArrow = 17,
    DownArrow = 18,
    Insert = 19,
    Delete = 20,
    Digit0 = 21,
    Digit1 = 22,
    Digit2 = 23,
    Digit3 = 24,
    Digit4 = 25,
    Digit5 = 26,
    Digit6 = 27,
    Digit7 = 28,
    Digit8 = 29,
    Digit9 = 30,
    KeyA = 31,
    KeyB = 32,
    KeyC = 33,
    KeyD = 34,
    KeyE = 35,
    KeyF = 36,
    KeyG = 37,
    KeyH = 38,
    KeyI = 39,
    KeyJ = 40,
    KeyK = 41,
    KeyL = 42,
    KeyM = 43,
    KeyN = 44,
    KeyO = 45,
    KeyP = 46,
    KeyQ = 47,
    KeyR = 48,
    KeyS = 49,
    KeyT = 50,
    KeyU = 51,
    KeyV = 52,
    KeyW = 53,
    KeyX = 54,
    KeyY = 55,
    KeyZ = 56,
    Meta = 57,
    ContextMenu = 58,
    F1 = 59,
    F2 = 60,
    F3 = 61,
    F4 = 62,
    F5 = 63,
    F6 = 64,
    F7 = 65,
    F8 = 66,
    F9 = 67,
    F10 = 68,
    F11 = 69,
    F12 = 70,
    F13 = 71,
    F14 = 72,
    F15 = 73,
    F16 = 74,
    F17 = 75,
    F18 = 76,
    F19 = 77,
    NumLock = 78,
    ScrollLock = 79,
    /**
     * Used for miscellaneous characters; it can vary by keyboard.
     * For the US standard keyboard, the ';:' key
     */
    Semicolon = 80,
    /**
     * For any country/region, the '+' key
     * For the US standard keyboard, the '=+' key
     */
    Equal = 81,
    /**
     * For any country/region, the ',' key
     * For the US standard keyboard, the ',<' key
     */
    Comma = 82,
    /**
     * For any country/region, the '-' key
     * For the US standard keyboard, the '-_' key
     */
    Minus = 83,
    /**
     * For any country/region, the '.' key
     * For the US standard keyboard, the '.>' key
     */
    Period = 84,
    /**
     * Used for miscellaneous characters; it can vary by keyboard.
     * For the US standard keyboard, the '/?' key
     */
    Slash = 85,
    /**
     * Used for miscellaneous characters; it can vary by keyboard.
     * For the US standard keyboard, the '`~' key
     */
    Backquote = 86,
    /**
     * Used for miscellaneous characters; it can vary by keyboard.
     * For the US standard keyboard, the '[{' key
     */
    BracketLeft = 87,
    /**
     * Used for miscellaneous characters; it can vary by keyboard.
     * For the US standard keyboard, the '\|' key
     */
    Backslash = 88,
    /**
     * Used for miscellaneous characters; it can vary by keyboard.
     * For the US standard keyboard, the ']}' key
     */
    BracketRight = 89,
    /**
     * Used for miscellaneous characters; it can vary by keyboard.
     * For the US standard keyboard, the ''"' key
     */
    Quote = 90,
    /**
     * Used for miscellaneous characters; it can vary by keyboard.
     */
    OEM_8 = 91,
    /**
     * Either the angle bracket key or the backslash key on the RT 102-key keyboard.
     */
    IntlBackslash = 92,
    Numpad0 = 93,
    Numpad1 = 94,
    Numpad2 = 95,
    Numpad3 = 96,
    Numpad4 = 97,
    Numpad5 = 98,
    Numpad6 = 99,
    Numpad7 = 100,
    Numpad8 = 101,
    Numpad9 = 102,
    NumpadMultiply = 103,
    NumpadAdd = 104,
    NUMPAD_SEPARATOR = 105,
    NumpadSubtract = 106,
    NumpadDecimal = 107,
    NumpadDivide = 108,
    /**
     * Cover all key codes when IME is processing input.
     */
    KEY_IN_COMPOSITION = 109,
    ABNT_C1 = 110,
    ABNT_C2 = 111,
    AudioVolumeMute = 112,
    AudioVolumeUp = 113,
    AudioVolumeDown = 114,
    BrowserSearch = 115,
    BrowserHome = 116,
    BrowserBack = 117,
    BrowserForward = 118,
    MediaTrackNext = 119,
    MediaTrackPrevious = 120,
    MediaStop = 121,
    MediaPlayPause = 122,
    LaunchMediaPlayer = 123,
    LaunchMail = 124,
    LaunchApp2 = 125,
    /**
     * VK_CLEAR, 0x0C, CLEAR key
     */
    Clear = 126,
    /**
     * Placed last to cover the length of the enum.
     * Please do not depend on this value!
     */
    MAX_VALUE = 127
}

/**
 * 获取事件中的keycode对应的键
 * @param key 要获取的键
 */
declare function keycode(key: number): KeyCode;

declare namespace keyCodes {
    export {
        KeyChord,
        KeyCode,
        ScanCode,
        EVENT_KEY_CODE_MAP,
        NATIVE_WINDOWS_KEY_CODE_TO_KEY_CODE,
        ScanCodeUtils,
        IMMUTABLE_CODE_TO_KEY_CODE,
        IMMUTABLE_KEY_CODE_TO_CODE,
        KeyCodeUtils,
        KeyMod
    }
}

declare namespace KeyCodeUtils {
    function toString(keyCode: KeyCode): string;
    function fromString(key: string): KeyCode;
    function toUserSettingsUS(keyCode: KeyCode): string;
    function toUserSettingsGeneral(keyCode: KeyCode): string;
    function fromUserSettings(key: string): KeyCode;
    function toElectronAccelerator(keyCode: KeyCode): string | null;
}

declare type KeyEmitType = 'down' | 'up';

declare const enum KeyMod {
    CtrlCmd = 2048,
    Shift = 1024,
    Alt = 512,
    WinCtrl = 256
}

declare interface Light {
    id: string;
    x: number;
    y: number;
    r: number;
    /** 衰减开始半径 */
    decay: number;
    /** 颜色，每个值的范围0.0~1.0 */
    color: Color;
    /** 是否可以被物体遮挡 */
    noShelter?: boolean;
    /** 是否跟随勇士 */
    followHero?: boolean;
    /** 正在动画的属性 */
    _animating?: Record<string, boolean>;
    /** 执行渐变的属性 */
    _transition?: Record<string, TransitionInfo>;
    /** 表示是否是代理，只有设置渐变后才会变为true */
    _isProxy?: boolean;
    /** 跟随勇士的时候的偏移量 */
    _offset?: Loc;
}

declare interface Listener<T extends (...params: any) => any> {
    fn: T;
    once?: boolean;
    immediate?: boolean;
}

declare type Listener_2 = AudioParamOf<AudioListener>;

declare interface ListenerEvent extends EmitableEvent {
    hoverBlock: (block: Block, ev: MouseEvent) => void;
    leaveBlock: (block: Block, ev: MouseEvent, leaveGame: boolean) => void;
    clickBlock: (block: Block, ev: MouseEvent) => void;
    mouseMove: (ev: MouseEvent) => void;
}

declare interface ListenerOptions {
    once: boolean;
    immediate: boolean;
}

declare function listShopIds(): string[];

declare const loading: GameLoading;

/**
 * 创建一个MComponent实例，由于该函数在创建ui时会频繁使用，因此使用m这个简单的名字作为函数名
 * @returns 一个新的MComponent实例
 */
declare function m(): MComponent;

/**
 * 计算曼哈顿距离
 */
declare function manhattan(x1: number, y1: number, x2: number, y2: number): number;

declare interface MapBFSResult {
    maps: FloorIds[];
    link: Record<BFSFromString, BFSToString>;
}

declare interface MapDamage {
    damage: number;
    type: Set<string>;
    repulse?: LocArr[];
    ambush?: DamageEnemy[];
}

declare interface MapDrawData {
    locs: Partial<Record<FloorIds, LocArr>>;
    line: [number, number, number, number][];
    width: number;
    height: number;
}

declare namespace mark {
    export {
        markEnemy,
        unmarkEnemy,
        checkMarkedEnemy,
        hasMarkedEnemy,
        MarkInfo
    }
}

/**
 * 标记一个怪物，标记后的怪物会在勇士刚好能打过怪物时、伤害刚好小于勇士生命值的2/3和1/3时、踩到临界时提示
 * @param id 标记的怪物id
 */
declare function markEnemy(id: EnemyIds): void;

declare interface MarkInfo<T extends EnemyIds> {
    id: T;
    enemy: DamageEnemy<T>;
    /**
     * 提示模式，从低到高位数分别为：
     * 1. 踩临界时
     * 2. 能打过怪物时
     * 3. 小于勇士生命值的2/3时
     * 4. 小于勇士生命值的1/3时
     * 5. 零伤时
     * 6. 小于指定伤害时
     */
    mode: number;
    /** 当前提示状态，提示模式的 2-6 */
    status: number;
    lastAtk: number;
    lastDamage: number;
    markDamage?: number;
    /** 数据更新用，取反更新标记信息 */
    update: Ref_2<boolean>;
}

declare function maxGameScale(n?: number): void;

declare namespace MCGenerator {
    function h(type: string | Component | MComponent, children?: MComponentChildren, config?: MotaComponentConfig): MotaComponent;
    function div(children?: MComponentChildren, config?: NonComponentConfig): MotaComponent;
    function span(children?: MComponentChildren, config?: NonComponentConfig): MotaComponent;
    function canvas(config?: NonComponentConfig): MotaComponent;
    function text(text: string | (() => string), config?: NonComponentConfig): MotaComponent;
    function com(component: Component | MComponent, config: Omit<MotaComponentConfig, 'innerText' | 'component'>): MotaComponent;
    /**
     * 生成一个图标的VNode
     * @param id 图标的id
     * @param width 显示宽度，单位像素
     * @param height 显示高度，单位像素
     * @param noBoarder 显示的时候是否没有边框和背景
     */
    function icon(id: AllIds, width?: number, height?: number, noBoarder?: number): VNode;
    function vfor<T>(items: T[] | (() => T[]), map: (value: T, index: number) => VNode): VForRenderer;
    /**
     * 为一个常量创建为一个函数
     * @param value 要创建成函数的值
     */
    function f<T>(value: T): () => T;
}

declare class MComponent {
    static mountNum: number;
    content: (MotaComponent | VForRenderer)[];
    private onSetupFn?;
    private setupFn?;
    private onMountedFn?;
    private retFn?;
    private propsDef;
    private emitsDef;
    /**
     * 定义一个props，是一个对象，键表示props名称，值表示类型，例如num: Number
     * 对于直接通过`UiController.open`方法打开的ui，应当包含以下两项
     * - num: ui的唯一标识符，类型为Number
     * - ui: 对于的GameUi实例，类型为GameUi
     * @param props 被定义的props
     */
    defineProps(props: Record<string, any>): void;
    /**
     * 定义这个组件的emits，是一个字符串数组，表示emits的名称
     * @param emits 被定义的emits
     */
    defineEmits(emits: string[]): void;
    /**
     * 添加一个div渲染内容
     * @param children 渲染内容的子内容
     * @param config 渲染内容的配置信息，参考 {@link MComponent.h}
     */
    div(children?: MComponentChildren, config?: NonComponentConfig): this;
    /**
     * 添加一个span渲染内容
     * @param children 渲染内容的子内容
     * @param config 渲染内容的配置信息，参考 {@link MComponent.h}
     */
    span(children?: MComponentChildren, config?: NonComponentConfig): this;
    /**
     * 添加一个canvas渲染内容
     * @param config 渲染内容的配置信息，参考 {@link MComponent.h}
     */
    canvas(config?: NonComponentConfig): this;
    /**
     * 添加一个文字渲染内容
     * @param text 要渲染的文字内容
     */
    text(text: string | (() => string), config?: NonComponentConfig): this;
    /**
     * 添加一个组件渲染内容
     * @param component 要添加的组件
     * @param config 渲染内容的配置信息，参考 {@link MComponent.h}
     */
    com(component: Component | MComponent, config?: Omit<MotaComponentConfig, 'innerText' | 'component'>): this;
    /**
     * 列表渲染一系列内容
     * @param items 要遍历的列表，可以是一个数组，也可以是一个返回数组的函数
     * @param map 遍历函数，接收列表的每一项的值和索引，并返回一个VNode，VNode可以通过Vue.h函数，
     *            或者MComponent.vNode函数生成。
     */
    vfor<T>(items: T[] | (() => T[]), map: (value: T, index: number) => VNode): this;
    /**
     * 添加渲染内容，注意区分组件和`MComponent`的区别，组件是经由`MComponent`的`export`函数输出的内容。
     * 该函数是对`Vue`的`h`函数的高度包装，将`h`函数抽象成为了一个模板，然后经由`export`函数导出后直接输出成为一个组件。
     * 而因此，几乎所有内容都要求传入一个函数，一般这个函数会在真正渲染的时候执行，并将返回值作为真正值传入。
     * 不过对于部分内容，例如`slots`和`vfor.map`，并不是这样的。具体用法请参考参数注释。
     * 注意如果使用了该包装，那么是无法实现响应式布局的，如果想要使用响应式布局，就必须调用`setup`方法，
     * 手写全部的`setup`函数。
     * @param type 要添加的渲染内容。
     *             - 可以是一个字符串，表示dom元素，例如`div` `span`等，
     *             - 可以是一个组件，也可以是一个`MComponent`，表示将其的导出作为组件。
     *             - 除此之外，还可以填`text`，表示这个渲染内容是一个单独的文字，同时`children`会无效，
     *               必须填写`config`的`innerText`参数。
     *             - 该值还可以是字符串`component`，表示动态组件，同时必须填入`config`的`component`参数，
     *               同时`children`会无效
     *             - 该值不能填`@v-for`
     * @param children 该渲染内容的子内容。
     *                 - 可以是一个`MComponent`数组，数组内容即是子内容
     *                 - 也可以是一个`MComponent`，表示这个组件内容为子内容
     * @param config 渲染内容的配置内容，包含下列内容，均为可选。
     *               - `innerText`: 当渲染内容为字符串时显示的内容，可以是字符串，或是返回字符串的函数
     *               - `props`: 传入渲染内容的`props`，是一个对象，每个值都是一个函数，其返回值是真正传入的`props`
     *                        对象的键是`prop`名称，如果是如`class` `id`这样的html属性，那么会视为其`attribute`，
     *                        会符合`Vue`的`attribute`透传。对于以on开头，然后紧接着大写字母的属性，会被视为事件监听，
     *                        即v-on
     *               - `component`: 当为动态组件时，该项与`dComponent`必填其中之一，该项表示动态组件的内容
     *               - `dComponent`: 当为动态组件时，该项与`component`必填其中之一，该项是一个函数，返回值表示动态组件的内容
     *                               当`component`也填时，优先使用该项
     *               - `slots`: 传递插槽，将内容传入渲染内容的插槽，是一个对象，每个对象都是一个函数，
     *                        要求函数返回一个渲染VNode或数组，可以通过`MComponent.vNode`函数将组件转换成VNode数组，
     *                        返回值直接作为插槽内容
     *               - `vif`: 条件渲染，是一个函数，返回一个布尔值，表示条件是否满足，当`velse`为`true`时，
     *                      条件渲染将会变成 `else-if`
     *               - `velse`: 条件渲染，当前一个条件不满足时渲染该内容
     */
    h(type: string | Component | MComponent, children?: MComponentChildren, config?: MotaComponentConfig): this;
    /**
     * 当setup被执行时，要执行的函数，接受props，没有返回值，可以不设置
     */
    onSetup(fn: OnSetupFunction): this;
    /**
     * 当组件被挂载完毕后执行函数
     * @param fn 当组件被挂载完毕后执行的函数，接收props和当前级组件（不包含子组件）的所有画布作为参数
     *           当前级组件表示直接在当前组件中渲染的内容，不包括子组件，子组件的画布需要在其对应的函数中获取
     *           例如我在A组件中调用了B组件，那么我只能获取A组件的画布，而不能获取B组件的画布
     */
    onMounted(fn: OnMountedFunction): this;
    /**
     * 完全设置setup执行函数，接收props, slots，并返回一个函数，函数返回VNode，可以不设置
     */
    setup(fn: SetupFunction): this;
    /**
     * 完全设置setup返回的函数，可以不设置
     * @param fn setup返回的函数
     */
    ret(fn: RetFunction): this;
    /**
     * 将这个MComponent实例导出成为一个组件
     */
    export(): (props: {
        [x: string]: any;
    } & {
        [x: `on${Capitalize<string>}`]: ((...args: any[]) => any) | undefined;
    }) => any;
    /**
     * 将单个渲染内容生成为一个单个的VNode
     * @param child 要生成的单个渲染内容
     * @param mount 组件生成时的挂载id，一般不需要填，用于画布获取
     */
    static vNodeS(child: MotaComponent, mount?: number): VNode<RendererNode, RendererElement, {
        [key: string]: any;
    }>;
    /**
     * 将一个MComponent实例生成为一个VNode列表
     * @param mc 要生成VNode的组件
     * @param mount 组件生成时的挂载id，一般不需要填，用于画布获取
     */
    static vNodeM(mc: MComponent, mount?: number): VNode<RendererNode, RendererElement, {
        [key: string]: any;
    }>[];
    /**
     * 将一系列MComponent内容生成为一个VNode列表
     * @param children 要生成VNode的内容列表
     * @param mount 组件生成时的挂载id，一般不需要填，用于画布获取
     */
    static vNode(children: (MotaComponent | VForRenderer | VNode)[], mount?: number): VNode<RendererNode, RendererElement, {
        [key: string]: any;
    }>[];
    /**
     * 获取props的真实值。因为传入渲染内容的props是一个函数，因此需要一层调用
     * @param props 要获取的props
     */
    static unwrapProps(props?: Record<string, () => any>): Record<string, any>;
    /**
     * 在渲染时给一个组件传递props。实际效果为在调用后并不会传递，当被传递的组件被渲染时，将会传递props。
     * @param component 要传递props的组件
     * @param props 要传递的props
     */
    static prop(component: Component, props: Record<string, any>): VNode<RendererNode, RendererElement, {
        [key: string]: any;
    }>;
}

declare type MComponentChildren = (MComponent | MotaComponent | VNode)[] | MComponent | MotaComponent | VNode;

export declare interface ModuleInterface {
    CustomComponents: {
        createSettingComponents: typeof createSettingComponents;
        createToolbarComponents: typeof createToolbarComponents;
        createToolbarEditorComponents: typeof createToolbarEditorComponents;
    };
    Use: typeof use;
    Mark: typeof mark;
    KeyCodes: typeof keyCodes;
    UITools: typeof bookTools & typeof commonTools & typeof equipboxTools & typeof fixedTools & typeof flyTools & typeof statusBarTools & typeof toolboxTools;
    Damage: typeof Damage;
    UI: typeof UI;
    UIComponents: {
        Box: typeof _default_18;
        BoxAnimate: typeof BoxAnimate_2;
        Colomn: typeof Colomn;
        EnemyOne: typeof EnemyOne;
        Scroll: typeof Scroll;
        EnemyCritical: typeof _default_19;
        EnemySpecial: typeof EnemySpecial;
        EnemyTarget: typeof EnemyTarget;
        KeyboardPanel: typeof KeyboardPanel;
    };
    MCGenerator: typeof MCGenerator;
    RenderUtils: typeof utils_2;
    MiscComponents: {
        VirtualKey: typeof VirtualKey;
    };
}

declare interface MotaComponent extends MotaComponentConfig {
    type: string;
    children: (MComponent | MotaComponent | VNode)[];
}

declare interface MotaComponentConfig {
    innerText?: string | (() => string);
    props?: Record<string, () => any>;
    component?: Component | MComponent;
    dComponent?: () => Component;
    /** 传递插槽 */
    slots?: Record<string, (props: Record<string, any>) => VNode | VNode[]>;
    vif?: () => boolean;
    velse?: boolean;
}

declare class MotaSetting extends EventEmitter<SettingEvent> {
    static noStorage: string[];
    readonly list: Record<string, MotaSettingItem>;
    /**
     * 重设设置
     * @param setting 设置信息
     */
    reset(setting: Record<string, boolean | number>): void;
    /**
     * 注册一个数字型设置
     * @param key 设置的键名
     * @param value 设置的值
     */
    register(key: string, name: string, value: number, com?: SettingComponent, step?: [number, number, number]): this;
    /**
     * 注册一个非数字型设置
     * @param key 设置的键名
     * @param value 设置的值
     */
    register(key: string, name: string, value: boolean | MotaSetting, com?: SettingComponent): this;
    /**
     * 获取一个设置信息
     * @param key 要获取的设置的键
     */
    getSetting(key: string): Readonly<MotaSettingItem | null>;
    /**
     * 设置一个设置的值
     * @param key 要设置的设置的键
     * @param value 要设置的值
     */
    setValue(key: string, value: boolean | number, noEmit?: boolean): void;
    /**
     * 增加一个设置的值
     * @param key 要改变的设置的值
     * @param value 值的增量
     */
    addValue(key: string, value: number): void;
    /**
     * 获取一个设置的值，如果获取到的是一个MotaSetting实例，那么返回undefined
     * @param key 要获取的设置
     */
    getValue(key: string): boolean | number | undefined;
    /**
     * 获取一个设置的值，如果获取到的是一个MotaSetting实例，那么返回defaultValue
     * @param key 要获取的设置
     * @param defaultValue 设置的默认值
     */
    getValue<T extends boolean | number>(key: string, defaultValue: T): T;
    /**
     * 设置一个设置的值显示函数
     * @param key 要设置的设置的键
     * @param func 显示函数
     */
    setDisplayFunc(key: string, func: (value: MotaSettingType) => string): this;
    /**
     * 设置一个设置的修改部分组件
     * @param key 要设置的设置的键
     * @param com 设置修改部分的组件
     */
    setValueController(key: string, com: SettingComponent): this;
    /**
     * 设置一个设置的说明
     * @param key 要设置的设置的id
     * @param desc 设置的说明
     */
    setDescription(key: string, desc: string): this;
    private getSettingBy;
}

declare interface MotaSettingItem<T extends MotaSettingType = MotaSettingType> {
    name: string;
    key: string;
    value: T;
    controller: SettingComponent;
    description?: string;
    defaults?: boolean | number;
    step?: [number, number, number];
    display?: (value: T) => string;
}

declare type MotaSettingType = boolean | number | MotaSetting;

declare interface MountedVBind {
    num: number;
    ui: GameUi;
    [x: string]: any;
}

/**
 * 移动一个灯光
 * @param id 灯光id
 * @param x 目标横坐标
 * @param y 目标纵坐标
 * @param time 移动时间
 * @param mode 移动方式，渐变函数
 * @param relative 相对模式，相对还是绝对
 */
declare function moveLight(id: string, x: number, y: number, time?: number, mode?: TimingFn, relative?: boolean): void;

/**
 * 以一个路径移动光源
 * @param id 灯光id
 * @param time 移动时长
 * @param path 移动路径
 * @param mode 移动方式，渐变函数，表示移动的完成度
 * @param relative 相对模式，相对还是绝对
 */
declare function moveLightAs(id: string, time: number, path: PathFn, mode?: TimingFn, relative?: boolean): void;

declare const NATIVE_WINDOWS_KEY_CODE_TO_KEY_CODE: {
    [nativeKeyCode: string]: KeyCode;
};

/**
 * 在下一帧执行某个函数
 * @param cb 执行的函数
 */
declare function nextFrame(cb: (time: number) => void): void;

declare type NonComponentConfig = Omit<MotaComponentConfig, 'innerText' | 'component' | 'slots' | 'dComponent'>;

declare function ofDir(x: number, y: number, dir: Dir2): LocArr;

declare type OnMountedFunction = (props: Record<string, any>, ctx: SetupContext, canvas: HTMLCanvasElement[]) => void;

declare type OnSetupFunction = (props: Record<string, any>, ctx: SetupContext) => void;

declare function openShop(shopId: string, noRoute: boolean): boolean | undefined;

export declare interface PackageInterface {
    axios: axios;
    'chart.js': chartJs;
    jszip: jszip;
    lodash: lodashEs;
    'lz-string': lzString;
    'mutate-animate': mutateAnimate;
    vue: vue;
}

declare type Panner = AudioParamOf<PannerNode>;

/**
 * 解析css字符串为CSSStyleDeclaration对象
 * @param css 要解析的css字符串
 */
declare function parseCss(css: string): Partial<Record<CanParseCss_2, string>>;

declare function pColor(color: string): Color;

export declare interface PluginInterface {
    pop_r: typeof pop_r;
    use_r: typeof use;
    fly_r: typeof flyTools;
    shadow_r: typeof shadow_r;
    gameShadow_r: typeof gameShadow_r;
    gameCanvas_r: typeof gameCanvas_r;
    smooth_r: typeof smooth_r;
    frag_r: typeof frag_r;
    utils_g: typeof utils_g;
    shop_g: typeof shop_g;
    replay_g: typeof replay_g;
    removeMap_g: typeof removeMap_g;
    remainEnemy_g: typeof remainEnemy_g;
    heroFourFrames_g: typeof heroFourFrames_g;
    rewrite_g: typeof rewrite_g;
    itemDetail_g: typeof itemDetail_g;
}

declare class Polygon {
    /**
     * 多边形的节点
     */
    nodes: LocArr[];
    private cache;
    static from(...polygons: LocArr[][]): Polygon[];
    constructor(nodes: LocArr[]);
    /**
     * 获取一个点光源下的阴影
     */
    shadowArea(x: number, y: number, r: number): LocArr[][];
}

declare namespace pop_r {
    export {
        init_3 as init,
        addPop
    }
}

/**
 * 在渲染进程包裹下执行一段代码，该段代码不会在录像验证及编辑器中执行，因此里面的内容一定不会引起录像报错
 * 一般特效，或者是ui显示、内容显示、交互监听等内容应当在渲染进程包裹下执行。
 * 无法获取到执行内容的返回值，因为渲染进程中的值不应当直接出现在游戏进程中，否则很可能导致录像出错，
 * 如果需要其返回值，应当直接在函数后面新增内容，而不是在游戏进程中使用
 * @param fn 要执行的函数，传入一个参数，表示所有的第三方库，也就是`Mota.Package.requireAll()`的内容
 * @param thisArg 函数的执行上下文，即函数中`this`指向
 */
declare function r<T = undefined>(fn: (this: T, packages: PackageInterface) => void, thisArg?: T): void;

declare class Range_2<C extends Partial<Loc>> {
    collection: RangeCollection<C>;
    cache: Record<string, any>;
    static rangeType: Record<string, RangeType<Partial<Loc>>>;
    constructor(collection: RangeCollection<C>);
    /**
     * 扫描 collection 中在范围内的物品
     * @param type 范围类型
     * @param data 范围数据
     * @returns 在范围内的物品列表
     */
    scan(type: string, data: any): C[];
    inRange(type: string, data: any, item: Partial<Loc>): boolean;
    clearCache(): void;
    static registerRangeType(type: string, scan: RangeScanFn<Partial<Loc>>, inRange: InRangeFn<Partial<Loc>>): void;
}

declare interface RangeCollection<I extends Partial<Loc>> {
    list: I[];
    range: Range_2<I>;
}

declare type RangeScanFn<C extends Partial<Loc>> = (collection: Range_2<C>, data: any) => C[];

declare interface RangeType<C extends Partial<Loc>> {
    scan: RangeScanFn<C>;
    inRange: InRangeFn<C>;
}

declare function ready(): void;

declare function readyClip(): number;

/**
 * 刷新灯光信息并重绘
 */
declare function refreshLight(): void;

declare interface RegisteredCustomToolInfo {
    name: string;
    onEmit: ToolItemEmitFn<ToolbarItemType>;
    show: CustomToolbarComponent;
    editor: CustomToolbarComponent;
    onCreate: (item: any) => ToolbarItemBase<ToolbarItemType>;
}

declare interface RegisterHotkeyData extends Partial<AssistHoykey> {
    id: string;
    name: string;
    defaults: KeyCode;
    type?: KeyEmitType;
}

declare namespace remainEnemy_g {
    export {
        checkRemainEnemy,
        getRemainEnemyString
    }
}

/**
 * 去除所有的光源
 */
declare function removeAllLights(): void;

/**
 * 移除一个动画
 * @param fn 要移除的函数
 */
declare function removeAnimate(fn: (time: number) => void): void;

/**
 * 移除一个光源
 * @param id 光源id
 */
declare function removeLight(id: string): void;

declare namespace removeMap_g {
    export {
        removeMaps,
        deleteFlags,
        resumeMaps,
        autoRemoveMaps
    }
}

declare function removeMaps(fromId: FloorIds, toId: FloorIds, force?: boolean): void;

declare namespace replay_g {
    export {
        ready,
        readyClip,
        clip,
        init_9 as init
    }
}

declare abstract class ResourceController<D, T = D> extends EventEmitter<ResourceControllerEvent> {
    list: Record<string, T>;
    /**
     * 添加一个资源
     * @param uri 资源uri
     * @param data 资源数据
     */
    abstract add(uri: string, data: D): void;
    /**
     * 删除一个资源
     * @param uri 要删除的资源的uri
     */
    remove(uri: string): void;
}

declare interface ResourceControllerEvent<D = any, T = D> extends EmitableEvent {
    add: (uri: string, data: D) => void;
    delete: (uri: string, content: T) => void;
}

declare function resumeMaps(fromId: FloorIds, toId: FloorIds): void;

declare type RetFunction = (props: Record<string, any>, ctx: SetupContext) => VNodeChild | VNodeChild[];

/**
 * 全量复写或在函数前添加内容
 * @param base 函数所在对象
 * @param key 函数名称，即函数在base中叫什么
 * @param type 复写类型，full表示全量复写，front表示在原函数之前添加内容
 * @param re 复写函数，类型为full时表示将原函数完全覆盖，为front时表示将该函数添加到原函数之前
 * @param bind 原函数的调用对象，默认为base
 * @param rebind 复写函数的调用对象，默认为base
 */
declare function rewrite<O, K extends SelectKey<O, _Func>, R extends 'full' | 'front', T = O>(base: O, key: K, type: R, re: (this: T, ...params: [..._F<O[K]>[0], ...any[]]) => R extends 'full' ? _F<O[K]>[1] : void, bind?: any, rebind?: T): (this: T, ...params: [..._F<O[K]>[0], ...any[]]) => _F<O[K]>[1];

/**
 * 在函数后追加内容
 * @param base 函数所在对象
 * @param key 函数名称，即函数在base中叫什么
 * @param type 复写类型，add表示在函数后追加
 * @param re 复写函数，类型为add时表示在原函数后面追加复写函数，会在第一个参数中传入原函数的返回值，
 *           并要求复写函数必须有返回值，作为复写的最终返回值。
 * @param bind 原函数的调用对象，默认为`base`
 * @param rebind 复写函数的调用对象，默认为`base`
 */
declare function rewrite<O, K extends SelectKey<O, _Func>, T = O>(base: O, key: K, type: 'add', re: (this: T, ...params: [_F<O[K]>[1], ..._F<O[K]>[0], ...any[]]) => _F<O[K]>[1], bind?: any, rebind?: T): (this: T, ...params: [..._F<O[K]>[0], ...any[]]) => _F<O[K]>[1];

declare namespace rewrite_g {
    export {
        init_11 as init
    }
}

/**
 * 将一个函数包裹成渲染进程函数，执行这个函数时将直接在渲染进程下执行。该函数与 {@link r} 函数的关系，
 * 与`call`和`bind`的关系类似。
 * ```ts
 * const fn = rf((x) => x * x);
 * console.log(fn(2)); // 在正常游玩中会输出 4，但是录像验证中会输出undefined，因为录像验证中不会执行渲染进程函数
 * ```
 * @param fn 要执行的函数
 * @param thisArg 函数执行时的上下文，即this指向
 * @returns 经过渲染进程包裹的函数，直接调用即是在渲染进程下执行的
 */
declare function rf<F extends (...params: any) => any, T>(fn: F, thisArg?: T): (this: T, ...params: Parameters<F>) => ReturnType<F> | undefined;

/**
 * keyboardEvent.code
 */
declare enum ScanCode {
    DependsOnKbLayout = -1,
    None = 0,
    Hyper = 1,
    Super = 2,
    Fn = 3,
    FnLock = 4,
    Suspend = 5,
    Resume = 6,
    Turbo = 7,
    Sleep = 8,
    WakeUp = 9,
    KeyA = 10,
    KeyB = 11,
    KeyC = 12,
    KeyD = 13,
    KeyE = 14,
    KeyF = 15,
    KeyG = 16,
    KeyH = 17,
    KeyI = 18,
    KeyJ = 19,
    KeyK = 20,
    KeyL = 21,
    KeyM = 22,
    KeyN = 23,
    KeyO = 24,
    KeyP = 25,
    KeyQ = 26,
    KeyR = 27,
    KeyS = 28,
    KeyT = 29,
    KeyU = 30,
    KeyV = 31,
    KeyW = 32,
    KeyX = 33,
    KeyY = 34,
    KeyZ = 35,
    Digit1 = 36,
    Digit2 = 37,
    Digit3 = 38,
    Digit4 = 39,
    Digit5 = 40,
    Digit6 = 41,
    Digit7 = 42,
    Digit8 = 43,
    Digit9 = 44,
    Digit0 = 45,
    Enter = 46,
    Escape = 47,
    Backspace = 48,
    Tab = 49,
    Space = 50,
    Minus = 51,
    Equal = 52,
    BracketLeft = 53,
    BracketRight = 54,
    Backslash = 55,
    IntlHash = 56,
    Semicolon = 57,
    Quote = 58,
    Backquote = 59,
    Comma = 60,
    Period = 61,
    Slash = 62,
    CapsLock = 63,
    F1 = 64,
    F2 = 65,
    F3 = 66,
    F4 = 67,
    F5 = 68,
    F6 = 69,
    F7 = 70,
    F8 = 71,
    F9 = 72,
    F10 = 73,
    F11 = 74,
    F12 = 75,
    PrintScreen = 76,
    ScrollLock = 77,
    Pause = 78,
    Insert = 79,
    Home = 80,
    PageUp = 81,
    Delete = 82,
    End = 83,
    PageDown = 84,
    ArrowRight = 85,
    ArrowLeft = 86,
    ArrowDown = 87,
    ArrowUp = 88,
    NumLock = 89,
    NumpadDivide = 90,
    NumpadMultiply = 91,
    NumpadSubtract = 92,
    NumpadAdd = 93,
    NumpadEnter = 94,
    Numpad1 = 95,
    Numpad2 = 96,
    Numpad3 = 97,
    Numpad4 = 98,
    Numpad5 = 99,
    Numpad6 = 100,
    Numpad7 = 101,
    Numpad8 = 102,
    Numpad9 = 103,
    Numpad0 = 104,
    NumpadDecimal = 105,
    IntlBackslash = 106,
    ContextMenu = 107,
    Power = 108,
    NumpadEqual = 109,
    F13 = 110,
    F14 = 111,
    F15 = 112,
    F16 = 113,
    F17 = 114,
    F18 = 115,
    F19 = 116,
    F20 = 117,
    F21 = 118,
    F22 = 119,
    F23 = 120,
    F24 = 121,
    Open = 122,
    Help = 123,
    Select = 124,
    Again = 125,
    Undo = 126,
    Cut = 127,
    Copy = 128,
    Paste = 129,
    Find = 130,
    AudioVolumeMute = 131,
    AudioVolumeUp = 132,
    AudioVolumeDown = 133,
    NumpadComma = 134,
    IntlRo = 135,
    KanaMode = 136,
    IntlYen = 137,
    Convert = 138,
    NonConvert = 139,
    Lang1 = 140,
    Lang2 = 141,
    Lang3 = 142,
    Lang4 = 143,
    Lang5 = 144,
    Abort = 145,
    Props = 146,
    NumpadParenLeft = 147,
    NumpadParenRight = 148,
    NumpadBackspace = 149,
    NumpadMemoryStore = 150,
    NumpadMemoryRecall = 151,
    NumpadMemoryClear = 152,
    NumpadMemoryAdd = 153,
    NumpadMemorySubtract = 154,
    NumpadClear = 155,
    NumpadClearEntry = 156,
    ControlLeft = 157,
    ShiftLeft = 158,
    AltLeft = 159,
    MetaLeft = 160,
    ControlRight = 161,
    ShiftRight = 162,
    AltRight = 163,
    MetaRight = 164,
    BrightnessUp = 165,
    BrightnessDown = 166,
    MediaPlay = 167,
    MediaRecord = 168,
    MediaFastForward = 169,
    MediaRewind = 170,
    MediaTrackNext = 171,
    MediaTrackPrevious = 172,
    MediaStop = 173,
    Eject = 174,
    MediaPlayPause = 175,
    MediaSelect = 176,
    LaunchMail = 177,
    LaunchApp2 = 178,
    LaunchApp1 = 179,
    SelectTask = 180,
    LaunchScreenSaver = 181,
    BrowserSearch = 182,
    BrowserHome = 183,
    BrowserBack = 184,
    BrowserForward = 185,
    BrowserStop = 186,
    BrowserRefresh = 187,
    BrowserFavorites = 188,
    ZoomToggle = 189,
    MailReply = 190,
    MailForward = 191,
    MailSend = 192,
    MAX_VALUE = 193
}

declare const ScanCodeUtils: {
    lowerCaseToEnum: (scanCode: string) => number;
    toEnum: (scanCode: string) => number;
    toString: (scanCode: ScanCode) => string;
};

/**
 * 设置背景色
 * @param color 背景色
 */
declare function setBackground(color: Color): void;

/**
 * 设置光源的虚化程度
 * @param n 虚化程度
 */
declare function setBlur(n: number): void;

/**
 * 设置是否不计算墙壁遮挡，对所有灯光有效
 * @param n 目标值
 */
declare function setCalShadow(n: boolean): void;

declare function setCanvasFilterByFloorId(floorId?: FloorIds): void;

/**
 * 设置画布的长宽
 * @param canvas 画布
 * @param w 宽度
 * @param h 高度
 */
declare function setCanvasSize(canvas: HTMLCanvasElement, w: number, h: number): void;

declare function setGameCanvasFilter(filter: string): void;

/**
 * 设置一个光源的信息
 * @param id 光源id
 * @param info 光源信息
 */
declare function setLight(id: string, info: Partial<Light>): void;

/**
 * 设置当前的光源列表
 * @param list 光源列表
 */
declare function setLightList(list: Light[]): void;

/**
 * 根据坐标数组设置物体节点
 * @param nodes 坐标数组
 */
declare function setShadowNodes(nodes: LocArr[][]): void;

/**
 * 根据多边形数组设置物体节点
 * @param nodes 多边形数组
 */
declare function setShadowNodes(nodes: Polygon[]): void;

declare function setShopVisited(id: string, visited: boolean): void;

declare type SettableItemData<T extends ToolbarItemType = ToolbarItemType> = Omit<ToolbarItemMap[T], 'id' | 'type'>;

declare type SettingComponent = FunctionalComponent<SettingComponentProps>;

declare interface SettingComponentProps {
    item: MotaSettingItem;
    setting: MotaSetting;
    displayer: SettingDisplayer;
}

declare class SettingDisplayer extends EventEmitter<SettingDisplayerEvent> {
    setting: MotaSetting;
    /** 选项选中栈 */
    selectStack: string[];
    displayInfo: SettingDisplayInfo[];
    constructor(setting: MotaSetting);
    /**
     * 添加选择项
     * @param key 下一个选择项
     */
    add(key: string): void;
    /**
     * 剪切后面的选择项
     * @param index 从哪开始剪切
     */
    cut(index: number, noUpdate?: boolean): void;
    update(): void;
}

declare interface SettingDisplayerEvent extends EmitableEvent {
    update: (stack: string[], display: SettingDisplayInfo[]) => void;
}

declare interface SettingDisplayInfo {
    item: MotaSettingItem | null;
    list: Record<string, MotaSettingItem>;
    text: string[];
}

declare interface SettingEvent extends EmitableEvent {
    valueChange: <T extends boolean | number>(key: string, newValue: T, oldValue: T) => void;
}

declare type SetupFunction = (props: Record<string, any>, ctx: SetupContext) => RenderFunction | Promise<RenderFunction>;

declare namespace shadow_r {
    export {
        init_4 as init,
        initShadowCanvas,
        addLight,
        removeLight,
        setLight,
        setLightList,
        removeAllLights,
        getLight,
        getAllLights,
        setBackground,
        refreshLight,
        animateLight,
        transitionLight,
        moveLight,
        moveLightAs,
        animateLightColor,
        setShadowNodes,
        addPolygon,
        setBlur,
        drawShadow,
        Light
    }
}

declare const shadowInfo: Partial<Record<FloorIds, Light[]>>;

declare namespace shop_g {
    export {
        openShop,
        _convertShop_replaceChoices,
        isShopVisited,
        listShopIds,
        canOpenShop,
        setShopVisited,
        canUseQuickShop
    }
}

declare interface ShowableGameUi {
    ui: GameUi;
    vOn?: UiVOn;
    vBind?: UiVBind;
}

/**
 * 滑动数组
 * @param arr
 * @param delta
 */
declare function slide<T>(arr: T[], delta: number): T[];

declare namespace smooth_r {
    export {
        init_7 as init
    }
}

declare class SoundController extends ResourceController<ArrayBuffer, SoundEffect> {
    private seIndex;
    /**
     * 添加一个新的音频
     * @param uri 音频的uri，由于音频也是一种资源，因此格式为`sounds.xxx`
     * @param data 音频的ArrayBuffer信息，会被解析为AudioBuffer
     */
    add(uri: string, data: ArrayBuffer): SoundEffect;
    /**
     * 播放音频
     * @param sound 音效的名称
     * @returns 本次播放的音效的唯一标识符，如果音效不存在返回-1
     */
    play(sound: SoundIds, end?: () => void): number;
    /**
     * 停止一个音效的播放
     * @param id 音效的唯一标识符
     */
    stop(id: number): void;
    /**
     * 停止一个名称的所有音效的播放
     * @param id 音效名称
     */
    stopById(id: SoundIds): void;
    /**
     * 停止所有音效的播放
     */
    stopAll(): void;
    /**
     * 获取一个音效实例
     * @param sound 音效名称
     */
    get(sound: SoundIds): SoundEffect;
    getPlaying(sound?: SoundIds): string[];
}

declare class SoundEffect extends AudioPlayer {
    static playIndex: number;
    /** 音量 */
    static volume: number;
    /** 是否关闭音效 */
    static disable: boolean;
    private playing;
    private _stopingAll;
    private playMap;
    private _stereo;
    gain: GainNode;
    panner: PannerNode | null;
    set volumn(value: number);
    get volumn(): number;
    set stereo(value: boolean);
    get stereo(): boolean;
    constructor(data: ArrayBuffer, stereo?: boolean);
    /**
     * 设置音频路由线路
     * ```txt
     * 不启用立体声：source -> gain -> destination
     * 启用立体声：source -> panner -> gain -> destination
     * ```
     * @param stereo 是否启用立体声
     */
    protected initAudio(stereo?: boolean): void;
    /**
     * 播放音频
     * @returns 音频的唯一id
     */
    playSE(): number | undefined;
    /**
     * 停止所有音频
     */
    stopAll(): void;
    /**
     * 根据唯一id停止音频
     * @param index 音频唯一id
     */
    stopByIndex(index: number): void;
    /**
     * 设置立体声信息
     * @param source 立体声声源位置与朝向
     * @param listener 听者的位置、头顶方向、面朝方向
     */
    setPanner(source?: Partial<Panner>, listener?: Partial<Listener_2>): void;
}

declare interface SpecialDeclaration {
    code: number;
    name: string | ((enemy: Enemy) => string);
    desc: string | ((enemy: Enemy) => string);
    color: string;
}

declare const specials: SpecialDeclaration[];

declare function spliceBy<T>(arr: T[], from: T): T[];

/**
 * 切分地图区域
 */
declare function splitArea(): void;

declare interface SplittedImage {
    canvas: HTMLCanvasElement;
    x: number;
    y: number;
}

/**
 * 设置文字分段换行等
 * @param str 文字
 */
declare function splitText(str: string[]): string;

declare const status_2: Ref_2<boolean>;

declare namespace statusBarTools {
    export {
        status_2 as status,
        fontSize
    }
}

export declare interface SystemInterfaceMap {
    class: ClassInterface;
    fn: FunctionInterface;
    var: VariableInterface;
    module: ModuleInterface;
}

declare function tip(type: Exclude<keyof MessageApi, 'open' | 'config' | 'destroy'>, text: string): void;

declare interface ToolbarItemBase<T extends ToolbarItemType> {
    type: T;
    id: string;
}

declare interface ToolbarItemMap {
    hotkey: HotkeyToolbarItem;
    item: ItemToolbarItem;
    assistKey: AssistKeyToolbarItem;
}

declare type ToolbarItemType = keyof ToolbarItemMap;

declare namespace toolboxTools {
    export {
        getClsName,
        getItems
    }
}

declare type ToolItemEmitFn<T extends ToolbarItemType> = (this: CustomToolbar, id: string, item: ToolbarItemMap[T]) => boolean;

declare interface ToShowEnemy extends CurrentEnemy {
    critical: string;
    criticalDam: string;
    defDam: string;
    /** [名称, 描述, 颜色] */
    special: [string, string, string][];
    damageColor: string;
    showSpecial: [string, string, string][];
    damage: string;
}

declare interface TransitionInfo {
    time: number;
    mode: TimingFn;
}

/**
 * 把一个属性设置为渐变模式
 * @param id 灯光id
 * @param key 渐变的属性
 * @param time 渐变时长
 * @param mode 渐变方式，渐变函数，高级动画提供了大量内置的渐变函数
 */
declare function transitionLight<K extends Exclude<keyof Light, 'id'>>(id: string, key: K, time?: number, mode?: TimingFn): void;

declare function triggerFullscreen(full: boolean): Promise<void>;

/**
 * 使用打字机效果显示一段文字
 * @param str 要打出的字符串
 * @param time 打出总用时，默认1秒，当第四个参数是true时，该项为每个字的平均时间
 * @param timing 打出时的速率曲线，默认为线性变化
 * @param avr 是否将第二个参数视为每个字的平均时间
 * @returns 文字的响应式变量
 */
declare function type(str: string, time?: number, timing?: TimingFn, avr?: boolean): Ref<string>;

declare namespace UI {
    export {
        _default as Book,
        _default_2 as BookDetail,
        _default_3 as Chapter,
        _default_4 as Equipbox,
        _default_5 as Fixed,
        _default_6 as FixedDetail,
        _default_7 as Fly,
        _default_8 as Marked,
        _default_9 as Settings,
        _default_10 as Shop,
        _default_11 as Start,
        _default_12 as StatusBar,
        _default_13 as Toolbox,
        _default_14 as Hotkey,
        _default_15 as Toolbar,
        _default_16 as ToolEditor,
        _default_17 as Performance
    }
}

declare class UiController extends Focus<IndexedGameUi> {
    static list: UiController[];
    list: Record<string, GameUi>;
    num: number;
    show: 'end' | 'all';
    private hold;
    constructor(equal?: boolean);
    /**
     * 设置为仅显示最后一个ui
     */
    showEnd(): void;
    /**
     * 设置为显示所有ui
     */
    showAll(): void;
    /**
     * 根据id获取到ui
     * @param id ui的id
     */
    get(id: string): GameUi;
    /**
     * 暂时保持下一次删除ui不会导致ui整体被关闭，引起ui背景闪烁。
     * 例如可以用于道具栏，打开道具时就应当 holdOn，然后通过道具使用钩子来判断接下来是否要隐藏 app:
     * ```txt
     * hold on -> close -> use item -> hook -> stack.length === 0 ? end() : no action
     * ```
     */
    holdOn(): HoldOnController;
    /**
     * 关闭一个ui，注意如果不是平等模式，在其之后的ui都会同时关闭掉
     * @param num 要关闭的ui的唯一标识符
     */
    close(num: number): void;
    /**
     * 根据id关闭所有同id的ui，注意非平等模式下，会将第一个ui后的所有ui都关闭掉
     * @param id 要关闭的ui的id
     */
    closeByName(id: string): void;
    /**
     * 打开一个新的ui
     * @param id 要打开的ui的id
     * @param vOn 监听的事件
     * @param vBind 绑定的数据
     * @returns ui的唯一标识符
     */
    open(id: string, vBind?: UiVBind, vOn?: UiVOn): number;
    /**
     * 注册一个ui
     * @param id ui的id
     * @param ui 对应的GameUi实例
     */
    register(...ui: GameUi[]): void;
    /**
     * 取消注册一个ui
     * @param id 要取消注册的ui的id
     */
    unregister(...id: string[]): this;
    /**
     * 根据ui的唯一标识符进行聚焦
     * @param num 要聚焦于的ui的唯一标识符
     */
    focusByNum(num: number): void;
    /**
     * 根据唯一标识符获取对应的ui
     * @param num ui的唯一标识符
     */
    getByNum(num: number): IndexedGameUi | undefined;
    /**
     * 根据ui的唯一标识符来判断当前是否存在某个ui
     * @param id ui的唯一标识符
     */
    hasName(id: string): boolean;
}

declare type UiVBind = Record<string, any>;

declare type UiVOn = Record<string, (param?: any) => void>;

declare interface Undoable<T> {
    stack: T[];
    redoStack: T[];
    /**
     * 撤销
     */
    undo(): T | undefined;
    /**
     * 重做
     */
    redo(): T | undefined;
}

declare function unmarkEnemy(id: EnemyIds): void;

declare function unwarpBinary(bin: number): AssistHoykey;

declare function updateShadow(nocache?: boolean): void;

declare namespace use {
    export {
        init as default,
        useDrag,
        cancelGlobalDrag,
        useWheel,
        useUp,
        useDown,
        isMobile
    }
}

/**
 * 当鼠标或手指按下时执行函数
 * @param ele 目标元素
 * @param fn 当鼠标或手指按下时执行的函数
 */
declare function useDown(ele: HTMLElement, fn: DragFn_2): void;

/**
 * 向一个元素添加拖拽事件
 * @param ele 目标元素，当为全局拖拽时，传入数组表示所有元素共用一个全局拖拽函数
 * @param fn 拖拽时触发的函数，传入x y和鼠标事件或点击事件
 * @param ondown 鼠标按下时执行的函数
 * @param global 是否全局拖拽，即拖拽后鼠标或手指离开元素后是否依然视为正在拖拽
 */
declare function useDrag(ele: HTMLElement | HTMLElement[], fn: DragFn_2, ondown?: DragFn_2, onup?: (e: MouseEvent | TouchEvent) => void, global?: boolean): void;

/**
 * 当鼠标或手指松开时执行函数
 * @param ele 目标元素
 * @param fn 当鼠标或手指松开时执行的函数
 */
declare function useUp(ele: HTMLElement, fn: DragFn_2): void;

/**
 * 当触发滚轮时执行函数
 * @param ele 目标元素
 * @param fn 当滚轮触发时执行的函数
 */
declare function useWheel(ele: HTMLElement, fn: (x: number, y: number, z: number, e: WheelEvent) => void): void;

declare namespace utils_2 {
    export {
        init_2 as default,
        has,
        getDamageColor,
        setCanvasSize,
        keycode,
        parseCss,
        type,
        tip,
        splitText,
        nextFrame,
        downloadCanvasImage,
        download,
        doByInterval,
        changeLocalStorage,
        ensureArray,
        pColor,
        deleteWith,
        spliceBy,
        triggerFullscreen,
        generateBinary,
        getStatusLabel,
        flipBinary,
        getVitualKeyOnce
    }
}

declare namespace utils_g {
    export {
        slide,
        backDir,
        has_2 as has,
        maxGameScale,
        ensureArray_2 as ensureArray,
        ofDir,
        manhattan,
        checkV2,
        formatDamage,
        equal,
        boundary,
        findDir
    }
}

export declare interface VariableInterface {
    loading: typeof loading;
    hook: typeof hook;
    gameListener: typeof gameListener;
    mainSetting: MotaSetting;
    gameKey: Hotkey;
    mainUi: UiController;
    fixedUi: UiController;
    KeyCode: typeof KeyCode;
    ScanCode: typeof ScanCode;
    bgm: BgmController;
    sound: SoundController;
    settingStorage: GameStorage;
    status: Ref_2<boolean>;
    enemySpecials: typeof specials;
}

declare interface VForRenderer {
    type: '@v-for';
    items: any[] | (() => any[]);
    map: (value: any, index: number) => VNode;
}

declare function VirtualKey(props: VirtualKeyProps): JSX.Element;

declare interface VirtualKeyboardEvent extends EmitableEvent {
    add: (item: KeyboardItem) => void;
    remove: (item: KeyboardItem) => void;
    extend: (extended: Keyboard) => void;
    emit: VirtualKeyEmitFn;
    scopeCreate: (scope: symbol) => void;
    scopeDispose: (scope: symbol) => void;
}

declare interface VirtualKeyEmit {
    preventDefault(): void;
    preventAssist(): void;
}

declare type VirtualKeyEmitFn = (item: KeyboardItem, assist: number, index: number, ev: VirtualKeyEmit) => void;

declare interface VirtualKeyProps {
    keyboard: Keyboard;
}

declare function withImage(image: CanvasImageSource, sx: number, sy: number, sw: number, sh: number): SplittedImage;

export { }
