var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {


	this.generateMap = function(){
		function getBlankMap(inum){
			inum = inum || 0;
			var ret = [];
			for(var i =0;i<core.__SIZE__;i++){
				var tmp = [];
				for(var j =0;j<core.__SIZE__;j++){
					tmp.push(inum);
				}
				ret.push(tmp);
			}
			return ret;
		}
		var map = getBlankMap();
		var xmap = getBlankMap(10);
		var ymap = getBlankMap(10);
		// 
		for(var i = 0;i<13;i++)map[i][0]=map[0][i]=map[i][12]=map[12][i]=-1;
		
		function isOut(pos){
			return pos.x < 1 || pos.y<1 || pos.x > 10 || pos.y>10;
		}
		function isAlone(pos){
			if(isOut(pos))return false;
			var x1 = pos.x - 1, x2 = pos.x+1;
			var y1 = pos.y - 1, y2 = pos.y+1;
			if(!map[x1][y1] || !map[x2][y1] || !map[x1][y2] || !map[x2][y2])return false;
			return true;
		}

		function getDirectionRoute(pos, dir){
			var scan = core.utils.scan[dir];
			var ret = [];
			var st = {x:pos.x,y:pos.y};
			while(true){
				var r = {x:parseInt(st.x)+scan.x, y:parseInt(st.y)+scan.y};
				if(isOut(r) || map[r.x][r.y]>0)break;
				if(xmap[r.x][r.y]>0 && ymap[r.x][r.y]>0)
					route.push(r);
				st = r;
			}
		}
		function touchWall(pos, dir){
			var scan = core.utils.scan[dir];
			var st = pos;
			while(true){
				var r = {x:parseInt(st.x)+scan.x, y:parseInt(st.y)+scan.y};
				if(isOut(r) || map[r.x][r.y]>0)break;
				if(xmap[r.x][r.y]>0 && ymap[r.x][r.y]>0)
					route.push(r);
				st = r;
			}
			return st;
		}

		var ct = 0;
		function selectOnePoint(pos){
			function getShootList(pos, bias, key, dofun) { // key : list type
				for (var p = parseInt(pos[key]) + bias; p >= 1 && p < core.__SIZE__-1; p += bias) {
					if (key == 'x' && core.getBlock(p, pos.y)) break;
					else if (key == 'y' && core.getBlock(pos.x, p)) break;
					ans.push(p);
				}
			}
			ct++;
			map[pos.x][pos.y] = ct%2;
		}

		var points = [];
		for(var x = 1;x<12;x++){
			for(var y = 1;y<12;y++){
				if(x==6&&y==6)continue;
				points.push({x:x,y:y});
			}
			tmp.push(null);
		}

		while(ct < 120){
			var next = [];
			var tmap = map;
			map = getBlankMap();
			for(var i = 0;i<13;i++)map[i][0]=map[0][i]=map[i][12]=map[12][i]=-1;

			while(points.length>0){
				var p1 = core.rand(points.length);
				var pos = points[p1];
				if(isAlone(pos)){
					next.push(pos);
					points = points.splice(0,p1-1).concat(points.splice(p1+1));
				}else{
					var dirs =  {'left':null,'right':null,'up':null,'down':null};
					for(var d in dirs){
						var route = getDirectionRoute(pos,d);
						if(route.length==0)delete dirs[d];
						else dirs[d] = route;
					}
				}
			}
		}



	}


	this.initialize = function () {
		var coordinate;
		for (var i = 0; i < 60; i++) {
			do coordinate = core.rand(121); while (core.getBlock(coordinate % 11 + 1, Math.floor(coordinate / 11) + 1) || coordinate == 60);
			core.setBlock(201 + i % core.status.hero.def, coordinate % 11 + 1, Math.floor(coordinate / 11) + 1);
			do coordinate = core.rand(121); while (core.getBlock(coordinate % 11 + 1, Math.floor(coordinate / 11) + 1) || coordinate == 60);
			core.setBlock(201 + i % core.status.hero.def, coordinate % 11 + 1, Math.floor(coordinate / 11) + 1);
		}
	};

	this.useBomb = function(){

	}


	this.canConnect = function () {
		var route = core.automaticRoute(flags.x, flags.y);
		var loc = core.status.hero.loc;
		if(loc.x==flags.x && loc.y==flags.y)return false;
		if(core.hasFlag('bomb') && core.getBlockId(loc.x, loc.y) == core.getBlockId(flags.x, flags.y))return true;


		if (core.getBlockId(loc.x, loc.y) != core.getBlockId(flags.x, flags.y) || !route.length) return false;
		if (route.length == Math.max(Math.abs(loc.x - flags.x), Math.abs(loc.y - flags.y))) return true;

		function getShootList(pos, bias, key) { // key : list type
			var ans = [];
			for (var p = parseInt(pos[key]) + bias; p >= 0 && p < core.__SIZE__; p += bias) {
				if (key == 'x' && core.getBlock(p, pos.y)) break;
				else if (key == 'y' && core.getBlock(pos.x, p)) break;
				ans.push(p);
			}
			return ans;
		}

		function intersection(la, lb) {
			var ans = [];
			for (var i in la)
				if (lb.indexOf(la[i]) >= 0) ans.push(la[i]);
			return ans;
		}

		function isClear(p, range, key) { // key : range type
			range.sort(function (a, b) { return a - b; });
			for (var i = parseInt(range[0]); i <= parseInt(range[1]); i++)
				if (key == 'y' && core.getBlock(p, i)) return false;
				else if (key == 'x' && core.getBlock(i, p)) return false;
			return true;
		}
		var hx = getShootList(loc, 1, 'x').concat(getShootList(loc, -1, 'x'));
		var hy = getShootList(loc, 1, 'y').concat(getShootList(loc, -1, 'y'));
		var ex = getShootList(flags, 1, 'x').concat(getShootList(flags, -1, 'x'));
		var ey = getShootList(flags, 1, 'y').concat(getShootList(flags, -1, 'y')); // one time
		if (ex.indexOf(loc.x) >= 0 && hy.indexOf(flags.y) >= 0) return true;
		if (ey.indexOf(loc.y) >= 0 && hx.indexOf(flags.x) >= 0) return true; // two time
		var ix = intersection(hx, ex);
		var iy = intersection(hy, ey);
		for (var i in ix)
			if (isClear(ix[i], [loc.y, flags.y], 'y')) return true;
		for (var i in iy)
			if (isClear(iy[i], [loc.x, flags.x], 'x')) return true;
		return false;
	};
	this._afterLoadResources = function () {};


////// 双击状态栏中的工具箱时 //////
main.statusBar.image.toolbox.onclick = function (e) {
    e.stopPropagation();

    if (core.isReplaying()) {
        return;
    }

    if(core.isPlaying()){
        if(core.hasFlag("bomb")){
            core.removeFlag("bomb");
            core.setHeroIcon("hero.png");
        }else{
            core.setFlag("bomb",true);
            core.setHeroIcon("hero_bomb.png");
        }
    }

}

////// 点击状态栏中的存档按钮时 //////
main.statusBar.image.save.onclick = function (e) {
	e.stopPropagation();

    if (core.isReplaying()) {
        core.speedDownReplay();
        return;
    }

    if (main.core.isPlaying() && (core.status.event||{}).id=='paint') {
        core.actions.savePaint();
        return;
    }

    if (main.core.isPlaying()){
		core.closePanel();
		core.insertAction([
			{"type": "callSave"},
			{"type": "insert", "name": "连连看"},
		  ]);
        main.core.save(true);
	}
}

////// 点击状态栏中的读档按钮时 //////
main.statusBar.image.load.onclick = function (e) {
    e.stopPropagation();

    if (core.isReplaying()) {
        core.speedUpReplay();
        return;
    }

    if (main.core.isPlaying() && (core.status.event||{}).id=='paint') {
        core.actions.loadPaint();
        return;
    }

	if (main.core.isPlaying()){
		core.closePanel();
		core.insertAction([
			{"type": "callLoad"},
			{"type": "insert", "name": "连连看"},
		  ]);
		main.core.save(true);
	}
}


},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
}
}