var data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d = 
{
	"main": {
		"floorIds": [
			"MT0",
			"MT1",
			"MT2",
			"MT3",
			"MT4",
			"MT5",
			"MT6",
			"MT7",
			"MT8",
			"MT9",
			"MT10",
			"MT11",
			"MT12",
			"MT13",
			"MT14",
			"MT15",
			"MT16",
			"MT17",
			"MT18",
			"MT19",
			"MT20",
			"MT21",
			"MT22",
			"MT23"
		],
		"floorPartitions": [],
		"images": [
			"bear.png",
			"bg.jpg",
			"brave.png",
			"dragon.png",
			"hero.png",
			"hero3.png",
			"winskin.png"
		],
		"tilesets": [
			"magictower.png"
		],
		"animates": [
			"hand",
			"sword",
			"zone"
		],
		"bgms": [
			"Sakuzyo_Lunatic.mp3",
			"Sakuzyo_Marshland.mp3"
		],
		"sounds": [
			"attack.mp3",
			"bomb.mp3",
			"cancel.mp3",
			"centerFly.mp3",
			"confirm.mp3",
			"cursor.mp3",
			"door.mp3",
			"equip.mp3",
			"error.mp3",
			"floor.mp3",
			"gem.mp3",
			"icePickaxe.mp3",
			"item.mp3",
			"jump.mp3",
			"load.mp3",
			"open_ui.mp3",
			"pickaxe.mp3",
			"recovery.mp3",
			"save.mp3",
			"shop.mp3",
			"zone.mp3"
		],
		"fonts": [],
		"nameMap": {
			"确定": "confirm.mp3",
			"取消": "cancel.mp3",
			"操作失败": "error.mp3",
			"光标移动": "cursor.mp3",
			"打开界面": "open_ui.mp3",
			"读档": "load.mp3",
			"存档": "save.mp3",
			"获得道具": "item.mp3",
			"回血": "recovery.mp3",
			"炸弹": "bomb.mp3",
			"飞行器": "centerFly.mp3",
			"开关门": "door.mp3",
			"上下楼": "floor.mp3",
			"跳跃": "jump.mp3",
			"破墙镐": "pickaxe.mp3",
			"破冰镐": "icePickaxe.mp3",
			"宝石": "gem.mp3",
			"阻激夹域": "zone.mp3",
			"穿脱装备": "equip.mp3",
			"背景音乐": "bgm.mp3",
			"攻击": "attack.mp3",
			"背景图": "bg.jpg",
			"商店": "shop.mp3",
			"领域": "zone"
		},
		"levelChoose": [
			{
				"title": "轻松",
				"name": "Relax",
				"hard": 1,
				"color": [
					64,
					255,
					223,
					1
				],
				"action": [
					"轻松难度下，生命+10000，攻防+20，护盾+200，红钥匙+1。\n十分简单轻松的难度。\n不建议除魔塔新手外的玩家游玩。",
					{
						"type": "setValue",
						"name": "status:hp",
						"operator": "+=",
						"value": "10000"
					},
					{
						"type": "setValue",
						"name": "status:atk",
						"operator": "+=",
						"value": "20"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"operator": "+=",
						"value": "20"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"operator": "+=",
						"value": "200"
					},
					{
						"type": "setValue",
						"name": "item:redKey",
						"operator": "+=",
						"value": "1"
					}
				]
			},
			{
				"title": "简单",
				"name": "Easy",
				"hard": 2,
				"color": [
					64,
					255,
					85,
					1
				],
				"action": [
					"简单难度下，生命+5000，攻防+5，红钥匙+1。\n适合绝大部分玩家的难度。",
					{
						"type": "setValue",
						"name": "status:hp",
						"operator": "+=",
						"value": "5000"
					},
					{
						"type": "setValue",
						"name": "status:atk",
						"operator": "+=",
						"value": "5"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"operator": "+=",
						"value": "5"
					},
					{
						"type": "setValue",
						"name": "item:redKey",
						"operator": "+=",
						"value": "1"
					}
				]
			},
			{
				"title": "普通",
				"name": "Normal",
				"hard": 3,
				"color": [
					137,
					137,
					187,
					1
				],
				"action": [
					"普通难度无福利。"
				]
			}
		],
		"equipName": [
			"武器",
			"盾牌"
		],
		"startBgm": "Sakuzyo_Lunatic.mp3",
		"styles": {
			"startBackground": "project/images/bg.jpg",
			"startVerticalBackground": "project/images/bg.jpg",
			"startLogoStyle": "color: black",
			"startButtonsStyle": "background-color: #32369F; opacity: 0.85; color: #FFFFFF; border: #FFFFFF 2px solid; caret-color: #FFD700;",
			"statusLeftBackground": "url(project/materials/ground.png) repeat",
			"statusTopBackground": "url(project/materials/ground.png) repeat",
			"toolsBackground": "black",
			"floorChangingStyle": "background-color: black; color: white",
			"statusBarColor": [
				255,
				255,
				255,
				1
			],
			"borderColor": [
				0,
				0,
				0,
				1
			],
			"selectColor": [
				255,
				215,
				0,
				1
			],
			"font": "Verdana"
		},
		"splitImages": [
			{
				"name": "dragon.png",
				"width": 384,
				"height": 96,
				"prefix": "dragon_"
			}
		]
	},
	"firstData": {
		"title": "领袖",
		"name": "leader",
		"version": "Ver 2.10.3",
		"floorId": "MT0",
		"hero": {
			"image": "brave.png",
			"animate": false,
			"name": "勇者",
			"lv": 1,
			"hpmax": 9999,
			"hp": 10000,
			"manamax": -1,
			"mana": 0,
			"atk": 250,
			"def": 250,
			"mdef": 200,
			"money": 0,
			"exp": 0,
			"equipment": [],
			"items": {
				"constants": {},
				"tools": {},
				"equips": {}
			},
			"loc": {
				"direction": "up",
				"x": 6,
				"y": 12
			},
			"flags": {},
			"followers": [],
			"steps": 0
		},
		"startCanvas": [
			{
				"type": "comment",
				"text": "在这里可以用事件来自定义绘制标题界面的背景图等"
			},
			{
				"type": "comment",
				"text": "也可以直接切换到其他楼层（比如某个开始剧情楼层）进行操作。"
			},
			{
				"type": "previewUI",
				"action": [
					{
						"type": "fillRect",
						"x": 0,
						"y": 0,
						"width": "core._PX_ || core.__PIXELS__",
						"height": "core._PY_ || core.__PIXELS__",
						"style": [
							82,
							82,
							82,
							1
						]
					},
					{
						"type": "setAttribute",
						"align": "center"
					},
					{
						"type": "fillBoldText",
						"x": "(core._PX_ || core.__PIXELS__) / 2",
						"y": 80,
						"style": [
							255,
							255,
							255,
							1
						],
						"strokeStyle": [
							0,
							0,
							0,
							1
						],
						"font": "bold 40px Verdana",
						"text": "${core.firstData.title}"
					}
				]
			},
			{
				"type": "setValue",
				"name": "flag:selection",
				"value": "0"
			},
			{
				"type": "comment",
				"text": "在右下方自绘一个对话框进行显示选择项"
			},
			{
				"type": "previewUI",
				"action": [
					{
						"type": "fillRect",
						"x": 230,
						"y": 250,
						"width": 150,
						"height": 142,
						"radius": 10,
						"style": [
							50,
							54,
							159,
							0.85
						]
					},
					{
						"type": "strokeRect",
						"x": 230,
						"y": 250,
						"width": 150,
						"height": 142,
						"radius": 10,
						"style": [
							255,
							255,
							255,
							1
						],
						"lineWidth": 2
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 290,
						"style": [
							255,
							255,
							255,
							1
						],
						"font": "bold 25px Verdana",
						"text": "开始游戏"
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 330,
						"font": "bold 25px Verdana",
						"text": "读取存档"
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 370,
						"font": "bold 25px Verdana",
						"text": "回放录像"
					}
				]
			},
			{
				"type": "while",
				"condition": "1",
				"data": [
					{
						"type": "drawSelector",
						"image": "winskin.png",
						"code": 1,
						"x": 245,
						"y": "261 + 40*flag:selection",
						"width": 120,
						"height": 40
					},
					{
						"type": "wait",
						"data": [
							{
								"case": "keyboard",
								"keycode": "13,32",
								"break": true,
								"action": [
									{
										"type": "switch",
										"condition": "flag:selection",
										"caseList": [
											{
												"case": "0",
												"action": [
													{
														"type": "comment",
														"text": "在“开始游戏”确定"
													},
													{
														"type": "break",
														"n": 1
													}
												]
											},
											{
												"case": "1",
												"action": [
													{
														"type": "comment",
														"text": "在“读取存档”确定"
													},
													{
														"type": "callLoad"
													}
												]
											},
											{
												"case": "2",
												"action": [
													{
														"type": "comment",
														"text": "在“回放录像”确定"
													},
													{
														"type": "if",
														"condition": "(!core.isReplaying())",
														"true": [
															{
																"type": "function",
																"function": "function(){\ncore.chooseReplayFile()\n}"
															}
														]
													}
												]
											}
										]
									}
								]
							},
							{
								"case": "keyboard",
								"keycode": "38",
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "光标上键"
									},
									{
										"type": "setValue",
										"name": "flag:selection",
										"value": "(flag:selection + 2) % 3"
									}
								]
							},
							{
								"case": "keyboard",
								"keycode": "40",
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "光标下键"
									},
									{
										"type": "setValue",
										"name": "flag:selection",
										"value": "(flag:selection + 1) % 3"
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									261,
									300
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“开始游戏”"
									},
									{
										"type": "break",
										"n": 1
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									301,
									340
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“读取存档”"
									},
									{
										"type": "callLoad"
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									341,
									380
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“播放录像”"
									},
									{
										"type": "if",
										"condition": "(!core.isReplaying())",
										"true": [
											{
												"type": "function",
												"function": "function(){\ncore.chooseReplayFile()\n}"
											}
										]
									}
								]
							}
						]
					}
				]
			},
			{
				"type": "setValue",
				"name": "flag:selection",
				"value": "null"
			},
			{
				"type": "drawSelector",
				"code": 1
			},
			{
				"type": "clearMap"
			},
			{
				"type": "function",
				"function": "function(){\ncore.control.checkBgm()\n}"
			},
			{
				"type": "if",
				"condition": "(main.levelChoose.length == 0)",
				"true": [
					{
						"type": "comment",
						"text": "没有难度选择：直接开始游戏"
					}
				],
				"false": [
					{
						"type": "comment",
						"text": "难度选择：作为样例，这里只提供了一个显示选择项。"
					},
					{
						"type": "function",
						"function": "function(){\nvar choices = [];\nmain.levelChoose.forEach(function (one) {\n\tchoices.push({\n\t\t\"text\": one.title || '',\n\t\t\"action\": [\n\t\t\t{ \"type\": \"function\", \"function\": \"function() { core.status.hard = '\" + (one.name || '') + \"'; }\" }\n\t\t]\n\t});\n})\ncore.insertAction({ \"type\": \"choices\", \"choices\": choices });\n}"
					},
					{
						"type": "comment",
						"text": "你也可以仿照上面的样例进行自己创建等待用户操作来处理不同的难度分歧。\n如需自己处理，请设置 core.status.hard \n（例如，自定义js脚本：core.status.hard = 'Easy' ）"
					}
				]
			},
			{
				"type": "clearMap"
			},
			{
				"type": "comment",
				"text": "接下来会执行startText中的事件"
			},
			{
				"type": "comment",
				"text": "状态栏默认处于隐藏状态；可以使用“显示状态栏”事件进行显示。"
			}
		],
		"startText": [
			{
				"type": "loadBgm",
				"name": "Sakuzyo_Marshland.mp3"
			},
			"\t[健康提示]本游戏有点剧情，自认为年龄过低的玩家请自觉退出游戏。\n请勿在现实模仿本塔行为！",
			"很久以前，某个星球上有两个势不两立的阵营。",
			"一个阵营的领袖是黑暗骑士，已经掌握政权20多年了。",
			"这个领袖十分有才能，他吸收前代领袖的思想，并提出一系列原创理论。",
			"正是因为他，魔族的经济和军事都发展得很快。",
			"魔族人都十分崇敬黑暗骑士。",
			"另一边的人族阵营，正在商讨对付魔族的策略。",
			"\t[勇者,T343]魔族势力越来越强大了，已经威胁到了我们的地位。",
			"\t[勇者,T343]你们有什么办法对付他们吗？",
			"\t[霸者,T345]要不要考虑直接发动战争？",
			"\t[勇者,T343]不能。魔族现在军事实力不亚于我们，直接战争会两败俱伤。",
			"\t[贤者,T344]我们要不要……把黑暗骑士弄死？",
			"\t[勇者,T343]这个想法听起来有点令人震惊……",
			"\t[勇者,T343]可以考虑。我们有什么办法？",
			"\t[贤者,T344]最近黑暗骑士在部署边境防御，我们可以趁机击杀他。",
			"\t[勇者,T343]不错。但……黑暗骑士附近的防守应该很严密吧。",
			"\t[贤者,T344]没事，我们有几个道具。",
			"\t[贤者,T344]这个破墙镐，可以破除围绕在黑暗骑士周围的物理外墙。",
			"\t[贤者,T344]这个飞行器，可以飞跃黑暗骑士附近的守卫。",
			"\t[贤者,T344]这颗足以炸翻黑暗骑士的炸弹，爆炸范围很小，建议贴近黑暗骑士后再使用。",
			"\t[贤者,T344]为了保证这颗炸弹一定命中，需要一个人贴近他的身体。",
			"\t[贤者,T344]所以，必须要有一个人牺牲。",
			"\t[贤者,T344]谁去执行这个艰巨的任务？",
			"\t[勇者,T343]让我来吧。",
			"\t[贤者,T344]为什么？",
			"\t[勇者,T343]估计这样做还是会有一些难度，我一定会全力以赴的。",
			"\t[霸者,T345]一人换一人，还都是领袖级别的人物，这样做值吗？",
			"\t[勇者,T343]我相信这很有用，现在先试一试。",
			"\t[贤者,T344]可以。",
			"\t[勇者,T343]等一会你继承我的职位，可以吗？",
			"\t[贤者,T344]好的。",
			"就这样，勇者踏上了刺杀魔族领袖的道路。",
			"而魔族，永远不会猜到，今天竟然……",
			{
				"type": "setValue",
				"name": "item:book",
				"value": "1"
			},
			{
				"type": "setValue",
				"name": "item:fly",
				"value": "1"
			},
			{
				"type": "setValue",
				"name": "item:pickaxe",
				"value": "1"
			},
			{
				"type": "setValue",
				"name": "item:centerFly",
				"value": "1"
			},
			{
				"type": "setValue",
				"name": "item:hammer",
				"value": "1"
			}
		],
		"shops": [
			{
				"id": "shop1",
				"text": "\t[贪婪之神,moneyShop]勇敢的武士啊, 给我${20+2*flag:shop1}金币就可以：",
				"textInList": "1F金币商店",
				"mustEnable": false,
				"disablePreview": false,
				"choices": [
					{
						"text": "生命+800",
						"need": "status:money>=20+2*flag:shop1",
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "20+2*flag:shop1"
							},
							{
								"type": "setValue",
								"name": "flag:shop1",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "800"
							}
						]
					},
					{
						"text": "攻击+4",
						"need": "status:money>=20+2*flag:shop1",
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "20+2*flag:shop1"
							},
							{
								"type": "setValue",
								"name": "flag:shop1",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "status:atk",
								"operator": "+=",
								"value": "4"
							}
						]
					}
				]
			},
			{
				"id": "shop2",
				"text": "\t[贪婪之神,expShop]勇敢的武士啊, 给我一定经验就可以：",
				"textInList": "1F经验商店",
				"mustEnable": false,
				"disablePreview": true,
				"choices": [
					{
						"text": "等级+1（100经验）",
						"need": "status:exp>=100",
						"action": [
							{
								"type": "setValue",
								"name": "status:exp",
								"operator": "-=",
								"value": "100"
							},
							{
								"type": "setValue",
								"name": "status:lv",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "1000"
							}
						]
					}
				]
			},
			{
				"id": "itemShop",
				"item": true,
				"textInList": "道具商店",
				"mustEnable": false,
				"choices": [
					{
						"id": "yellowKey",
						"number": 10,
						"money": "10",
						"sell": "5"
					}
				]
			},
			{
				"id": "keyShop",
				"textInList": "回收钥匙商店",
				"mustEnable": false,
				"commonEvent": "回收钥匙商店"
			}
		],
		"levelUp": [
			{
				"need": "0",
				"title": "",
				"action": [
					{
						"type": "comment",
						"text": "此处是初始等级，只需填写称号"
					}
				]
			},
			{
				"need": "20",
				"title": "",
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"operator": "+=",
						"value": "10"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"operator": "+=",
						"value": "10"
					}
				]
			},
			{
				"need": "40",
				"title": "",
				"action": [
					{
						"type": "tip",
						"text": "恭喜升级"
					}
				]
			}
		]
	},
	"values": {
		"lavaDamage": 100,
		"poisonDamage": 10,
		"weakValue": 20,
		"redGem": 3,
		"blueGem": 3,
		"greenGem": 50,
		"redPotion": 1500,
		"bluePotion": 3000,
		"yellowPotion": 6000,
		"greenPotion": 12000,
		"breakArmor": 0.9,
		"counterAttack": 0.1,
		"purify": 1,
		"hatred": 2,
		"animateSpeed": 300,
		"moveSpeed": 100,
		"statusCanvasRowsOnMobile": 3,
		"floorChangeTime": 100
	},
	"flags": {
		"statusBarItems": [
			"enableFloor",
			"enableHP",
			"enableAtk",
			"enableDef",
			"enableMDef",
			"enableKeys",
			"enablePZF"
		],
		"autoScale": true,
		"extendToolbar": false,
		"flyNearStair": false,
		"flyRecordPosition": true,
		"itemFirstText": false,
		"equipboxButton": false,
		"enableAddPoint": false,
		"enableNegativeDamage": false,
		"betweenAttackMax": false,
		"useLoop": false,
		"startUsingCanvas": false,
		"statusCanvas": false,
		"enableEnemyPoint": true,
		"enableGentleClick": true,
		"ignoreChangeFloor": true,
		"canGoDeadZone": false,
		"enableMoveDirectly": true,
		"enableRouteFolding": true,
		"disableShopOnDamage": false,
		"blurFg": false,
		"hideLeftStatusBar": false
	}
}