var data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d = 
{
	"main": {
		"floorIds": [
			"MT0",
			"MT1",
			"MT2",
			"MT3",
			"MT4",
			"MT5",
			"MT6",
			"MT7",
			"MT8",
			"MT9",
			"MT10"
		],
		"floorPartitions": [
			[
				"A1",
				"MT60"
			],
			[
				"A3",
				"MT181"
			],
			[
				"MT182",
				"MT194"
			],
			[
				"MT195"
			]
		],
		"images": [
			"11.png",
			"1211.png",
			"16.png",
			"17.png",
			"21.png",
			"22.png",
			"33.png",
			"36.png",
			"38.png",
			"46.png",
			"47.png",
			"51.png",
			"54.png",
			"bear.png",
			"bg.jpg",
			"dragon.png",
			"hero.png",
			"winskin.png"
		],
		"tilesets": [
			"magictower.png"
		],
		"animates": [
			"hand",
			"sword",
			"zone"
		],
		"bgms": [
			"bgm.mp3"
		],
		"sounds": [
			"attack.mp3",
			"bomb.mp3",
			"cancel.mp3",
			"centerFly.mp3",
			"confirm.mp3",
			"cursor.mp3",
			"door.mp3",
			"equip.mp3",
			"error.mp3",
			"floor.mp3",
			"gem.mp3",
			"icePickaxe.mp3",
			"item.mp3",
			"jump.mp3",
			"load.mp3",
			"open_ui.mp3",
			"pickaxe.mp3",
			"recovery.mp3",
			"save.mp3",
			"shop.mp3",
			"zone.mp3"
		],
		"fonts": [],
		"nameMap": {
			"确定": "confirm.mp3",
			"取消": "cancel.mp3",
			"操作失败": "error.mp3",
			"光标移动": "cursor.mp3",
			"打开界面": "open_ui.mp3",
			"读档": "load.mp3",
			"存档": "save.mp3",
			"获得道具": "item.mp3",
			"回血": "recovery.mp3",
			"炸弹": "bomb.mp3",
			"飞行器": "centerFly.mp3",
			"开关门": "door.mp3",
			"上下楼": "floor.mp3",
			"跳跃": "jump.mp3",
			"破墙镐": "pickaxe.mp3",
			"破冰镐": "icePickaxe.mp3",
			"宝石": "gem.mp3",
			"阻激夹域": "zone.mp3",
			"穿脱装备": "equip.mp3",
			"背景音乐": "bgm.mp3",
			"攻击": "attack.mp3",
			"背景图": "bg.jpg",
			"商店": "shop.mp3",
			"领域": "zone"
		},
		"levelChoose": null,
		"equipName": [
			"武器",
			"盾牌",
			"戒指",
			"耳环"
		],
		"startBgm": null,
		"styles": {
			"startBackground": "project/images/bg.jpg",
			"startVerticalBackground": "project/images/bg.jpg",
			"startLogoStyle": "color: black",
			"startButtonsStyle": "background-color: #32369F; opacity: 0.85; color: #FFFFFF; border: #FFFFFF 2px solid; caret-color: #FFD700;",
			"statusLeftBackground": "url(project/materials/ground.png) repeat",
			"statusTopBackground": "url(project/materials/ground.png) repeat",
			"toolsBackground": "url(project/materials/ground.png) repeat",
			"borderColor": [
				204,
				204,
				204,
				1
			],
			"statusBarColor": [
				255,
				255,
				255,
				1
			],
			"selectColor": [
				255,
				215,
				0,
				1
			],
			"floorChangingStyle": "background-color: black; color: white",
			"font": "Verdana"
		},
		"splitImages": [
			{
				"name": "dragon.png",
				"width": 384,
				"height": 96,
				"prefix": "dragon_"
			}
		]
	},
	"firstData": {
		"title": "国庆道具塔",
		"name": "guoqingdj1",
		"version": "Ver 2.8.2",
		"floorId": "MT0",
		"hero": {
			"image": "hero.png",
			"animate": false,
			"name": "阳光",
			"lv": 1,
			"hpmax": 9999,
			"hp": 444,
			"manamax": -1,
			"mana": 0,
			"atk": 0,
			"def": 0,
			"mdef": 0,
			"money": 0,
			"exp": 0,
			"equipment": [],
			"items": {
				"constants": {
					"book": 1,
					"setting": 1,
					"postman": 1
				},
				"tools": {},
				"equips": {}
			},
			"loc": {
				"direction": "up",
				"x": 6,
				"y": 6
			},
			"flags": {},
			"followers": [],
			"steps": 0
		},
		"startCanvas": [
			{
				"type": "comment",
				"text": "在这里可以用事件来自定义绘制标题界面的背景图等"
			},
			{
				"type": "comment",
				"text": "也可以直接切换到其他楼层（比如某个开始剧情楼层）进行操作。"
			},
			{
				"type": "previewUI",
				"action": [
					{
						"type": "fillRect",
						"x": 0,
						"y": 0,
						"width": "core.__PIXELS__",
						"height": "core.__PIXELS__",
						"style": [
							82,
							82,
							82,
							1
						]
					},
					{
						"type": "setAttribute",
						"align": "center"
					},
					{
						"type": "fillBoldText",
						"x": "core.__PIXELS__ / 2",
						"y": 80,
						"style": [
							255,
							255,
							255,
							1
						],
						"strokeStyle": [
							0,
							0,
							0,
							1
						],
						"font": "bold 40px Verdana",
						"text": "${core.firstData.title}"
					}
				]
			},
			{
				"type": "setValue",
				"name": "flag:selection",
				"value": "0"
			},
			{
				"type": "comment",
				"text": "在右下方自绘一个对话框进行显示选择项"
			},
			{
				"type": "previewUI",
				"action": [
					{
						"type": "fillRect",
						"x": 230,
						"y": 250,
						"width": 150,
						"height": 142,
						"radius": 10,
						"style": [
							50,
							54,
							159,
							0.85
						]
					},
					{
						"type": "strokeRect",
						"x": 230,
						"y": 250,
						"width": 150,
						"height": 142,
						"radius": 10,
						"style": [
							255,
							255,
							255,
							1
						],
						"lineWidth": 2
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 290,
						"style": [
							255,
							255,
							255,
							1
						],
						"font": "bold 25px Verdana",
						"text": "开始游戏"
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 330,
						"font": "bold 25px Verdana",
						"text": "读取存档"
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 370,
						"font": "bold 25px Verdana",
						"text": "回放录像"
					}
				]
			},
			{
				"type": "while",
				"condition": "1",
				"data": [
					{
						"type": "drawSelector",
						"image": "winskin.png",
						"code": 1,
						"x": 245,
						"y": "261 + 40*flag:selection",
						"width": 120,
						"height": 40
					},
					{
						"type": "wait",
						"data": [
							{
								"case": "keyboard",
								"keycode": "13,32",
								"break": true,
								"action": [
									{
										"type": "switch",
										"condition": "flag:selection",
										"caseList": [
											{
												"case": "0",
												"action": [
													{
														"type": "comment",
														"text": "在“开始游戏”确定"
													},
													{
														"type": "break",
														"n": 1
													}
												]
											},
											{
												"case": "1",
												"action": [
													{
														"type": "comment",
														"text": "在“读取存档”确定"
													},
													{
														"type": "callLoad"
													}
												]
											},
											{
												"case": "2",
												"action": [
													{
														"type": "comment",
														"text": "在“回放录像”确定"
													},
													{
														"type": "if",
														"condition": "(!core.isReplaying())",
														"true": [
															{
																"type": "function",
																"function": "function(){\ncore.chooseReplayFile()\n}"
															}
														]
													}
												]
											}
										]
									}
								]
							},
							{
								"case": "keyboard",
								"keycode": "38",
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "光标上键"
									},
									{
										"type": "setValue",
										"name": "flag:selection",
										"value": "(flag:selection + 2) % 3"
									}
								]
							},
							{
								"case": "keyboard",
								"keycode": "40",
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "光标下键"
									},
									{
										"type": "setValue",
										"name": "flag:selection",
										"value": "(flag:selection + 1) % 3"
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									261,
									300
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“开始游戏”"
									},
									{
										"type": "break",
										"n": 1
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									301,
									340
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“读取存档”"
									},
									{
										"type": "callLoad"
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									341,
									380
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“播放录像”"
									},
									{
										"type": "if",
										"condition": "(!core.isReplaying())",
										"true": [
											{
												"type": "function",
												"function": "function(){\ncore.chooseReplayFile()\n}"
											}
										]
									}
								]
							}
						]
					}
				]
			},
			{
				"type": "setValue",
				"name": "flag:selection",
				"value": "null"
			},
			{
				"type": "drawSelector",
				"code": 1
			},
			{
				"type": "clearMap"
			},
			{
				"type": "function",
				"function": "function(){\ncore.control.checkBgm()\n}"
			},
			{
				"type": "if",
				"condition": "(main.levelChoose.length == 0)",
				"true": [
					{
						"type": "comment",
						"text": "没有难度选择：直接开始游戏"
					}
				],
				"false": [
					{
						"type": "comment",
						"text": "难度选择：作为样例，这里只提供了一个显示选择项。"
					},
					{
						"type": "function",
						"function": "function(){\nvar choices = [];\nmain.levelChoose.forEach(function (one) {\n\tchoices.push({\n\t\t\"text\": one.title || '',\n\t\t\"action\": [\n\t\t\t{ \"type\": \"function\", \"function\": \"function() { core.status.hard = '\" + (one.name || '') + \"'; }\" }\n\t\t]\n\t});\n})\ncore.insertAction({ \"type\": \"choices\", \"choices\": choices });\n}"
					},
					{
						"type": "comment",
						"text": "你也可以仿照上面的样例进行自己创建等待用户操作来处理不同的难度分歧。\n如需自己处理，请设置 core.status.hard \n（例如，自定义js脚本：core.status.hard = 'Easy' ）"
					}
				]
			},
			{
				"type": "clearMap"
			},
			{
				"type": "comment",
				"text": "接下来会执行startText中的事件"
			},
			{
				"type": "comment",
				"text": "状态栏默认处于隐藏状态；可以使用“显示状态栏”事件进行显示。"
			}
		],
		"startText": [
			{
				"type": "comment",
				"text": "初始剧情"
			},
			{
				"type": "comment",
				"text": "血瓶宝石数据默认显示"
			},
			"获得装备后请背包自己装备",
			{
				"type": "setValue",
				"name": "flag:itemDetail",
				"value": "true"
			},
			{
				"type": "setValue",
				"name": "item:book",
				"value": "1"
			},
			{
				"type": "comment",
				"text": "如果不需要显示弹幕，可去除comment相关事件块"
			},
			{
				"type": "setValue",
				"name": "flag:comment",
				"value": "true"
			},
			{
				"type": "function",
				"function": "function(){\n// 默认读取弹幕数据\nif (core.hasFlag('comment') && !core.isReplaying()) {\n\tcore.plugin.getComment();\n\tsetTimeout(core.plugin.drawCommentSign, 1000);\n}\n}"
			}
		],
		"shops": [
			{
				"id": "shop1",
				"text": "\t[贪婪之神,moneyShop]勇敢的武士啊, 给我${20+3*flag:shop1}金币就可以：",
				"textInList": "1F金币商店",
				"mustEnable": false,
				"disablePreview": false,
				"choices": [
					{
						"text": "生命+750",
						"need": "status:money>=20+3*flag:shop1",
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "20+3*flag:shop1"
							},
							{
								"type": "setValue",
								"name": "flag:shop1",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "750"
							}
						]
					},
					{
						"text": "攻击+3",
						"need": "status:money>=20+3*flag:shop1",
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "20+3*flag:shop1"
							},
							{
								"type": "setValue",
								"name": "flag:shop1",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "status:atk",
								"operator": "+=",
								"value": "3"
							}
						]
					},
					{
						"text": "防御+3",
						"need": "status:money>=20+3*flag:shop1",
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "20+3*flag:shop1"
							},
							{
								"type": "setValue",
								"name": "flag:shop1",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "status:def",
								"operator": "+=",
								"value": "3"
							}
						]
					}
				]
			}
		],
		"levelUp": [
			{
				"need": "0",
				"title": "练气一层",
				"action": []
			},
			{
				"need": "15",
				"title": "练气二层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+1"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+1"
					},
					"增加防御1。魔防1"
				]
			},
			{
				"need": "25",
				"title": "练气三层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+7"
					},
					"增加魔防7。"
				]
			},
			{
				"need": "35",
				"title": "练气四层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+1"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+1"
					},
					"增加攻击1。魔防1"
				]
			},
			{
				"need": "55",
				"title": "练气五层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+1"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+1"
					},
					"增加攻击1防御1"
				]
			},
			{
				"need": "100",
				"title": "练气六层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+1"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+2"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+8"
					},
					"增加攻击1防御2魔防8。"
				]
			},
			{
				"need": "250",
				"title": "练气七层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+3"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+2"
					},
					"增加攻击3防御2。"
				]
			},
			{
				"need": "600",
				"title": "练气八层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+6"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+4"
					},
					"增加攻击6防御4。"
				]
			},
			{
				"need": "900",
				"title": "练气九层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+10"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+6"
					},
					"增加攻击10防御6。"
				]
			},
			{
				"need": "1500",
				"title": "练气大圆满",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+15"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+10"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+10"
					},
					"增加攻击15防御10魔防10。"
				]
			},
			{
				"need": "2500",
				"title": "筑基一层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+20"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+15"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+30"
					},
					"增加攻击20防御15魔防30。"
				]
			},
			{
				"need": "4000",
				"title": "筑基二层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+20"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+15"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+30"
					},
					"增加攻击20防御15魔防30。"
				]
			},
			{
				"need": "6000",
				"title": "筑基三层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+25"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+25"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+50"
					},
					"增加攻击25防御25魔防50。"
				]
			},
			{
				"need": "12000",
				"title": "筑基四层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+25"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+20"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+50"
					},
					"增加攻击25防御20魔防50。"
				]
			},
			{
				"need": "20000",
				"title": "筑基五层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+25"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+15"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+60"
					},
					"增加攻击25防御15魔防60。"
				]
			},
			{
				"need": "30000",
				"title": "筑基六层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+40"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+40"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+80"
					},
					"增加攻击40防御40魔防80。"
				]
			},
			{
				"need": "60000",
				"title": "筑基七层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+50"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+50"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+80"
					},
					"增加攻击50防御50魔防80。"
				]
			},
			{
				"need": "70000",
				"title": "筑基八层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+55"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+55"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+90"
					},
					"增加攻击55防御55魔防90。"
				]
			},
			{
				"need": "100000",
				"title": "筑基九层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+60"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+60"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+100"
					},
					"增加攻击60防御60魔防100。"
				]
			},
			{
				"need": "170000",
				"title": "筑基大圆满",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+300"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+300"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+120"
					},
					"增加攻击300防御300魔防120。"
				]
			},
			{
				"need": "250000",
				"title": "金丹一层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+350"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+350"
					},
					"增加攻击350防御350。"
				]
			},
			{
				"need": "330000",
				"title": "金丹二层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+400"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+400"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+400"
					},
					"增加全属性400"
				]
			},
			{
				"need": "400000",
				"title": "金丹三层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+400"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+400"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+400"
					},
					"增加全属性400"
				]
			},
			{
				"need": "480000",
				"title": "金丹四层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+400"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+400"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+400"
					},
					"增加全属性400"
				]
			},
			{
				"need": "560000",
				"title": "金丹五层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+400"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+400"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+400"
					},
					"增加全属性400"
				]
			},
			{
				"need": "650000",
				"title": "金丹六层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+400"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+400"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+400"
					},
					"增加全属性400"
				]
			},
			{
				"need": "750000",
				"title": "金丹七层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+400"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+400"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+400"
					},
					"增加全属性400"
				]
			},
			{
				"need": "850000",
				"title": "金丹八层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+500"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+500"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+500"
					},
					"增加全属性500"
				]
			},
			{
				"need": "1000000",
				"title": "金丹九层",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+500"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+500"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+500"
					},
					"增加全属性500"
				]
			},
			{
				"need": "1200000",
				"title": "金丹大圆满",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+500"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+500"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+500"
					},
					"增加全属性500"
				]
			},
			{
				"need": "5000000",
				"title": "假婴",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+300"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+300"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+300"
					},
					{
						"type": "if",
						"condition": "(flag:剧情==1)",
						"true": [
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "status:hp+1000000"
							}
						],
						"false": [
							{
								"type": "if",
								"condition": "(flag:剧情==2)",
								"true": [
									{
										"type": "setValue",
										"name": "status:hp",
										"operator": "+=",
										"value": "status:hp+1000000"
									}
								],
								"false": [
									{
										"type": "if",
										"condition": "(flag:剧情==3)",
										"true": [
											{
												"type": "setValue",
												"name": "status:hp",
												"operator": "+=",
												"value": "status:hp+1000000"
											}
										],
										"false": [
											{
												"type": "setValue",
												"name": "status:hp",
												"operator": "+=",
												"value": "1800000"
											}
										]
									}
								]
							}
						]
					},
					"终于假婴 了。。"
				]
			},
			{
				"need": "3000000",
				"title": "元婴期",
				"clear": true,
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+3000"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+3000"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"value": "status:mdef+3000"
					},
					"终于元婴 了。。",
					{
						"type": "if",
						"condition": "(flag:剧情==1)",
						"true": [
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "status:hp+1000000"
							}
						],
						"false": [
							{
								"type": "if",
								"condition": "(flag:剧情==2)",
								"true": [
									{
										"type": "setValue",
										"name": "status:hp",
										"operator": "+=",
										"value": "status:hp+1000000"
									}
								],
								"false": [
									{
										"type": "if",
										"condition": "(flag:剧情==3)",
										"true": [
											{
												"type": "setValue",
												"name": "status:hp",
												"operator": "+=",
												"value": "status:hp+1000000"
											}
										],
										"false": [
											{
												"type": "setValue",
												"name": "status:hp",
												"operator": "+=",
												"value": "3000000"
											}
										]
									}
								]
							}
						]
					},
					"终于假婴 了。。"
				]
			}
		]
	},
	"values": {
		"lavaDamage": 100,
		"poisonDamage": 10,
		"weakValue": 20,
		"redGem": 1,
		"blueGem": 1,
		"greenGem": 3,
		"redPotion": 100,
		"bluePotion": 200,
		"yellowPotion": 400,
		"greenPotion": 800,
		"breakArmor": 0.9,
		"counterAttack": 0.1,
		"purify": 3,
		"hatred": 2,
		"animateSpeed": 300,
		"moveSpeed": 100,
		"statusCanvasRowsOnMobile": 3,
		"floorChangeTime": 200
	},
	"flags": {
		"statusBarItems": [
			"enableFloor",
			"enableName",
			"enableLv",
			"enableHP",
			"enableAtk",
			"enableDef",
			"enableMDef",
			"enableMoney",
			"enableExp",
			"enableLevelUp",
			"levelUpLeftMode",
			"enableKeys",
			"enablePZF"
		],
		"autoScale": true,
		"extendToolbar": false,
		"flyNearStair": false,
		"flyRecordPosition": false,
		"itemFirstText": false,
		"equipboxButton": false,
		"enableAddPoint": false,
		"enableNegativeDamage": false,
		"betweenAttackMax": false,
		"useLoop": false,
		"startUsingCanvas": false,
		"statusCanvas": false,
		"enableEnemyPoint": true,
		"enableGentleClick": true,
		"ignoreChangeFloor": true,
		"canGoDeadZone": false,
		"enableMoveDirectly": true,
		"enableRouteFolding": true,
		"disableShopOnDamage": false,
		"blurFg": false,
		"chaseThroughEnemy": false,
		"showHard": false
	}
}