var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。

	core.events._changeFloor_beforeChange = function (info, callback) {
		window.setTimeout(function () {
			if (info.time == 0)
				core.events._changeFloor_changing(info, callback);
			else
				core.showWithAnimate(core.dom.floorMsgGroup, info.time / 2, function () {
					core.events._changeFloor_changing(info, callback);
				});
		}, 25);
	};

	core.ui._drawBook_drawBox = function (index, enemy, top, pageinfo) {
		// 横向：22+42；纵向：10 + 42 + 10（正好居中）；内部图像 32x32
		var border_top = top + (pageinfo.per_height - 42) / 2,
			border_left = 22;
		var img_top = border_top + 5,
			img_left = border_left + 5;
		core.strokeRect('ui', 22, border_top, 42, 42, '#DDDDDD', 2);
		var blockInfo = core.getBlockInfo(enemy.id);
		var book1 = 0;
		if (core.getFlag('world') == 2) {
			book1 = 16;
		}
		core.status.boxAnimateObjs.push({
			'bgx': border_left,
			'bgy': border_top,
			'bgWidth': 42,
			'bgHeight': 42,
			'x': img_left,
			'y': img_top - book1,
			'height': 32 + book1,
			'animate': blockInfo.animate,
			'image': blockInfo.image,
			'pos': blockInfo.posY * blockInfo.height
		});
	};

	core.ui._drawBook_drawBackground = function () {
		core.drawBackground(0, 0, 480, 480);
	};

	core.enemys.canBattle = function (enemy, x, y, floorId) {
		if (typeof enemy == 'string') enemy = core.material.enemys[enemy];
		var damage = this.getDamage(enemy, x, y, floorId);
		if (core.getFlag('world') == 1) {
			damage *= -1;
			return damage != null && damage < core.status.hero.hp;
		} else {
			return damage != null && damage < core.status.hero.hp;
		}
	};

	core.enemys.nextCriticals = function (enemy, number, x, y, floorId) {
		if (typeof enemy == 'string') enemy = core.material.enemys[enemy];
		number = number || 1;

		if (this.hasSpecial(enemy.special, 10)) return []; // 模仿怪物临界
		var info = this.getDamageInfo(enemy, null, x, y, floorId);
		if (info == null || this.hasSpecial(enemy.special, 3)) { // 未破防，或是坚固怪
			info = this.getEnemyInfo(enemy, null, x, y, floorId);
			if (core.status.hero.atk <= info.def) {
				return [
					[info.def + 1 - core.status.hero.atk, '?']
				];
			}
			return [];
		}

		// getDamageInfo直接返回数字；0伤且无负伤
		if (typeof info == 'number' || (info.damage <= 0 && !core.flags.enableNegativeDamage && core.getFlag('world') != 1)) {
			return [
				[0, 0]
			];
		}

		if (core.flags.useLoop) {
			var LOOP_MAX_VALUE = 1;
			if (core.status.hero.atk <= LOOP_MAX_VALUE) {
				return this._nextCriticals_useLoop(enemy, info, number, x, y, floorId);
			} else {
				return this._nextCriticals_useBinarySearch(enemy, info, number, x, y, floorId);
			}
		} else {
			return this._nextCriticals_useTurn(enemy, info, number, x, y, floorId);
		}
	};

	core.enemys._nextCriticals_useTurn = function (enemy, info, number, x, y, floorId) {
		var mon_hp = info.mon_hp,
			hero_atk = core.status.hero.atk,
			mon_def = info.mon_def,
			turn = info.turn;
		var list = [],
			pre = null;
		for (var t = turn - 1; t >= 1; t--) {
			var nextAtk = Math.ceil(mon_hp / t) + mon_def;
			// 装备提升比例的计算临界
			nextAtk = Math.ceil(nextAtk / core.getBuff('atk'));
			if (nextAtk <= hero_atk) break;
			if (nextAtk != pre) {
				var nextInfo = this.getDamageInfo(enemy, { "atk": nextAtk }, x, y, floorId);
				if (nextInfo == null || (typeof nextInfo == 'number')) break;
				list.push([nextAtk - hero_atk, Math.floor(info.damage - nextInfo.damage)]);
				if (nextInfo.damage <= 0 && !core.flags.enableNegativeDamage && core.getFlag('world') != 1) break;
				pre = nextAtk;
			}
			if (list.length >= number)
				break;
		}
		if (list.length == 0) list.push([0, 0]);
		return list;
	};

	core.enemys.getDamageString = function (enemy, x, y, floorId) {
		if (typeof enemy == 'string') enemy = core.material.enemys[enemy];
		var damage = this.getDamage(enemy, x, y, floorId);

		var color = '#000000';

		if (damage == null) {
			damage = "???";
			color = '#FF0000';
		} else {
			if (core.getFlag('world') == 1) {
				if (damage + core.status.hero.hp > 0) color = '#00FF00';
				else color = '#FF0000';
			} else if (damage <= 0) color = '#00FF00';
			else if (damage < core.status.hero.hp / 3) color = '#FFFFFF';
			else if (damage < core.status.hero.hp * 2 / 3) color = '#FFFF00';
			else if (damage < core.status.hero.hp) color = '#FF7F00';
			else color = '#FF0000';

			damage = core.formatBigNumber(damage, true);
			if (core.enemys.hasSpecial(enemy, 19))
				damage += "+";
			if (core.enemys.hasSpecial(enemy, 21))
				damage += "-";
			if (core.enemys.hasSpecial(enemy, 11))
				damage += "^";
		}

		return {
			"damage": damage,
			"color": color
		};
	};

	this.f1 = function (x, y) {
		x -= 7;
		y -= 6;
		var maxabs = Math.max(Math.abs(x), Math.abs(y));
		x /= maxabs;
		y /= maxabs;
		core.setFlag('x1', x);
		core.setFlag('y1', y);
		//得到引力球的位置关于中心点的方向
	};

	this.f2 = function (x, y) {
		var alpha = 0;
		switch (10 * x + y) {
		case 10:
			alpha = 0;
			break;
		case 9:
			alpha = 45;
			break;
		case -1:
			alpha = 90;
			break;
		case -11:
			alpha = 135;
			break;
		case -10:
			alpha = 180;
			break;
		case -9:
			alpha = 225;
			break;
		case 1:
			alpha = 270;
			break;
		case 11:
			alpha = 315;
			break;
		default:
		}
		core.setFlag('alpha', alpha);
		//把引力球的方向由向量表示转化为角度表示
		//这个函数和下一个函数都是4月初写的，现在看来方法特别笨，不过懒得重写了
	};

	this.f3 = function (alpha) {
		var x = 0;
		var y = 0;
		if (alpha % 90 == 0) {
			x = Math.cos(alpha * Math.PI / 180);
			y = -Math.sin(alpha * Math.PI / 180);
		} else {
			x = Math.sqrt(2) * Math.cos(alpha * Math.PI / 180);
			y = -Math.sqrt(2) * Math.sin(alpha * Math.PI / 180);
		}
		x = Math.round(x);
		y = Math.round(y);
		core.setFlag('x2', x);
		core.setFlag('y2', y);
		//把引力球的方向由角度表示转化为向量表示
	};

	this.f4 = function (x, y) {
		var n = 0;
		if (Math.abs(x) + Math.abs(y) == 2) {
			n = 4;
		} else {
			n = 5;
		}
		x3 = 7 + n * x;
		y3 = 6 + n * y;
		core.setFlag('x3', x3);
		core.setFlag('y3', y3);
		//根据引力球的方向，得到引力球的位置，此处得到的位置是靠里面一格的
	};

	this.f5 = function () {
		core.setFlag("B3", 1);
		core.values.moveSpeed = 100;
		core.setHeroIcon("hero.png", 0);
		core.changeFloor("B3", null, { "x": 0, "y": 0, }, 0, null, 0);
	};

	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作，比如切分图片等。

		// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
		// var arr = core.splitImage("assets.png", 32, 32);
		// for (var i = 0; i < arr.length; i++) {
		//     core.material.images.images["asset"+i+".png"] = arr[i];
		// }
	};
	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
}
}