functions_d6ad677b_427a_4623_b50f_a445a3b0ef8a = 
{
    "events": {
        "initGame": function () {
	// 游戏开始前的一些初始化操作

	// 根据flag来对道具进行修改
	if (core.flags.bigKeyIsBox)
		core.material.items.bigKey = {'cls': 'items', 'name': '钥匙盒'};
	// 面前的墙？四周的墙？
	if (core.flags.pickaxeFourDirections)
		core.material.items.pickaxe.text = "可以破坏勇士四周的墙";
	if (core.flags.bombFourDirections)
		core.material.items.bomb.text = "可以炸掉勇士四周的怪物";
    if (core.flags.snowFourDirections)
        core.material.items.bomb.text = "可以将四周的熔岩变成平地";
	if (core.flags.equipment) {
		core.material.items.sword1.cls = 'constants';
		core.material.items.sword2.cls = 'constants';
		core.material.items.sword3.cls = 'constants';
		core.material.items.sword4.cls = 'constants';
		core.material.items.sword5.cls = 'constants';
		core.material.items.shield1.cls = 'constants';
		core.material.items.shield2.cls = 'constants';
		core.material.items.shield3.cls = 'constants';
		core.material.items.shield4.cls = 'constants';
		core.material.items.shield5.cls = 'constants';
	}
},
        "setInitData": function (hard) {
	core.setFlag("cengshu", 5);
	core.setFlag("tingyong", 2);
	core.setFlag("jianyi", 0);

	// 不同难度分别设置初始属性
	if (hard=='Easy') { // 简单难度
		core.setFlag('hard', 1); // 可以用flag:hard来获得当前难度
		// 可以在此设置一些初始福利，比如设置初始生命值可以调用：
		// core.setStatus("hp", 10000);
		// 赠送一把黄钥匙可以调用
		// core.setItem("yellowKey", 1);
	}
	if (hard=='Normal') { // 普通难度
		core.setFlag('hard', 2); // 可以用flag:hard来获得当前难度
	}
	if (hard=='Hard') { // 困难难度
		core.setFlag('hard', 3); // 可以用flag:hard来获得当前难度
	}
	if (hard=='Hell') { // 噩梦难度
		core.setFlag('hard', 4); // 可以用flag:hard来获得当前难度
	}
	
	core.dom.statusBar.style.background = 'url(project/images/status.jpg) repeat';
	core.dom.toolBar.style.background = 'url(project/images/status.jpg) repeat';
	core.statusBar.money.style.color = 'black';
	["floorCol", "hpCol", "atkCol", "defCol", "mdefCol", "expCol", "keyCol"].forEach(function (e) {
		core.dom[e].style.display = 'none';
	})
	
	core.events.afterLoadData();
},
        "win": function (reason) {
	// 游戏获胜事件 
	core.ui.closePanel();
	var replaying = core.status.replay.replaying;
	core.stopReplay();
	core.waitHeroToStop(function() {
		core.removeGlobalAnimate(0,0,true);
		core.clearMap('all'); // 清空全地图
		core.drawText([
			"\t[" + (reason||"恭喜通关") + "]你的分数是${status:hp}。"
		], function () {
			core.events.gameOver(reason||'', replaying);
		})
	});
},
        "lose": function (reason) {
	// 游戏失败事件
	core.ui.closePanel();
	var replaying = core.status.replay.replaying;
	core.stopReplay();
	core.waitHeroToStop(function() {
		core.drawText([
			"\t["+(reason||"结局1")+"]你死了。\n如题。"
		], function () {
			core.events.gameOver(null, replaying);
		});
	})
},
        "afterChangeFloor": function (floorId) {
	// 转换楼层结束的事件
	if (!core.hasFlag("visited_"+floorId)) {
		core.insertAction(core.floors[floorId].firstArrive);
		core.setFlag("visited_"+floorId, true);
	}
},
        "addPoint": function (enemy) {
	// 加点事件
	var point = enemy.point;
	if (!core.flags.enableAddPoint || !core.isset(point) || point<=0) return [];

	// 加点，返回一个choices事件
	return [
		{"type": "choices",
			"choices": [
				{"text": "攻击+"+(1*point), "action": [
					{"type": "setValue", "name": "status:atk", "value": "status:atk+"+(1*point)}
				]},
				{"text": "防御+"+(2*point), "action": [
					{"type": "setValue", "name": "status:def", "value": "status:def+"+(2*point)}
				]},
				{"text": "生命+"+(200*point), "action": [
					{"type": "setValue", "name": "status:hp", "value": "status:hp+"+(200*point)}
				]},
			]
		}
	];
},
        "afterBattle": function (enemyId,x,y,callback) {
	// 战斗结束后触发的事件

	var enemy = core.material.enemys[enemyId];

	var damage = core.enemys.getDamage(enemyId);
	if (damage == null) damage = core.status.hero.hp+1;

	// 扣减体力值
	core.status.hero.hp -= damage;

	// 记录
	core.status.hero.statistics.battleDamage += damage;

	if (core.status.hero.hp<=0) {
		core.status.hero.hp=0;
		core.updateStatusBar();
		 core.plugin.reset();
		return;
	}
	// 获得金币和经验
  var money = enemy.money;
  if (core.getFlag("shuangbeiqian")==1 && damage==0) money *= 2;
  money+=core.getFlag("jinbi",0)
  core.status.hero.money += money;
			var hint = "打败 " + enemy.name;
	      hint += "，金币+" + money;
  switch (core.getFlag("hard", 0)) {
    case 1:		core.status.hero.experience = damage

		if (core.flags.enableExperience)
      hint += ",剑意变为" + core.status.hero.experience;


        break;
    case 0:	

    ;
        break;
}
core.drawTip(hint); ;


	/*if (core.hasItem('coin')) money *= 2;
	if (core.hasFlag('curse')) money=0;
	core.status.hero.money += money;
	var experience =enemy.experience;
	if (core.hasFlag('curse')) experience=0;
	core.status.hero.experience += experience;
	var hint = "打败 " + enemy.name;
	if (core.flags.enableMoney)
		hint += "，金币+" + money;
	if (core.flags.enableExperience)
		hint += "，经验+" + experience;
	core.drawTip(hint);*/

	// 删除该块
	if (core.isset(x) && core.isset(y)) {
		core.removeBlock(x, y);
		core.canvas.event.clearRect(32 * x, 32 * y, 32, 32);
	}

	// 毒衰咒的处理
	var special = enemy.special;
	// 中毒
	if (core.enemys.hasSpecial(special, 12) && !core.hasFlag('poison')) {
		core.setFlag('poison', true);
	}
	// 衰弱
	if (core.enemys.hasSpecial(special, 13) && !core.hasFlag('weak')) {
		core.setFlag('weak', true);
		var weakValue = core.values.weakValue;
		var weakAtk = weakValue>=1?weakValue:Math.floor(weakValue*core.status.hero.atk);
		var weakDef = weakValue>=1?weakValue:Math.floor(weakValue*core.status.hero.def);
		core.setFlag('weakAtk', weakAtk);
		core.setFlag('weakDef', weakDef);
		core.status.hero.atk-=weakAtk;
		core.status.hero.def-=weakDef;
	}
	// 诅咒
	if (core.enemys.hasSpecial(special, 14) && !core.hasFlag('curse')) {
		core.setFlag('curse', true);
	}
	// 仇恨属性：减半
	if (core.flags.hatredDecrease && core.enemys.hasSpecial(special, 17)) {
		core.setFlag('hatred', parseInt(core.getFlag('hatred', 0)/2));
	}
	// 自爆
	if (core.enemys.hasSpecial(special, 19)&&!core.getFlag("zibao")==1) {
		core.status.hero.hp = core.getFlag("zibaoyuxue",1);
	}
	// 退化
	if (core.enemys.hasSpecial(special, 21)&&!core.getFlag("tuihua")==1) {
		core.status.hero.atk -= (enemy.atkValue||0);
		core.status.hero.def -= (enemy.defValue||0);
		if (core.status.hero.atk<0) core.status.hero.atk=0;
		if (core.status.hero.def<0) core.status.hero.def=0;
	}
	// 增加仇恨值
	core.setFlag('hatred', core.getFlag('hatred',0)+core.values.hatred);
	core.updateStatusBar();


	// 事件的处理
	var todo = [];
	// 如果不为阻击，且该点存在，且有事件
	if (!core.enemys.hasSpecial(special, 18) && core.isset(x) && core.isset(y)) {
		var event = core.floors[core.status.floorId].afterBattle[x+","+y];
		if (core.isset(event)) {
			// 插入事件
			core.unshift(todo, event);
		}
	}
	// 如果有加点
	var point = core.material.enemys[enemyId].point;
	if (core.isset(point) && point>0) {
		core.unshift(todo, core.events.addPoint(core.material.enemys[enemyId]));
  }
  switch (core.getFlag("hard", 0)) {
    case 1: core.unshift(todo, core.plugin.zhanhou());


	  }


	// 如果事件不为空，将其插入
	if (todo.length>0) {
		core.events.insertAction(todo,x,y);
	}

	// 如果已有事件正在处理中
	if (core.status.event.id == null) {
		core.continueAutomaticRoute();
	}
	else {
		core.clearContinueAutomaticRoute();
	}
	if (core.isset(callback)) callback();

},
        "afterOpenDoor": function (doorId,x,y,callback) {
	// 开一个门后触发的事件
	
	var todo = [];
	if (core.isset(x) && core.isset(y)) {
		var event = core.floors[core.status.floorId].afterOpenDoor[x+","+y];
		if (core.isset(event)) {
			core.unshift(todo, event);
		}
	}

	if (todo.length>0) {
		core.events.insertAction(todo,x,y);
	}

	if (core.status.event.id == null) {
		core.continueAutomaticRoute();
	}
	else {
		core.clearContinueAutomaticRoute();
	}
	if (core.isset(callback)) callback();
},
        "afterChangeLight": function (x,y) {
	// 改变亮灯之后，可以触发的事件

},
        "afterPushBox": function () {
	// 推箱子后的事件

	var noBoxLeft = function () {
		// 地图上是否还存在未推到的箱子，如果不存在则返回true，存在则返回false
		for (var i=0;i<core.status.thisMap.blocks.length;i++) {
			var block=core.status.thisMap.blocks[i];
			if (core.isset(block.event) && block.event.id=='box') return false;
		}
		return true;
	}

	if (noBoxLeft()) {
		// 可以通过if语句来进行开门操作
		/*
		if (core.status.floorId=='xxx') { // 在某个楼层
			core.insertAction([ // 插入一条事件
				{"type": "openDoor", "loc": [x,y]} // 开门
			])
		}
		*/
	}
},
        "afterUseBomb": function () {
	if (core.status.floorId=='MT7' &&  // 楼层号
	!core.enemyExists(1,3) && // 怪物1不存在
	!core.enemyExists(3,3) && // 怪物2不存在
// 等等
	core.terrainExists(2,2,'specialDoor') // 机关门存在
	)
	{
			core.insertAction([ // 插入事件
					{"type": "openDoor", "loc": [2,2]} // 开门
			])
};
	if (core.status.floorId=='MT9' &&  // 楼层号
    !core.enemyExists(7,6) && // 怪物1不存在
    !core.enemyExists(5,6) && // 怪物2不存在
    // 等等
    core.terrainExists(6,5,'specialDoor') // 机关门存在
)
{
core.insertAction([ // 插入事件
    {"type": "openDoor", "loc": [6,5]} // 开门
])
}
	// 使用炸弹/圣锤后的事件

	// 这是一个使用炸弹也能开门的例子
	/*
	if (core.status.floorId=='xxx' && core.terrainExists(x0,y0,'specialDoor') // 某个楼层，该机关门存在
		&& !core.enemyExists(x1,y1) && !core.enemyExists(x2,y2)) // 且守门的怪物都不存在
	{
		core.insertAction([ // 插入事件
			{"type": "openDoor", "loc": [x0,y0]} // 开门
		])
	}
	*/

},
        "beforeSaveData": function (data) {
	// 即将存档前可以执行的操作

},
        "afterLoadData": function (data) {
	// 读档事件后，载入事件前，可以执行的操作
	// 可以在这里对怪物数据进行动态修改，详见文档——事件——怪物数据的动态修改


}
    },
    "ui": {
        "drawAbout": function () {
	// 绘制“关于”界面
	if (!core.isPlaying()) {
		core.status.event = {'id': null, 'data': null};
		core.dom.startPanel.style.display = 'none';
	}
	core.lockControl();
	core.status.event.id = 'about';

	core.clearMap('ui', 0, 0, 416, 416);
	var left = 48, top = 36, right = 416 - 2 * left, bottom = 416 - 2 * top;

	core.setAlpha('ui', 0.85);
	core.fillRect('ui', left, top, right, bottom, '#000000');
	core.setAlpha('ui', 1);
	core.strokeRect('ui', left - 1, top - 1, right + 1, bottom + 1, '#FFFFFF', 2);

	var text_start = left + 24;

	// 名称
	core.canvas.ui.textAlign = "left";
	core.fillText('ui', "HTML5 魔塔样板", text_start, top+35, "#FFD700", "bold 22px Verdana");
	core.fillText('ui', "版本： "+core.firstData.version, text_start, top + 80, "#FFFFFF", "bold 17px Verdana");
	core.fillText('ui', "作者： 艾之葵", text_start, top + 112);
	core.fillText('ui', 'HTML5魔塔交流群：539113091', text_start, top+112+32);
	// TODO: 写自己的“关于”页面，每次增加32像素即可
}
    },
    "plugins": {
        "plugin": function () {
	////// 插件编写，可以在这里写自己额外需要执行的脚本 //////

	// 在这里写的代码，在所有模块加载完毕后，游戏开始前会被执行
	console.log("插件编写测试");
	// 可以写一些其他的被直接执行的代码


	// 在这里写所有需要自定义的函数
	// 写法必须是 this.xxx = function (args) { ...
	// 如果不写this的话，函数将无法被外部所访问
	this.test  = function () {
		console.log("插件函数执行测试");
	};

	var _useEquipment = function (itemId, name, type) { // 具体的装备使用效果
		if (itemId.indexOf(name)==0) {
			var now=core.getFlag(name, name+"0");

			if (typeof core.values[now] == 'number') {
				core.status.hero[type] -= core.values[now];
			}
			else {
				core.status.hero.atk -= core.values[now].atk || 0;
				core.status.hero.def -= core.values[now].def || 0;
				core.status.hero.mdef -= core.values[now].mdef || 0;
			}

			if (typeof core.values[itemId] == 'number') {
				core.status.hero[type] += core.values[itemId];
			}
			else {
				core.status.hero.atk += core.values[itemId].atk || 0;
				core.status.hero.def += core.values[itemId].def || 0;
				core.status.hero.mdef += core.values[itemId].mdef || 0;
			}

			core.setItem(now, 1);
			core.setItem(itemId, 0);
			core.setFlag(name, itemId);
			core.drawTip("已装备"+core.material.items[itemId].name);
		}
	};
	
	this.reset = function () {
		// 重置地图
		for (var i=0;i<=10;i++) {
			core.resetMap("MT"+i);
			core.setFlag("visited_MT"+i, false);
		}
		// 重置各项属性
		core.status.hero.hp = 500;
		core.status.hero.atk = 20;
		core.status.hero.def = 20;
		core.status.hero.mdef = 0;
		// 金币不重置
		core.status.hero.experience = 0;
		
		// 重置道具
		core.setItem("yellowKey", 0);
		core.setItem("blueKey", 0);
		core.setItem("redKey", 0);
		core.setItem("pickaxe", 0);
		core.setItem("bomb", 0);
		core.setItem("centerFly", 0);
		core.setItem("cross", 0);
		core.setItem("book", 0);
		core.setItem("fly", 0);
		core.setItem('lifeWand',0);
		
		// 重置卡牌
		core.status.hero.flags.usedcard = {};
		
		// 重置flag
		 
		core.setFlag("xixueshang",0);
		core.setFlag("xuewangshang",0);
		core.setFlag("lingyushang",0);
		core.setFlag("jiajishang",0);
		core.setFlag("zujishang",0);
		core.setFlag("jiangshang",0);
    core.setFlag("jiamofang",0);
		core.setFlag("zibaoyuxue",0);
		core.setFlag('hatred',0);
    // 重置行走图
    core.plugin.setHeroIcon('hero.png');
		["floorCol", "hpCol", "atkCol", "defCol", "mdefCol", "expCol", "keyCol"].forEach(function (e) {
			core.dom[e].style.display = 'none';
		})
		core.statusBar.money.style.color = 'black';
		core.dom.statusBar.style.background = 'url(project/images/status.jpg) repeat';
		core.dom.toolBar.style.background = 'url(project/images/status.jpg) repeat';
		
		core.insertAction([
      "很遗憾你挂了，即将回到游戏大厅，请再接再厉哦！",
      {"type": "playBgm", "name": "boymeetsgirlandgirl.mp3"},
			{"type": "changeFloor", "floorId": "JQ2","loc":[5,5]},
			{"type": "trigger", "loc": [0,0]},
		]);
		
	};
	
	this.canUseCard = function(itemId) {
		return !core.status.hero.flags.usedcard[itemId];
	};
	
	core.items.canUseItem = function (itemId) {
		// 没有道具
		if (!core.hasItem(itemId)) return false;
		
		if (!core.plugin.canUseCard(itemId)) {
			return false;
		}

		if (itemId in this.canUseItemEffect) {
			return eval(this.canUseItemEffect[itemId]);
		}

		return false;
	};
	
	core.items.useItem = function (itemId, callback) {
		if (!this.canUseItem(itemId)) {
			if (core.isset(callback)) callback();
			return;
		}
		var itemCls = core.material.items[itemId].cls;

		if (itemId in this.useItemEffect) {
			var cost = function() {
				core.status.hero.flags.usedcard[itemId] = true;
			};
			eval(this.useItemEffect[itemId]);
		}

		core.updateStatusBar();

		// 记录路线
		if (itemId!='book' && itemId!='fly') {
			core.status.route.push("item:"+itemId);
		}

		// 道具使用完毕：删除
		if (itemCls=='tools')
			core.status.hero.items[itemCls][itemId]--;
		if (core.status.hero.items[itemCls][itemId]==0)
			delete core.status.hero.items[itemCls][itemId];

		if (core.isset(callback)) callback();
	};
	
	core.events.useItem = function(itemId) {
		core.ui.closePanel();

		if (itemId=='book') {
			core.openBook(false);
			return;
		}
		if (itemId=='fly') {
			core.useFly(false);
			return;
		}
		if (itemId=='centerFly') {
			core.status.usingCenterFly= true;
			var fillstyle = 'rgba(255,0,0,0.5)';
			if (core.canUseItem('centerFly')) fillstyle = 'rgba(0,255,0,0.5)';
			core.fillRect('ui',(12-core.getHeroLoc('x'))*32,(12-core.getHeroLoc('y'))*32,32,32,fillstyle);
			core.drawTip("请确认当前中心对称飞行器的位置");
			return;
		}
		if (core.plugin.canUseCard(itemId)){
			if (core.canUseItem(itemId))
				core.useItem(itemId);
			else
				core.drawTip("当前无法使用"+core.material.items[itemId].name);
		}else{
			core.drawTip("你已经使用过"+core.material.items[itemId].name);
		}
		
	};
	
	this.getCard = function (id,bgm) {
		// id从333开始
		var img = id+".png", itemId = "I"+(332+id);
		var item = core.material.items[itemId] || {};
		var text = item.name || "暂无描述";
		core.insertAction([
			{"type": "if", "condition": "item:"+itemId, 
				"true": [
					"你已拥有卡牌："+text+"，恢复1点金币值。",
					{"type": "setValue", "name": "status:money", "value": "status:money+1"}
				],
			 	"false": [
					{"type": "setValue", "name": "flag:jj", "value": "flag:jj+1"},
					{"type": "moveImage", "name": img, "from": [192,384], "to": [192,64], "time": 2000},
					{"type": "showImage", "name": img, "loc": [192,64]},
					{"type": "playSound", "name": bgm||"113.mp3"},
					{"type": "setValue", "name": "item:"+itemId, "value": "1"},
					{"type": "setText", "position": "down", "bold": true, "time": 50},
					text,
					{"type": "showImage"},
										
				]
			}
		]);
	};

	this.useEquipment = function (itemId) { // 使用装备
		_useEquipment(itemId, "sword", "atk");
		_useEquipment(itemId, "shield", "def");
	};
	
	this.zhanhou = function (zhanhou) {
		return [
		  { "type": "update" },
		  { "type": "setValue", "name": "flag:jianyi", "value": "status:experience" },
		  { "type": "setValue", "name": "flag:jilu", "value": "core.status.hero.steps" },
		  { "type": "setHeroIcon", "name": "hero2.png" },
		  { "type": "animate", "name": "xuejiansanbu", "loc": "hero" },
		  { "type": "setValue", "name": "flag:tingyong", "value": "0" },
		];
	  };
	  this.tiaozhan = function (tiaozhan) {
		core.insertAction([
  {"type": "function", "function": "function(){\ncore.setFlag('suiji',core.rand(4)+1)\n}"},
  {"type": "if", "condition": "status:experience>=30",
  "true": [
    {"type": "function", "function": "function(){\nif (core.enemyExists(core.status.hero.loc.x,core.status.hero.loc.y+core.getFlag('linshi1',100))) {core.setFlag('linshi2',1);}\n}"},
    {"type": "setValue", "name": "flag:herox", "value": "core.status.hero.loc.x"},
    {"type": "setValue", "name": "flag:heroy", "value": "core.status.hero.loc.y"},
    {"type": "setValue", "name": "flag:herotux", "value": "(flag:herox*32)"},
    {"type": "setValue", "name": "flag:herotuy", "value": "(flag:heroy*32)"},
    {"type": "setValue", "name": "flag:linshi1", "value": "1"},
    {"type": "setValue", "name": "flag:linshi2", "value": "0"},
    {"type": "function", "function": "function(){\nif (core.status.hero.loc.direction == 'up') core.setFlag('heroz',1);     else if (core.status.hero.loc.direction == 'right') core.setFlag('heroz',2);     else if (core.status.hero.loc.direction == 'down') core.setFlag('heroz',3);     else if (core.status.hero.loc.direction == 'left') core.setFlag('heroz',4);\n}"},
    {"type": "if", "condition": "flag:heroz==1",
    "true": [
      {"type": "setValue", "name": "flag:herodatux", "value": "(flag:herotux-576)"},
      {"type": "setValue", "name": "flag:herodatuy", "value": "(flag:herotuy-448)"},
      {"type": "setValue", "name": "flag:panduan", "value": "flag:herotuy"},
      {"type": "setValue", "name": "flag:herotuy", "value": "(flag:herotuy-32)"},
      {"type": "animateImage", "action": "show", "name": "shang.png", "loc": ["flag:herodatux","flag:herodatuy"], "time": 500},
      {"type": "showImage", "name": "shang.png", "loc": ["flag:herodatux","flag:herodatuy"]},
      {"type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux","flag:herotuy"]},
      {"type": "while", "condition": "true",
      "data": [
        {"type": "wait"},
        {"type": "if", "condition": "flag:type==0",
        "true": [
          {"type": "if", "condition": "flag:keycode==27",
          "true": [
            {"type": "showImage"},
            {"type": "exit"},
          ],
          "false": [

          ]
          },
          {"type": "if", "condition": "flag:keycode==13",
          "true": [
            {"type": "showImage"},
            {"type": "break"},
          ],
          "false": [

          ]
          },
          {"type": "if", "condition": "flag:keycode==32",
          "true": [
            {"type": "showImage"},
            {"type": "break"},
          ],
          "false": [

          ]
          },
          {"type": "if", "condition": "flag:keycode==38",
          "true": [
            {"type": "setValue", "name": "flag:herotuy2", "value": "(flag:herotuy-32)"},
            {"type": "showImage"},
            {"type": "showImage", "name": "shang.png", "loc": ["flag:herodatux","flag:herodatuy"]},
            {"type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux","flag:herotuy"], "to": ["flag:herotux","flag:herotuy2"], "time": 1},
            {"type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux","flag:herotuy2"]},
            {"type": "setValue", "name": "flag:herotuy", "value": "flag:herotuy2"},
            {"type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1+1)"},
          ],
          "false": [

          ]
          },
          {"type": "if", "condition": "flag:keycode==40",
          "true": [
            {"type": "setValue", "name": "flag:herotuy2", "value": "(flag:herotuy+32)"},
            {"type": "if", "condition": "flag:herotuy2>=flag:panduan",
            "true": [
              {"type": "setValue", "name": "flag:herotuy2", "value": "(flag:herotuy-32)"},
            ],
            "false": [
              {"type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1-1)"},
              {"type": "showImage"},
              {"type": "showImage", "name": "shang.png", "loc": ["flag:herodatux","flag:herodatuy"]},
              {"type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux","flag:herotuy"], "to": ["flag:herotux","flag:herotuy2"], "time": 1},
              {"type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux","flag:herotuy2"]},
              {"type": "setValue", "name": "flag:herotuy", "value": "flag:herotuy2"},
            ]
            },
          ],
          "false": [

          ]
          },
        ],
        "false": [
          {"type": "if", "condition": "flag:x==flag:herox",
          "true": [
            {"type": "setValue", "name": "flag:herotuy2", "value": "(flag:y*32)"},
            {"type": "if", "condition": "flag:herotuy2>=flag:panduan",
            "true": [

            ],
            "false": [
              {"type": "if", "condition": "flag:herotuy2==flag:herotuy",
              "true": [
                {"type": "break"},
              ],
              "false": [
                {"type": "function", "function": "function(){\ncore.setFlag(\"linshi1\",core.status.hero.loc.y-core.getFlag(\"y\"))\n}"},
                {"type": "showImage"},
                {"type": "showImage", "name": "shang.png", "loc": ["flag:herodatux","flag:herodatuy"]},
                {"type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux","flag:herotuy"], "to": ["flag:herotux","flag:herotuy2"], "time": 1},
                {"type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux","flag:herotuy2"]},
                {"type": "setValue", "name": "flag:herotuy", "value": "flag:herotuy2"},
              ]
              },
            ]
            },
          ],
          "false": [

          ]
          },
        ]
        },
      ],
      },
      {"type": "showImage"},
      {"type": "if", "condition": "flag:linshi1==1",
      "true": [
        {"type": "if", "condition": "flag:suiji==1",
        "true": [
          "走路和跳跃，你选一种吧",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==2",
        "true": [
          "他就在你面前，用什么破技能，丢人",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==3",
        "true": [
          "无影鬼斩服务部提醒您，您已到站，请下车步行",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==4",
        "true": [
          "走一走，迈开腿，一步到位，跳什么跳？闲得慌啊！？",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==5",
        "true": [
          "大哥，他就在你面前，跳什么跳",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
      ],
      "false": [

      ]
      },
      {"type": "function", "function": "function(){\nif (core.enemyExists(core.status.hero.loc.x,core.status.hero.loc.y-core.getFlag('linshi1',100))) {core.setFlag('linshi2',1);}\n}"},
      {"type": "if", "condition": "flag:linshi2==1",
      "true": [

      ],
      "false": [
        {"type": "if", "condition": "flag:suiji==1",
        "true": [
          "我要砍的是怪，懂么？",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==2",
        "true": [
          "无影鬼斩服务部提醒您，您的目标地点没必要用砍的",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==3",
        "true": [
          "本人不斩无名之辈.........简单的说墙啊空地啊什么的我是不砍的",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==4",
        "true": [
          "想砍啥呢？",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==5",
        "true": [
          "我的剑，只斩妖魔鬼怪",
        ],
        "false": [

        ]
        },
        {"type": "exit"},
      ]
      },
      {"type": "function", "function": "function(){\nif (core.enemys.canBattle(core.getBlockId(core.status.hero.loc.x,core.status.hero.loc.y-core.getFlag('linshi1',100)))) {core.setFlag('linshi2',2);}\n}"},
      {"type": "if", "condition": "flag:linshi2==2",
      "true": [

      ],
      "false": [
        {"type": "if", "condition": "flag:suiji==1",
        "true": [
          "等我回去吃几个血瓶回来干翻你",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==2",
        "true": [
          "想打怪想疯了吧你",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==3",
        "true": [
          "打怪要讲策略懂么",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==4",
        "true": [
          "对面那货好像有点硬啊",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==5",
        "true": [
          "无影鬼斩服务部提醒您，您的目标地点太过危险，请下车",
        ],
        "false": [

        ]
        },
        {"type": "exit"},
      ]
      },
      {"type": "setValue", "name": "flag:heroy", "value": "(core.status.hero.loc.y-flag:linshi1)"},
      {"type": "setValue", "name": "flag:heroy3", "value": "(core.status.hero.loc.y)"},
      {"type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1-2)"},
      {"type": "setValue", "name": "flag:linshi1", "value": "Math.pow(2, flag:linshi1)"},
      {"type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1*20)"},
      {"type": "if", "condition": "status:experience>=flag:linshi1",
      "true": [
        {"type": "animate", "name": "wuyingguizhan", "loc": "hero"},
        {"type": "changePos", "loc": [0,14]},
        {"type": "function", "function": "function(){\ncore.insertAction({\"type\": \"animate\", \"name\": \"qitiaoshang\", \"loc\": [core.getFlag(\"herox\"),core.getFlag(\"heroy3\")]})\n}"},
        {"type": "changePos", "loc": ["flag:herox","flag:heroy"]},
        {"type": "animate", "name": "tiaozhansha", "loc": "hero"},
        {"type": "function", "function": "function(){\ncore.insertAction({\"type\": \"battle\", \"id\": core.getBlockId(core.getFlag(\"herox\"),core.getFlag(\"heroy\"))})\n}"},
        {"type": "hide", "loc": ["flag:herox","flag:heroy"]},
        {"type": "exit"},
      ],
      "false": [
        {"type": "if", "condition": "flag:suiji==1",
        "true": [
          "无影鬼斩服务部提示您，您的剑意余额已不足，请充值",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==2",
        "true": [
          "剑意不足，拒载",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==3",
        "true": [
          "待我蓄一波意",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==4",
        "true": [
          "乡愁是差一点点剑意,我在这头,敌人在那头。",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==5",
        "true": [
          "太远了有木有",
        ],
        "false": [

        ]
        },
        {"type": "exit"},
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:heroz==2",
    "true": [
      {"type": "setValue", "name": "flag:herodatux", "value": "(flag:herotux-576)"},
      {"type": "setValue", "name": "flag:herodatuy", "value": "(flag:herotuy-448)"},
      {"type": "setValue", "name": "flag:panduan", "value": "(flag:herotux)"},
      {"type": "setValue", "name": "flag:herotux", "value": "(flag:herotux+32)"},
      {"type": "animateImage", "action": "show", "name": "you.png", "loc": ["flag:herodatux","flag:herodatuy"], "time": 500},
      {"type": "showImage", "name": "you.png", "loc": ["flag:herodatux","flag:herodatuy"]},
      {"type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux","flag:herotuy"]},
      {"type": "while", "condition": "true",
      "data": [
        {"type": "wait"},
        {"type": "if", "condition": "flag:type==0",
        "true": [
          {"type": "if", "condition": "flag:keycode==27",
          "true": [
            {"type": "showImage"},
            {"type": "exit"},
          ],
          "false": [

          ]
          },
          {"type": "if", "condition": "flag:keycode==13",
          "true": [
            {"type": "showImage"},
            {"type": "break"},
          ],
          "false": [

          ]
          },
          {"type": "if", "condition": "flag:keycode==32",
          "true": [
            {"type": "showImage"},
            {"type": "break"},
          ],
          "false": [

          ]
          },
          {"type": "if", "condition": "flag:keycode==39",
          "true": [
            {"type": "setValue", "name": "flag:herotux2", "value": "(flag:herotux+32)"},
            {"type": "showImage"},
            {"type": "showImage", "name": "you.png", "loc": ["flag:herodatux","flag:herodatuy"]},
            {"type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux","flag:herotuy"], "to": ["flag:herotux2","flag:herotuy"], "time": 1},
            {"type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux2","flag:herotuy"]},
            {"type": "setValue", "name": "flag:herotux", "value": "flag:herotux2"},
            {"type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1+1)"},
          ],
          "false": [

          ]
          },
          {"type": "if", "condition": "flag:keycode==37",
          "true": [
            {"type": "setValue", "name": "flag:herotux2", "value": "(flag:herotux-32)"},
            {"type": "if", "condition": "flag:herotux2<=flag:panduan",
            "true": [
              {"type": "setValue", "name": "flag:herotux2", "value": "flag:herotux"},
            ],
            "false": [
              {"type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1-1)"},
              {"type": "showImage"},
              {"type": "showImage", "name": "you.png", "loc": ["flag:herodatux","flag:herodatuy"]},
              {"type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux","flag:herotuy"], "to": ["flag:herotux2","flag:herotuy"], "time": 1},
              {"type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux2","flag:herotuy"]},
              {"type": "setValue", "name": "flag:herotux", "value": "flag:herotux2"},
            ]
            },
          ],
          "false": [

          ]
          },
        ],
        "false": [
          {"type": "if", "condition": "flag:y==flag:heroy",
          "true": [
            {"type": "setValue", "name": "flag:herotux2", "value": "(flag:x*32)"},
            {"type": "if", "condition": "flag:herotux2<=flag:panduan",
            "true": [

            ],
            "false": [
              {"type": "if", "condition": "flag:herotux2==flag:herotux",
              "true": [
                {"type": "showImage"},
                {"type": "break"},
              ],
              "false": [
                {"type": "function", "function": "function(){\ncore.setFlag(\"linshi1\",core.getFlag(\"x\")-core.status.hero.loc.x)\n}"},
                {"type": "showImage"},
                {"type": "showImage", "name": "you.png", "loc": ["flag:herodatux","flag:herodatuy"]},
                {"type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux","flag:herotuy"], "to": ["flag:herotux2","flag:herotuy"], "time": 1},
                {"type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux2","flag:herotuy"]},
                {"type": "setValue", "name": "flag:herotux", "value": "flag:herotux2"},
              ]
              },
            ]
            },
          ],
          "false": [

          ]
          },
        ]
        },
      ],
      },
      {"type": "showImage"},
      {"type": "if", "condition": "flag:linshi1==1",
      "true": [
        {"type": "if", "condition": "flag:suiji==1",
        "true": [
          "走和跳，你选一种吧",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==2",
        "true": [
          "他就在你面前，用什么破技能，丢人",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==3",
        "true": [
          "无影鬼斩服务部提醒您，您已到站，请下车步行",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==4",
        "true": [
          "走一走，迈开腿，一步到位，跳什么跳？闲得慌啊！？",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==5",
        "true": [
          "大哥，他就在你面前，跳什么跳",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
      ],
      "false": [

      ]
      },
      {"type": "function", "function": "function(){\nif (core.enemyExists(core.status.hero.loc.x+core.getFlag('linshi1',100),core.status.hero.loc.y)) {core.setFlag('linshi2',1);}\n}"},
      {"type": "if", "condition": "flag:linshi2==1",
      "true": [

      ],
      "false": [
        {"type": "if", "condition": "flag:suiji==1",
        "true": [
          "我要砍的是怪，懂么？",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==2",
        "true": [
          "无影鬼斩服务部提醒您，您的目标地点没必要用砍的",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==3",
        "true": [
          "本人不斩无名之辈.........简单的说墙啊空地啊什么的我是不砍的",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==4",
        "true": [
          "想砍啥呢？",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==5",
        "true": [
          "我的剑，只斩妖魔鬼怪",
        ],
        "false": [

        ]
        },
        {"type": "exit"},
      ]
      },
      {"type": "function", "function": "function(){\nif (core.enemys.canBattle(core.getBlockId(core.status.hero.loc.x+core.getFlag('linshi1',100),core.status.hero.loc.y))) {core.setFlag('linshi2',2);}\n}"},
      {"type": "if", "condition": "flag:linshi2==2",
      "true": [

      ],
      "false": [
        {"type": "if", "condition": "flag:suiji==1",
        "true": [
          "等我回去吃几个血瓶回来干翻你",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==2",
        "true": [
          "不是不打，时候未到",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==3",
        "true": [
          "打怪要讲策略懂么",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==4",
        "true": [
          "对面那货好像有点硬啊",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==5",
        "true": [
          "无影鬼斩服务部提醒您，您的目标地点太过危险，请下车",
        ],
        "false": [

        ]
        },
        {"type": "exit"},
      ]
      },
      {"type": "setValue", "name": "flag:herox", "value": "(core.status.hero.loc.x+flag:linshi1)"},
      {"type": "setValue", "name": "flag:herox3", "value": "(core.status.hero.loc.x)"},
      {"type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1-2)"},
      {"type": "setValue", "name": "flag:linshi1", "value": "Math.pow(2, flag:linshi1)"},
      {"type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1*20)"},
      {"type": "if", "condition": "status:experience>=flag:linshi1",
      "true": [
        {"type": "animate", "name": "wuyingguizhan", "loc": "hero"},
        {"type": "changePos", "loc": [0,14]},
        {"type": "function", "function": "function(){\ncore.insertAction({\"type\": \"animate\", \"name\": \"qitiaoyou\", \"loc\": [core.getFlag(\"herox3\"),core.getFlag(\"heroy\")]})\n}"},
        {"type": "changePos", "loc": ["flag:herox","flag:heroy"]},
        {"type": "function", "function": "function(){\ncore.insertAction({\"type\": \"battle\", \"id\": core.getBlockId(core.getFlag(\"herox\"),core.getFlag(\"heroy\"))})\n}"},
        {"type": "hide", "loc": ["flag:herox","flag:heroy"]},
        {"type": "exit"},
      ],
      "false": [
        {"type": "if", "condition": "flag:suiji==1",
        "true": [
          "无影鬼斩服务部提示您，您的剑意余额已不足，请充值",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==2",
        "true": [
          "剑意不足，拒载",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==3",
        "true": [
          "待我蓄一波意",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==4",
        "true": [
          "乡愁是差一点点剑意,我在这头,敌人在那头。",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==5",
        "true": [
          "太远了有木有",
        ],
        "false": [

        ]
        },
        {"type": "exit"},
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:heroz==3",
    "true": [
      {"type": "setValue", "name": "flag:herodatux", "value": "(flag:herotux-576)"},
      {"type": "setValue", "name": "flag:herodatuy", "value": "(flag:herotuy-448)"},
      {"type": "setValue", "name": "flag:panduan", "value": "(flag:herotuy)"},
      {"type": "setValue", "name": "flag:herotuy", "value": "(flag:herotuy+32)"},
      {"type": "animateImage", "action": "show", "name": "xia.png", "loc": ["flag:herodatux","flag:herodatuy"], "time": 500},
      {"type": "showImage", "name": "xia.png", "loc": ["flag:herodatux","flag:herodatuy"]},
      {"type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux","flag:herotuy"]},
      {"type": "while", "condition": "true",
      "data": [
        {"type": "wait"},
        {"type": "if", "condition": "flag:type==0",
        "true": [
          {"type": "if", "condition": "flag:keycode==27",
          "true": [
            {"type": "showImage"},
            {"type": "exit"},
          ],
          "false": [

          ]
          },
          {"type": "if", "condition": "flag:keycode==13",
          "true": [
            {"type": "showImage"},
            {"type": "break"},
          ],
          "false": [

          ]
          },
          {"type": "if", "condition": "flag:keycode==32",
          "true": [
            {"type": "showImage"},
            {"type": "break"},
          ],
          "false": [

          ]
          },
          {"type": "if", "condition": "flag:keycode==40",
          "true": [
            {"type": "setValue", "name": "flag:herotuy2", "value": "(flag:herotuy+32)"},
            {"type": "showImage"},
            {"type": "showImage", "name": "xia.png", "loc": ["flag:herodatux","flag:herodatuy"]},
            {"type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux","flag:herotuy"], "to": ["flag:herotux","flag:herotuy2"], "time": 1},
            {"type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux","flag:herotuy2"]},
            {"type": "setValue", "name": "flag:herotuy", "value": "flag:herotuy2"},
            {"type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1+1)"},
          ],
          "false": [

          ]
          },
          {"type": "if", "condition": "flag:keycode==38",
          "true": [
            {"type": "setValue", "name": "flag:herotuy2", "value": "(flag:herotuy-32)"},
            {"type": "if", "condition": "flag:herotuy2<=flag:panduan",
            "true": [
              {"type": "setValue", "name": "flag:herotuy2", "value": "(flag:herotuy+32)"},
            ],
            "false": [
              {"type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1-1)"},
              {"type": "showImage"},
              {"type": "showImage", "name": "xia.png", "loc": ["flag:herodatux","flag:herodatuy"]},
              {"type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux","flag:herotuy"], "to": ["flag:herotux","flag:herotuy2"], "time": 1},
              {"type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux","flag:herotuy2"]},
              {"type": "setValue", "name": "flag:herotuy", "value": "flag:herotuy2"},
            ]
            },
          ],
          "false": [

          ]
          },
        ],
        "false": [
          {"type": "if", "condition": "flag:x==flag:herox",
          "true": [
            {"type": "setValue", "name": "flag:herotuy2", "value": "(flag:y*32)"},
            {"type": "if", "condition": "flag:herotuy2<=flag:panduan",
            "true": [

            ],
            "false": [
              {"type": "if", "condition": "flag:herotuy2==flag:herotuy",
              "true": [
                {"type": "break"},
              ],
              "false": [
                {"type": "function", "function": "function(){\ncore.setFlag(\"linshi1\",core.getFlag(\"y\")-core.status.hero.loc.y)\n}"},
                {"type": "showImage"},
                {"type": "showImage", "name": "xia.png", "loc": ["flag:herodatux","flag:herodatuy"]},
                {"type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux","flag:herotuy"], "to": ["flag:herotux","flag:herotuy2"], "time": 1},
                {"type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux","flag:herotuy2"]},
                {"type": "setValue", "name": "flag:herotuy", "value": "flag:herotuy2"},
              ]
              },
            ]
            },
          ],
          "false": [

          ]
          },
        ]
        },
      ],
      },
      {"type": "showImage"},
      {"type": "if", "condition": "flag:linshi1==1",
      "true": [
        {"type": "if", "condition": "flag:suiji==1",
        "true": [
          "走和跳，你选一种吧",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==2",
        "true": [
          "他就在你面前，用什么破技能，丢人",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==3",
        "true": [
          "无影鬼斩服务部提醒您，您已到站，请下车步行",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==4",
        "true": [
          "走一走，迈开腿，一步到位，跳什么跳？闲得慌啊！？",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==5",
        "true": [
          "大哥，他就在你面前，跳什么跳",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
      ],
      "false": [

      ]
      },
      {"type": "function", "function": "function(){\nif (core.enemyExists(core.status.hero.loc.x,core.status.hero.loc.y+core.getFlag('linshi1',100))) {core.setFlag('linshi2',1);}\n}"},
      {"type": "if", "condition": "flag:linshi2>=1",
      "true": [

      ],
      "false": [
        {"type": "if", "condition": "flag:suiji==1",
        "true": [
          "我要砍的是怪，懂么？",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==2",
        "true": [
          "无影鬼斩服务部提醒您，您的目标地点没必要用砍的",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==3",
        "true": [
          "本人不斩无名之辈.........简单的说墙啊空地啊什么的我是不砍的",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==4",
        "true": [
          "想砍啥呢？",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==5",
        "true": [
          "我的剑，只斩妖魔鬼怪",
        ],
        "false": [

        ]
        },
        {"type": "exit"},
      ]
      },
      {"type": "function", "function": "function(){\nif (core.enemys.canBattle(core.getBlockId(core.status.hero.loc.x,core.status.hero.loc.y+core.getFlag('linshi1',100)))) {core.setFlag('linshi2',2);}\n}"},
      {"type": "if", "condition": "flag:linshi2==2",
      "true": [

      ],
      "false": [
        {"type": "if", "condition": "flag:suiji==1",
        "true": [
          "等我回去吃几个血瓶回来干翻你",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==2",
        "true": [
          "不是不打，时候未到",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==3",
        "true": [
          "打怪要讲策略懂么",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==4",
        "true": [
          "对面那货好像有点硬啊",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==5",
        "true": [
          "无影鬼斩服务部提醒您，您的目标地点太过危险，拒载",
        ],
        "false": [

        ]
        },
        {"type": "exit"},
      ]
      },
      {"type": "setValue", "name": "flag:heroy", "value": "(core.status.hero.loc.y+flag:linshi1)"},
      {"type": "setValue", "name": "flag:heroy3", "value": "(core.status.hero.loc.y)"},
      {"type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1-2)"},
      {"type": "setValue", "name": "flag:linshi1", "value": "Math.pow(2, flag:linshi1)"},
      {"type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1*20)"},
      {"type": "if", "condition": "status:experience>=flag:linshi1",
      "true": [
        {"type": "animate", "name": "wuyingguizhan", "loc": "hero"},
        {"type": "changePos", "loc": [0,14]},
        {"type": "function", "function": "function(){\ncore.insertAction({\"type\": \"animate\", \"name\": \"qitiaoxia\", \"loc\": [core.getFlag(\"herox\"),core.getFlag(\"heroy3\")]})\n}"},
        {"type": "changePos", "loc": ["flag:herox","flag:heroy"]},
        {"type": "animate", "name": "tiaozhansha", "loc": "hero"},
        {"type": "function", "function": "function(){\ncore.insertAction({\"type\": \"battle\", \"id\": core.getBlockId(core.getFlag(\"herox\"),core.getFlag(\"heroy\"))})\n}"},
        {"type": "hide", "loc": ["flag:herox","flag:heroy"]},
        {"type": "exit"},
      ],
      "false": [
        {"type": "if", "condition": "flag:suiji==1",
        "true": [
          "无影鬼斩服务部提示您，您的剑意余额已不足，请充值",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==2",
        "true": [
          "剑意不足，拒载",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==3",
        "true": [
          "待我蓄一波意",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==4",
        "true": [
          "乡愁是差一点剑意,我在这头,敌人在那头。",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==5",
        "true": [
          "太远了有木有",
        ],
        "false": [

        ]
        },
        {"type": "exit"},
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:heroz==4",
    "true": [
      {"type": "setValue", "name": "flag:herodatux", "value": "(flag:herotux-576)"},
      {"type": "setValue", "name": "flag:herodatuy", "value": "(flag:herotuy-448)"},
      {"type": "setValue", "name": "flag:panduan", "value": "(flag:herotux)"},
      {"type": "setValue", "name": "flag:herotux", "value": "(flag:herotux-32)"},
      {"type": "animateImage", "action": "show", "name": "zuo.png", "loc": ["flag:herodatux","flag:herodatuy"], "time": 500},
      {"type": "showImage", "name": "zuo.png", "loc": ["flag:herodatux","flag:herodatuy"]},
      {"type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux","flag:herotuy"]},
      {"type": "while", "condition": "true",
      "data": [
        {"type": "wait"},
        {"type": "if", "condition": "flag:type==0",
        "true": [
          {"type": "if", "condition": "flag:keycode==27",
          "true": [
            {"type": "showImage"},
            {"type": "exit"},
          ],
          "false": [

          ]
          },
          {"type": "if", "condition": "flag:keycode==13",
          "true": [
            {"type": "showImage"},
            {"type": "break"},
          ],
          "false": [

          ]
          },
          {"type": "if", "condition": "flag:keycode==32",
          "true": [
            {"type": "showImage"},
            {"type": "break"},
          ],
          "false": [

          ]
          },
          {"type": "if", "condition": "flag:keycode==37",
          "true": [
            {"type": "setValue", "name": "flag:herotux2", "value": "(flag:herotux-32)"},
            {"type": "showImage"},
            {"type": "showImage", "name": "zuo.png", "loc": ["flag:herodatux","flag:herodatuy"]},
            {"type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux","flag:herotuy"], "to": ["flag:herotux2","flag:herotuy"], "time": 1},
            {"type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux2","flag:herotuy"]},
            {"type": "setValue", "name": "flag:herotux", "value": "flag:herotux2"},
            {"type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1+1)"},
          ],
          "false": [

          ]
          },
          {"type": "if", "condition": "flag:keycode==39",
          "true": [
            {"type": "setValue", "name": "flag:herotux2", "value": "(flag:herotux+32)"},
            {"type": "if", "condition": "flag:herotux2>=flag:panduan",
            "true": [
              {"type": "setValue", "name": "flag:herotux2", "value": "flag:herotux"},
            ],
            "false": [
              {"type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1-1)"},
              {"type": "showImage"},
              {"type": "showImage", "name": "zuo.png", "loc": ["flag:herodatux","flag:herodatuy"]},
              {"type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux","flag:herotuy"], "to": ["flag:herotux2","flag:herotuy"], "time": 1},
              {"type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux2","flag:herotuy"]},
              {"type": "setValue", "name": "flag:herotux", "value": "flag:herotux2"},
            ]
            },
          ],
          "false": [

          ]
          },
        ],
        "false": [
          {"type": "if", "condition": "flag:y==flag:heroy",
          "true": [
            {"type": "setValue", "name": "flag:herotux2", "value": "(flag:x*32)"},
            {"type": "if", "condition": "flag:herotux2>=flag:panduan",
            "true": [

            ],
            "false": [
              {"type": "if", "condition": "flag:herotux2==flag:herotux",
              "true": [
                {"type": "break"},
              ],
              "false": [
                {"type": "function", "function": "function(){\ncore.setFlag(\"linshi1\",core.status.hero.loc.x-core.getFlag(\"x\"))\n}"},
                {"type": "showImage"},
                {"type": "showImage", "name": "zuo.png", "loc": ["flag:herodatux","flag:herodatuy"]},
                {"type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux","flag:herotuy"], "to": ["flag:herotux2","flag:herotuy"], "time": 1},
                {"type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux2","flag:herotuy"]},
                {"type": "setValue", "name": "flag:herotux", "value": "flag:herotux2"},
              ]
              },
            ]
            },
          ],
          "false": [

          ]
          },
        ]
        },
      ],
      },
      {"type": "showImage"},
      {"type": "if", "condition": "flag:linshi1==1",
      "true": [
        {"type": "if", "condition": "flag:suiji==1",
        "true": [
          "走和跳，你选一种吧",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==2",
        "true": [
          "他就在你面前，用什么破技能，丢人",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==3",
        "true": [
          "无影鬼斩服务部提醒您，您已到站，请下车步行",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==4",
        "true": [
          "走一走，迈开腿，一步到位，跳什么跳？闲得慌啊！？",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==5",
        "true": [
          "大哥，他就在你面前，跳什么跳",
          {"type": "exit"},
        ],
        "false": [

        ]
        },
      ],
      "false": [

      ]
      },
      {"type": "function", "function": "function(){\nif (core.enemyExists(core.status.hero.loc.x-core.getFlag('linshi1',100),core.status.hero.loc.y)) {core.setFlag('linshi2',1);}\n}"},
      {"type": "if", "condition": "flag:linshi2==1",
      "true": [

      ],
      "false": [
        {"type": "if", "condition": "flag:suiji==1",
        "true": [
          "我要砍的是怪，懂么？",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==2",
        "true": [
          "无影鬼斩服务部提醒您，您的目标地点没必要用斩的",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==3",
        "true": [
          "本人不斩无名之辈.........简单的说墙啊空地啊什么的我是不砍的",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==4",
        "true": [
          "想砍啥呢？",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==5",
        "true": [
          "我的剑，只斩妖魔鬼怪",
        ],
        "false": [

        ]
        },
        {"type": "exit"},
      ]
      },
      {"type": "function", "function": "function(){\nif (core.enemys.canBattle(core.getBlockId(core.status.hero.loc.x-core.getFlag('linshi1',100),core.status.hero.loc.y))) {core.setFlag('linshi2',2);}\n}"},
      {"type": "if", "condition": "flag:linshi2==2",
      "true": [

      ],
      "false": [
        {"type": "if", "condition": "flag:suiji==1",
        "true": [
          "等我回去吃几个血瓶回来干翻你",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==2",
        "true": [
          "不是不打，时候未到",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==3",
        "true": [
          "打怪要讲策略懂么",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==4",
        "true": [
          "对面那货好像有点硬啊",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==5",
        "true": [
          "无影鬼斩服务部提醒您，您的目标地点太过危险，拒载",
        ],
        "false": [

        ]
        },
        {"type": "exit"},
      ]
      },
      {"type": "setValue", "name": "flag:herox", "value": "(core.status.hero.loc.x-flag:linshi1)"},
      {"type": "setValue", "name": "flag:herox3", "value": "(core.status.hero.loc.x)"},
      {"type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1-2)"},
      {"type": "setValue", "name": "flag:linshi1", "value": "Math.pow(2, flag:linshi1)"},
      {"type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1*20)"},
      {"type": "if", "condition": "status:experience>=flag:linshi1",
      "true": [
        {"type": "animate", "name": "wuyingguizhan", "loc": "hero"},
        {"type": "changePos", "loc": [0,14]},
        {"type": "function", "function": "function(){\ncore.insertAction({\"type\": \"animate\", \"name\": \"qitiaozuo\", \"loc\": [core.getFlag(\"herox3\"),core.getFlag(\"heroy\")]})\n}"},
        {"type": "changePos", "loc": ["flag:herox","flag:heroy"]},
        {"type": "animate", "name": "tiaozhansha", "loc": "hero"},
        {"type": "function", "function": "function(){\ncore.insertAction({\"type\": \"battle\", \"id\": core.getBlockId(core.getFlag(\"herox\"),core.getFlag(\"heroy\"))})\n}"},
        {"type": "hide", "loc": ["flag:herox","flag:heroy"]},
        {"type": "exit"},
      ],
      "false": [
        {"type": "if", "condition": "flag:suiji==1",
        "true": [
          "无影鬼斩服务部提示您，您的剑意余额已不足，请充值",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==2",
        "true": [
          "剑意不足，拒载",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==3",
        "true": [
          "等我蓄一波意",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==4",
        "true": [
          "乡愁是差一点剑意,我在这头,敌人在那头。",
        ],
        "false": [

        ]
        },
        {"type": "if", "condition": "flag:suiji==5",
        "true": [
          "太远了有木有",
        ],
        "false": [

        ]
        },
        {"type": "exit"},
      ]
      },
    ],
    "false": [

    ]
    },
  ],
  "false": [
    {"type": "if", "condition": "flag:suiji==1",
    "true": [
      "无影鬼斩服务部提示您，您的剑意余额已不足，请充值",
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:suiji==2",
    "true": [
      "剑意不足，拒载",
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:suiji==3",
    "true": [
      "待我蓄一波意",
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:suiji==4",
    "true": [
      "乡愁是差一点剑意,我在这头,敌人在那头。",
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:suiji==5",
    "true": [
      "太远了有木有",
    ],
    "false": [

    ]
    },
    {"type": "exit"},
  ]
  },
]

		);

	  };
	  this.shuoming = function (shuoming) {
		core.insertAction([
		  { "type": "showImage", "name": "jianjian1.jpg", "loc": [0, 0] },
		  { "type": "wait" },
		  { "type": "showImage" },
		  { "type": "showImage", "name": "jianjian2.jpg", "loc": [0, 0] },
		  { "type": "wait" },
		  { "type": "showImage" },
		  { "type": "showImage", "name": "jianjian3.jpg", "loc": [0, 0] },
		  { "type": "wait" },
		  { "type": "showImage" },
		]);
	  };
	  this.xingzou = function (xingzou) {
		if (core.getFlag("tingyong") == 2) { }
		else {
		  if (core.getFlag("tingyong") == 1) {
			core.status.hero.experience = core.getFlag("jianyi");
			core.setFlag("tingyong", 2);
			core.plugin.setHeroIcon('hero1.png');
			core.updateStatusBar();
		  }
		  else {
			core.setFlag("linshi2", core.status.hero.steps);
			core.setFlag("linshi1", core.getFlag("linshi2") - core.getFlag("jilu"));
			if (core.getFlag("linshi1") <= 3) {
			  core.status.hero.experience += core.getFlag("cengshu");
			  core.updateStatusBar();

			}
			else {
			  core.setFlag("tingyong", 2);
			  core.status.hero.experience = core.getFlag("jianyi");
			  core.plugin.setHeroIcon('hero1.png');
			  core.updateStatusBar();
			}
		  }
		}
	  };
	  this.fenqi = function (fenqi) {
      core.plugin.tiaozhan();
	  };


	  this.setHeroIcon = function (name) {


		core.setFlag("heroIcon", name);
		core.material.images.hero.src = core.material.images.images[name].src;
		core.material.icons.hero.height = core.material.images.images[name].height / 4;
		core.drawHero();

	  };


   
	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();

}
    }
}