var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。


	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作，比如切分图片等。

		// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
		// var arr = core.splitImage("assets.png", 32, 32);
		// for (var i = 0; i < arr.length; i++) {
		//     core.material.images.images["asset"+i+".png"] = arr[i];
		// }

	}

	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
},
    "drawTextCenter": function () {
        this.drawTextCenter = function (ctx, text, x, y, font, style) {
            var size;
            var i;
            for (i = 30; i >= 8; i--) {
                ctx.font = font.replace(/(\d+)px/, i+"px");
                size = ctx.measureText(text);
                if (size.width <= 30) break;
            }
            ctx.fillStyle = style;
            ctx.fillText(text, x * 32 + (32 - size.width) / 2, (y + 1) * 32 - (32 - i) / 2 - 2);
        }
    },
    "generateMap": function () {
        this.generateMap = function (floorId) {
            var num = core.getFlag("num", null);
            var op = core.getFlag("op", null);
            if (!num || !op) return;
            num[floorId] = [];
            op[floorId] = [];
            num = num[floorId];
            op = op[floorId];
            for (var x = 0; x < 13; x++)
                for (var y = 0; y < 13; y++) {
                    var block = core.getBlock(x, y, floorId);
                    if (!block) continue;
                    var t = block.block.event;
                    if (!t.data || !t.data[0]) continue;
                    t = t.data[0].text;
                    if (!t) continue;
                    t = t.split(",");
                    if (t.length != 2) continue;
                    var block_op = t[0];
                    var block_num = Number(t[1]);
                    if (!(x in op)) op[x] = []
                    op[x][y] = block_op;
                    if (!(x in num)) num[x] = []
                    num[x][y] = block_num;
                    switch (block_op[0]) {
                        case "b":
                            core.setBlock(block_op[1] == "@" ? 36 : 322, x, y, floorId);
                            break;
                        case "r":
                            core.setBlock(321, x, y, floorId);
                            break;
                        case "R":
                            core.setBlock(320, x, y, floorId);
                            break;
                        case "g":
                            core.setBlock(324, x, y, floorId);
                            break;
                    }
                }
        }
    },
    "updateDamage": function () {
        control.prototype.updateDamage = function (floorId, ctx) {
            floorId = floorId || core.status.floorId;
            if (!core.isset(floorId) || core.status.gameOver) return;
            if (core.status.gameOver) return;
            if (!core.isset(ctx)) {
                ctx = core.canvas.damage;
            }
            core.clearMap('damage');
            core.setTextAlign(ctx, 'left');
            var num = core.getFlag("num", null);
            var op = core.getFlag("op", null);
            if (!num || !op) return;
            num = num[floorId];
            op = op[floorId];
            if (!num || !op) return;
            core.status.maps[floorId].blocks.forEach(function (block) {
                var x = block.x, y = block.y;
                if (!block.disable && op[x] && op[x][y]) {
                    var hint;
                    switch (op[x][y][0]) {
                        case 'b':
                            switch (op[x][y].slice(1)) {
                                case '$':
                                    hint = "∽";
                                    break;
                                case '@':
                                    hint = "";
                                    break;
                                default:
                                    hint = op[x][y].slice(1).replace("?",num[x][y].toString());
                            }
                            break;
                        case 'r':
                            if (op[x][y][1] == "$") hint = "∽";
                            else hint = op[x][y].slice(1).replace("?",num[x][y].toString());
                            break;
                        case 'R':
                            hint = num[x][y].toString();
                            break;
                        case 'g':
                            if (op[x][y][1] == "!") hint = "≠?";
                            else hint = op[x][y].slice(1);
                            hint = hint.replace("?",num[x][y].toString());
                            break;
                    }
                    core.drawTextCenter(ctx, hint, x, y, "bold 0px Monospace", op[x][y][0] == 'g' ? "#FF3300" : "#FFFF00");
                }
            });
        }
    },
    "updateGreen": function () {
        this.updateGreen = function () {
            var op = core.getFlag("op", null);
            var num = core.getFlag("num", null);
            if (!num || !op) return;
            num = num[core.status.floorId];
            op = op[core.status.floorId];
            if (!num || !op) return;
            var hp = core.status.hero.hp;
            for (var x = 0; x < 13; x++)
                for (var y = 0; y < 13; y++)
                    if (op[x] && op[x][y] && op[x][y][0] == 'g') {
                        var flag;
                        switch (op[x][y].slice(1)) {
                            case ">?":
                                flag = hp > num[x][y];
                                break;
                            case "<?":
                                flag = hp < num[x][y];
                                break;
                            case "=?":
                                flag = hp == num[x][y];
                                break;
                            case "!=?":
                                flag = hp != num[x][y];
                                break;
                        }
                        core.setBlock(flag ? 325 : 324, x, y);
                    }
        }
    },
    "setTrigger": function () {
        core.registerSystemEvent("blue", function (data, callback) {
            var num = core.getFlag("num", null);
            var op = core.getFlag("op", null);
            if (!num || !op) return;
            num = num[core.status.floorId];
            op = op[core.status.floorId];
            if (!num || !op) return;
            var x = data.x, y = data.y;
            var hp = core.status.hero.hp;
            switch(op[x][y].slice(1)) {
                case "+?":
                    hp += num[x][y];
                    break;
                case "-?":
                    hp -= num[x][y];
                    break;
                case "*?":
                    hp *= num[x][y];
                    break;
                case "/?":
                    hp /= num[x][y];
                    hp = Math.round(hp);
                    break;
                case "?-":
                    hp = num[x][y] - hp;
                    break;
                case "?/":
                    hp = num[x][y] / hp;
                    hp = Math.round(hp);
                    break;
                case "$":
                    hp = Number(hp.toString().split("").reverse().join(""));
                    break;
            }
            if (hp <= 0) {
                core.status.hero.hp = 0;
                core.updateStatusBar();
                core.events.lose();
            } else {
                core.status.hero.hp = hp;
                core.updateStatusBar();
                core.updateGreen();
            }
            core.removeBlock(x, y);
            if (callback) callback();
        });
        core.registerSystemEvent("RED", function (data, callback) {
            var num = core.getFlag("num", null);
            var op = core.getFlag("op", null);
            if (!num || !op) return;
            num = num[core.status.floorId];
            op = op[core.status.floorId];
            if (!num || !op) return;
            var x = data.x, y = data.y;
            if (core.getFlag("shield", 0) == 1) {
                core.setFlag("shield", 0);
            } else {
                var hp = core.status.hero.hp;
                hp -= num[x][y];
                if (hp <= 0) {
                    core.status.hero.hp = 0;
                    core.updateStatusBar();
                    core.events.lose();
                } else if (num[x][y] != 0) {
                    core.status.hero.hp = hp;
                    core.updateStatusBar();
                    core.updateGreen();
                }
            }
            core.removeBlock(x, y);
            if (callback) callback();
        });
        core.registerSystemEvent("red", function (data, callback) {
            var num = core.getFlag("num", null);
            var op = core.getFlag("op", null);
            if (!num || !op) return;
            num = num[core.status.floorId];
            op = op[core.status.floorId];
            if (!num || !op) return;
            var x = data.x, y = data.y;
            var func;
            switch(op[x][y].slice(1)) {
                case "+?":
                    func = function (t) {return t + num[x][y];};
                    break;
                case "-?":
                    func = function (t) {return Math.max(t - num[x][y], 0);};
                    break;
                case "*?":
                    func = function (t) {return t * num[x][y];};
                    break;
                case "/?":
                    func = function (t) {return Math.round(t / num[x][y]);};
                    break;
                case "?-":
                    func = function (t) {return Math.max(num[x][y] - t, 0);};
                    break;
                case "?/":
                    func = function (t) {return Math.round(num[x][y] / t);};
                    break;
                case "$":
                    func = function (t) {return Number(t.toString().split("").reverse().join(""));};
                    break;
            }
            for (var i = 0; i < 13; i++)
                for (var j = 0; j < 13; j++)
                    if (op[i] && op[i][j] && op[i][j][0] == "R")
                        num[i][j] = func(num[i][j]);
            core.updateDamage();
            core.removeBlock(x, y);
            if (callback) callback();
        });
    }
}