///<reference path='../runtime.d.ts'/>
var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = {
    init: function () {
        console.clear();
        console.log(`通过Magic塔，相信你已经了解了基础玩法`);
        console.log(`但是当你逃脱之后，发现自己只不过逃脱了多层梦境的第一层`);
        console.log(`后面还有更多谜题等待着你`);
        console.log(`这是第二关，看看你能不能通关吧`);
        console.log(`不要妄图抄作业哦，这一关每次开始游戏，答案都不同`);

        const isStringifiedEqual = (a, b) => {
            return String(a) === String(b);
        };

        const isLargerThan = (a, b, n = 3) => {
            return String(a).slice(0, n) > String(b).slice(0, n);
        };

        const isEqual = (a, b) => {
            return Object.is(a, b);
        };

        const substractString = (a, b, n = 0) => {
            return String.fromCharCode(a.charCodeAt(n) - b.charCodeAt(n));
        };

        const subStringNumber = (a, b, n = 0) => {
            return String.fromCharCode(a.charCodeAt(n) - b);
        };

        const resetEmits = [];

        const hook = {
            emitReset() {
                resetEmits.forEach(v => v());
            },
            onReset(fn) {
                resetEmits.push(fn);
            }
        };

        window.Magic = {
            isStringifiedEqual,
            isLargerThan,
            isEqual,
            substractString,
            subStringNumber,
            hook,
            magic: {
                rand: 0,
                digit: 0,
                char: []
            },
            check: {
                key0: 'exxxxs',
                key1: 'xvxxxdxxx',
                key2: 'xix',
                value0: 999,
                value1: 0
            }
        };
    },
    replay: function () {
        const idle = name => {
            if (name !== 'idle') return false;
            core.status.route.push(name);
            core.replay();
            return true;
        };
        core.registerReplayAction('idle', idle);

        core.plugin.checkpoint = 0;

        const checkCP = () => {
            core.extractBlocks();
            const blocks = core.status.thisMap.blocks;
            switch (core.plugin.checkpoint) {
                case 0: {
                    let n1 = 0;
                    let n2 = 0;
                    let n3 = 0;
                    blocks.forEach(v => {
                        if (v.id !== 1) return;
                        if (v.x >= 2 && v.x <= 10 && v.y >= 2 && v.y <= 6) {
                            n3 -= -1;
                            if (v.y === 2) {
                                n1 -= -1;
                            }
                            if (v.x === 2) {
                                n2 -= -1;
                            }
                        }
                    });
                    if (n1 === 9 && n2 === 5 && n3 === 17) {
                        core.plugin.checkpoint = 1;
                        return true;
                    }
                    return false;
                }
                case 1: {
                    const id1 = core.getBlock(5, 4, 'MT0')?.id ?? 0;
                    const id2 = core.getBlock(8, 6, 'MT0')?.id ?? 0;
                    const id3 = core.getBlock(3, 2, 'MT0')?.id ?? 0;
                    const id4 = core.getBlock(8, 2, 'MT0')?.id ?? 0;
                    const res = (id1 - id2) / (id3 + id4);
                    if (String(res).length !== 3) return false;
                    if (Magic.isLargerThan(res, Magic.check.value0)) {
                        core.plugin.checkpoint = 2;
                        return true;
                    }
                    return false;
                }
                case 2: {
                    if (core.plugin.getAreaCount() === 11) {
                        const id1 = core.getBlock(10, 2, 'MT0')?.id ?? 0;
                        const id2 = core.getBlock(6, 4, 'MT0')?.id ?? 0;
                        const num = id1 - id2;
                        if (
                            Magic.isEqual(-num, Magic.check.value1) &&
                            num === Magic.check.value1
                        ) {
                            core.plugin.checkpoint = 3;
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        };

        const checkpoint = name => {
            if (name !== 'checkpoint') return false;
            if (checkCP()) {
                core.status.route.push(name);
                core.replay();
                return true;
            }
            return false;
        };
        core.registerReplayAction('checkpoint', checkpoint);

        const replaceWith = (key, num) => {
            if (key !== 'key0' && key !== 'key1' && key !== 'key2') {
                return false;
            }
            const rand = Math.floor(core.rand(Magic.magic.char.length));
            const char = Magic.magic.char[rand];
            const index = Magic.check[key].indexOf('x');
            if (index === -1) return false;
            const before = Magic.check[key].slice(0, index);
            const after = Magic.check[key].slice(index + 1);
            const cal = Magic.subStringNumber(char, num, 0);
            Magic.check[key] = before + cal + after;
            return true;
        };

        // 方便你进行调试，添加一个全局函数
        window.re = replaceWith;

        const replaceCheckKey = name => {
            const [_name, key, num] = name.split(':');
            if (_name !== 'replace') return false;
            if (replaceWith(key, parseInt(num))) {
                core.status.route.push(name);
                core.replay();
                return true;
            }
            return false;
        };
        core.registerReplayAction('replace', replaceCheckKey);

        const setBlock = name => {
            const [id, block, x, y, d] = name.split(':');
            let num = 0;
            if (block === 'wall') {
                num = 1;
            } else if (block === 'none') {
                num = 0;
            } else {
                return false;
            }
            if (Number(d) < 0) return false;
            const sx = Number(x);
            const sy = Number(y);
            const ex = sx + Number(d);
            const ey = sy + Number(d);

            if (id === 'blockx') {
                for (let nx = sx; nx < ex; nx++) {
                    core.setBlock(num, nx, sy);
                }
                core.status.route.push(name);
                core.replay();
                return true;
            } else if (id === 'blocky') {
                for (let ny = sy; ny < ey; ny++) {
                    core.setBlock(num, sx, ny);
                }
                core.status.route.push(name);
                core.replay();
                return true;
            }
            return false;
        };
        core.registerReplayAction('setBlock', setBlock);

        const setValue1 = name => {
            const [v, value] = name.split(':');
            if (v !== 'value1') return false;
            const num = Number(value);
            if (isNaN(num)) return false;
            Magic.check.value1 = num;
            core.status.route.push(name);
            core.replay();
            return true;
        };
        core.registerReplayAction('value1', setValue1);
    },
    check: function () {
        const check1 = () => {
            return core.status.route.length < 50;
        };

        const check2 = () => {
            true;
        };

        const check3 = () => {
            return !Array(100)
                .fill(true)
                .some(v => {
                    v === true;
                });
        };

        const check4 = () => {
            core.extractBlocks();
            const blocks = core.status.thisMap.blocks;
            const n = blocks.length;
            return n <= 67;
        };

        const check5 = () => {
            return core.plugin.checkpoint === 3;
        };

        const check6 = () => {
            return +null + !+null;
        };

        const checkAll = () => {
            const { check } = Magic;

            const func = core[check.key0]?.[check.key1]?.[check.key2];
            if (typeof func !== 'function') {
                return false;
            }

            return (
                check1() &&
                !check2() &&
                check3() &&
                check4() &&
                check5() &&
                check6()
            );
        };

        const win = name => {
            if (name !== 'win') return false;
            core.lose('逃脱失败');
            return false;
        };
        core.registerReplayAction('win', win);

        const start = (key0, key1) => {
            core.status.gameOver = true;
        };

        const lose = name => {
            if (name !== 'lose') return false;
            const { check } = Magic;

            if (!checkAll()) {
                core.status.gameOver = true;
                start();
                win('win');
                core.status.route.push(name);
                return false;
            }
            const func = core[check.key0]?.[check.key1]?.[check.key2];
            start(check.key0, check.key1);
            func(core.plugin._0x3777_223c);
            core.status.route.push(name);
            return true;
        };
        core.registerReplayAction('lose', lose);
    },
    magic: function () {
        const _0x3777_223c = `\u9003\u8131\u6210\u529f`;
        const _0 = (+[![]] +
            [
                +(
                    +!+[] +
                    (!+[] + [])[!+[] + !+[] + !+[]] +
                    [+!+[]] +
                    [+[]] +
                    [+[]] +
                    [+[]]
                )
            ])[+!+[] + [+[]]];
        const _1 = ([][[]] + [])[+!+[]];
        const _2 = ([![]] + [][[]])[+!+[] + [+[]]];
        const _3 = ([][[]] + [])[!+[] + !+[]];
        const _4 = (!![] + [])[!+[] + !+[] + !+[]];
        const _5 = (![] + [])[+!+[]];

        // 此函数会在每次开始游戏及读档操作后执行
        // 也就是在 resetGame 操作后执行
        Magic.hook.onReset(() => {
            core.rand();
            core.rand();
            core.rand();
            core.rand();
            core.rand();
            const seed = flags.__rand__;
            const digit = Math.ceil(Math.log10(seed));
            Magic.magic.rand = seed;
            Magic.magic.digit = digit;
            Magic.magic.char = [_0, _1, _2, _3, _4, _5];
            core.plugin.checkpoint = 0;
        });
        core.plugin._0x3777_223c = _0x3777_223c;

        control.prototype.startReplay = function (list) {
            if (!core.isPlaying()) return;
            core.status.replay.replaying = true;
            core.status.replay.pausing = true;
            core.status.replay.failed = false;
            core.status.replay.speed = 1.0;
            core.status.replay.toReplay = core.cloneArray(list);
            core.status.replay.totalList = core.status.route.concat(list);
            core.status.replay.steps = 0;
            core.status.replay.save = [];
            core.createCanvas('replay', 0, core._PY_ - 40, core._PX_, 40, 199);
            core.setOpacity('replay', 0.6);
            this._replay_drawProgress();
            core.updateStatusBar(false, true);
            core.drawTip('开始播放');
            flags.__rand__ = flags.__seed__;
            core.rand();
            core.rand();
            core.rand();
            core.rand();
            core.rand();
            const seed = flags.__rand__;
            const digit = Math.ceil(Math.log10(seed));
            Magic.magic.rand = seed;
            Magic.magic.digit = digit;
            Magic.magic.char = [_0, _1, _2, _3, _4, _5];
            core.plugin.checkpoint = 0;
            this.replay();
        };

        core.plugin.getAreaCount = function () {
            const used = new Set();
            const maps = Object.values(core.utils.scan);
            let areas = 0;

            for (let nx = 1; nx < 12; nx++) {
                for (let ny = 0; ny < 8; ny++) {
                    const index = nx + ny * 13;
                    if (used.has(index)) continue;
                    const block = core.getBlock(nx, ny, 'MT0');
                    if (block) continue;

                    const queue = [index];
                    while (queue.length > 0) {
                        const index = queue.shift();
                        const x = index % 13;
                        const y = Math.floor(index / 13);

                        maps.forEach(v => {
                            const tx = x + v.x;
                            const ty = y + v.y;
                            const index = tx + ty * 13;
                            if (used.has(index)) return;
                            used.add(index);
                            const block = core.getBlock(tx, ty, 'MT0');
                            if (block) return;
                            queue.push(index);
                        });
                    }
                    areas++;
                }
            }
            return areas;
        };
    },
    override: function () {
        events.prototype._startGame_start = function (
            hard,
            seed,
            route,
            callback
        ) {
            core.resetGame(
                core.firstData.hero,
                hard,
                null,
                core.cloneArray(core.initStatus.maps)
            );
            core.setHeroLoc('x', -1);
            core.setHeroLoc('y', -1);

            if (seed != null && seed > 0) {
                core.setFlag('__seed__', seed);
                core.setFlag('__rand__', seed);
            } else core.utils.__init_seed();
            core.clearStatusBar();

            flags.__rand__ = flags.__seed__;
            core.updateStatusBar(false, true);

            Magic.magic = {
                rand: 0,
                digit: 0,
                char: []
            };
            Magic.check = {
                key0: 'exxxxs',
                key1: 'xvxxxdxxx',
                key2: 'xix',
                value0: 999,
                value1: 0
            };

            Magic.hook.emitReset();

            var todo = [];
            if (core.flags.startUsingCanvas) {
                core.hideStatusBar();
                core.dom.musicBtn.style.display = 'block';
                core.push(todo, core.firstData.startCanvas);
            }
            core.push(todo, {
                type: 'function',
                function: 'function() { core.events._startGame_setHard(); }'
            });
            core.push(todo, core.firstData.startText);
            this.insertAction(todo, null, null, function () {
                core.events._startGame_afterStart(callback);
            });

            if (route != null) core.startReplay(route);
        };
    }
};
