var data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d = 
{
	"main": {
		"floorIds": [
			"MT0",
			"MT1",
			"MT2",
			"MT3",
			"MT4",
			"MT5",
			"MT6",
			"MT7",
			"MT8",
			"MT9",
			"MT10",
			"MT11",
			"MT12",
			"MT13",
			"MT14",
			"MT15"
		],
		"floorPartitions": [],
		"images": [
			"bear.png",
			"bg.jpg",
			"dragon.png",
			"hero.png",
			"winskin.png"
		],
		"tilesets": [
			"magictower.png"
		],
		"animates": [
			"hand",
			"sword",
			"zone"
		],
		"bgms": [
			"bgm.mp3"
		],
		"sounds": [
			"attack.mp3",
			"bomb.mp3",
			"cancel.mp3",
			"centerFly.mp3",
			"confirm.mp3",
			"cursor.mp3",
			"door.mp3",
			"equip.mp3",
			"error.mp3",
			"floor.mp3",
			"gem.mp3",
			"icePickaxe.mp3",
			"item.mp3",
			"jump.mp3",
			"load.mp3",
			"open_ui.mp3",
			"pickaxe.mp3",
			"recovery.mp3",
			"save.mp3",
			"shop.mp3",
			"zone.mp3"
		],
		"fonts": [],
		"nameMap": {
			"确定": "confirm.mp3",
			"取消": "cancel.mp3",
			"操作失败": "error.mp3",
			"光标移动": "cursor.mp3",
			"打开界面": "open_ui.mp3",
			"读档": "load.mp3",
			"存档": "save.mp3",
			"获得道具": "item.mp3",
			"回血": "recovery.mp3",
			"炸弹": "bomb.mp3",
			"飞行器": "centerFly.mp3",
			"开关门": "door.mp3",
			"上下楼": "floor.mp3",
			"跳跃": "jump.mp3",
			"破墙镐": "pickaxe.mp3",
			"破冰镐": "icePickaxe.mp3",
			"宝石": "gem.mp3",
			"阻激夹域": "zone.mp3",
			"穿脱装备": "equip.mp3",
			"背景音乐": "bgm.mp3",
			"攻击": "attack.mp3",
			"背景图": "bg.jpg",
			"商店": "shop.mp3",
			"领域": "zone"
		},
		"levelChoose": [
			{
				"title": "秩序",
				"name": "Lawful",
				"hard": 1,
				"color": [
					64,
					255,
					85,
					1
				],
				"action": [
					{
						"type": "function",
						"function": "function(){\nvar i, j, k;\nfor (i in core.material.enemys) { //秩序难度下删除所有掉落池属性；\n\tif (!Array.isArray(core.material.enemys[i].special)) { continue; }\n\tfor (j = 31; j <= 38; j++) {\n\t\tk = core.material.enemys[i].special.indexOf(j);\n\t\tif (k >= 0) {\n\t\t\tcore.material.enemys[i].special.splice(k, 1);\n\t\t\tvar c = [].concat(core.material.enemys[i].special);\n\t\t\tcore.setEnemy(i, 'special', c);\n\t\t}\n\t}\n}\nflags.chaos = false;\nflags.atkTimes = 0;\nflags.defTimes = 0;\nflags.gameTime = -100;\n}"
					}
				]
			},
			{
				"title": "混沌",
				"name": "Chaos",
				"hard": 2,
				"color": [
					255,
					68,
					64,
					1
				],
				"action": [
					{
						"type": "function",
						"function": "function(){\nflags.chaos = flags.hard;\nflags.buchang0 = false;\nflags.buchang1 = false;\nflags.buchang2 = false;\nflags.gameTime = -100;\nflags.showList = 100;\nflags.uiORPageMax = 20;\ncore.plugin.ChaosSimulate(0, 0); //执行混沌难度初始化;\n}"
					}
				]
			}
		],
		"equipName": [
			"武器",
			"盾牌"
		],
		"startBgm": null,
		"styles": {
			"startBackground": "project/images/bg.jpg",
			"startVerticalBackground": "project/images/bg.jpg",
			"startLogoStyle": "color: black",
			"startButtonsStyle": "background-color: #32369F; opacity: 0.85; color: #FFFFFF; border: #FFFFFF 2px solid; caret-color: #FFD700;",
			"statusLeftBackground": "url(project/materials/ground.png) repeat",
			"statusTopBackground": "url(project/materials/ground.png) repeat",
			"toolsBackground": "url(project/materials/ground.png) repeat",
			"borderColor": [
				204,
				204,
				204,
				1
			],
			"statusBarColor": [
				255,
				255,
				255,
				1
			],
			"selectColor": [
				255,
				215,
				0,
				1
			],
			"floorChangingStyle": "background-color: black; color: white",
			"font": "Verdana"
		},
		"splitImages": [
			{
				"name": "dragon.png",
				"width": 384,
				"height": 96,
				"prefix": "dragon_"
			}
		]
	},
	"firstData": {
		"title": "守序混沌",
		"name": "LawfulChaos",
		"version": "Ver 2.8.2",
		"floorId": "MT0",
		"hero": {
			"image": "hero.png",
			"animate": false,
			"name": "阳光",
			"lv": 1,
			"hpmax": 20000,
			"hp": 20000,
			"manamax": -1,
			"mana": 0,
			"atk": 15,
			"def": 15,
			"mdef": 0,
			"money": 0,
			"exp": 0,
			"equipment": [],
			"items": {
				"constants": {},
				"tools": {},
				"equips": {}
			},
			"loc": {
				"direction": "up",
				"x": 6,
				"y": 11
			},
			"flags": {},
			"followers": [],
			"steps": 0
		},
		"startCanvas": [
			{
				"type": "comment",
				"text": "在这里可以用事件来自定义绘制标题界面的背景图等"
			},
			{
				"type": "comment",
				"text": "也可以直接切换到其他楼层（比如某个开始剧情楼层）进行操作。"
			},
			{
				"type": "previewUI",
				"action": [
					{
						"type": "fillRect",
						"x": 0,
						"y": 0,
						"width": "core.__PIXELS__",
						"height": "core.__PIXELS__",
						"style": [
							82,
							82,
							82,
							1
						]
					},
					{
						"type": "setAttribute",
						"align": "center"
					},
					{
						"type": "fillBoldText",
						"x": "core.__PIXELS__ / 2",
						"y": 80,
						"style": [
							255,
							255,
							255,
							1
						],
						"strokeStyle": [
							0,
							0,
							0,
							1
						],
						"font": "bold 40px Verdana",
						"text": "${core.firstData.title}"
					}
				]
			},
			{
				"type": "setValue",
				"name": "flag:selection",
				"value": "0"
			},
			{
				"type": "comment",
				"text": "在右下方自绘一个对话框进行显示选择项"
			},
			{
				"type": "previewUI",
				"action": [
					{
						"type": "fillRect",
						"x": 230,
						"y": 250,
						"width": 150,
						"height": 142,
						"radius": 10,
						"style": [
							50,
							54,
							159,
							0.85
						]
					},
					{
						"type": "strokeRect",
						"x": 230,
						"y": 250,
						"width": 150,
						"height": 142,
						"radius": 10,
						"style": [
							255,
							255,
							255,
							1
						],
						"lineWidth": 2
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 290,
						"style": [
							255,
							255,
							255,
							1
						],
						"font": "bold 25px Verdana",
						"text": "开始游戏"
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 330,
						"font": "bold 25px Verdana",
						"text": "读取存档"
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 370,
						"font": "bold 25px Verdana",
						"text": "回放录像"
					}
				]
			},
			{
				"type": "while",
				"condition": "1",
				"data": [
					{
						"type": "drawSelector",
						"image": "winskin.png",
						"code": 1,
						"x": 245,
						"y": "261 + 40*flag:selection",
						"width": 120,
						"height": 40
					},
					{
						"type": "wait",
						"data": [
							{
								"case": "keyboard",
								"keycode": "13,32",
								"break": true,
								"action": [
									{
										"type": "switch",
										"condition": "flag:selection",
										"caseList": [
											{
												"case": "0",
												"action": [
													{
														"type": "comment",
														"text": "在“开始游戏”确定"
													},
													{
														"type": "break",
														"n": 1
													}
												]
											},
											{
												"case": "1",
												"action": [
													{
														"type": "comment",
														"text": "在“读取存档”确定"
													},
													{
														"type": "callLoad"
													}
												]
											},
											{
												"case": "2",
												"action": [
													{
														"type": "comment",
														"text": "在“回放录像”确定"
													},
													{
														"type": "if",
														"condition": "(!core.isReplaying())",
														"true": [
															{
																"type": "function",
																"function": "function(){\ncore.chooseReplayFile()\n}"
															}
														]
													}
												]
											}
										]
									}
								]
							},
							{
								"case": "keyboard",
								"keycode": "38",
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "光标上键"
									},
									{
										"type": "setValue",
										"name": "flag:selection",
										"value": "(flag:selection + 2) % 3"
									}
								]
							},
							{
								"case": "keyboard",
								"keycode": "40",
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "光标下键"
									},
									{
										"type": "setValue",
										"name": "flag:selection",
										"value": "(flag:selection + 1) % 3"
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									261,
									300
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“开始游戏”"
									},
									{
										"type": "break",
										"n": 1
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									301,
									340
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“读取存档”"
									},
									{
										"type": "callLoad"
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									341,
									380
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“播放录像”"
									},
									{
										"type": "if",
										"condition": "(!core.isReplaying())",
										"true": [
											{
												"type": "function",
												"function": "function(){\ncore.chooseReplayFile()\n}"
											}
										]
									}
								]
							}
						]
					}
				]
			},
			{
				"type": "setValue",
				"name": "flag:selection",
				"value": "null"
			},
			{
				"type": "drawSelector",
				"code": 1
			},
			{
				"type": "clearMap"
			},
			{
				"type": "function",
				"function": "function(){\ncore.control.checkBgm()\n}"
			},
			{
				"type": "if",
				"condition": "(main.levelChoose.length == 0)",
				"true": [
					{
						"type": "comment",
						"text": "没有难度选择：直接开始游戏"
					}
				],
				"false": [
					{
						"type": "comment",
						"text": "难度选择：作为样例，这里只提供了一个显示选择项。"
					},
					{
						"type": "function",
						"function": "function(){\nvar choices = [];\nmain.levelChoose.forEach(function (one) {\n\tchoices.push({\n\t\t\"text\": one.title || '',\n\t\t\"action\": [\n\t\t\t{ \"type\": \"function\", \"function\": \"function() { core.status.hard = '\" + (one.name || '') + \"'; }\" }\n\t\t]\n\t});\n})\ncore.insertAction({ \"type\": \"choices\", \"choices\": choices });\n}"
					},
					{
						"type": "comment",
						"text": "你也可以仿照上面的样例进行自己创建等待用户操作来处理不同的难度分歧。\n如需自己处理，请设置 core.status.hard \n（例如，自定义js脚本：core.status.hard = 'Easy' ）"
					}
				]
			},
			{
				"type": "clearMap"
			},
			{
				"type": "comment",
				"text": "接下来会执行startText中的事件"
			},
			{
				"type": "comment",
				"text": "状态栏默认处于隐藏状态；可以使用“显示状态栏”事件进行显示。"
			}
		],
		"startText": [
			{
				"type": "comment",
				"text": "初始剧情"
			},
			{
				"type": "setValue",
				"name": "flag:shop1",
				"value": "true"
			},
			{
				"type": "setValue",
				"name": "item:book",
				"value": "1"
			},
			"本塔采用时间计分制，每次切换楼层会+100单位时间并重置楼层地图，每场战斗会+(10+战斗回合数)单位时间，最终成绩为(99999999-时间)[不会小于0]*100+血量。",
			"在秩序难度下，初始点下方的伯伯可以给你提供一些物质上的帮助;\n在混沌难度下，请在初始点下方的伯伯处了解特殊规则。",
			"特别的，在秩序难度下，踩到血网需要重新找伯伯开启商店！\n在混沌难度下，如果到达一定时间还没有达到一定攻防，伯伯可能会给你一些补偿！"
		],
		"shops": [
			{
				"id": "shop1",
				"text": "\t[伯伯,man]商店",
				"textInList": "金币商店",
				"mustEnable": true,
				"disablePreview": false,
				"choices": [
					{
						"text": "生命+50(5金币)",
						"need": "status:money>=5",
						"condition": "flags.shop1",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "5"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "50"
							}
						]
					},
					{
						"text": "生命+250(25金币)",
						"need": "status:money>=25",
						"condition": "flags.shop1",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "25"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "250"
							}
						]
					},
					{
						"text": "护盾+3(30金币)",
						"need": "status:money>=30",
						"condition": "flags.shop1",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "30"
							},
							{
								"type": "setValue",
								"name": "status:mdef",
								"operator": "+=",
								"value": "3"
							}
						]
					},
					{
						"text": "生命+800(75金币)",
						"need": "status:money>=75",
						"condition": "flags.shop1",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "75"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "800"
							}
						]
					},
					{
						"text": "防御+1(${100+flag:defTimes*10}金币)",
						"need": "status:money>=(100+flag:defTimes*10)",
						"condition": "flags.shop1",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "100+flag:defTimes*10"
							},
							{
								"type": "setValue",
								"name": "status:def",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "flag:defTimes",
								"operator": "+=",
								"value": "1"
							}
						]
					},
					{
						"text": "攻击+1(${150+15*flag:atkTimes}金币)",
						"need": "status:money>=(150+flag:atkTimes*15)",
						"condition": "flags.shop1",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "150+flag:atkTimes*15"
							},
							{
								"type": "setValue",
								"name": "status:atk",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "flag:atkTimes",
								"operator": "+=",
								"value": "1"
							}
						]
					},
					{
						"text": "铁盾(250金币,装备,+3防御)",
						"need": "status:money>=250",
						"condition": "!flags.shop1",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "250"
							},
							{
								"type": "setValue",
								"name": "item:shield1",
								"operator": "+=",
								"value": "1"
							}
						]
					},
					{
						"text": "铁剑(350金币,装备,+3攻击)",
						"need": "status:money>=350",
						"condition": "!flags.shop1",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "350"
							},
							{
								"type": "setValue",
								"name": "item:sword1",
								"operator": "+=",
								"value": "1"
							}
						]
					},
					{
						"text": "骑士盾(550金币,装备,+7防御)",
						"need": "status:money>=550",
						"condition": "!flags.shop1",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "550"
							},
							{
								"type": "setValue",
								"name": "item:shield3",
								"operator": "+=",
								"value": "1"
							}
						]
					},
					{
						"text": "骑士剑(800金币,装备,+7攻击)",
						"need": "status:money>=800",
						"condition": "!flags.shop1",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "800"
							},
							{
								"type": "setValue",
								"name": "item:sword3",
								"operator": "+=",
								"value": "1"
							}
						]
					},
					{
						"text": "神圣盾(1300金币,装备,+10防御,提供被动绝对防御)",
						"need": "status:money>=1300",
						"condition": "!flags.shop1",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "1300"
							},
							{
								"type": "setValue",
								"name": "item:shield5",
								"operator": "+=",
								"value": "1"
							}
						]
					},
					{
						"text": "神圣剑(1700金币,装备,+10攻击,提供被动恩赐解脱)",
						"need": "status:money>=1700",
						"condition": "!flags.shop1",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "1700"
							},
							{
								"type": "setValue",
								"name": "item:sword5",
								"operator": "+=",
								"value": "1"
							}
						]
					},
					{
						"text": "翻页",
						"need": "true",
						"action": [
							{
								"type": "setValue",
								"name": "flag:shop1",
								"value": "(!flag:shop1)"
							}
						]
					}
				]
			},
			{
				"id": "shop2",
				"text": "\t[设置,sign]你可以在这里查看混沌难度的说明或设置每个池子预览的回合数([100,1000]内的正整数)，当前:${flag:showList}。",
				"textInList": "设置",
				"mustEnable": true,
				"disablePreview": false,
				"choices": [
					{
						"text": "修改设置",
						"need": "true",
						"action": [
							{
								"type": "input",
								"text": "请输入一个[100,1000]内的正整数"
							},
							{
								"type": "function",
								"function": "function(){\nif (flags.input > 1000) { flags.showList = 1000; } else { if (flags.input < 100) { flags.showList = 100; } else { flags.showList = flags.input; } }\nflags.uiORPageMax = Math.ceil(flags.showList / 100) * 20;\n}"
							}
						]
					},
					{
						"text": "混沌难度补偿",
						"need": "flags.buchang0==false",
						"condition": "flags.buchang0==false",
						"action": [
							{
								"type": "confirm",
								"text": "确认领取混沌难度补偿吗?\n(回复10000生命,仅一次)",
								"yes": [
									{
										"type": "setValue",
										"name": "status:hp",
										"operator": "+=",
										"value": "10000"
									},
									{
										"type": "setValue",
										"name": "flag:buchang0",
										"value": "true"
									}
								],
								"no": []
							}
						]
					},
					{
						"text": "非酋补偿1",
						"need": "flags.gameTime>=5000&&core.status.hero.atk<16&&core.status.hero.def<16",
						"condition": "flags.gameTime>=5000&&core.status.hero.atk<16&&core.status.hero.def<16&&flags.buchang1==false&&!core.hasItem('sword1')&&!core.hasItem('sword3')&&!core.hasItem('sword5')&&!core.hasItem('shield1')&&!core.hasItem('shield3')&&!core.hasItem('shield5')",
						"action": [
							"你是非酋吗？都过了5000时间了，你怎么还是15攻防！",
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "5000"
							},
							"补偿你5000生命！",
							{
								"type": "setValue",
								"name": "flag:buchang1",
								"value": "true"
							}
						]
					},
					{
						"text": "非酋补偿2",
						"need": "flags.gameTime>=10000&&core.status.hero.atk<16",
						"condition": "flags.gameTime>=10000&&core.status.hero.atk<16&&flags.buchang1==false&&!core.hasItem('sword1')&&!core.hasItem('sword3')&&!core.hasItem('sword5')",
						"action": [
							"你是非酋吗？都过了10000时间了，你怎么还是15攻击！",
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "10000"
							},
							"补偿你10000生命！",
							{
								"type": "setValue",
								"name": "flag:buchang2",
								"value": "true"
							}
						]
					},
					{
						"text": "查看说明",
						"need": "true",
						"action": [
							"在混沌难度下，当且仅当游戏开始时，会随机生成计入存档和录像的一定数量个Seed，这些Seed将用于按一定规则决定本局游戏中的所有“概率”事件。",
							"可以保证的是，对于同一个开局存档(所有Seed相同的存档)，均存在理论上的max，且通过SL不会影响max的值。",
							"需要注意的是，对于每一个不同的开局存档(Seed不完全相同的存档)，游戏的难度均不一致，不一定比秩序难度更难或更容易。",
							"在混沌难度下，金币不再能购买物品，取而代之的是怪物将按一定“概率”掉落物品，同时部分技能效果也改为按一定“概率”触发。",
							"对于“概率”触发的事件，同名事件占用一个触发池，当尝试触发一种事件累计一定次数后，必定会得到固定的触发结果。你可以随时按下 数字键:4 来预览接下来一定长度的触发池。触发池底部行显示的是具有该触发池的怪物。",
							"如: 触发池:掉落E 前五项显示为[空，空，空，红血瓶，空]，那么你按任意顺序击败五个具有 掉落E 属性的怪物，一定会在第四次击败怪物时获得一个红血瓶，且其它几次不获得道具。并且对应触发池向后移动击败怪物数个长度。",
							"如: 触发池:闪避D 前五项显示为[空，空，空，标记，空]，那么你与任意一个拥有 闪避D 属性的怪物战斗时，该怪物就一定会在第四回合闪避你的攻击。并且对应触发池向后移动战斗回合数个长度。",
							"特别的，拥有多个触发池属性的怪物，各个触发池的效果独立计算，可以叠加，若一个怪物在同一回合内触发了两个属性的暴击，将在该回合造成4倍的伤害！",
							"你可以通过与较弱的拥有某属性的怪物战斗来调整接下来的触发池，以减弱较强的拥有相同属性的怪物的伤害！"
						]
					}
				]
			}
		],
		"levelUp": [
			{
				"need": "0",
				"title": "",
				"action": [
					{
						"type": "comment",
						"text": "此处是初始等级，只需填写称号"
					}
				]
			},
			{
				"need": "20",
				"title": "",
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"operator": "+=",
						"value": "10"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"operator": "+=",
						"value": "10"
					}
				]
			},
			{
				"need": "40",
				"title": "",
				"action": [
					{
						"type": "tip",
						"text": "恭喜升级"
					}
				]
			}
		]
	},
	"values": {
		"lavaDamage": 0,
		"poisonDamage": 10,
		"weakValue": 20,
		"redGem": 1,
		"blueGem": 1,
		"greenGem": 3,
		"redPotion": 50,
		"bluePotion": 100,
		"yellowPotion": 250,
		"greenPotion": 800,
		"breakArmor": 0.9,
		"counterAttack": 0.1,
		"purify": 3,
		"hatred": 2,
		"animateSpeed": 300,
		"moveSpeed": 100,
		"statusCanvasRowsOnMobile": 3,
		"floorChangeTime": 100
	},
	"flags": {
		"statusBarItems": [
			"enableFloor",
			"enableHPMax",
			"enableHP",
			"enableAtk",
			"enableDef",
			"enableMDef",
			"enableMoney",
			"enableKeys"
		],
		"extendToolbar": false,
		"flyNearStair": true,
		"flyRecordPosition": false,
		"itemFirstText": false,
		"equipboxButton": false,
		"enableAddPoint": false,
		"enableNegativeDamage": false,
		"betweenAttackMax": false,
		"useLoop": true,
		"startUsingCanvas": false,
		"statusCanvas": true,
		"enableEnemyPoint": true,
		"enableGentleClick": true,
		"ignoreChangeFloor": true,
		"canGoDeadZone": false,
		"enableMoveDirectly": true,
		"enableRouteFolding": true,
		"disableShopOnDamage": true,
		"blurFg": false
	}
}