var data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d = 
{
	"main": {
		"floorIds": [
			"MT1",
			"MT2",
			"MT3",
			"MT4",
			"MT5",
			"MT6",
			"MT7",
			"MT8",
			"EX"
		],
		"floorPartitions": [],
		"images": [
			"bear.png",
			"bg.jpg",
			"brave.png",
			"dragon.png",
			"egg.png",
			"egg2.png",
			"egg3.png",
			"hero.png",
			"winskin.png"
		],
		"tilesets": [
			"magictower.png"
		],
		"animates": [
			"hand",
			"jianji",
			"jump",
			"recover",
			"sword",
			"thunder",
			"yongchang",
			"zone"
		],
		"bgms": [
			"bgm.mp3"
		],
		"sounds": [
			"attack.mp3",
			"bomb.mp3",
			"cancel.mp3",
			"centerFly.mp3",
			"coin.mp3",
			"confirm.mp3",
			"cursor.mp3",
			"door.mp3",
			"dropkey.mp3",
			"equip.mp3",
			"error.mp3",
			"floor.mp3",
			"gem.mp3",
			"icePickaxe.mp3",
			"item.mp3",
			"jump.mp3",
			"kaijia.mp3",
			"load.mp3",
			"open_ui.mp3",
			"pickaxe.mp3",
			"recovery.mp3",
			"save.mp3",
			"shop.mp3",
			"water.mp3",
			"xuewang.ogg",
			"zone.mp3"
		],
		"fonts": [
			"Verdana",
			"number"
		],
		"nameMap": {
			"确定": "confirm.mp3",
			"取消": "cancel.mp3",
			"操作失败": "error.mp3",
			"光标移动": "cursor.mp3",
			"打开界面": "open_ui.mp3",
			"读档": "load.mp3",
			"存档": "save.mp3",
			"获得道具": "item.mp3",
			"回血": "recovery.mp3",
			"炸弹": "bomb.mp3",
			"飞行器": "centerFly.mp3",
			"开关门": "door.mp3",
			"上下楼": "floor.mp3",
			"跳跃": "jump.mp3",
			"破墙镐": "pickaxe.mp3",
			"破冰镐": "icePickaxe.mp3",
			"宝石": "gem.mp3",
			"阻激夹域": "zone.mp3",
			"穿脱装备": "equip.mp3",
			"背景音乐": "bgm.mp3",
			"攻击": "attack.mp3",
			"背景图": "bg.jpg",
			"商店": "shop.mp3",
			"领域": "zone"
		},
		"levelChoose": null,
		"equipName": [
			"武器",
			"盾牌"
		],
		"startBgm": "bgm.mp3",
		"styles": {
			"startBackground": "project/images/bg.jpg",
			"startVerticalBackground": "project/images/bg.jpg",
			"startLogoStyle": "display:none",
			"startButtonsStyle": "background-color: #32369F; opacity: 0.85; color: #FFFFFF; border: #FFFFFF 2px solid; caret-color: #FFD700;",
			"statusLeftBackground": "url(project/images/egg.png) 0/100% no-repeat",
			"statusTopBackground": "url(project/images/egg2.png) 0/100% repeat",
			"toolsBackground": "url(project/images/egg3.png) 0/100% repeat",
			"floorChangingStyle": "background-color: black; color: white",
			"statusBarColor": [
				255,
				255,
				255,
				1
			],
			"borderColor": [
				204,
				204,
				204,
				1
			],
			"selectColor": [
				255,
				215,
				0,
				1
			],
			"font": "Verdana"
		},
		"splitImages": [
			{
				"name": "dragon.png",
				"width": 384,
				"height": 96,
				"prefix": "dragon_"
			}
		]
	},
	"firstData": {
		"title": "敲可爱3",
		"name": "KnockTower3",
		"version": "KnockTower3",
		"floorId": "MT1",
		"hero": {
			"image": "brave.png",
			"animate": true,
			"name": "勇者",
			"lv": 1,
			"hpmax": 99999999,
			"hp": 1000,
			"manamax": null,
			"mana": null,
			"atk": 10,
			"def": 10,
			"mdef": 0,
			"money": 0,
			"exp": 0,
			"equipment": [],
			"items": {
				"constants": {},
				"tools": {},
				"equips": {}
			},
			"loc": {
				"direction": "up",
				"x": 6,
				"y": 11
			},
			"flags": {},
			"followers": [],
			"steps": 0
		},
		"startCanvas": [
			{
				"type": "comment",
				"text": "在这里可以用事件来自定义绘制标题界面的背景图等"
			},
			{
				"type": "comment",
				"text": "也可以直接切换到其他楼层（比如某个开始剧情楼层）进行操作。"
			},
			{
				"type": "previewUI",
				"action": [
					{
						"type": "fillRect",
						"x": 0,
						"y": 0,
						"width": "core.__PIXELS__",
						"height": "core.__PIXELS__",
						"style": [
							82,
							82,
							82,
							1
						]
					},
					{
						"type": "setAttribute",
						"align": "center"
					},
					{
						"type": "fillBoldText",
						"x": "core.__PIXELS__ / 2",
						"y": 80,
						"style": [
							255,
							255,
							255,
							1
						],
						"strokeStyle": [
							0,
							0,
							0,
							1
						],
						"font": "bold 40px Verdana",
						"text": "${core.firstData.title}"
					}
				]
			},
			{
				"type": "setValue",
				"name": "flag:selection",
				"value": "0"
			},
			{
				"type": "comment",
				"text": "在右下方自绘一个对话框进行显示选择项"
			},
			{
				"type": "previewUI",
				"action": [
					{
						"type": "fillRect",
						"x": 230,
						"y": 250,
						"width": 150,
						"height": 142,
						"radius": 10,
						"style": [
							50,
							54,
							159,
							0.85
						]
					},
					{
						"type": "strokeRect",
						"x": 230,
						"y": 250,
						"width": 150,
						"height": 142,
						"radius": 10,
						"style": [
							255,
							255,
							255,
							1
						],
						"lineWidth": 2
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 290,
						"style": [
							255,
							255,
							255,
							1
						],
						"font": "bold 25px Verdana",
						"text": "开始游戏"
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 330,
						"font": "bold 25px Verdana",
						"text": "读取存档"
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 370,
						"font": "bold 25px Verdana",
						"text": "回放录像"
					}
				]
			},
			{
				"type": "while",
				"condition": "1",
				"data": [
					{
						"type": "drawSelector",
						"image": "winskin.png",
						"code": 1,
						"x": 245,
						"y": "261 + 40*flag:selection",
						"width": 120,
						"height": 40
					},
					{
						"type": "wait",
						"data": [
							{
								"case": "keyboard",
								"keycode": "13,32",
								"break": true,
								"action": [
									{
										"type": "switch",
										"condition": "flag:selection",
										"caseList": [
											{
												"case": "0",
												"action": [
													{
														"type": "comment",
														"text": "在“开始游戏”确定"
													},
													{
														"type": "break",
														"n": 1
													}
												]
											},
											{
												"case": "1",
												"action": [
													{
														"type": "comment",
														"text": "在“读取存档”确定"
													},
													{
														"type": "callLoad"
													}
												]
											},
											{
												"case": "2",
												"action": [
													{
														"type": "comment",
														"text": "在“回放录像”确定"
													},
													{
														"type": "if",
														"condition": "(!core.isReplaying())",
														"true": [
															{
																"type": "function",
																"function": "function(){\ncore.chooseReplayFile()\n}"
															}
														]
													}
												]
											}
										]
									}
								]
							},
							{
								"case": "keyboard",
								"keycode": "38",
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "光标上键"
									},
									{
										"type": "setValue",
										"name": "flag:selection",
										"value": "(flag:selection + 2) % 3"
									}
								]
							},
							{
								"case": "keyboard",
								"keycode": "40",
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "光标下键"
									},
									{
										"type": "setValue",
										"name": "flag:selection",
										"value": "(flag:selection + 1) % 3"
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									261,
									300
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“开始游戏”"
									},
									{
										"type": "break",
										"n": 1
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									301,
									340
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“读取存档”"
									},
									{
										"type": "callLoad"
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									341,
									380
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“播放录像”"
									},
									{
										"type": "if",
										"condition": "(!core.isReplaying())",
										"true": [
											{
												"type": "function",
												"function": "function(){\ncore.chooseReplayFile()\n}"
											}
										]
									}
								]
							}
						]
					}
				]
			},
			{
				"type": "setValue",
				"name": "flag:selection",
				"value": "null"
			},
			{
				"type": "drawSelector",
				"code": 1
			},
			{
				"type": "clearMap"
			},
			{
				"type": "function",
				"function": "function(){\ncore.control.checkBgm()\n}"
			},
			{
				"type": "if",
				"condition": "(main.levelChoose.length == 0)",
				"true": [
					{
						"type": "comment",
						"text": "没有难度选择：直接开始游戏"
					}
				],
				"false": [
					{
						"type": "comment",
						"text": "难度选择：作为样例，这里只提供了一个显示选择项。"
					},
					{
						"type": "function",
						"function": "function(){\nvar choices = [];\nmain.levelChoose.forEach(function (one) {\n\tchoices.push({\n\t\t\"text\": one.title || '',\n\t\t\"action\": [\n\t\t\t{ \"type\": \"function\", \"function\": \"function() { core.status.hard = '\" + (one.name || '') + \"'; }\" }\n\t\t]\n\t});\n})\ncore.insertAction({ \"type\": \"choices\", \"choices\": choices });\n}"
					},
					{
						"type": "comment",
						"text": "你也可以仿照上面的样例进行自己创建等待用户操作来处理不同的难度分歧。\n如需自己处理，请设置 core.status.hard \n（例如，自定义js脚本：core.status.hard = 'Easy' ）"
					}
				]
			},
			{
				"type": "clearMap"
			},
			{
				"type": "comment",
				"text": "接下来会执行startText中的事件"
			},
			{
				"type": "comment",
				"text": "状态栏默认处于隐藏状态；可以使用“显示状态栏”事件进行显示。"
			}
		],
		"startText": [
			{
				"type": "playBgm",
				"name": "bgm.mp3",
				"keep": true
			},
			{
				"type": "setValue",
				"name": "flag:itemDetail",
				"value": "true"
			},
			{
				"type": "setValue",
				"name": "flag:shop1",
				"value": "0"
			},
			{
				"type": "setValue",
				"name": "item:book",
				"value": "1"
			},
			{
				"type": "setValue",
				"name": "flag:gongji",
				"value": "0"
			},
			{
				"type": "setValue",
				"name": "flag:fangyu",
				"value": "0"
			},
			{
				"type": "setValue",
				"name": "flag:hudun",
				"value": "0"
			},
			{
				"type": "setValue",
				"name": "flag:chuizi",
				"value": "0"
			},
			{
				"type": "setValue",
				"name": "flag:层",
				"value": "0"
			},
			{
				"type": "setValue",
				"name": "flag:inshop",
				"value": "0"
			}
		],
		"shops": [
			{
				"id": "shop1",
				"text": "\t[金币商店,moneyShop]欢迎光临商店！\n\r[red]<金币购买后价格提升3点>",
				"textInList": "金币商店",
				"mustEnable": false,
				"disablePreview": false,
				"choices": [
					{
						"text": "攻击+2（-${7+3*flag:shop1}金币）",
						"need": "status:money>=(7+3*flag:shop1)",
						"icon": "T451",
						"color": [
							255,
							85,
							85
						],
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "7+3*flag:shop1"
							},
							{
								"type": "setValue",
								"name": "status:atk",
								"operator": "+=",
								"value": "2"
							},
							{
								"type": "setValue",
								"name": "flag:shop1",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "flag:gongji",
								"operator": "+=",
								"value": "1"
							}
						]
					},
					{
						"text": "防御+2（-${7+3*flag:shop1}金币）",
						"need": "status:money>=(7+3*flag:shop1)",
						"icon": "T452",
						"color": [
							69,
							209,
							224
						],
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "7+3*flag:shop1"
							},
							{
								"type": "setValue",
								"name": "status:def",
								"operator": "+=",
								"value": "2"
							},
							{
								"type": "setValue",
								"name": "flag:shop1",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "flag:fangyu",
								"operator": "+=",
								"value": "1"
							}
						]
					},
					{
						"text": "护盾+12（-${7+3*flag:shop1}金币）",
						"need": "status:money>=(7+3*flag:shop1)",
						"icon": "T453",
						"color": [
							69,
							224,
							146
						],
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "7+3*flag:shop1"
							},
							{
								"type": "setValue",
								"name": "status:mdef",
								"operator": "+=",
								"value": "12"
							},
							{
								"type": "setValue",
								"name": "flag:shop1",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "flag:hudun",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "function",
								"function": "function(){\nfor (let i = 0; i <= 12; i++) { \t\t\t\tfor (let j = 0; j <= 12; j++) { \t\t\t\t\tlet id = core.getBlockId(i, j); \t\t\t\t\tif (id && id.endsWith('Potion')) { \t\t\t\t\t\tcore.drawAnimate('jump', i, j); \t\t\t\t\t} \t\t\t\t} \t\t\t}\n}"
							}
						]
					},
					{
						"text": "锤子+2（-${7+3*flag:shop1}金币）",
						"need": "status:money>=(7+3*flag:shop1)",
						"icon": "bomb",
						"color": [
							255,
							206,
							123
						],
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "7+3*flag:shop1"
							},
							{
								"type": "setValue",
								"name": "item:bomb",
								"operator": "+=",
								"value": "2"
							},
							{
								"type": "setValue",
								"name": "flag:shop1",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "flag:chuizi",
								"operator": "+=",
								"value": "1"
							}
						]
					},
					{
						"text": "蓝钥匙+1（-2黄钥匙）",
						"need": "item:yellowKey>=2",
						"icon": "blueKey",
						"color": [
							170,
							170,
							221
						],
						"action": [
							{
								"type": "setValue",
								"name": "item:yellowKey",
								"operator": "-=",
								"value": "2"
							},
							{
								"type": "setValue",
								"name": "item:blueKey",
								"operator": "+=",
								"value": "1"
							}
						]
					}
				]
			}
		],
		"levelUp": null
	},
	"values": {
		"lavaDamage": 35,
		"poisonDamage": 10,
		"weakValue": 20,
		"redGem": 1,
		"blueGem": 1,
		"greenGem": 3,
		"redPotion": 40,
		"bluePotion": 100,
		"yellowPotion": 800,
		"greenPotion": 300,
		"breakArmor": 0.9,
		"counterAttack": 0.1,
		"purify": 0.5,
		"hatred": 60,
		"animateSpeed": 300,
		"moveSpeed": 110,
		"statusCanvasRowsOnMobile": 3,
		"floorChangeTime": 0
	},
	"flags": {
		"statusBarItems": [
			"enableName",
			"enableHP",
			"enableAtk",
			"enableDef",
			"enableMDef",
			"enableMoney",
			"enableKeys",
			"enablePZF"
		],
		"autoScale": true,
		"extendToolbar": false,
		"flyNearStair": false,
		"flyRecordPosition": false,
		"itemFirstText": false,
		"equipboxButton": false,
		"enableAddPoint": false,
		"enableNegativeDamage": false,
		"betweenAttackMax": false,
		"useLoop": false,
		"startUsingCanvas": false,
		"statusCanvas": true,
		"enableEnemyPoint": true,
		"enableGentleClick": true,
		"ignoreChangeFloor": true,
		"canGoDeadZone": false,
		"enableMoveDirectly": true,
		"enableRouteFolding": true,
		"disableShopOnDamage": false,
		"blurFg": false,
		"hideLeftStatusBar": null
	}
}