var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。

	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作，比如切分图片等。

		// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
		// var arr = core.splitImage("assets.png", 32, 32);
		// for (var i = 0; i < arr.length; i++) {
		//     core.material.images.images["asset"+i+".png"] = arr[i];
		// }

	}
	this.checkEmptyEnemy = function(){
		var blks = core.status.thisMap.blocks.filter(function(it){return it.event.cls == 'enemys'});
		var nextFloor = core.floorIds[core.floorIds.indexOf(core.status.floorId)+1];
		if(blks.length==0 && nextFloor)core.insertAction([
			{"type": "changeFloor", "floorId": nextFloor, "loc": [7,13], "time": 500 },
		  ]);
	}

	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
},

	"dljgs1_light":function(){
		////// rewrite //////
		var origin_drawFg = core.maps.drawFg;
		core.maps.drawFg = function (floorId, ctx) {
			origin_drawFg.call(core.maps,floorId,ctx);
			ctx = ctx || core.canvas.fg;
			core.renderLight(ctx, floorId);
		}

		this.initLight = function(){
		}
		// 工具
		this.genMap = function(val){
			var m = [];
			for(var x =0;x<core.__SIZE__;x++){
				m[x] = [];
				for(var y = 0;y < core.__SIZE__;y++){
					m[x][y] = val;
				}
			}
			return m;
		}
		
		this.myDrawLine = function (ctx, x1, y1, x2, y2, style, lineWidth) {
			if (style) ctx.strokeStyle = style;
			if (lineWidth != null)ctx.lineWidth=lineWidth;
			ctx.beginPath();
			ctx.moveTo(x1, y1);
			ctx.lineTo(x2, y2);
			ctx.stroke();
		}


		// 模拟照射
		var shine = function(s, tmap, procfun){
			var dir_change_left = ['left', 'down', 'up', 'right'];
			var dir_change_right = ['right', 'left', 'up', 'down'];
			var odir = s.dir;
			var ox = s.x, oy = s.y, ocolor = s.color;
			var x = s.x, y = s.y;
			tmap[x][y] = 'source';
			var stop = false;
			do{
				x += core.utils.scan[s.dir].x;
				y += core.utils.scan[s.dir].y;
				if(x>=0 && x<core.__SIZE__ && y>=0 && y<core.__SIZE__)
				switch(tmap[x][y]){
					case 'source':stop=true;break;
					case 'left': 
						s.dir = dir_change_left[(dir_change_left.indexOf(s.dir)+2)%4];break;
					case 'right':
						s.dir = dir_change_right[(dir_change_right.indexOf(s.dir)+2)%4];break;
					default:
						if(procfun)procfun(x,y);
				}
			}while(!stop && x>0 && x<core.__SIZE__-1 && y>0 && y<core.__SIZE__-1);
			s.x = ox; s.y = oy; s.color = ocolor; s.dir = odir;
		}

		// 更新光照数据
		this.updateLightMap = function(floorId){
			floorId = floorId || core.status.floorId;
			var sL = core.getFlag("sourceLight",{})[floorId] || [];
			var mirror = core.getFlag("mirror_list",{})[floorId] || [];
			var tmap = core.genMap(0);
			mirror.forEach(function(m){
				tmap[m.x][m.y] = m.dir;
			});
			var cross_pts = {};
			// 定光源：
			sL.forEach(function(s){
				tmap[s.x][s.y] = 'source';
			})
			// 预照射:
			sL.forEach(function(s){
				shine(s, tmap, function(x,y){
					var idx = x+','+y;
					cross_pts[idx] = cross_pts[idx]||0;
					cross_pts[idx] |= (s.color | tmap[x][y]);
					tmap[x][y] |= s.color;
				});
			});
			function checkCross(pos){
				var x = parseInt(pos[0]), y = parseInt(pos[1]);
				var x1 = Math.max(0,x-1), y1 = y;
				var x2 = Math.min(core.__SIZE__-1,x+1), y2 = y;
				var x3 = x, y3 = Math.max(0,y-1);
				var x4 = x, y4 = Math.min(core.__SIZE__-1,y+1);
				return tmap[x1][y1] && tmap[x2][y2] && tmap[x3][y3] && tmap[x4][y4];
			}
			for(var p in cross_pts){
				var pos = p.split(',');
				if(!checkCross(pos)){
					delete cross_pts[p];
				}
			}
			// 二次照射，确定交叉——注意 对射、同射不属于交叉 需要从cp排除
			var cross_dirs = {};
			var dir_change_cross = ['left', 'up', 'right', 'down'];
			sL.forEach(function(s){
				shine(s, tmap, function(x,y){
					var idx = x+','+y;
					if(cross_pts[idx]){
						if(cross_dirs[idx]){
							var dis = dir_change_cross.indexOf(cross_dirs[idx]) - dir_change_cross.indexOf(s.dir);
							if(Math.abs(dis)==2){//属于对射
								delete cross_pts[idx];
							}
						}
						cross_dirs[idx] = s.dir;
						s.color |= cross_pts[idx];
						cross_pts[idx] |= s.color;
					}
					tmap[x][y] |= s.color;
					s.color |= tmap[x][y];
				});
			});

			// 三次照射 彻底确定光路
			sL.forEach(function(s){
				shine(s, tmap, function(x,y){
					tmap[x][y] |= s.color;
					s.color |= tmap[x][y];
				});
			})
			core.getFlag("light_map")[core.status.floorId]=tmap;
			core.getFlag('cross_pts')[floorId] = cross_pts;
		}

		// 实际照射渲染
		var code2color = function(code){
			return "#"+((code & 1)?"FF":"00") + ((code & 2)?"FF":"00") + ((code & 4)?"FF":"00");
		}
		this.renderLight = function(ctx, floorId){
			floorId = floorId || core.status.floorId;
			var sL = core.getFlag("sourceLight",{})[floorId] || [];
			var tmap = core.getFlag("light_map",{})[floorId] || [];
			var cp = core.getFlag('cross_pts',{})[floorId] || [];
			sL.forEach(function(s){
				var dx = core.utils.scan[s.dir].x, dy = core.utils.scan[s.dir].y;
				core.myDrawLine(ctx, s.x*32+16, s.y*32+16, s.x*32+16+32*dx, s.y*32+16+32*dy, code2color(s.color, 2));
				shine(s, tmap, function(x,y){
					var dx = core.utils.scan[s.dir].x, dy = core.utils.scan[s.dir].y;
					var prex = x - dx, prey = y - dy;
					var nxtx = x + dx, nxty = y + dy;
					if(cp[x+','+y]){
						core.myDrawLine(ctx, x*32+16, y*32+16, x*32+16+16*dx, y*32+16+16*dy, code2color(tmap[x][y]), 2);
						core.myDrawLine(ctx, x*32+16-16*dx, y*32+16-16*dy, x*32+16, y*32+16, code2color(s.color), 2);
					}else
					core.myDrawLine(ctx, prex*32+16, prey*32+16, nxtx*32+16, nxty*32+16, code2color(tmap[x][y]), 2);
					s.color = tmap[x][y];
				});
			});
		}


		// 添加
		this.addSourceLight = function(x,y,n,color,dir){
			var num = n + dir;
			core.insertAction({ "type": "setBgFgBlock", "name": "bg", "number": "I" + num, "loc": [x, y] });
			var sL = core.getFlag("sourceLight");
			sL[core.status.floorId] = sL[core.status.floorId] || [];
			var dir_list = ['up', 'right', 'down', 'left'];
			sL[core.status.floorId].push({ x: x, y: y, color: color, dir: dir_list[dir]});
			core.updateLightMap();
			core.drawMap();
		}

		this.addMirror = function(x,y,dir){
			var mirror = core.getFlag("mirror_list");
			mirror[core.status.floorId] = mirror[core.status.floorId] || [];
			mirror[core.status.floorId].push({'x':x,'y':y,'dir':dir});
			core.setFlag("mirror_list",mirror);
			core.updateLightMap();
			core.drawMap();
		}

		// 判断当前所在光色 1 red 2 green 4 blue
		this.getCurrentColor = function(x, y){
			if(!core.isset(x))x = core.getHeroLoc('x');
			if(!core.isset(y))y = core.getHeroLoc('y');
			var tmap = core.getFlag('light_map')[core.status.floorId];
			if(tmap && tmap[x])
				return tmap[x][y];
			return null;
		}
		this.initLight();
},

}