main.floors.MT1=
{
    "floorId": "MT1",
    "title": "魔塔 第01层",
    "name": "第 1 层",
    "width": 13,
    "height": 13,
    "map": [
    [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1],
    [  1, 87,  0,201,202,201,  0,  0,  0,  0,  0,  0,  1],
    [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  1],
    [  1, 31,  0,  0, 81,  0,  1, 27, 21,  0,  1,  0,  1],
    [  1,  0,209,  0,  1,  0,  1, 28, 31,  0,  1,  0,  1],
    [  1,  1, 81,  1,  1,  0,  1,  1,  1, 81,  1,  0,  1],
    [  1, 21,  0,  0,  1,  0, 81,205,217,205,  1,  0,  1],
    [  1,  0,210,  0,  1,  0,  1,  1,  1,  1,  1,  0,  1],
    [  1,  1, 81,  1,  1,  0,  0,  0,  0,  0,  0,  0,  1],
    [  1,  0,  0,  0,  1,  1, 86,  1,  1,  1, 81,  1,  1],
    [  1, 31,  0, 21,  1, 25, 73,127,  1,  0,205,  0,  1],
    [  1, 31,  0, 21,  1, 46,  0, 45,  1,201, 32,201,  1],
    [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1]
],
    "canFlyTo": true,
    "canFlyFrom": true,
    "canUseQuickShop": true,
    "images": [],
    "ratio": 1,
    "defaultGround": "ground",
    "bgm": "section1.mp3",
    "firstArrive": [
        {
            "type": "tip",
            "text": "游戏已重启"
        },
        {
            "type": "loadBgm",
            "name": "Ending.mp3"
        },
        {
            "type": "loadBgm",
            "name": "SkeletonA.mp3"
        },
        {
            "type": "loadBgm",
            "name": "Vampire.mp3"
        },
        {
            "type": "loadBgm",
            "name": "GreatMagicMaster.mp3"
        },
        {
            "type": "loadBgm",
            "name": "Knight.mp3"
        },
        {
            "type": "loadBgm",
            "name": "Zeno.mp3"
        },
        {
            "type": "setValue",
            "name": "flag:调试模式",
            "value": "false"
        },
        {
            "type": "setValue",
            "name": "flag:小游戏开关",
            "value": "false"
        },
        {
            "type": "setValue",
            "name": "flag:道具存档",
            "value": "true"
        },
        {
            "type": "choices",
            "text": "\t[作者,oldMan]选择难度",
            "choices": [
                {
                    "text": "有三区",
                    "action": [
                        {
                            "type": "setValue",
                            "name": "flag:难度",
                            "value": "1"
                        }
                    ]
                },
                {
                    "text": "无三区",
                    "action": [
                        {
                            "type": "setValue",
                            "name": "flag:难度",
                            "value": "2"
                        }
                    ]
                }
            ]
        },
        {
            "type": "choices",
            "text": "\t[作者,oldMan]选择模式",
            "choices": [
                {
                    "text": "宝石升区",
                    "action": [
                        {
                            "type": "setValue",
                            "name": "flag:模式",
                            "value": "1"
                        }
                    ]
                },
                {
                    "text": "血瓶升区",
                    "action": [
                        {
                            "type": "setValue",
                            "name": "flag:模式",
                            "value": "2"
                        }
                    ]
                },
                {
                    "text": "剑盾升区",
                    "action": [
                        {
                            "type": "setBlock",
                            "number": "sword1",
                            "loc": [
                                [
                                    2,
                                    2
                                ]
                            ],
                            "floorId": "MT17"
                        },
                        {
                            "type": "setBlock",
                            "number": "sword1",
                            "loc": [
                                [
                                    10,
                                    10
                                ]
                            ],
                            "floorId": "MT33"
                        },
                        {
                            "type": "setBlock",
                            "number": "sword1",
                            "loc": [
                                [
                                    8,
                                    10
                                ]
                            ],
                            "floorId": "MT48"
                        },
                        {
                            "type": "setBlock",
                            "number": "shield1",
                            "loc": [
                                [
                                    2,
                                    2
                                ]
                            ],
                            "floorId": "MT11"
                        },
                        {
                            "type": "setBlock",
                            "number": "shield1",
                            "loc": [
                                [
                                    2,
                                    7
                                ]
                            ],
                            "floorId": "MT38"
                        },
                        {
                            "type": "setBlock",
                            "number": "shield1",
                            "loc": [
                                [
                                    9,
                                    4
                                ]
                            ],
                            "floorId": "MT43"
                        },
                        {
                            "type": "setValue",
                            "name": "flag:模式",
                            "value": "3"
                        }
                    ]
                },
                {
                    "text": "宝石血瓶升区",
                    "action": [
                        {
                            "type": "setValue",
                            "name": "flag:模式",
                            "value": "4"
                        }
                    ]
                },
                {
                    "text": "宝石剑盾血瓶升区",
                    "action": [
                        {
                            "type": "setBlock",
                            "number": "sword1",
                            "loc": [
                                [
                                    2,
                                    2
                                ]
                            ],
                            "floorId": "MT17"
                        },
                        {
                            "type": "setBlock",
                            "number": "sword1",
                            "loc": [
                                [
                                    10,
                                    10
                                ]
                            ],
                            "floorId": "MT33"
                        },
                        {
                            "type": "setBlock",
                            "number": "sword1",
                            "loc": [
                                [
                                    8,
                                    10
                                ]
                            ],
                            "floorId": "MT48"
                        },
                        {
                            "type": "setBlock",
                            "number": "shield1",
                            "loc": [
                                [
                                    2,
                                    2
                                ]
                            ],
                            "floorId": "MT11"
                        },
                        {
                            "type": "setBlock",
                            "number": "shield1",
                            "loc": [
                                [
                                    2,
                                    7
                                ]
                            ],
                            "floorId": "MT38"
                        },
                        {
                            "type": "setBlock",
                            "number": "shield1",
                            "loc": [
                                [
                                    9,
                                    4
                                ]
                            ],
                            "floorId": "MT43"
                        },
                        {
                            "type": "setValue",
                            "name": "flag:模式",
                            "value": "5"
                        }
                    ]
                },
                {
                    "text": "（新增）宝石剑盾升区",
                    "action": [
                        {
                            "type": "setBlock",
                            "number": "sword1",
                            "loc": [
                                [
                                    2,
                                    2
                                ]
                            ],
                            "floorId": "MT17"
                        },
                        {
                            "type": "setBlock",
                            "number": "sword1",
                            "loc": [
                                [
                                    10,
                                    10
                                ]
                            ],
                            "floorId": "MT33"
                        },
                        {
                            "type": "setBlock",
                            "number": "sword1",
                            "loc": [
                                [
                                    8,
                                    10
                                ]
                            ],
                            "floorId": "MT48"
                        },
                        {
                            "type": "setBlock",
                            "number": "shield1",
                            "loc": [
                                [
                                    2,
                                    2
                                ]
                            ],
                            "floorId": "MT11"
                        },
                        {
                            "type": "setBlock",
                            "number": "shield1",
                            "loc": [
                                [
                                    2,
                                    7
                                ]
                            ],
                            "floorId": "MT38"
                        },
                        {
                            "type": "setBlock",
                            "number": "shield1",
                            "loc": [
                                [
                                    9,
                                    4
                                ]
                            ],
                            "floorId": "MT43"
                        },
                        {
                            "type": "setValue",
                            "name": "flag:模式",
                            "value": "6"
                        }
                    ]
                },
                {
                    "text": "（新增）血瓶剑盾升区",
                    "action": [
                        {
                            "type": "setBlock",
                            "number": "sword1",
                            "loc": [
                                [
                                    2,
                                    2
                                ]
                            ],
                            "floorId": "MT17"
                        },
                        {
                            "type": "setBlock",
                            "number": "sword1",
                            "loc": [
                                [
                                    10,
                                    10
                                ]
                            ],
                            "floorId": "MT33"
                        },
                        {
                            "type": "setBlock",
                            "number": "sword1",
                            "loc": [
                                [
                                    8,
                                    10
                                ]
                            ],
                            "floorId": "MT48"
                        },
                        {
                            "type": "setBlock",
                            "number": "shield1",
                            "loc": [
                                [
                                    2,
                                    2
                                ]
                            ],
                            "floorId": "MT11"
                        },
                        {
                            "type": "setBlock",
                            "number": "shield1",
                            "loc": [
                                [
                                    2,
                                    7
                                ]
                            ],
                            "floorId": "MT38"
                        },
                        {
                            "type": "setBlock",
                            "number": "shield1",
                            "loc": [
                                [
                                    9,
                                    4
                                ]
                            ],
                            "floorId": "MT43"
                        },
                        {
                            "type": "setValue",
                            "name": "flag:模式",
                            "value": "7"
                        }
                    ]
                }
            ]
        },
        {
            "type": "function",
            "function": "function(){\nconst mode = core.getFlag('模式', 1);\n\n// 构造筛选器：只返回“符合模式的物品”\nconst filter = function (block) {\n\tif (!block.event || block.event.cls !== 'items') return false;\n\n\tconst itemId = block.event.id;\n\n\tswitch (mode) {\n\tcase 1:\n\t\treturn itemId.endsWith('Gem');\n\tcase 2:\n\t\treturn itemId.endsWith('Potion');\n\tcase 3:\n\t\treturn itemId === 'sword1' || itemId === 'shield1';\n\tcase 4:\n\t\treturn itemId.endsWith('Gem') || itemId.endsWith('Potion');\n\tcase 5:\n\t\treturn (\n\t\t\titemId === 'sword1' || itemId === 'shield1' ||\n\t\t\titemId.endsWith('Gem') || itemId.endsWith('Potion')\n\t\t);\n\tcase 6:\n\t\treturn itemId.endsWith('Gem') || itemId === 'sword1' || itemId === 'shield1';\n\tcase 7:\n\t\treturn itemId.endsWith('Potion') || itemId === 'sword1' || itemId === 'shield1';\n\t}\n\treturn false;\n};\n\n// 遍历所有楼层\nfor (const floorId of core.floorIds) {\n\n\t// 搜索该层所有符合模式的物品\n\tconst items = core.searchBlockWithFilter(filter, floorId);\n\tif (!items || items.length === 0) continue;\n\n\t// 找目标层\n\tlet targetFloorIndex = core.floorIds.indexOf(floorId) + 10;\n\n\tif (core.getFlag('难度', 1) > 1) {\n\t\tif (targetFloorIndex >= 21 && targetFloorIndex <= 30) targetFloorIndex += 10;\n\t}\n\n\tconst targetFloor = core.floorIds[targetFloorIndex];\n\tif (!targetFloor) continue;\n\tif (targetFloor === 'MT50') continue;\n\n\n\t// 逐个复制到对应位置（仅处理目标为空的）\n\tfor (const info of items) {\n\t\tconst itemId = info.block.event.id;\n\t\tconst x = info.x;\n\t\tconst y = info.y;\n\n\t\tconst targetBlock = core.getBlock(x, y, targetFloor, true);\n\t\tif (targetBlock && targetBlock.event && targetBlock.event.data) continue;\n\n\t\tcore.setBlock(itemId, x, y, targetFloor);\n\t}\n}\n}"
        }
    ],
    "eachArrive": [],
    "parallelDo": "",
    "events": {
        "7,10": [
            "\t[作者,oldMan]选定的项将不再有区域倍率加成，取而代之的是在后续的+10层，+20层……的相同位置复制一个",
            "\t[作者,oldMan]例如你选择了宝石升区时，在1层(7, 3)的红宝石，会在11层，21层，31层，41层的(7, 3)生成一个红宝石。但是这些红宝石的效果均为1。",
            "\t[作者,oldMan]boss战的战利品也会以相同方式生成"
        ]
    },
    "changeFloor": {
        "1,1": {
            "floorId": ":next",
            "stair": "downFloor",
            "time": 0
        }
    },
    "afterBattle": {},
    "afterGetItem": {},
    "afterOpenDoor": {
        "6,9": [
            "修改较多，放在样板简介里面了！就是工具栏那个长得像卷轴一样的东西"
        ]
    },
    "cannotMove": {},
    "bgmap": [
    [ 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17]
],
    "fgmap": [

],
    "upFloor": [
        2,
        1
    ],
    "downFloor": [
        6,
        11
    ],
    "autoEvent": {},
    "beforeBattle": {},
    "cannotMoveIn": {}
}