import os
import re

def modify_ratio_number(match):
    """
    这是一个替换函数，用于 "ratio"。
    它接收一个匹配对象，提取其中的数字，减去1，然后重新构建字符串。
    """
    # group(1) 捕获了 '"ratio"\s*:\s*' 这部分
    prefix = match.group(1)
    # group(2) 捕获了数字部分
    number_string = match.group(2)
    
    original_number = int(number_string)
    # 根据要求，将 ratio 的值减 1
    new_number = original_number - 1
    
    return f"{prefix}{new_number}"

def process_files():
    """
    主函数，用于遍历、读取、修改和保存文件。
    """
    # 定义要匹配 "ratio" 的正则表达式
    # ("ratio"\s*:\s*) - 捕获 "ratio" 和冒号，以及它们之间的空格
    # (\d+)             - 捕获一个或多个数字
    pattern_ratio = re.compile(r'("ratio"\s*:\s*)(\d+)')

    # 循环处理从 MT21.js 到 MT39.js 的文件
    for i in range(21, 40):
        filename = f"MT{i}.js"
        
        # 检查文件是否存在
        if not os.path.exists(filename):
            print(f"文件 {filename} 不存在，已跳过。")
            continue

        try:
            # 读取文件内容
            print(f"正在处理文件: {filename}...")
            with open(filename, 'r', encoding='utf-8') as f:
                content = f.read()

            # 修改 "ratio" 的值
            new_content, count = pattern_ratio.subn(modify_ratio_number, content)

            if count > 0:
                # 如果有内容被修改，则写回文件
                with open(filename, 'w', encoding='utf-8') as f:
                    f.write(new_content)

                print(f"处理完成！在 {filename} 中共修改了 {count} 处 'ratio'。")
            else:
                print(f"在 {filename} 中未找到需要修改的 'ratio'。")

        except Exception as e:
            print(f"处理文件 {filename} 时发生错误: {e}")

# --- 脚本入口 ---
if __name__ == "__main__":
    process_files()
    print("\n所有文件处理完毕。")

