var events_c12a15a8_c380_4b28_8144_256cba95f760 = 
{
	"commonEvent": {
		"加点事件": [
			{
				"type": "comment",
				"text": "通过传参，flag:arg1 表示当前应该的加点数值"
			},
			{
				"type": "choices",
				"choices": [
					{
						"text": "攻击+${1*flag:arg1}",
						"action": [
							{
								"type": "setValue",
								"name": "status:atk",
								"operator": "+=",
								"value": "1*flag:arg1"
							}
						]
					},
					{
						"text": "防御+${2*flag:arg1}",
						"action": [
							{
								"type": "setValue",
								"name": "status:def",
								"operator": "+=",
								"value": "2*flag:arg1"
							}
						]
					},
					{
						"text": "生命+${200*flag:arg1}",
						"action": [
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "200*flag:arg1"
							}
						]
					}
				]
			}
		],
		"回收钥匙商店": [
			{
				"type": "comment",
				"text": "此事件在全局商店中被引用了(全局商店keyShop)"
			},
			{
				"type": "comment",
				"text": "解除引用前勿删除此事件"
			},
			{
				"type": "comment",
				"text": "玩家在快捷列表（V键）中可以使用本公共事件"
			},
			{
				"type": "while",
				"condition": "1",
				"data": [
					{
						"type": "choices",
						"text": "\t[商人,trader]你有多余的钥匙想要出售吗？",
						"choices": [
							{
								"text": "黄钥匙（10金币）",
								"color": [
									255,
									255,
									0,
									1
								],
								"action": [
									{
										"type": "if",
										"condition": "item:yellowKey >= 1",
										"true": [
											{
												"type": "setValue",
												"name": "item:yellowKey",
												"operator": "-=",
												"value": "1"
											},
											{
												"type": "setValue",
												"name": "status:money",
												"operator": "+=",
												"value": "10"
											}
										],
										"false": [
											"\t[商人,trader]你没有黄钥匙！"
										]
									}
								]
							},
							{
								"text": "蓝钥匙（50金币）",
								"color": [
									0,
									0,
									255,
									1
								],
								"action": [
									{
										"type": "if",
										"condition": "item:blueKey >= 1",
										"true": [
											{
												"type": "setValue",
												"name": "item:blueKey",
												"operator": "-=",
												"value": "1"
											},
											{
												"type": "setValue",
												"name": "status:money",
												"operator": "+=",
												"value": "50"
											}
										],
										"false": [
											"\t[商人,trader]你没有蓝钥匙！"
										]
									}
								]
							},
							{
								"text": "离开",
								"action": [
									{
										"type": "exit"
									}
								]
							}
						]
					}
				]
			}
		],
		"游戏说明": [
			{
				"type": "playSound",
				"name": "打开界面"
			},
			{
				"type": "choices",
				"choices": [
					{
						"text": "样板简介",
						"color": [
							255,
							255,
							255,
							1
						],
						"action": [
							"该样板一般默认有36层暗道，有圣剑守卫，不能偷雪花",
							"增加了自动存档的上限，关闭了预览模式，现在允许在浏览地图的时候点击图标使用怪物手册了",
							"改善了音乐音效，删除替换了一部分过于刺耳的音效（特别点出3层）。添加了部分来自rpgmaker的音效",
							"修正了楼传的按钮判定，优化了移动端体验",
							"优化了缩略图的绘制，现在缩略图也高清了",
							"增加了持有冰冻徽章时触碰岩浆，岩浆自动消失的功能",
							"现在，暗墙跟碰触熔岩都不会导致自动寻路被打断了",
							"加入了功能：自动清怪、拾取道具、打开暗墙与熔岩。",
							"加入了功能：道具前存档，楼传页面时查看怪物手册"
						]
					},
					{
						"text": "游戏简介",
						"action": [
							"原50层魔塔是按照flash版复刻，其中部分对话使用的魔塔盛宴的版本。",
							"地图复制：数码宝贝51、641\n部分事件复制：小艾\n默认背景音乐：无；可在切换音乐处设置\n游戏音乐、怪物显伤等开关可以在系统设置里打开和关闭",
							"想要获得更详细的介绍，可以在https://h5mota.com/tower/?name=51，查看置顶评论。"
						]
					},
					{
						"text": "游戏结局",
						"action": [
							"在原版魔塔（哪个原版？）中，使用“下楼器和破墙镐”或“下楼器和地震卷轴”可以封印魔王（真的吗？），因此，有些mod会保留有这个封印魔王的TE结局。",
							"不过嘛，具体还是看作者心情的。一般来说各个结局都会在开头的作者处说明。如果作者忘了，可以看看现有的评论区与榜单"
						]
					},
					{
						"text": "对话穿墙（已移除）",
						"need": "false",
						"action": [
							{
								"type": "insert",
								"name": "游戏说明"
							}
						]
					},
					{
						"text": "切换音乐（根本没用！）",
						"need": "false",
						"action": [
							{
								"type": "insert",
								"name": "游戏说明"
							}
						]
					},
					{
						"text": "返回游戏",
						"action": []
					}
				]
			}
		],
		"对话": [
			{
				"type": "switch",
				"condition": "flag:arg1",
				"caseList": [
					{
						"case": "2",
						"action": [
							{
								"type": "setValue",
								"name": "flag:content",
								"value": "'也许你不需要击败守卫就能救我……总之还是给你1000金币！'"
							},
							{
								"type": "setValue",
								"name": "flag:对话2",
								"value": "1"
							}
						]
					},
					{
						"case": "3",
						"action": [
							{
								"type": "setValue",
								"name": "flag:content",
								"value": "'吾命休矣！'"
							},
							{
								"type": "setValue",
								"name": "flag:对话3",
								"value": "1"
							}
						]
					},
					{
						"case": "4",
						"action": [
							{
								"type": "setValue",
								"name": "flag:content",
								"value": "'你是否发现怪物有一种神秘的能力？'"
							},
							{
								"type": "setValue",
								"name": "flag:对话4",
								"value": "1"
							}
						]
					},
					{
						"case": "6",
						"action": [
							{
								"type": "if",
								"condition": "flag:arg4",
								"true": [
									{
										"type": "setValue",
										"name": "flag:content",
										"value": "'魔塔共有40层，每10层为一个区域。如果不打败此区域的头目就不能到更高的地方。'"
									},
									{
										"type": "setValue",
										"name": "flag:对话602",
										"value": "1"
									}
								],
								"false": [
									{
										"type": "setValue",
										"name": "flag:content",
										"value": "'能力值似乎并非越高越好，你发现了吗？'"
									},
									{
										"type": "setValue",
										"name": "flag:对话6",
										"value": "1"
									}
								]
							}
						]
					},
					{
						"case": "7",
						"action": [
							{
								"type": "setValue",
								"name": "flag:content",
								"value": "'如何加点呢？'"
							},
							{
								"type": "setValue",
								"name": "flag:对话7",
								"value": "1"
							}
						]
					},
					{
						"case": "12",
						"action": [
							{
								"type": "setValue",
								"name": "flag:content",
								"value": "'我要玩且卖且退！卖一份东西后退一格……不过npc也不堵路，太可惜了！'"
							},
							{
								"type": "setValue",
								"name": "flag:对话12",
								"value": "1"
							}
						]
					},
					{
						"case": "15",
						"action": [
							{
								"type": "setValue",
								"name": "flag:content",
								"value": "'也许你可以硬抗大章鱼的攻击去拿破墙镐，但是这值得吗？'"
							},
							{
								"type": "setValue",
								"name": "flag:对话15",
								"value": "1"
							}
						]
					},
					{
						"case": "16",
						"action": [
							{
								"type": "setValue",
								"name": "flag:content",
								"value": "'这些闲置怪真烦人！'"
							},
							{
								"type": "setValue",
								"name": "flag:对话16",
								"value": "1"
							}
						]
					},
					{
						"case": "18",
						"action": [
							{
								"type": "setValue",
								"name": "flag:content",
								"value": "'不多次提升攻击就无法击败石头人，当然你也可以不击败，直接去拿十字架说不定也是一种选择？'"
							},
							{
								"type": "setValue",
								"name": "flag:对话18",
								"value": "1"
							}
						]
					},
					{
						"case": "21",
						"action": [
							{
								"type": "if",
								"condition": "flag:arg4",
								"true": [
									{
										"type": "setValue",
										"name": "flag:content",
										"value": "'你居然买了我的钥匙，那我就告诉你一个秘密：原本打算怪物不能破墙的，但是看起来没解。如果你想玩这个模式，你可以下载本游戏并修改一层的到达事件即可。'"
									},
									{
										"type": "setValue",
										"name": "flag:对话2102",
										"value": "1"
									}
								],
								"false": [
									{
										"type": "setValue",
										"name": "flag:content",
										"value": "'我听说下一层的骑士队长非常头铁，并不会退避！'"
									},
									{
										"type": "setValue",
										"name": "flag:对话21",
										"value": "1"
									}
								]
							}
						]
					},
					{
						"case": "23",
						"action": [
							{
								"type": "setValue",
								"name": "flag:content",
								"value": "'怎么拿到骑士剑呢？'"
							},
							{
								"type": "setValue",
								"name": "flag:对话23",
								"value": "1"
							}
						]
					},
					{
						"case": "26",
						"action": [
							{
								"type": "setValue",
								"name": "flag:content",
								"value": "'暗道，有用吗？'"
							},
							{
								"type": "setValue",
								"name": "flag:对话26",
								"value": "1"
							}
						]
					},
					{
						"case": "27",
						"action": [
							{
								"type": "setValue",
								"name": "flag:content",
								"value": "'你可以尝试让怪物帮忙打开宝库？'"
							},
							{
								"type": "setValue",
								"name": "flag:对话27",
								"value": "1"
							}
						]
					},
					{
						"case": "28",
						"action": [
							{
								"type": "setValue",
								"name": "flag:content",
								"value": "'存放圣剑的房间的门好了，进去的办法有的是。'"
							},
							{
								"type": "setValue",
								"name": "flag:对话28",
								"value": "1"
							}
						]
					},
					{
						"case": "29",
						"action": [
							{
								"type": "if",
								"condition": "flag:arg4",
								"true": [
									{
										"type": "setValue",
										"name": "flag:content",
										"value": "'你居然买了我的钥匙，那我就告诉你一个秘密：其实作者是想神圣盾不能免疫捕捉的……但是测塔员太辛苦了，而且容错本来就低，还是算了！'"
									},
									{
										"type": "setValue",
										"name": "flag:对话2902",
										"value": "1"
									}
								],
								"false": [
									{
										"type": "setValue",
										"name": "flag:content",
										"value": "'有个好消息是，怪物不会吞掉对称飞，不知道这消息对你是否有用'"
									},
									{
										"type": "setValue",
										"name": "flag:对话29",
										"value": "1"
									}
								]
							}
						]
					},
					{
						"case": "32",
						"action": [
							{
								"type": "setValue",
								"name": "flag:content",
								"value": "'魔法攻击加且战且退，给你无与伦比的体验！'"
							},
							{
								"type": "setValue",
								"name": "flag:对话32",
								"value": "1"
							}
						]
					},
					{
						"case": "35",
						"action": [
							{
								"type": "if",
								"condition": "flag:arg4",
								"true": [
									{
										"type": "setValue",
										"name": "flag:content",
										"value": "'34楼被藏在异空间，但是里面有两个会且战且退的高级卫兵'"
									},
									{
										"type": "setValue",
										"name": "flag:对话3502",
										"value": "1"
									}
								],
								"false": [
									{
										"type": "setValue",
										"name": "flag:content",
										"value": "'神圣盾能防御魔法攻击，但是它不能防止捕捉，真遗憾'"
									},
									{
										"type": "setValue",
										"name": "flag:对话35",
										"value": "1"
									}
								]
							}
						]
					},
					{
						"case": "36",
						"action": [
							{
								"type": "setValue",
								"name": "flag:content",
								"value": "'31层其实是对称的，太明显了！'"
							},
							{
								"type": "setValue",
								"name": "flag:对话36",
								"value": "1"
							}
						]
					},
					{
						"case": "37",
						"action": [
							{
								"type": "setValue",
								"name": "flag:content",
								"value": "'该用在哪里呢？'"
							},
							{
								"type": "setValue",
								"name": "flag:对话37",
								"value": "1"
							}
						]
					},
					{
						"case": "38",
						"action": [
							{
								"type": "setValue",
								"name": "flag:content",
								"value": "'楼上用了两种魔法警卫来确保不出bug，但是感觉这个机制还是很容易出现bug！'"
							},
							{
								"type": "setValue",
								"name": "flag:对话38",
								"value": "1"
							}
						]
					},
					{
						"case": "default",
						"action": []
					}
				]
			},
			{
				"type": "if",
				"condition": "flag:arg4",
				"true": [
					"\t[商人,woman]${flag:content}"
				],
				"false": [
					"\t[老人,man]${flag:content}"
				]
			},
			{
				"type": "switch",
				"condition": "flag:arg1",
				"caseList": [
					{
						"case": "2",
						"action": [
							{
								"type": "playSound",
								"name": "获得道具"
							},
							{
								"type": "addValue",
								"name": "status:money",
								"value": "1000"
							},
							{
								"type": "tip",
								"text": "获得1000金币"
							}
						]
					},
					{
						"case": "3",
						"action": []
					},
					{
						"case": "default",
						"action": []
					}
				]
			},
			{
				"type": "hide",
				"loc": [
					"flag:arg2",
					"flag:arg3"
				],
				"remove": true,
				"time": 500
			}
		],
		"商人": [
			{
				"type": "switch",
				"condition": "parseInt(core.status.floorId.substring(2))",
				"caseList": [
					{
						"case": "6",
						"action": [
							{
								"type": "setValue",
								"name": "flag:money",
								"value": "50"
							},
							{
								"type": "setValue",
								"name": "flag:item",
								"value": "'一把蓝钥匙'"
							}
						]
					},
					{
						"case": "7",
						"action": [
							{
								"type": "setValue",
								"name": "flag:money",
								"value": "50"
							},
							{
								"type": "setValue",
								"name": "flag:item",
								"value": "'五把黄钥匙'"
							}
						]
					},
					{
						"case": "12",
						"action": [
							{
								"type": "setValue",
								"name": "flag:money",
								"value": "800"
							},
							{
								"type": "setValue",
								"name": "flag:item",
								"value": "'一把红钥匙'"
							}
						]
					},
					{
						"case": "15",
						"action": [
							{
								"type": "setValue",
								"name": "flag:money",
								"value": "200"
							},
							{
								"type": "setValue",
								"name": "flag:item",
								"value": "'一把蓝钥匙'"
							}
						]
					},
					{
						"case": "21",
						"action": [
							{
								"type": "setValue",
								"name": "flag:money",
								"value": "1000"
							},
							{
								"type": "setValue",
								"name": "flag:item",
								"value": "'一把蓝钥匙, 四把黄钥匙'"
							}
						]
					},
					{
						"case": "28",
						"action": [
							{
								"type": "setValue",
								"name": "flag:money",
								"value": "200"
							},
							{
								"type": "setValue",
								"name": "flag:alt",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "flag:item",
								"value": "'大甩卖! 三把黄钥匙只要200金币, 先到先得!'"
							}
						]
					},
					{
						"case": "29",
						"action": [
							{
								"type": "setValue",
								"name": "flag:money",
								"value": "2000"
							},
							{
								"type": "setValue",
								"name": "flag:item",
								"value": "'三把蓝钥匙'"
							}
						]
					},
					{
						"case": "35",
						"action": [
							{
								"type": "setValue",
								"name": "flag:money",
								"value": "1000"
							},
							{
								"type": "setValue",
								"name": "flag:alt",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "flag:item",
								"value": "'你出1000金币, 我就帮你回复2000点生命值'"
							}
						]
					},
					{
						"case": "37",
						"action": [
							{
								"type": "setValue",
								"name": "flag:money",
								"value": "4000"
							},
							{
								"type": "setValue",
								"name": "flag:item",
								"value": "'地震卷轴'"
							}
						]
					},
					{
						"case": "default",
						"action": []
					}
				]
			},
			{
				"type": "choices",
				"text": "\t[商人,woman]${flag:alt ? flag:item : '我有'+flag:item+', 你出'+flag:money+'金币就卖给你'}",
				"choices": [
					{
						"text": "我太需要了",
						"action": [
							{
								"type": "if",
								"condition": "(status:money >= flag:money)",
								"true": [
									{
										"type": "setValue",
										"name": "status:money",
										"operator": "-=",
										"value": "flag:money"
									},
									{
										"type": "switch",
										"condition": "parseInt(core.status.floorId.substring(2))",
										"caseList": [
											{
												"case": "6",
												"action": [
													{
														"type": "setValue",
														"name": "item:blueKey",
														"operator": "+=",
														"value": "1"
													}
												]
											},
											{
												"case": "7",
												"action": [
													{
														"type": "setValue",
														"name": "item:yellowKey",
														"operator": "+=",
														"value": "5"
													}
												]
											},
											{
												"case": "12",
												"action": [
													{
														"type": "setValue",
														"name": "item:redKey",
														"operator": "+=",
														"value": "1"
													}
												]
											},
											{
												"case": "15",
												"action": [
													{
														"type": "setValue",
														"name": "item:blueKey",
														"operator": "+=",
														"value": "1"
													}
												]
											},
											{
												"case": "21",
												"action": [
													{
														"type": "setValue",
														"name": "item:yellowKey",
														"operator": "+=",
														"value": "4"
													},
													{
														"type": "setValue",
														"name": "item:blueKey",
														"operator": "+=",
														"value": "1"
													}
												]
											},
											{
												"case": "28",
												"action": [
													{
														"type": "setValue",
														"name": "item:yellowKey",
														"operator": "+=",
														"value": "3"
													}
												]
											},
											{
												"case": "29",
												"action": [
													{
														"type": "setValue",
														"name": "item:blueKey",
														"operator": "+=",
														"value": "3"
													}
												]
											},
											{
												"case": "35",
												"action": [
													{
														"type": "playSound",
														"name": "获得道具"
													},
													{
														"type": "setValue",
														"name": "status:hp",
														"operator": "+=",
														"value": "2000"
													}
												]
											},
											{
												"case": "37",
												"action": [
													{
														"type": "setValue",
														"name": "item:earthquake",
														"operator": "+=",
														"value": "1"
													}
												]
											},
											{
												"case": "default",
												"action": []
											}
										]
									},
									{
										"type": "function",
										"function": "function(){\nvar name = core.status.floorId + '@' + core.getFlag(\"arg1\", 0) + '@' + core.getFlag(\"arg2\", 0) + '@' + 'A';\ncore.setFlag(name, 1);\n}"
									}
								],
								"false": [
									"\t[商人,woman]你的金币不够${flag:money}枚，无法交易！"
								]
							}
						]
					},
					{
						"text": "下次再说",
						"action": []
					}
				]
			},
			{
				"type": "setValue",
				"name": "flag:alt",
				"value": "0"
			}
		],
		"商店": [
			{
				"type": "if",
				"condition": "(flag:times1===0)",
				"true": [
					{
						"type": "setValue",
						"name": "flag:times1",
						"value": "1"
					}
				]
			},
			{
				"type": "while",
				"condition": "true",
				"data": [
					{
						"type": "setValue",
						"name": "flag:money1",
						"value": "20+10*flag:times1*(flag:times1-1)"
					},
					{
						"type": "choices",
						"text": "\t[祭坛,blueShop]如果供奉${flag:money1}金币, 便可以增加你的力量, 你想要什么呢…",
						"choices": [
							{
								"text": "生命+${100*flag:times1}",
								"action": [
									{
										"type": "if",
										"condition": "(status:money>=flag:money1)",
										"true": [
											{
												"type": "playSound",
												"name": "获得道具"
											},
											{
												"type": "setValue",
												"name": "status:hp",
												"operator": "+=",
												"value": "100*flag:times1"
											},
											{
												"type": "setValue",
												"name": "status:money",
												"operator": "-=",
												"value": "flag:money1"
											},
											{
												"type": "setValue",
												"name": "flag:times1",
												"operator": "+=",
												"value": "1"
											}
										],
										"false": [
											{
												"type": "tip",
												"text": "你的金币不足${flag:money1}枚，无法供奉！"
											}
										]
									}
								]
							},
							{
								"text": "攻击+${2*flag:ratio}",
								"action": [
									{
										"type": "if",
										"condition": "(status:money>=flag:money1)",
										"true": [
											{
												"type": "playSound",
												"name": "获得道具"
											},
											{
												"type": "setValue",
												"name": "status:atk",
												"operator": "+=",
												"value": "2*flag:ratio"
											},
											{
												"type": "setValue",
												"name": "status:money",
												"operator": "-=",
												"value": "flag:money1"
											},
											{
												"type": "setValue",
												"name": "flag:times1",
												"operator": "+=",
												"value": "1"
											}
										],
										"false": [
											{
												"type": "tip",
												"text": "你的金币不足${flag:money1}枚，无法供奉！"
											}
										]
									}
								]
							},
							{
								"text": "防御+${4*flag:ratio}",
								"action": [
									{
										"type": "if",
										"condition": "(status:money>=flag:money1)",
										"true": [
											{
												"type": "playSound",
												"name": "获得道具"
											},
											{
												"type": "setValue",
												"name": "status:def",
												"operator": "+=",
												"value": "4*flag:ratio"
											},
											{
												"type": "setValue",
												"name": "status:money",
												"operator": "-=",
												"value": "flag:money1"
											},
											{
												"type": "setValue",
												"name": "flag:times1",
												"operator": "+=",
												"value": "1"
											}
										],
										"false": [
											{
												"type": "tip",
												"text": "你的金币不足${flag:money1}枚，无法供奉！"
											}
										]
									}
								]
							},
							{
								"text": "离开",
								"action": [
									{
										"type": "exit"
									}
								]
							}
						]
					}
				]
			}
		],
		"记事本": [
			{
				"type": "choices",
				"text": "\t[作者,oldMan]选择功能",
				"choices": [
					{
						"text": "小游戏！",
						"condition": "flag:小游戏开关",
						"action": [
							{
								"type": "choices",
								"text": "\t[hero]选择小游戏！",
								"choices": [
									{
										"text": "翻牌子",
										"action": [
											{
												"type": "playBgm",
												"name": "GreatMagicMaster.mp3"
											},
											{
												"type": "insert",
												"name": "翻牌子"
											}
										]
									},
									{
										"text": "老虎机",
										"action": [
											{
												"type": "playBgm",
												"name": "GreatMagicMaster.mp3"
											},
											{
												"type": "insert",
												"name": "老虎机"
											}
										]
									},
									{
										"text": "Flappy Hero（更新中）",
										"action": [
											{
												"type": "playBgm",
												"name": "GreatMagicMaster.mp3"
											},
											{
												"type": "insert",
												"name": "Flappy Hero"
											}
										]
									},
									{
										"text": "祖玛（更新中）",
										"action": [
											{
												"type": "playBgm",
												"name": "GreatMagicMaster.mp3"
											},
											{
												"type": "function",
												"async": true,
												"function": "function(){\ncore.plugin.starZuMaGame()\n}"
											}
										]
									},
									{
										"text": "放置游戏（更新中）",
										"action": [
											{
												"type": "playBgm",
												"name": "GreatMagicMaster.mp3"
											},
											{
												"type": "function",
												"async": true,
												"function": "function(){\ncore.startMonsterGoldGame()\n}"
											}
										]
									},
									{
										"text": "下次再说",
										"action": [
											{
												"type": "exit"
											}
										]
									}
								]
							}
						]
					},
					{
						"text": "自动清怪、拾取、开暗墙！",
						"action": [
							{
								"type": "while",
								"condition": "1",
								"data": [
									{
										"type": "function",
										"function": "function(){\nif (!core.status.hero.flags.__auto__) core.status.hero.flags.__auto__ = { battle: false, item: false, wall: false }\n}"
									},
									{
										"type": "choices",
										"text": "\t[作者,oldMan]选择要开启的功能！",
										"choices": [
											{
												"text": "自动清零伤怪 [off]",
												"need": "false",
												"condition": "!core.status.hero.flags.__auto__.battle",
												"action": [
													{
														"type": "function",
														"function": "function(){\ncore.status.hero.flags.__auto__.battle = true\n}"
													},
													{
														"type": "tip",
														"text": "自动清怪已开启"
													}
												]
											},
											{
												"text": "自动清零伤怪 [on]",
												"need": "false",
												"condition": "core.status.hero.flags.__auto__.battle",
												"action": [
													{
														"type": "function",
														"function": "function(){\ncore.status.hero.flags.__auto__.battle = false\n}"
													},
													{
														"type": "tip",
														"text": "自动清怪已关闭"
													}
												]
											},
											{
												"text": "自动拾取物品 [off]",
												"condition": "!core.status.hero.flags.__auto__.item",
												"action": [
													{
														"type": "function",
														"function": "function(){\ncore.status.hero.flags.__auto__.item = true\n}"
													},
													{
														"type": "tip",
														"text": "自动拾取已开启"
													}
												]
											},
											{
												"text": "自动拾取物品 [on]",
												"condition": "core.status.hero.flags.__auto__.item",
												"action": [
													{
														"type": "function",
														"function": "function(){\ncore.status.hero.flags.__auto__.item = false\n}"
													},
													{
														"type": "tip",
														"text": "自动拾取已关闭"
													}
												]
											},
											{
												"text": "自动开暗墙岩浆 [off]",
												"condition": "!core.status.hero.flags.__auto__.wall",
												"action": [
													{
														"type": "function",
														"function": "function(){\ncore.status.hero.flags.__auto__.wall = true\n}"
													},
													{
														"type": "tip",
														"text": "自动开暗墙岩浆已开启"
													}
												]
											},
											{
												"text": "自动开暗墙岩浆 [on]",
												"condition": "core.status.hero.flags.__auto__.wall",
												"action": [
													{
														"type": "function",
														"function": "function(){\ncore.status.hero.flags.__auto__.wall = false\n}"
													},
													{
														"type": "tip",
														"text": "自动开暗墙岩浆已开启"
													}
												]
											},
											{
												"text": "退出设置",
												"action": [
													{
														"type": "exit"
													}
												]
											}
										]
									}
								]
							}
						]
					},
					{
						"text": "退出设置",
						"action": [
							{
								"type": "exit"
							}
						]
					}
				]
			}
		],
		"寄生": [
			{
				"type": "setValue",
				"name": "temp:X",
				"value": "-1+status:x"
			},
			{
				"type": "setValue",
				"name": "temp:Y",
				"value": "-1+status:y"
			},
			{
				"type": "update"
			},
			{
				"type": "tip",
				"text": "请选择一个怪物进行寄生，双击确认。双击其它位置取消技能使用"
			},
			{
				"type": "while",
				"condition": "true",
				"data": [
					{
						"type": "drawSelector",
						"image": "winskin.png",
						"code": 1,
						"x": "32*temp:X",
						"y": "32*temp:Y",
						"width": 32,
						"height": 32
					},
					{
						"type": "wait",
						"forceChild": true,
						"data": [
							{
								"case": "mouse",
								"px": [
									0,
									512
								],
								"py": [
									0,
									512
								],
								"action": [
									{
										"type": "if",
										"condition": "((temp:X==flag:x)&&(temp:Y==flag:y))",
										"true": [
											{
												"type": "if",
												"condition": "(core.getBlockCls(1+core.getFlag('x',0),1+core.getFlag('y',0))=='enemys')",
												"true": [
													{
														"type": "setHeroOpacity",
														"opacity": 0,
														"time": 100
													},
													{
														"type": "setValue",
														"name": "flag:原位置x",
														"value": "status:x"
													},
													{
														"type": "setValue",
														"name": "flag:原位置y",
														"value": "status:y"
													},
													{
														"type": "setValue",
														"name": "flag:寄生",
														"value": "true"
													},
													{
														"type": "function",
														"function": "function(){\n(function () {\n\tlet m = core.getBlockId(1 + core.getFlag('x', 0), 1 + core.getFlag('y', 0));\n\tlet bi = core.getBlockInfo(m);\n\tvar getImage = function (img, m) {\n\t\tconst canvas = document.createElement('canvas');\n\t\tconst ctx = canvas.getContext('2d');\n\n\t\tconst partX = 0; // 截取的起始X坐标\n\t\tconst partY = core.material.icons.enemys[m] * 32; // 截取的起始Y坐标\n\t\tconst partWidth = 64; // 截取的宽度\n\t\tconst partHeight = 32; // 截取的高度\n\n\t\t// 设置 canvas 的大小\n\t\tcanvas.width = partWidth * 2; // 横向复制后宽度加倍\n\t\tcanvas.height = partHeight * 4; // 纵向复制 4 次后的高度\n\n\t\t// 截取图片的一部分并绘制到 canvas 上\n\t\tfor (let y = 0; y < 4; y++) {\n\t\t\tfor (let x = 0; x < 2; x++) {\n\t\t\t\tctx.drawImage(\n\t\t\t\t\timg,\n\t\t\t\t\tpartX, partY, partWidth, partHeight, // 从图片中截取的部分\n\t\t\t\t\tx * partWidth, y * partHeight, partWidth, partHeight // 绘制在 canvas 上的目标位置\n\t\t\t\t);\n\t\t\t}\n\t\t}\n\n\t\t/*const imgElement = new Image(); \n\t\timgElement.src = canvas.toDataURL('image/png'); \n\t\timgElement.setAttribute('_width', canvas.width);\n\t\timgElement.setAttribute('_height', canvas.height);*/\n\t\treturn canvas;\n\t};\n\tlet img = getImage(bi.image, m);\n\tcore.status.hero.image = bi.name;\n\tcore.material.images.hero = img;\n\tcore.material.icons.hero.width = 32;\n\tcore.material.icons.hero.height = 32;\n\t//core.control.updateHeroIcon(bi.name);\n\tcore.drawHero();\n\n\tvar enemy = core.material.enemys[m];\n\tvar enemyInfo = core.enemys.getEnemyInfo(enemy, null, 1 + core.getFlag('x', 0), 1 + core.getFlag('y', 0), core.status.floorId);\n\tcore.setFlag('hp', enemyInfo.hp);\n\tcore.setFlag('atk', enemyInfo.atk);\n\tcore.setFlag('def', enemyInfo.def);\n\tcore.setFlag('money', enemyInfo.money);\n})();\n}"
													},
													{
														"type": "changePos",
														"loc": [
															"1+core.getFlag('x',0)",
															"1+core.getFlag('y',0)"
														]
													},
													{
														"type": "setHeroOpacity",
														"opacity": 1,
														"time": 100
													},
													{
														"type": "drawSelector",
														"code": 1
													},
													{
														"type": "clearMap"
													},
													{
														"type": "update"
													},
													{
														"type": "waitAsync"
													},
													{
														"type": "exit"
													}
												],
												"false": []
											}
										]
									},
									{
										"type": "setValue",
										"name": "temp:X",
										"value": "flag:x"
									},
									{
										"type": "setValue",
										"name": "temp:Y",
										"value": "flag:y"
									}
								]
							}
						]
					}
				]
			}
		],
		"选怪夹击": [
			{
				"type": "superAutoSave"
			},
			{
				"type": "setValue",
				"name": "temp:X",
				"value": "-1+status:x"
			},
			{
				"type": "setValue",
				"name": "temp:Y",
				"value": "-1+status:y"
			},
			{
				"type": "update"
			},
			{
				"type": "tip",
				"text": "请选择一个怪物夹击"
			},
			{
				"type": "while",
				"condition": "true",
				"data": [
					{
						"type": "drawSelector",
						"image": "winskin.png",
						"code": 1,
						"x": "32*temp:X",
						"y": "32*temp:Y",
						"width": 32,
						"height": 32
					},
					{
						"type": "wait",
						"forceChild": true,
						"data": [
							{
								"case": "keyboard",
								"keycode": "65",
								"action": [
									{
										"type": "function",
										"function": "function(){\n(function () {\n\t//debugger;\n\tlet id = 'autoSave';\n\tcore.saves.autosave.now -= 2;\n\tvar data = core.saves.autosave.data.splice(core.saves.autosave.now, 1)[0];\n\tif (core.isPlaying() && !core.status.gameOver) {\n\t\tcore.control.autosave(0);\n\t\tcore.saves.autosave.now -= 1;\n\t}\n\tif (core.saves.autosave.now == 0) {\n\t\tcore.saves.autosave.data.unshift(core.clone(data));\n\t\tcore.saves.autosave.now += 1;\n\t}\n\tcore.control._doSL_load_afterGet(id, data);\n\treturn;\n})();\n}"
									},
									{
										"type": "exit"
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									0,
									512
								],
								"py": [
									0,
									512
								],
								"action": [
									{
										"type": "if",
										"condition": "((temp:X==flag:x)&&(temp:Y==flag:y))",
										"true": [
											{
												"type": "if",
												"condition": "(core.getBlockCls(1+flag:x,1+flag:y)==='enemys')",
												"true": [
													{
														"type": "choices",
														"text": "\t[作者,oldMan]选择朝向",
														"choices": [
															{
																"text": "横向",
																"action": [
																	{
																		"type": "setBlock",
																		"number": "whiteKing",
																		"loc": [
																			"flag:x",
																			"1+flag:y"
																		],
																		"time": 500,
																		"async": true
																	},
																	{
																		"type": "setBlock",
																		"number": "whiteKing",
																		"loc": [
																			"2+flag:x",
																			"1+flag:y"
																		],
																		"time": 500,
																		"async": true
																	},
																	{
																		"type": "waitAsync"
																	},
																	{
																		"type": "setEnemyOnPoint",
																		"loc": [
																			"1+flag:x",
																			"1+flag:y"
																		],
																		"name": "hp",
																		"operator": "/=",
																		"value": "2"
																	},
																	{
																		"type": "drawSelector",
																		"code": 1
																	},
																	{
																		"type": "clearMap"
																	},
																	{
																		"type": "update"
																	},
																	{
																		"type": "exit"
																	}
																]
															},
															{
																"text": "纵向",
																"action": [
																	{
																		"type": "setBlock",
																		"number": "whiteKing",
																		"loc": [
																			"1+flag:x",
																			"2+flag:y"
																		],
																		"time": 500,
																		"async": true
																	},
																	{
																		"type": "setBlock",
																		"number": "whiteKing",
																		"loc": [
																			"1+flag:x",
																			"flag:y"
																		],
																		"time": 500,
																		"async": true
																	},
																	{
																		"type": "waitAsync"
																	},
																	{
																		"type": "setEnemyOnPoint",
																		"loc": [
																			"1+flag:x",
																			"1+flag:y"
																		],
																		"name": "hp",
																		"operator": "/=",
																		"value": "2"
																	},
																	{
																		"type": "drawSelector",
																		"code": 1
																	},
																	{
																		"type": "clearMap"
																	},
																	{
																		"type": "update"
																	},
																	{
																		"type": "exit"
																	}
																]
															},
															{
																"text": "重选",
																"action": []
															},
															{
																"text": "读档",
																"action": [
																	{
																		"type": "function",
																		"function": "function(){\n(function () {\n\t//debugger;\n\tlet id = 'autoSave';\n\tcore.saves.autosave.now -= 2;\n\tvar data = core.saves.autosave.data.splice(core.saves.autosave.now, 1)[0];\n\tif (core.isPlaying() && !core.status.gameOver) {\n\t\tcore.control.autosave(0);\n\t\tcore.saves.autosave.now -= 1;\n\t}\n\tif (core.saves.autosave.now == 0) {\n\t\tcore.saves.autosave.data.unshift(core.clone(data));\n\t\tcore.saves.autosave.now += 1;\n\t}\n\tcore.control._doSL_load_afterGet(id, data);\n\treturn;\n})();\n}"
																	}
																]
															}
														]
													}
												]
											}
										]
									},
									{
										"type": "setValue",
										"name": "temp:X",
										"value": "flag:x"
									},
									{
										"type": "setValue",
										"name": "temp:Y",
										"value": "flag:y"
									}
								]
							}
						]
					}
				]
			}
		],
		"翻牌子": [
			{
				"type": "if",
				"condition": "core.isReplaying()",
				"true": [
					{
						"type": "exit"
					}
				]
			},
			{
				"type": "function",
				"function": "function(){\ncore.setFlag('存储录像', core.clone(core.status.route));\ncore.setFlag('total', 0);\n}"
			},
			{
				"type": "choices",
				"text": "\t[hero]选择开门所需金币数量：",
				"choices": [
					{
						"text": "1",
						"action": [
							{
								"type": "setValue",
								"name": "flag:开门金币",
								"value": "1"
							}
						]
					},
					{
						"text": "10",
						"action": [
							{
								"type": "setValue",
								"name": "flag:开门金币",
								"value": "10"
							}
						]
					},
					{
						"text": "100",
						"action": [
							{
								"type": "setValue",
								"name": "flag:开门金币",
								"value": "100"
							}
						]
					},
					{
						"text": "1000",
						"action": [
							{
								"type": "setValue",
								"name": "flag:开门金币",
								"value": "1000"
							}
						]
					}
				]
			},
			{
				"type": "function",
				"function": "function(){\ncore.createCanvas('game_combo', 0, 0, 352, 352, 134);\ncore.createCanvas('game_button', 0, 0, 352, 352, 134);\ncore.createCanvas('game_event_l0', 0, 0, 352, 352, 132);\ncore.createCanvas('game_event_l1', 0, 0, 352, 352, 133);\ncore.createCanvas('game_event_l2', 0, 0, 352, 352, 134);\n\ncore.ui.drawWindowSkin('winskin.png', 'game_event_l0', 0, 0, 352, 352);\n\nlet cards = Array.from({ length: 5 }, () => Array(4).fill(0));\nconst positions = [];\nfor (let i = 0; i < 5; i++) {\n\tfor (let j = 0; j < 4; j++) {\n\t\tpositions.push([i, j]);\n\t}\n}\nwhile (positions.length > 0) {\n\tlet rpn = (core.rand2(3) + 1) * 2;\n\trpn = Math.min(positions.length, rpn);\n\tconst keys = Object.keys(core.material.enemys);\n\tconst randomEnemy = keys[core.rand2(keys.length)];\n\tif (randomEnemy !== 'blackKing' && randomEnemy !== 'redKing') {\n\t\t//debugger;\n\t\twhile (rpn > 0) {\n\t\t\tconst randIndex = core.rand2(positions.length);\n\t\t\tconst [i, j] = positions.splice(randIndex, 1)[0];\n\t\t\tcards[i][j] = randomEnemy;\n\t\t\trpn -= 1;\n\t\t}\n\t}\n}\nconsole.log(cards);\ncore.setFlag('cards', cards);\nfor (let i = 0; i < 5; i++) {\n\tfor (let j = 0; j < 4; j++) {\n\t\tlet x = 32 + i * 64,\n\t\t\ty = 32 + j * 64;\n\t\tcore.drawIcon('game_event_l2', 'yellowWall', x, y, 32, 32);\n\t\tcore.drawIcon('game_event_l1', cards[i][j], x, y, 32, 32);\n\t}\n}\ncore.setFlag('当前游戏总金币', 0);\ncore.setFlag('combo', 0);\ncore.fillBoldText('game_combo', \"累计金币: \" + core.getFlag('当前游戏总金币', 0), 32, 320, '#FFFFFF', '#000000', \"bold 24px Verdana\");\ncore.fillBoldText('game_button', \"取消\", 256, 320, '#FFFFFF', '#000000', \"bold 24px Verdana\");\n}"
			},
			{
				"type": "while",
				"condition": "(flag:total <20)",
				"data": [
					{
						"type": "wait",
						"forceChild": true,
						"data": [
							{
								"case": "keyboard",
								"keycode": "27",
								"action": [
									{
										"type": "confirm",
										"text": "确认要取消吗?",
										"yes": [
											{
												"type": "break",
												"n": 1
											}
										],
										"no": []
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									0,
									512
								],
								"py": [
									0,
									512
								],
								"action": [
									{
										"type": "function",
										"function": "function(){\nconsole.log(core.getFlag('x') + ',' + core.getFlag('y'))\n}"
									},
									{
										"type": "if",
										"condition": "(function () {\n\tif(core.getFlag('x') % 2 && core.getFlag('y') % 2 && core.getFlag('y') < 8) {\n\t\tconst x = (core.getFlag('x') - 1) / 2,\n\t\t\ty = (core.getFlag('y') - 1) / 2;\n\t\treturn core.getFlag('cards')[x][y] !== null;\n\t}\n\treturn false;\n})();",
										"true": [
											{
												"type": "if",
												"condition": "(status:money >= flag:开门金币)",
												"true": [
													{
														"type": "setValue",
														"name": "status:money",
														"operator": "-=",
														"value": " flag:开门金币"
													},
													{
														"type": "setValue",
														"name": "flag:总花费金币",
														"operator": "+=",
														"value": " flag:开门金币"
													},
													{
														"type": "function",
														"function": "function(){\ncore.setFlag('first_choice_x', core.getFlag('x'));\ncore.setFlag('first_choice_y', core.getFlag('y'));\n}"
													},
													{
														"type": "function",
														"function": "function(){\nconst blockInfo = core.getBlockInfo('yellowWall');\nconst x = core.getFlag('x') * 32,\n\ty = core.getFlag('y') * 32;\nconst speed = 30;\nconst ctx = 'game_event_l2';\n\nconst locked = core.status.lockControl;\ncore.lockControl();\ncore.status.replay.animate = true;\n\nblockInfo.posX = 0;\n\nvar cb = function () {\n\tif (!locked) core.unlockControl();\n\tcore.status.replay.animate = false;\n\t//if (callback) callback();\n}\ncore.playSound('开关门');\nvar animate = window.setInterval(function () {\n\t//debugger;\n\tblockInfo.posX++;\n\tif (blockInfo.posX == 4) {\n\t\tcore.clearMap(ctx, x, y, 32, 32);\n\t\tclearInterval(animate);\n\t\tdelete core.animateFrame.asyncId[animate];\n\t\tcb();\n\t\treturn;\n\t}\n\tconst image = blockInfo.image,\n\t\tposX = blockInfo.posX,\n\t\tposY = blockInfo.posY,\n\t\theight = blockInfo.height;\n\tcore.clearMap(ctx, x, y, 32, 32);\n\tcore.drawImage(ctx, image, posX * 32, posY * height + height - 32, 32, 32, x, y, 32, 32);\n}, core.status.replay.speed == 24 ? 1 : speed / Math.max(core.status.replay.speed, 1));\n\ncore.animateFrame.lastAsyncId = animate;\ncore.animateFrame.asyncId[animate] = cb;\n}"
													},
													{
														"type": "while",
														"condition": "true",
														"data": [
															{
																"type": "wait",
																"forceChild": true,
																"data": [
																	{
																		"case": "keyboard",
																		"keycode": "65",
																		"action": [
																			{
																				"type": "confirm",
																				"text": "确认要取消吗?",
																				"yes": [
																					{
																						"type": "break",
																						"n": 1
																					}
																				],
																				"no": []
																			}
																		]
																	},
																	{
																		"case": "mouse",
																		"px": [
																			0,
																			512
																		],
																		"py": [
																			0,
																			512
																		],
																		"action": [
																			{
																				"type": "if",
																				"condition": "(function () {\n\tif(core.getFlag('first_choice_x') === core.getFlag('x') && core.getFlag('first_choice_y') === core.getFlag('y')) return false;\n\tif(core.getFlag('x') % 2 && core.getFlag('y') % 2 && core.getFlag('y') < 8) {\n\t\tconst x = (core.getFlag('x') - 1) / 2,\n\t\t\ty = (core.getFlag('y') - 1) / 2;\n\t\treturn core.getFlag('cards')[x][y] !== null;\n\t}\n\treturn false;\n})();",
																				"true": [
																					{
																						"type": "if",
																						"condition": "(status:money >= flag:开门金币)",
																						"true": [
																							{
																								"type": "setValue",
																								"name": "status:money",
																								"operator": "-=",
																								"value": " flag:开门金币"
																							},
																							{
																								"type": "setValue",
																								"name": "flag:总花费金币",
																								"operator": "+=",
																								"value": " flag:开门金币"
																							},
																							{
																								"type": "if",
																								"condition": "(function () {\n\tconst x1 = (core.getFlag('first_choice_x') - 1) / 2,\n\ty1 = (core.getFlag('first_choice_y') - 1) / 2;\n\tconst x2 = (core.getFlag('x') - 1) / 2,\n\ty2 = (core.getFlag('y') - 1) / 2;\n\treturn core.getFlag('cards')[x1][y1] === core.getFlag('cards')[x2][y2];\n})();",
																								"true": [
																									{
																										"type": "function",
																										"function": "function(){\nconst blockInfo = core.getBlockInfo('yellowWall');\nconst x = core.getFlag('x') * 32,\n\ty = core.getFlag('y') * 32;\nconst speed = 30;\nconst ctx = 'game_event_l2';\n\nconst locked = core.status.lockControl;\ncore.lockControl();\ncore.status.replay.animate = true;\n\nblockInfo.posX = 0;\n\nvar cb = function () {\n\tif (!locked) core.unlockControl();\n\tcore.status.replay.animate = false;\n\t//if (callback) callback();\n}\ncore.playSound('开关门');\nvar animate = window.setInterval(function () {\n\t//debugger;\n\tblockInfo.posX++;\n\tif (blockInfo.posX == 4) {\n\t\tcore.clearMap(ctx, x, y, 32, 32);\n\t\tclearInterval(animate);\n\t\tdelete core.animateFrame.asyncId[animate];\n\t\tcb();\n\t\treturn;\n\t}\n\tconst image = blockInfo.image,\n\t\tposX = blockInfo.posX,\n\t\tposY = blockInfo.posY,\n\t\theight = blockInfo.height;\n\tcore.clearMap(ctx, x, y, 32, 32);\n\tcore.drawImage(ctx, image, posX * 32, posY * height + height - 32, 32, 32, x, y, 32, 32);\n}, core.status.replay.speed == 24 ? 1 : speed / Math.max(core.status.replay.speed, 1));\n\ncore.animateFrame.lastAsyncId = animate;\ncore.animateFrame.asyncId[animate] = cb;\n}"
																									},
																									{
																										"type": "sleep",
																										"time": 500
																									},
																									{
																										"type": "function",
																										"function": "function(){\nlet x1 = core.getFlag('first_choice_x') * 32,\n\ty1 = core.getFlag('first_choice_y') * 32,\n\tx2 = core.getFlag('x') * 32,\n\ty2 = core.getFlag('y') * 32;\n\nconst ctx = 'game_event_l1';\n\ncore.clearMap(ctx, x1, y1, 32, 32);\ncore.clearMap(ctx, x2, y2, 32, 32);\n\nx1 = (core.getFlag('first_choice_x') - 1) / 2;\ny1 = (core.getFlag('first_choice_y') - 1) / 2;\nx2 = (core.getFlag('x') - 1) / 2;\ny2 = (core.getFlag('y') - 1) / 2;\n\nlet cards = core.getFlag('cards');\n//debugger;\ncards[x1][y1] = null;\ncards[x2][y2] = null;\ncore.setFlag('cards', cards);\ncore.addFlag('combo', 1);\n\ncore.playSound('Shop2.ogg')\n\nlet m = core.rand(4 * core.getFlag('开门金币', 0)) + 4 * core.getFlag('开门金币', 0);\ncore.addFlag('当前游戏总金币', m);\ncore.addFlag('total', 2);\nconsole.log(cards);\n}"
																									},
																									{
																										"type": "break",
																										"n": 1
																									}
																								],
																								"false": [
																									{
																										"type": "function",
																										"function": "function(){\nconst blockInfo = core.getBlockInfo('yellowWall');\nconst x = core.getFlag('x') * 32,\n\ty = core.getFlag('y') * 32;\nconst speed = 30;\nconst ctx = 'game_event_l2';\n\nconst locked = core.status.lockControl;\ncore.lockControl();\ncore.status.replay.animate = true;\n\nblockInfo.posX = 0;\n\nvar cb = function () {\n\tif (!locked) core.unlockControl();\n\tcore.status.replay.animate = false;\n\t//if (callback) callback();\n}\ncore.playSound('开关门');\nvar animate = window.setInterval(function () {\n\t//debugger;\n\tblockInfo.posX++;\n\tif (blockInfo.posX == 4) {\n\t\tcore.clearMap(ctx, x, y, 32, 32);\n\t\tclearInterval(animate);\n\t\tdelete core.animateFrame.asyncId[animate];\n\t\tcb();\n\t\treturn;\n\t}\n\tconst image = blockInfo.image,\n\t\tposX = blockInfo.posX,\n\t\tposY = blockInfo.posY,\n\t\theight = blockInfo.height;\n\tcore.clearMap(ctx, x, y, 32, 32);\n\tcore.drawImage(ctx, image, posX * 32, posY * height + height - 32, 32, 32, x, y, 32, 32);\n}, core.status.replay.speed == 24 ? 1 : speed / Math.max(core.status.replay.speed, 1));\n\ncore.animateFrame.lastAsyncId = animate;\ncore.animateFrame.asyncId[animate] = cb;\n}"
																									},
																									{
																										"type": "sleep",
																										"time": 500
																									},
																									{
																										"type": "function",
																										"function": "function(){\nconst blockInfo = core.getBlockInfo('yellowWall');\nconst x1 = core.getFlag('first_choice_x') * 32,\n\ty1 = core.getFlag('first_choice_y') * 32,\n\tx2 = core.getFlag('x') * 32,\n\ty2 = core.getFlag('y') * 32;\nconst speed = 30;\nconst ctx = 'game_event_l2';\n\nconst locked = core.status.lockControl;\ncore.lockControl();\ncore.status.replay.animate = true;\n\nblockInfo.posX = 4;\n\nvar cb = function () {\n\tif (!locked) core.unlockControl();\n\tcore.status.replay.animate = false;\n\t//if (callback) callback();\n}\ncore.playSound('操作失败');\nvar animate = window.setInterval(function () {\n\t//debugger;\n\tblockInfo.posX--;\n\tif (blockInfo.posX < 0) {\n\t\tclearInterval(animate);\n\t\tdelete core.animateFrame.asyncId[animate];\n\t\tcb();\n\t\treturn;\n\t}\n\tconst image = blockInfo.image,\n\t\tposX = blockInfo.posX,\n\t\tposY = blockInfo.posY,\n\t\theight = blockInfo.height;\n\tcore.clearMap(ctx, x1, y1, 32, 32);\n\tcore.clearMap(ctx, x2, y2, 32, 32);\n\tcore.drawImage(ctx, image, posX * 32, posY * height + height - 32, 32, 32, x1, y1, 32, 32);\n\tcore.drawImage(ctx, image, posX * 32, posY * height + height - 32, 32, 32, x2, y2, 32, 32);\n}, core.status.replay.speed == 24 ? 1 : speed / Math.max(core.status.replay.speed, 1));\n\ncore.animateFrame.lastAsyncId = animate;\ncore.animateFrame.asyncId[animate] = cb;\ncore.setFlag('combo', 0);\n}"
																									},
																									{
																										"type": "break",
																										"n": 1
																									}
																								]
																							}
																						],
																						"false": [
																							"\t[hero]我没钱了！"
																						]
																					}
																				],
																				"false": [
																					{
																						"type": "if",
																						"condition": "((core.getFlag('x') >=8 )&&( core.getFlag('y') >=9 ))",
																						"true": [
																							{
																								"type": "confirm",
																								"text": "确认要取消吗?",
																								"yes": [
																									{
																										"type": "break",
																										"n": 2
																									}
																								],
																								"no": []
																							}
																						],
																						"false": []
																					}
																				]
																			}
																		]
																	}
																]
															}
														]
													}
												],
												"false": [
													"\t[hero]我没钱了！"
												]
											}
										],
										"false": [
											{
												"type": "if",
												"condition": "((core.getFlag('x') >=8 )&&( core.getFlag('y') >=9 ))",
												"true": [
													{
														"type": "confirm",
														"text": "确认要取消吗?",
														"yes": [
															{
																"type": "break",
																"n": 1
															}
														],
														"no": []
													}
												],
												"false": []
											}
										]
									}
								]
							}
						]
					},
					{
						"type": "function",
						"function": "function(){\ncore.clearMap('game_combo');\ncore.fillBoldText('game_combo', \"累计金币: \" + core.getFlag('当前游戏总金币', 0), 32, 320, '#FFFFFF', '#000000', \"bold 24px Verdana\");\n}"
					}
				]
			},
			{
				"type": "sleep",
				"time": 500
			},
			{
				"type": "clearMap"
			},
			{
				"type": "function",
				"function": "function(){\ncore.clearMap('game_combo');\ncore.clearMap('game_button');\ncore.clearMap('game_event_l0');\ncore.clearMap('game_event_l1');\ncore.clearMap('game_event_l2');\n}"
			},
			{
				"type": "function",
				"function": "function(){\nlet r = core.getFlag('当前游戏总金币', 0);\ncore.status.route = core.getFlag('存储录像', null);\ncore.addStatus('money', r);\ncore.status.route.push('game:money:' + (r - (core.getFlag('总花费金币', 0))));\ncore.setFlag('总花费金币', 0);\ncore.setFlag('玩小游戏', true);\n}"
			},
			"获得${core.getFlag('当前游戏总金币', 0)}点金币！",
			{
				"type": "exit"
			}
		],
		"老虎机": [
			{
				"type": "if",
				"condition": "core.isReplaying()",
				"true": [
					{
						"type": "exit"
					}
				]
			},
			{
				"type": "function",
				"function": "function(){\ncore.setFlag('存储录像', core.clone(core.status.route));\ncore.setFlag('total', 0);\n}"
			},
			{
				"type": "choices",
				"text": "\t[hero]一次要投注多少？",
				"choices": [
					{
						"text": "25",
						"action": [
							{
								"type": "setValue",
								"name": "flag:投注金币",
								"value": "25"
							}
						]
					},
					{
						"text": "100",
						"action": [
							{
								"type": "setValue",
								"name": "flag:投注金币",
								"value": "100"
							}
						]
					},
					{
						"text": "250",
						"action": [
							{
								"type": "setValue",
								"name": "flag:投注金币",
								"value": "250"
							}
						]
					},
					{
						"text": "1000",
						"action": [
							{
								"type": "setValue",
								"name": "flag:投注金币",
								"value": "1000"
							}
						]
					}
				]
			},
			{
				"type": "function",
				"async": true,
				"function": "function(){\ncore.plugin.initSlotGame()\n}"
			}
		],
		"Flappy Hero": [
			{
				"type": "if",
				"condition": "core.isReplaying()",
				"true": [
					{
						"type": "exit"
					}
				]
			},
			{
				"type": "function",
				"function": "function(){\ncore.setFlag('存储录像', core.clone(core.status.route));\ncore.setFlag('total', 0);\n}"
			},
			{
				"type": "choices",
				"text": "\t[hero]一次要投注多少？",
				"choices": [
					{
						"text": "1",
						"action": [
							{
								"type": "setValue",
								"name": "flag:投注金币",
								"value": "1"
							}
						]
					},
					{
						"text": "10",
						"action": [
							{
								"type": "setValue",
								"name": "flag:投注金币",
								"value": "10"
							}
						]
					},
					{
						"text": "100",
						"action": [
							{
								"type": "setValue",
								"name": "flag:投注金币",
								"value": "100"
							}
						]
					}
				]
			},
			{
				"type": "function",
				"async": true,
				"function": "function(){\ncore.plugin.startPipeBirdGame();\n}"
			}
		]
	}
}