main.floors.MT25=
{
    "floorId": "MT25",
    "title": "魔塔 第25层",
    "name": "第 25 层",
    "width": 13,
    "height": 13,
    "canFlyTo": true,
    "canFlyFrom": true,
    "canUseQuickShop": true,
    "images": [],
    "ratio": 3,
    "defaultGround": "ground",
    "bgm": "section3.mp3",
    "firstArrive": [],
    "eachArrive": [],
    "parallelDo": "",
    "events": {
        "6,9": [
            "\t[大法师,blackMagician]杀死入侵者",
            {
                "type": "hide",
                "time": 0
            }
        ],
        "6,3": {
            "trigger": null,
            "enable": false,
            "noPass": null,
            "displayDamage": true,
            "opacity": 1,
            "filter": {
                "blur": 0,
                "hue": 0,
                "grayscale": 0,
                "invert": false,
                "shadow": 0
            },
            "data": [
                "秘境中属性、黄蓝钥匙是独立于塔内的，不过秘境中收集的攻击、防御、金币和带出的钥匙都会加到塔内的属性上，打败秘境中的boss就会被传送回塔内并获得一把绿钥匙"
            ]
        }
    },
    "changeFloor": {
        "1,11": {
            "floorId": ":next",
            "stair": "downFloor",
            "time": 0
        },
        "2,10": {
            "floorId": ":before",
            "stair": "upFloor",
            "time": 0
        },
        "4,8": {
            "floorId": "LAN31",
            "loc": [
                6,
                11
            ],
            "direction": "down",
            "ignoreChangeFloor": true
        },
        "5,8": {
            "floorId": "LAN32",
            "loc": [
                6,
                11
            ],
            "direction": "down",
            "ignoreChangeFloor": true
        },
        "7,8": {
            "floorId": "LAN33",
            "loc": [
                6,
                11
            ],
            "direction": "down",
            "ignoreChangeFloor": true
        },
        "8,8": {
            "floorId": "LAN34",
            "loc": [
                6,
                11
            ],
            "direction": "down",
            "ignoreChangeFloor": true
        }
    },
    "afterBattle": {
        "6,6": [
            {
                "type": "hide",
                "loc": [
                    [
                        6,
                        9
                    ]
                ],
                "time": 0
            },
            {
                "type": "playSound",
                "name": "door.mp3"
            },
            {
                "type": "function",
                "function": "function(){\nif (!core.isReplaying()) {\n\tconst sentences = [\n\t\t\"杀-死-入-侵-者\",\n\t\t\"住在25楼\",\n\t\t\"魔塔的主人\",\n\t\t\"简直就是自杀\",\n\t\t\"再去打败他\",\n\t\t\"更高级别\",\n\t\t\"你现在的状态\",\n\t\t\"去攻击他\",\n\t\t\"大法师大法师大法师大法师大法师大法师大法师大法师大法师大法师大法师\",\n\t\t\"穞堵臸猭畍\",\n\t\t\"穞堵臸猭畍2\"\n\t];\n\n\tfunction shuffleAndConcat(str) {\n\t\t// 如果输入不是字符串或为空，返回空字符串\n\t\tif (typeof str !== 'string' || str.length === 0) {\n\t\t\treturn '';\n\t\t}\n\n\t\t// 将字符串转换为数组以便打乱\n\t\tconst arr = str.split('');\n\n\t\t// 打乱数组的函数\n\t\tconst shuffleArray = (array) => {\n\t\t\tconst newArray = [...array];\n\t\t\tfor (let i = newArray.length - 1; i > 0; i--) {\n\t\t\t\tconst j = Math.floor(Math.random() * (i + 1));\n\t\t\t\t[newArray[i], newArray[j]] = [newArray[j], newArray[i]];\n\t\t\t}\n\t\t\treturn newArray;\n\t\t};\n\n\t\t// 生成三种不同的打乱结果\n\t\tconst shuffled1 = shuffleArray(arr).join('');\n\t\tconst shuffled2 = shuffleArray(arr).join('');\n\t\tconst shuffled3 = shuffleArray(arr).join('');\n\n\t\t// 拼接三种结果并返回\n\t\treturn shuffled1 + shuffled2 + shuffled3;\n\t}\n\n\tconst ctx = core.createCanvas('大法师', 0, 0, 11 * 32, 11 * 32, 101);\n\n\tlet animationId;\n\tlet addTextTimer;\n\tlet isRunning = false;\n\n\t// 黑白灰色系\n\tconst grayscaleColors = [\n\t\t//'#000000', // 纯黑\n\t\t'#333333', // 深灰\n\t\t'#666666', // 中灰\n\t\t'#999999', // 浅灰\n\t\t'#CCCCCC', // 更浅灰\n\t\t'#FFFFFF' // 纯白\n\t];\n\n\t// 文字对象数组\n\tlet textObjects = [];\n\n\t// 文字对象构造函数\n\tclass TextObject {\n\t\tconstructor() {\n\t\t\tthis.text = sentences[Math.floor(Math.random() * sentences.length)];\n\t\t\tif (this.text === \"穞堵臸猭畍2\") this.text = shuffleAndConcat(\"穞堵臸猭畍\");\n\t\t\tthis.x = Math.random() * 11 * 32;\n\t\t\tthis.y = Math.random() * 11 * 32;\n\t\t\tthis.size = 10 + Math.random() * 30;\n\t\t\tthis.angle = Math.random() * 180 - 90;\n\t\t\tthis.alpha = 0;\n\t\t\tthis.fadeIn = true;\n\t\t\tthis.fadeSpeed = 0.005 + Math.random() * 0.005;\n\t\t\t//this.rotationSpeed = (Math.random() - 0.5) * 0.5;\n\t\t\t//this.color = `hsl(${Math.random() * 360}, 70%, 60%)`;\n\t\t\tthis.color = grayscaleColors[Math.floor(Math.random() * grayscaleColors.length)];\n\t\t}\n\n\t\tupdate() {\n\t\t\t// 更新透明度\n\t\t\tif (this.fadeIn) {\n\t\t\t\tthis.alpha += this.fadeSpeed;\n\t\t\t\tif (this.alpha >= 1) {\n\t\t\t\t\tthis.alpha = 1;\n\t\t\t\t\tthis.fadeIn = false;\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tthis.alpha -= this.fadeSpeed;\n\t\t\t\tif (this.alpha <= 0) {\n\t\t\t\t\treturn false; // 表示该对象可以移除\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// 更新角度\n\t\t\t//this.angle += this.rotationSpeed;\n\n\t\t\treturn true; // 对象继续存在\n\t\t}\n\n\t\tdraw() {\n\t\t\tctx.save();\n\t\t\tctx.translate(this.x, this.y);\n\t\t\tctx.rotate(this.angle * Math.PI / 180);\n\t\t\tctx.globalAlpha = this.alpha;\n\t\t\tctx.font = `${this.size}px Arial`;\n\t\t\tctx.fillStyle = this.color;\n\t\t\tctx.textAlign = 'center';\n\t\t\tctx.textBaseline = 'middle';\n\t\t\tctx.fillText(this.text, 0, 0);\n\t\t\tctx.restore();\n\t\t}\n\t}\n\n\t// 添加新文字对象\n\tfunction addTextObject() {\n\t\tif (!isRunning) return;\n\t\ttextObjects.push(new TextObject());\n\n\t\t// 随机时间后添加下一个文字\n\t\taddTextTimer = setTimeout(addTextObject, Math.random() * 250);\n\t}\n\n\t// 动画循环\n\tfunction animate() {\n\t\t// 清除画布，使用半透明填充实现拖尾效果\n\t\t//ctx.fillStyle = 'rgba(240, 240, 240, 0.9)';\n\t\t//ctx.fillRect(0, 0, 11 * 32, 11 * 32);\n\t\tctx.clearRect(0, 0, 11 * 32, 11 * 32);\n\n\t\t// 更新并绘制所有文字对象\n\t\tfor (let i = textObjects.length - 1; i >= 0; i--) {\n\t\t\tconst obj = textObjects[i];\n\t\t\tif (!obj.update()) {\n\t\t\t\ttextObjects.splice(i, 1); // 移除透明度为0的对象\n\t\t\t} else {\n\t\t\t\tobj.draw();\n\t\t\t}\n\t\t}\n\n\t\tanimationId = requestAnimationFrame(animate);\n\t}\n\n\t// 停止动画\n\tfunction stopAnimation() {\n\t\tisRunning = false;\n\t\tclearTimeout(addTextTimer);\n\t\tcancelAnimationFrame(animationId);\n\t\tclearCanvas();\n\t}\n\n\t// 清除画布\n\tfunction clearCanvas() {\n\t\ttextObjects = [];\n\t\tctx.clearRect(0, 0, 11 * 32, 11 * 32);\n\t\tcore.deleteCanvas('大法师');\n\t}\n\t// 开始动画\n\tfunction startAnimation() {\n\t\tif (isRunning) return;\n\t\tisRunning = true;\n\t\taddTextObject();\n\t\tanimate();\n\t}\n\n\tstartAnimation();\n\tsetTimeout(stopAnimation, 10000);\n}\n\nconst actions = [{ \"type\": \"setCurtain\", \"color\": [0, 0, 0, 1], \"time\": 9000, \"keep\": true },\n\t{\n\t\t\"type\": \"setBlock\",\n\t\t\"number\": \"switch\",\n\t\t\"loc\": [\n\t\t\t[4, 8]\n\t\t]\n\t},\n\t{\n\t\t\"type\": \"setBlock\",\n\t\t\"number\": \"switch\",\n\t\t\"loc\": [\n\t\t\t[5, 8]\n\t\t]\n\t},\n\t{\n\t\t\"type\": \"setBlock\",\n\t\t\"number\": \"switch\",\n\t\t\"loc\": [\n\t\t\t[7, 8]\n\t\t]\n\t},\n\t{\n\t\t\"type\": \"setBlock\",\n\t\t\"number\": \"switch\",\n\t\t\"loc\": [\n\t\t\t[8, 8]\n\t\t]\n\t},\n\t{\n\t\t\"type\": \"show\",\n\t\t\"loc\": [\n\t\t\t[6, 3]\n\t\t]\n\t},\n\t{ \"type\": \"sleep\", \"time\": 1200, \"noSkip\": true }, \"\\t[hero]什么情况？\",\n];\ncore.insertAction(actions);\n}"
            },
            {
                "type": "setCurtain",
                "time": 1000
            },
            "大法师施展幻术，制造了四个秘境！"
        ]
    },
    "afterGetItem": {},
    "afterOpenDoor": {},
    "cannotMove": {},
    "map": [
    [  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4],
    [  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4],
    [  4,  0,  0,  0,  1,  1,  1,  1,  1,  0,  0,  0,  4],
    [  4,  0,  0,  1,  1,  0,129,  0,  1,  1,  0,  0,  4],
    [  4,  0,  1,  1,  0,  0,  0,  0,  0,  1,  1,  0,  4],
    [  4,  0,  1,  0,  0,  1,  0,  1,  0,  0,  1,  0,  4],
    [  4,  0,  1,  0,  0,  0,247,  0,  0,  0,  1,  0,  4],
    [  4,  0,  1,  0,  0,  1,  0,  1,  0,  0,  1,  0,  4],
    [  4,  0,  1,  1,  0,  0,  0,  0,  0,  1,  1,  0,  4],
    [  4,  0,  0,  1,  1,  0,  0,  0,  1,  1,  0,  0,  4],
    [  4,  0, 88,  0,  1,  1, 84,  1,  1,  0,  0,  0,  4],
    [  4, 87,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4],
    [  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4]
],
    "bgmap": [
    [ 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17],
    [ 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17]
],
    "fgmap": [

],
    "upFloor": [
        2,
        11
    ],
    "downFloor": [
        2,
        11
    ],
    "autoEvent": {},
    "beforeBattle": {},
    "cannotMoveIn": {}
}