var data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d = 
{
	"main": {
		"floorIds": [
			"MB0",
			"MB1",
			"MB2",
			"MB3",
			"MB4",
			"MB5",
			"MB6",
			"MB7",
			"MB8",
			"MB9",
			"MB10",
			"MB11",
			"MB12",
			"MB13",
			"MB14",
			"MB15",
			"MB16",
			"MB17",
			"MB18",
			"MB19",
			"MB20",
			"MB21",
			"MB22",
			"MB23",
			"MB24",
			"MB25"
		],
		"floorPartitions": [],
		"images": [
			"bear.png",
			"bg.jpg",
			"dragon.png",
			"hajimi.png",
			"hajimihero.png",
			"hero.png",
			"hongyan.png",
			"kaichang.png",
			"manbo.png",
			"manbohero.png",
			"maodie.png",
			"statusBackground.jpg",
			"statusBackground_vertical.png",
			"winskin.png"
		],
		"tilesets": [
			"magictower.png"
		],
		"animates": [
			"hand",
			"sword",
			"zone"
		],
		"bgms": [
			"10F.mp3",
			"20F.mp3",
			"bgm.mp3",
			"biaoti.mp3",
			"boss4.mp3",
			"boss5.mp3",
			"death.mp3",
			"section1.mp3",
			"section2.mp3",
			"section3.mp3",
			"section4.mp3",
			"section5.mp3",
			"tiaolouji.mp3",
			"truth.mp3",
			"win.mp3"
		],
		"sounds": [
			"3F.mp3",
			"attack.mp3",
			"bomb.mp3",
			"centerFly.mp3",
			"door.mp3",
			"equip.mp3",
			"floor.mp3",
			"hajimi.mp3",
			"item.mp3",
			"jump.mp3",
			"manbo.mp3",
			"pbb.mp3",
			"pickaxe.mp3",
			"zone.mp3"
		],
		"fonts": [],
		"nameMap": {
			"确定": "confirm.mp3",
			"取消": "cancel.mp3",
			"操作失败": "error.mp3",
			"光标移动": "cursor.mp3",
			"打开界面": "open_ui.mp3",
			"读档": "load.mp3",
			"存档": "save.mp3",
			"获得道具": "item.mp3",
			"回血": "recovery.mp3",
			"炸弹": "bomb.mp3",
			"飞行器": "centerFly.mp3",
			"开关门": "door.mp3",
			"上下楼": "floor.mp3",
			"跳跃": "jump.mp3",
			"破墙镐": "pickaxe.mp3",
			"破冰镐": "icePickaxe.mp3",
			"宝石": "gem.mp3",
			"阻激夹域": "zone.mp3",
			"穿脱装备": "equip.mp3",
			"背景音乐": "bgm.mp3",
			"攻击": "attack.mp3",
			"背景图": "bg.jpg",
			"商店": "shop.mp3",
			"领域": "zone"
		},
		"levelChoose": [],
		"equipName": [],
		"startBgm": "biaoti.mp3",
		"styles": {
			"startBackground": "project/images/bg.jpg",
			"startVerticalBackground": "project/images/bg.jpg",
			"startLogoStyle": "display:none",
			"startButtonsStyle": "background-color: #32369F; opacity: 0.85; color: #FFFFFF; border: #FFFFFF 2px solid; caret-color: #FFD700;",
			"statusLeftBackground": "url(project/materials/ground.png) repeat",
			"statusTopBackground": "url(project/materials/ground.png) repeat",
			"toolsBackground": "url(project/materials/ground.png) repeat",
			"floorChangingStyle": "background-color: black; color: white",
			"statusBarColor": [
				255,
				255,
				255,
				1
			],
			"borderColor": [
				204,
				204,
				204,
				1
			],
			"selectColor": [
				255,
				215,
				0,
				1
			],
			"font": "Verdana"
		},
		"splitImages": [
			{
				"name": "dragon.png",
				"width": 384,
				"height": 96,
				"prefix": "dragon_"
			}
		]
	},
	"firstData": {
		"title": "哈基米 曼波",
		"name": "51_hajimimanbo",
		"version": "Ver 2.6",
		"floorId": "MB0",
		"hero": {
			"image": "hero.png",
			"animate": false,
			"name": "勇者",
			"lv": 1,
			"hpmax": -1,
			"hp": 400,
			"manamax": -1,
			"mana": 0,
			"atk": 10,
			"def": 10,
			"mdef": 0,
			"money": 0,
			"exp": 0,
			"equipment": [],
			"items": {
				"constants": {
					"I300": 1
				},
				"tools": {},
				"equips": {}
			},
			"loc": {
				"direction": "down",
				"x": 6,
				"y": 11
			},
			"flags": {
				"红宝石数值": 0,
				"蓝宝石数值": 0,
				"__winskin_opacity__": 1
			},
			"followers": [],
			"steps": 0
		},
		"startCanvas": [
			{
				"type": "comment",
				"text": "在这里可以用事件来自定义绘制标题界面的背景图等"
			},
			{
				"type": "comment",
				"text": "也可以直接切换到其他楼层（比如某个开始剧情楼层）进行操作。"
			},
			{
				"type": "previewUI",
				"action": [
					{
						"type": "fillRect",
						"x": 0,
						"y": 0,
						"width": "core.__PIXELS__",
						"height": "core.__PIXELS__",
						"style": [
							82,
							82,
							82,
							1
						]
					},
					{
						"type": "setAttribute",
						"align": "center"
					},
					{
						"type": "fillBoldText",
						"x": "core.__PIXELS__ / 2",
						"y": 80,
						"style": [
							255,
							255,
							255,
							1
						],
						"strokeStyle": [
							0,
							0,
							0,
							1
						],
						"font": "bold 40px Verdana",
						"text": "${core.firstData.title}"
					}
				]
			},
			{
				"type": "setValue",
				"name": "flag:selection",
				"value": "0"
			},
			{
				"type": "comment",
				"text": "在右下方自绘一个对话框进行显示选择项"
			},
			{
				"type": "previewUI",
				"action": [
					{
						"type": "fillRect",
						"x": 230,
						"y": 250,
						"width": 150,
						"height": 142,
						"radius": 10,
						"style": [
							50,
							54,
							159,
							0.85
						]
					},
					{
						"type": "strokeRect",
						"x": 230,
						"y": 250,
						"width": 150,
						"height": 142,
						"radius": 10,
						"style": [
							255,
							255,
							255,
							1
						],
						"lineWidth": 2
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 290,
						"style": [
							255,
							255,
							255,
							1
						],
						"font": "bold 25px Verdana",
						"text": "开始游戏"
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 330,
						"font": "bold 25px Verdana",
						"text": "读取存档"
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 370,
						"font": "bold 25px Verdana",
						"text": "回放录像"
					}
				]
			},
			{
				"type": "while",
				"condition": "1",
				"data": [
					{
						"type": "drawSelector",
						"image": "winskin.png",
						"code": 1,
						"x": 245,
						"y": "261 + 40*flag:selection",
						"width": 120,
						"height": 40
					},
					{
						"type": "wait",
						"data": [
							{
								"case": "keyboard",
								"keycode": "13,32",
								"break": true,
								"action": [
									{
										"type": "switch",
										"condition": "flag:selection",
										"caseList": [
											{
												"case": "0",
												"action": [
													{
														"type": "comment",
														"text": "在“开始游戏”确定"
													},
													{
														"type": "break",
														"n": 1
													}
												]
											},
											{
												"case": "1",
												"action": [
													{
														"type": "comment",
														"text": "在“读取存档”确定"
													},
													{
														"type": "callLoad"
													}
												]
											},
											{
												"case": "2",
												"action": [
													{
														"type": "comment",
														"text": "在“回放录像”确定"
													},
													{
														"type": "if",
														"condition": "(!core.isReplaying())",
														"true": [
															{
																"type": "function",
																"function": "function(){\ncore.chooseReplayFile()\n}"
															}
														]
													}
												]
											}
										]
									}
								]
							},
							{
								"case": "keyboard",
								"keycode": "38",
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "光标上键"
									},
									{
										"type": "setValue",
										"name": "flag:selection",
										"value": "(flag:selection + 2) % 3"
									}
								]
							},
							{
								"case": "keyboard",
								"keycode": "40",
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "光标下键"
									},
									{
										"type": "setValue",
										"name": "flag:selection",
										"value": "(flag:selection + 1) % 3"
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									261,
									300
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“开始游戏”"
									},
									{
										"type": "break",
										"n": 1
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									301,
									340
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“读取存档”"
									},
									{
										"type": "callLoad"
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									341,
									380
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“播放录像”"
									},
									{
										"type": "if",
										"condition": "(!core.isReplaying())",
										"true": [
											{
												"type": "function",
												"function": "function(){\ncore.chooseReplayFile()\n}"
											}
										]
									}
								]
							}
						]
					}
				]
			},
			{
				"type": "setValue",
				"name": "flag:selection",
				"value": "null"
			},
			{
				"type": "drawSelector",
				"code": 1
			},
			{
				"type": "clearMap"
			},
			{
				"type": "function",
				"function": "function(){\ncore.control.checkBgm()\n}"
			},
			{
				"type": "if",
				"condition": "(main.levelChoose.length == 0)",
				"true": [
					{
						"type": "comment",
						"text": "没有难度选择：直接开始游戏"
					}
				],
				"false": [
					{
						"type": "comment",
						"text": "难度选择：作为样例，这里只提供了一个显示选择项。"
					},
					{
						"type": "function",
						"function": "function(){\nvar choices = [];\nmain.levelChoose.forEach(function (one) {\n\tchoices.push({\n\t\t\"text\": one.title || '',\n\t\t\"action\": [\n\t\t\t{ \"type\": \"function\", \"function\": \"function() { core.status.hard = '\" + (one.name || '') + \"'; }\" }\n\t\t]\n\t});\n})\ncore.insertAction({ \"type\": \"choices\", \"choices\": choices });\n}"
					},
					{
						"type": "comment",
						"text": "你也可以仿照上面的样例进行自己创建等待用户操作来处理不同的难度分歧。\n如需自己处理，请设置 core.status.hard \n（例如，自定义js脚本：core.status.hard = 'Easy' ）"
					}
				]
			},
			{
				"type": "clearMap"
			},
			{
				"type": "comment",
				"text": "接下来会执行startText中的事件"
			},
			{
				"type": "comment",
				"text": "状态栏默认处于隐藏状态；可以使用“显示状态栏”事件进行显示。"
			}
		],
		"startText": [
			{
				"type": "setText",
				"position": "down",
				"background": "winskin.png"
			},
			{
				"type": "previewUI",
				"action": [
					{
						"type": "setAttribute",
						"align": "center"
					},
					{
						"type": "drawImage",
						"image": "kaichang.png",
						"x": -120,
						"y": 0,
						"w": 627,
						"h": 352
					},
					{
						"type": "insert",
						"name": "本塔修改内容",
						"args": [
							20
						]
					},
					{
						"type": "pauseBgm"
					},
					{
						"type": "fillRect",
						"x": 132,
						"y": 6,
						"width": 88,
						"height": 30,
						"radius": 5,
						"style": [
							115,
							115,
							115,
							1
						]
					},
					{
						"type": "strokeRect",
						"x": 132,
						"y": 6,
						"width": 88,
						"height": 30,
						"radius": 5,
						"style": [
							0,
							0,
							0,
							1
						],
						"lineWidth": 3
					},
					{
						"type": "fillText",
						"x": 176,
						"y": 28,
						"style": [
							255,
							255,
							255,
							1
						],
						"font": "bold 20px Verdana",
						"text": "选择角色"
					},
					{
						"type": "fillRect",
						"x": 298,
						"y": 6,
						"width": 44,
						"height": 20,
						"radius": 5,
						"style": [
							115,
							115,
							115,
							1
						]
					},
					{
						"type": "strokeRect",
						"x": 298,
						"y": 6,
						"width": 44,
						"height": 20,
						"radius": 5,
						"style": [
							0,
							0,
							0,
							1
						],
						"lineWidth": 3
					},
					{
						"type": "fillText",
						"x": 320,
						"y": 20,
						"style": [
							255,
							255,
							255,
							1
						],
						"font": "bold 12px Verdana",
						"text": "都不选"
					},
					{
						"type": "fillRect",
						"x": 24,
						"y": 48,
						"width": 128,
						"height": 200,
						"radius": 5,
						"style": [
							115,
							115,
							115,
							1
						]
					},
					{
						"type": "strokeRect",
						"x": 24,
						"y": 48,
						"width": 128,
						"height": 200,
						"radius": 5,
						"style": [
							0,
							0,
							0,
							1
						],
						"lineWidth": 3
					},
					{
						"type": "drawImage",
						"image": "hajimi.png",
						"x": 0,
						"y": 0,
						"w": 750,
						"h": 1320,
						"x1": 25,
						"y1": 25,
						"w1": 120,
						"h1": "211.2"
					},
					{
						"type": "fillRect",
						"x": 200,
						"y": 48,
						"width": 128,
						"height": 200,
						"radius": 5,
						"style": [
							115,
							115,
							115,
							1
						]
					},
					{
						"type": "strokeRect",
						"x": 200,
						"y": 48,
						"width": 128,
						"height": 200,
						"radius": 5,
						"style": [
							0,
							0,
							0,
							1
						],
						"lineWidth": 3
					},
					{
						"type": "drawImage",
						"image": "manbo.png",
						"x": 0,
						"y": 0,
						"w": 750,
						"h": 1320,
						"x1": 206,
						"y1": 25,
						"w1": 120,
						"h1": "211.2"
					},
					{
						"type": "fillRect",
						"x": 24,
						"y": 260,
						"width": 304,
						"height": 84,
						"radius": 5,
						"style": [
							115,
							115,
							115,
							1
						]
					},
					{
						"type": "strokeRect",
						"x": 24,
						"y": 260,
						"width": 304,
						"height": 84,
						"radius": 5,
						"style": [
							0,
							0,
							0,
							1
						],
						"lineWidth": 3
					},
					{
						"type": "drawTextContent",
						"text": "选择哈基米或曼波，这里会显示技能\n都不选请点右上角",
						"left": 28,
						"top": 264,
						"align": "left",
						"fontSize": 12
					},
					{
						"type": "setValue",
						"name": "flag:生命",
						"value": "0"
					},
					{
						"type": "while",
						"condition": "(!flag:选择技能)",
						"data": [
							{
								"type": "wait",
								"forceChild": true,
								"data": [
									{
										"case": "mouse",
										"px": [
											298,
											342
										],
										"py": [
											6,
											26
										],
										"action": [
											{
												"type": "setValue",
												"name": "temp:A",
												"value": "null"
											},
											{
												"type": "fillRect",
												"x": 24,
												"y": 48,
												"width": 128,
												"height": 200,
												"radius": 5,
												"style": [
													115,
													115,
													115,
													1
												]
											},
											{
												"type": "strokeRect",
												"x": 24,
												"y": 48,
												"width": 128,
												"height": 200,
												"radius": 5,
												"style": [
													0,
													0,
													0,
													1
												],
												"lineWidth": 3
											},
											{
												"type": "drawImage",
												"image": "hajimi.png",
												"x": 0,
												"y": 0,
												"w": 750,
												"h": 1320,
												"x1": 25,
												"y1": 25,
												"w1": 120,
												"h1": "211.2"
											},
											{
												"type": "fillRect",
												"x": 200,
												"y": 48,
												"width": 128,
												"height": 200,
												"radius": 5,
												"style": [
													115,
													115,
													115,
													1
												]
											},
											{
												"type": "strokeRect",
												"x": 200,
												"y": 48,
												"width": 128,
												"height": 200,
												"radius": 5,
												"style": [
													0,
													0,
													0,
													1
												],
												"lineWidth": 3
											},
											{
												"type": "drawImage",
												"image": "manbo.png",
												"x": 0,
												"y": 0,
												"w": 750,
												"h": 1320,
												"x1": 206,
												"y1": 25,
												"w1": 120,
												"h1": "211.2"
											},
											{
												"type": "fillRect",
												"x": 24,
												"y": 260,
												"width": 304,
												"height": 84,
												"radius": 5,
												"style": [
													115,
													115,
													115,
													1
												]
											},
											{
												"type": "strokeRect",
												"x": 24,
												"y": 260,
												"width": 304,
												"height": 84,
												"radius": 5,
												"style": [
													0,
													0,
													0,
													1
												],
												"lineWidth": 3
											},
											{
												"type": "drawTextContent",
												"text": "选择哈基米或曼波，这里会显示技能\n都不选请点右上角",
												"left": 28,
												"top": 264,
												"align": "left",
												"fontSize": 12
											},
											{
												"type": "confirm",
												"text": "确认什么都不选\n使用没有技能的勇者吗?",
												"yes": [
													{
														"type": "setValue",
														"name": "flag:选择技能",
														"value": "'勇者'"
													}
												],
												"no": []
											}
										]
									},
									{
										"case": "mouse",
										"px": [
											24,
											152
										],
										"py": [
											48,
											248
										],
										"action": [
											{
												"type": "if",
												"condition": "(temp:A==='哈基米')",
												"true": [
													{
														"type": "setValue",
														"name": "flag:选择技能",
														"value": "'哈基米'"
													}
												],
												"false": [
													{
														"type": "setValue",
														"name": "temp:A",
														"value": "'哈基米'"
													},
													{
														"type": "stopSound"
													},
													{
														"type": "playSound",
														"name": "hajimi.mp3"
													},
													{
														"type": "fillRect",
														"x": 24,
														"y": 48,
														"width": 128,
														"height": 200,
														"radius": 5,
														"style": [
															199,
															168,
															0,
															1
														]
													},
													{
														"type": "strokeRect",
														"x": 24,
														"y": 48,
														"width": 128,
														"height": 200,
														"radius": 5,
														"style": [
															0,
															0,
															0,
															1
														],
														"lineWidth": 3
													},
													{
														"type": "drawImage",
														"image": "hajimi.png",
														"x": 0,
														"y": 0,
														"w": 750,
														"h": 1320,
														"x1": 25,
														"y1": 25,
														"w1": 120,
														"h1": "211.2"
													},
													{
														"type": "fillRect",
														"x": 200,
														"y": 48,
														"width": 128,
														"height": 200,
														"radius": 5,
														"style": [
															115,
															115,
															115,
															1
														]
													},
													{
														"type": "strokeRect",
														"x": 200,
														"y": 48,
														"width": 128,
														"height": 200,
														"radius": 5,
														"style": [
															0,
															0,
															0,
															1
														],
														"lineWidth": 3
													},
													{
														"type": "drawImage",
														"image": "manbo.png",
														"x": 0,
														"y": 0,
														"w": 750,
														"h": 1320,
														"x1": 206,
														"y1": 25,
														"w1": 120,
														"h1": "211.2"
													},
													{
														"type": "clearMap",
														"x": 24,
														"y": 260,
														"width": 304,
														"height": 84
													},
													{
														"type": "fillRect",
														"x": 24,
														"y": 260,
														"width": 304,
														"height": 84,
														"radius": 5,
														"style": [
															115,
															115,
															115,
															1
														]
													},
													{
														"type": "strokeRect",
														"x": 24,
														"y": 260,
														"width": 304,
														"height": 84,
														"radius": 5,
														"style": [
															0,
															0,
															0,
															1
														],
														"lineWidth": 3
													},
													{
														"type": "drawTextContent",
														"text": "哈基米热情奔放，喜欢蜜水，选择哈基米获得如下效果：\n\\i[redGem]数值+1\n\\i[blueGem]数值-1\n\\i[redPotion]升级为蜜水\\i[yellowPotion]（一区基准值为${core.values.yellowPotion}）\n\\i[bluePotion]升级为南北绿豆浆\\i[greenPotion]（一区基准值为${core.values.greenPotion}）",
														"left": 28,
														"top": 264,
														"align": "left",
														"fontSize": 12
													}
												]
											}
										]
									},
									{
										"case": "mouse",
										"px": [
											200,
											328
										],
										"py": [
											48,
											248
										],
										"action": [
											{
												"type": "if",
												"condition": "(temp:A==='曼波')",
												"true": [
													{
														"type": "setValue",
														"name": "flag:选择技能",
														"value": "'曼波'"
													}
												],
												"false": [
													{
														"type": "setValue",
														"name": "temp:A",
														"value": "'曼波'"
													},
													{
														"type": "stopSound"
													},
													{
														"type": "playSound",
														"name": "manbo.mp3"
													},
													{
														"type": "fillRect",
														"x": 24,
														"y": 48,
														"width": 128,
														"height": 200,
														"radius": 5,
														"style": [
															115,
															115,
															115,
															1
														]
													},
													{
														"type": "strokeRect",
														"x": 24,
														"y": 48,
														"width": 128,
														"height": 200,
														"radius": 5,
														"style": [
															0,
															0,
															0,
															1
														],
														"lineWidth": 3
													},
													{
														"type": "drawImage",
														"image": "hajimi.png",
														"x": 0,
														"y": 0,
														"w": 750,
														"h": 1320,
														"x1": 25,
														"y1": 25,
														"w1": 120,
														"h1": "211.2"
													},
													{
														"type": "fillRect",
														"x": 200,
														"y": 48,
														"width": 128,
														"height": 200,
														"radius": 5,
														"style": [
															199,
															168,
															0,
															1
														]
													},
													{
														"type": "strokeRect",
														"x": 200,
														"y": 48,
														"width": 128,
														"height": 200,
														"radius": 5,
														"style": [
															0,
															0,
															0,
															1
														],
														"lineWidth": 3
													},
													{
														"type": "drawImage",
														"image": "manbo.png",
														"x": 0,
														"y": 0,
														"w": 750,
														"h": 1320,
														"x1": 206,
														"y1": 25,
														"w1": 120,
														"h1": "211.2"
													},
													{
														"type": "clearMap",
														"x": 24,
														"y": 260,
														"width": 304,
														"height": 84
													},
													{
														"type": "fillRect",
														"x": 24,
														"y": 260,
														"width": 304,
														"height": 84,
														"radius": 5,
														"style": [
															115,
															115,
															115,
															1
														]
													},
													{
														"type": "strokeRect",
														"x": 24,
														"y": 260,
														"width": 304,
														"height": 84,
														"radius": 5,
														"style": [
															0,
															0,
															0,
															1
														],
														"lineWidth": 3
													},
													{
														"type": "drawTextContent",
														"text": "曼波开朗积极，爱逛祭典，选择曼波获得如下效果：\n\\i[redGem]数值-1\n\\i[blueGem]数值+1\n\\i[shop]价格打对折\n\\i[sword5]\\i[shield5]所有剑盾位置互换",
														"left": 28,
														"top": 264,
														"align": "left",
														"fontSize": 12
													}
												]
											}
										]
									}
								]
							}
						]
					},
					{
						"type": "clearMap"
					}
				]
			},
			{
				"type": "setValue",
				"name": "flag:开过商店",
				"value": "0"
			},
			{
				"type": "setValue",
				"name": "flag:战后删除怪物",
				"value": "0"
			},
			{
				"type": "setValue",
				"name": "flag:被先攻",
				"value": "0"
			},
			{
				"type": "setValue",
				"name": "flag:itemDetail",
				"value": "1"
			},
			{
				"type": "switch",
				"condition": "flag:选择技能",
				"caseList": [
					{
						"case": "'哈基米'",
						"action": [
							{
								"type": "setHeroIcon",
								"name": "hajimihero.png"
							},
							{
								"type": "function",
								"function": "function(){\ncore.replaceBlock(31, 34, core.floorIds);\ncore.replaceBlock(32, 33, core.floorIds);\n}"
							},
							{
								"type": "setValue",
								"name": "flag:红宝石数值",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "flag:蓝宝石数值",
								"value": "-1"
							}
						]
					},
					{
						"case": "'曼波'",
						"action": [
							{
								"type": "setHeroIcon",
								"name": "manbohero.png"
							},
							{
								"type": "function",
								"function": "function(){\nconst swordIds = ['sword1', 'sword2', 'sword3', 'sword4', 'sword5'];\nconst shieldIds = ['shield1', 'shield2', 'shield3', 'shield4', 'shield5'];\nconst swords = [];\nconst shields = [];\ncore.floorIds.forEach(\n\t(floorId) => {\n\t\tfor (let i = 1; i <= 11; i++) {\n\t\t\tfor (let j = 1; j <= 11; j++) {\n\t\t\t\tconst block = core.getBlock(i, j, floorId);\n\t\t\t\tif (block) {\n\t\t\t\t\tif (block.event.id.startsWith('sword')) {\n\t\t\t\t\t\tswords.push({\n\t\t\t\t\t\t\tx: block.x,\n\t\t\t\t\t\t\ty: block.y,\n\t\t\t\t\t\t\tid: block.event.id,\n\t\t\t\t\t\t\tfloorId: floorId\n\t\t\t\t\t\t});\n\t\t\t\t\t} else if (block.event.id.startsWith('shield')) {\n\t\t\t\t\t\tshields.push({\n\t\t\t\t\t\t\tx: block.x,\n\t\t\t\t\t\t\ty: block.y,\n\t\t\t\t\t\t\tid: block.event.id,\n\t\t\t\t\t\t\tfloorId: floorId\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n);\nswords.forEach(({ x, y, id, floorId }) => {\n\tcore.setBlock(shieldIds[swordIds.indexOf(id)], x, y, floorId);\n});\nshields.forEach(({ x, y, id, floorId }) => {\n\tcore.setBlock(swordIds[shieldIds.indexOf(id)], x, y, floorId);\n});\n}"
							},
							{
								"type": "setValue",
								"name": "flag:红宝石数值",
								"value": "-1"
							},
							{
								"type": "setValue",
								"name": "flag:蓝宝石数值",
								"value": "1"
							}
						]
					},
					{
						"case": "default",
						"action": [
							{
								"type": "comment",
								"text": "当没有符合的值的场合执行default事件"
							}
						]
					}
				]
			}
		],
		"shops": [],
		"levelUp": [
			{
				"need": "0",
				"title": "",
				"action": [
					{
						"type": "comment",
						"text": "此处是初始等级，只需填写称号"
					}
				]
			},
			{
				"need": "20",
				"title": "",
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"operator": "+=",
						"value": "10"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"operator": "+=",
						"value": "10"
					}
				]
			},
			{
				"need": "40",
				"title": "",
				"action": [
					{
						"type": "tip",
						"text": "恭喜升级"
					}
				]
			}
		]
	},
	"values": {
		"lavaDamage": 100,
		"poisonDamage": 10,
		"weakValue": 20,
		"redGem": 1,
		"blueGem": 1,
		"greenGem": 5,
		"redPotion": 50,
		"bluePotion": 200,
		"yellowPotion": 100,
		"greenPotion": 250,
		"breakArmor": 0.9,
		"counterAttack": 0.1,
		"purify": 3,
		"hatred": 2,
		"animateSpeed": 400,
		"moveSpeed": 100,
		"statusCanvasRowsOnMobile": 3,
		"floorChangeTime": 0
	},
	"flags": {
		"statusBarItems": [
			"enableFloor",
			"enableHP",
			"enableAtk",
			"enableDef",
			"enableMoney",
			"enableKeys"
		],
		"extendToolbar": false,
		"flyNearStair": true,
		"flyRecordPosition": false,
		"itemFirstText": false,
		"equipboxButton": false,
		"enableAddPoint": false,
		"enableNegativeDamage": false,
		"betweenAttackMax": false,
		"useLoop": true,
		"startUsingCanvas": false,
		"statusCanvas": false,
		"enableEnemyPoint": true,
		"enableGentleClick": false,
		"ignoreChangeFloor": true,
		"canGoDeadZone": false,
		"enableMoveDirectly": true,
		"enableRouteFolding": true,
		"disableShopOnDamage": false,
		"blurFg": false
	}
}